/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.networkconnectivity.v1.CreateInternalRangeRequest;
import com.google.cloud.networkconnectivity.v1.DeleteInternalRangeRequest;
import com.google.cloud.networkconnectivity.v1.GetInternalRangeRequest;
import com.google.cloud.networkconnectivity.v1.InternalRange;
import com.google.cloud.networkconnectivity.v1.InternalRangeName;
import com.google.cloud.networkconnectivity.v1.InternalRangeServiceSettings;
import com.google.cloud.networkconnectivity.v1.ListInternalRangesRequest;
import com.google.cloud.networkconnectivity.v1.ListInternalRangesResponse;
import com.google.cloud.networkconnectivity.v1.LocationName;
import com.google.cloud.networkconnectivity.v1.OperationMetadata;
import com.google.cloud.networkconnectivity.v1.UpdateInternalRangeRequest;
import com.google.cloud.networkconnectivity.v1.stub.InternalRangeServiceStub;
import com.google.cloud.networkconnectivity.v1.stub.InternalRangeServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class InternalRangeServiceClient
implements BackgroundResource {
    private final InternalRangeServiceSettings settings;
    private final InternalRangeServiceStub stub;
    private final OperationsClient operationsClient;

    public static final InternalRangeServiceClient create() throws IOException {
        return InternalRangeServiceClient.create(InternalRangeServiceSettings.newBuilder().build());
    }

    public static final InternalRangeServiceClient create(InternalRangeServiceSettings settings) throws IOException {
        return new InternalRangeServiceClient(settings);
    }

    public static final InternalRangeServiceClient create(InternalRangeServiceStub stub) {
        return new InternalRangeServiceClient(stub);
    }

    protected InternalRangeServiceClient(InternalRangeServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InternalRangeServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected InternalRangeServiceClient(InternalRangeServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final InternalRangeServiceSettings getSettings() {
        return this.settings;
    }

    public InternalRangeServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListInternalRangesPagedResponse listInternalRanges(LocationName parent) {
        ListInternalRangesRequest request = ListInternalRangesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInternalRanges(request);
    }

    public final ListInternalRangesPagedResponse listInternalRanges(String parent) {
        ListInternalRangesRequest request = ListInternalRangesRequest.newBuilder().setParent(parent).build();
        return this.listInternalRanges(request);
    }

    public final ListInternalRangesPagedResponse listInternalRanges(ListInternalRangesRequest request) {
        return (ListInternalRangesPagedResponse)((Object)this.listInternalRangesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInternalRangesRequest, ListInternalRangesPagedResponse> listInternalRangesPagedCallable() {
        return this.stub.listInternalRangesPagedCallable();
    }

    public final UnaryCallable<ListInternalRangesRequest, ListInternalRangesResponse> listInternalRangesCallable() {
        return this.stub.listInternalRangesCallable();
    }

    public final InternalRange getInternalRange(InternalRangeName name) {
        GetInternalRangeRequest request = GetInternalRangeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInternalRange(request);
    }

    public final InternalRange getInternalRange(String name) {
        GetInternalRangeRequest request = GetInternalRangeRequest.newBuilder().setName(name).build();
        return this.getInternalRange(request);
    }

    public final InternalRange getInternalRange(GetInternalRangeRequest request) {
        return (InternalRange)this.getInternalRangeCallable().call((Object)request);
    }

    public final UnaryCallable<GetInternalRangeRequest, InternalRange> getInternalRangeCallable() {
        return this.stub.getInternalRangeCallable();
    }

    public final OperationFuture<InternalRange, OperationMetadata> createInternalRangeAsync(LocationName parent, InternalRange internalRange, String internalRangeId) {
        CreateInternalRangeRequest request = CreateInternalRangeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInternalRange(internalRange).setInternalRangeId(internalRangeId).build();
        return this.createInternalRangeAsync(request);
    }

    public final OperationFuture<InternalRange, OperationMetadata> createInternalRangeAsync(String parent, InternalRange internalRange, String internalRangeId) {
        CreateInternalRangeRequest request = CreateInternalRangeRequest.newBuilder().setParent(parent).setInternalRange(internalRange).setInternalRangeId(internalRangeId).build();
        return this.createInternalRangeAsync(request);
    }

    public final OperationFuture<InternalRange, OperationMetadata> createInternalRangeAsync(CreateInternalRangeRequest request) {
        return this.createInternalRangeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateInternalRangeRequest, InternalRange, OperationMetadata> createInternalRangeOperationCallable() {
        return this.stub.createInternalRangeOperationCallable();
    }

    public final UnaryCallable<CreateInternalRangeRequest, Operation> createInternalRangeCallable() {
        return this.stub.createInternalRangeCallable();
    }

    public final OperationFuture<InternalRange, OperationMetadata> updateInternalRangeAsync(InternalRange internalRange, FieldMask updateMask) {
        UpdateInternalRangeRequest request = UpdateInternalRangeRequest.newBuilder().setInternalRange(internalRange).setUpdateMask(updateMask).build();
        return this.updateInternalRangeAsync(request);
    }

    public final OperationFuture<InternalRange, OperationMetadata> updateInternalRangeAsync(UpdateInternalRangeRequest request) {
        return this.updateInternalRangeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateInternalRangeRequest, InternalRange, OperationMetadata> updateInternalRangeOperationCallable() {
        return this.stub.updateInternalRangeOperationCallable();
    }

    public final UnaryCallable<UpdateInternalRangeRequest, Operation> updateInternalRangeCallable() {
        return this.stub.updateInternalRangeCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInternalRangeAsync(InternalRangeName name) {
        DeleteInternalRangeRequest request = DeleteInternalRangeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteInternalRangeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInternalRangeAsync(String name) {
        DeleteInternalRangeRequest request = DeleteInternalRangeRequest.newBuilder().setName(name).build();
        return this.deleteInternalRangeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInternalRangeAsync(DeleteInternalRangeRequest request) {
        return this.deleteInternalRangeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteInternalRangeRequest, Empty, OperationMetadata> deleteInternalRangeOperationCallable() {
        return this.stub.deleteInternalRangeOperationCallable();
    }

    public final UnaryCallable<DeleteInternalRangeRequest, Operation> deleteInternalRangeCallable() {
        return this.stub.deleteInternalRangeCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInternalRangesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInternalRangesRequest, ListInternalRangesResponse, InternalRange, ListInternalRangesPage, ListInternalRangesFixedSizeCollection> {
        private ListInternalRangesFixedSizeCollection(List<ListInternalRangesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInternalRangesFixedSizeCollection createEmptyCollection() {
            return new ListInternalRangesFixedSizeCollection(null, 0);
        }

        protected ListInternalRangesFixedSizeCollection createCollection(List<ListInternalRangesPage> pages, int collectionSize) {
            return new ListInternalRangesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInternalRangesPage
    extends AbstractPage<ListInternalRangesRequest, ListInternalRangesResponse, InternalRange, ListInternalRangesPage> {
        private ListInternalRangesPage(PageContext<ListInternalRangesRequest, ListInternalRangesResponse, InternalRange> context, ListInternalRangesResponse response) {
            super(context, (Object)response);
        }

        private static ListInternalRangesPage createEmptyPage() {
            return new ListInternalRangesPage(null, null);
        }

        protected ListInternalRangesPage createPage(PageContext<ListInternalRangesRequest, ListInternalRangesResponse, InternalRange> context, ListInternalRangesResponse response) {
            return new ListInternalRangesPage(context, response);
        }

        public ApiFuture<ListInternalRangesPage> createPageAsync(PageContext<ListInternalRangesRequest, ListInternalRangesResponse, InternalRange> context, ApiFuture<ListInternalRangesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInternalRangesPagedResponse
    extends AbstractPagedListResponse<ListInternalRangesRequest, ListInternalRangesResponse, InternalRange, ListInternalRangesPage, ListInternalRangesFixedSizeCollection> {
        public static ApiFuture<ListInternalRangesPagedResponse> createAsync(PageContext<ListInternalRangesRequest, ListInternalRangesResponse, InternalRange> context, ApiFuture<ListInternalRangesResponse> futureResponse) {
            ApiFuture<ListInternalRangesPage> futurePage = ListInternalRangesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInternalRangesPagedResponse((ListInternalRangesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInternalRangesPagedResponse(ListInternalRangesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInternalRangesFixedSizeCollection.createEmptyCollection());
        }
    }
}

