/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.networkconnectivity.v1.AcceptHubSpokeRequest;
import com.google.cloud.networkconnectivity.v1.AcceptHubSpokeResponse;
import com.google.cloud.networkconnectivity.v1.CreateHubRequest;
import com.google.cloud.networkconnectivity.v1.CreateSpokeRequest;
import com.google.cloud.networkconnectivity.v1.DeleteHubRequest;
import com.google.cloud.networkconnectivity.v1.DeleteSpokeRequest;
import com.google.cloud.networkconnectivity.v1.GetGroupRequest;
import com.google.cloud.networkconnectivity.v1.GetHubRequest;
import com.google.cloud.networkconnectivity.v1.GetRouteRequest;
import com.google.cloud.networkconnectivity.v1.GetRouteTableRequest;
import com.google.cloud.networkconnectivity.v1.GetSpokeRequest;
import com.google.cloud.networkconnectivity.v1.Group;
import com.google.cloud.networkconnectivity.v1.GroupName;
import com.google.cloud.networkconnectivity.v1.Hub;
import com.google.cloud.networkconnectivity.v1.HubName;
import com.google.cloud.networkconnectivity.v1.HubRouteName;
import com.google.cloud.networkconnectivity.v1.HubServiceSettings;
import com.google.cloud.networkconnectivity.v1.ListGroupsRequest;
import com.google.cloud.networkconnectivity.v1.ListGroupsResponse;
import com.google.cloud.networkconnectivity.v1.ListHubSpokesRequest;
import com.google.cloud.networkconnectivity.v1.ListHubSpokesResponse;
import com.google.cloud.networkconnectivity.v1.ListHubsRequest;
import com.google.cloud.networkconnectivity.v1.ListHubsResponse;
import com.google.cloud.networkconnectivity.v1.ListRouteTablesRequest;
import com.google.cloud.networkconnectivity.v1.ListRouteTablesResponse;
import com.google.cloud.networkconnectivity.v1.ListRoutesRequest;
import com.google.cloud.networkconnectivity.v1.ListRoutesResponse;
import com.google.cloud.networkconnectivity.v1.ListSpokesRequest;
import com.google.cloud.networkconnectivity.v1.ListSpokesResponse;
import com.google.cloud.networkconnectivity.v1.LocationName;
import com.google.cloud.networkconnectivity.v1.OperationMetadata;
import com.google.cloud.networkconnectivity.v1.RejectHubSpokeRequest;
import com.google.cloud.networkconnectivity.v1.RejectHubSpokeResponse;
import com.google.cloud.networkconnectivity.v1.Route;
import com.google.cloud.networkconnectivity.v1.RouteTable;
import com.google.cloud.networkconnectivity.v1.RouteTableName;
import com.google.cloud.networkconnectivity.v1.Spoke;
import com.google.cloud.networkconnectivity.v1.SpokeName;
import com.google.cloud.networkconnectivity.v1.UpdateHubRequest;
import com.google.cloud.networkconnectivity.v1.UpdateSpokeRequest;
import com.google.cloud.networkconnectivity.v1.stub.HubServiceStub;
import com.google.cloud.networkconnectivity.v1.stub.HubServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class HubServiceClient
implements BackgroundResource {
    private final HubServiceSettings settings;
    private final HubServiceStub stub;
    private final OperationsClient operationsClient;

    public static final HubServiceClient create() throws IOException {
        return HubServiceClient.create(HubServiceSettings.newBuilder().build());
    }

    public static final HubServiceClient create(HubServiceSettings settings) throws IOException {
        return new HubServiceClient(settings);
    }

    public static final HubServiceClient create(HubServiceStub stub) {
        return new HubServiceClient(stub);
    }

    protected HubServiceClient(HubServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((HubServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected HubServiceClient(HubServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final HubServiceSettings getSettings() {
        return this.settings;
    }

    public HubServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListHubsPagedResponse listHubs(LocationName parent) {
        ListHubsRequest request = ListHubsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listHubs(request);
    }

    public final ListHubsPagedResponse listHubs(String parent) {
        ListHubsRequest request = ListHubsRequest.newBuilder().setParent(parent).build();
        return this.listHubs(request);
    }

    public final ListHubsPagedResponse listHubs(ListHubsRequest request) {
        return (ListHubsPagedResponse)((Object)this.listHubsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListHubsRequest, ListHubsPagedResponse> listHubsPagedCallable() {
        return this.stub.listHubsPagedCallable();
    }

    public final UnaryCallable<ListHubsRequest, ListHubsResponse> listHubsCallable() {
        return this.stub.listHubsCallable();
    }

    public final Hub getHub(HubName name) {
        GetHubRequest request = GetHubRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getHub(request);
    }

    public final Hub getHub(String name) {
        GetHubRequest request = GetHubRequest.newBuilder().setName(name).build();
        return this.getHub(request);
    }

    public final Hub getHub(GetHubRequest request) {
        return (Hub)this.getHubCallable().call((Object)request);
    }

    public final UnaryCallable<GetHubRequest, Hub> getHubCallable() {
        return this.stub.getHubCallable();
    }

    public final OperationFuture<Hub, OperationMetadata> createHubAsync(LocationName parent, Hub hub, String hubId) {
        CreateHubRequest request = CreateHubRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setHub(hub).setHubId(hubId).build();
        return this.createHubAsync(request);
    }

    public final OperationFuture<Hub, OperationMetadata> createHubAsync(String parent, Hub hub, String hubId) {
        CreateHubRequest request = CreateHubRequest.newBuilder().setParent(parent).setHub(hub).setHubId(hubId).build();
        return this.createHubAsync(request);
    }

    public final OperationFuture<Hub, OperationMetadata> createHubAsync(CreateHubRequest request) {
        return this.createHubOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateHubRequest, Hub, OperationMetadata> createHubOperationCallable() {
        return this.stub.createHubOperationCallable();
    }

    public final UnaryCallable<CreateHubRequest, Operation> createHubCallable() {
        return this.stub.createHubCallable();
    }

    public final OperationFuture<Hub, OperationMetadata> updateHubAsync(Hub hub, FieldMask updateMask) {
        UpdateHubRequest request = UpdateHubRequest.newBuilder().setHub(hub).setUpdateMask(updateMask).build();
        return this.updateHubAsync(request);
    }

    public final OperationFuture<Hub, OperationMetadata> updateHubAsync(UpdateHubRequest request) {
        return this.updateHubOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateHubRequest, Hub, OperationMetadata> updateHubOperationCallable() {
        return this.stub.updateHubOperationCallable();
    }

    public final UnaryCallable<UpdateHubRequest, Operation> updateHubCallable() {
        return this.stub.updateHubCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteHubAsync(HubName name) {
        DeleteHubRequest request = DeleteHubRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteHubAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteHubAsync(String name) {
        DeleteHubRequest request = DeleteHubRequest.newBuilder().setName(name).build();
        return this.deleteHubAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteHubAsync(DeleteHubRequest request) {
        return this.deleteHubOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteHubRequest, Empty, OperationMetadata> deleteHubOperationCallable() {
        return this.stub.deleteHubOperationCallable();
    }

    public final UnaryCallable<DeleteHubRequest, Operation> deleteHubCallable() {
        return this.stub.deleteHubCallable();
    }

    public final ListHubSpokesPagedResponse listHubSpokes(HubName name) {
        ListHubSpokesRequest request = ListHubSpokesRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listHubSpokes(request);
    }

    public final ListHubSpokesPagedResponse listHubSpokes(String name) {
        ListHubSpokesRequest request = ListHubSpokesRequest.newBuilder().setName(name).build();
        return this.listHubSpokes(request);
    }

    public final ListHubSpokesPagedResponse listHubSpokes(ListHubSpokesRequest request) {
        return (ListHubSpokesPagedResponse)((Object)this.listHubSpokesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListHubSpokesRequest, ListHubSpokesPagedResponse> listHubSpokesPagedCallable() {
        return this.stub.listHubSpokesPagedCallable();
    }

    public final UnaryCallable<ListHubSpokesRequest, ListHubSpokesResponse> listHubSpokesCallable() {
        return this.stub.listHubSpokesCallable();
    }

    public final ListSpokesPagedResponse listSpokes(LocationName parent) {
        ListSpokesRequest request = ListSpokesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSpokes(request);
    }

    public final ListSpokesPagedResponse listSpokes(String parent) {
        ListSpokesRequest request = ListSpokesRequest.newBuilder().setParent(parent).build();
        return this.listSpokes(request);
    }

    public final ListSpokesPagedResponse listSpokes(ListSpokesRequest request) {
        return (ListSpokesPagedResponse)((Object)this.listSpokesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSpokesRequest, ListSpokesPagedResponse> listSpokesPagedCallable() {
        return this.stub.listSpokesPagedCallable();
    }

    public final UnaryCallable<ListSpokesRequest, ListSpokesResponse> listSpokesCallable() {
        return this.stub.listSpokesCallable();
    }

    public final Spoke getSpoke(SpokeName name) {
        GetSpokeRequest request = GetSpokeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSpoke(request);
    }

    public final Spoke getSpoke(String name) {
        GetSpokeRequest request = GetSpokeRequest.newBuilder().setName(name).build();
        return this.getSpoke(request);
    }

    public final Spoke getSpoke(GetSpokeRequest request) {
        return (Spoke)this.getSpokeCallable().call((Object)request);
    }

    public final UnaryCallable<GetSpokeRequest, Spoke> getSpokeCallable() {
        return this.stub.getSpokeCallable();
    }

    public final OperationFuture<Spoke, OperationMetadata> createSpokeAsync(LocationName parent, Spoke spoke, String spokeId) {
        CreateSpokeRequest request = CreateSpokeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSpoke(spoke).setSpokeId(spokeId).build();
        return this.createSpokeAsync(request);
    }

    public final OperationFuture<Spoke, OperationMetadata> createSpokeAsync(String parent, Spoke spoke, String spokeId) {
        CreateSpokeRequest request = CreateSpokeRequest.newBuilder().setParent(parent).setSpoke(spoke).setSpokeId(spokeId).build();
        return this.createSpokeAsync(request);
    }

    public final OperationFuture<Spoke, OperationMetadata> createSpokeAsync(CreateSpokeRequest request) {
        return this.createSpokeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateSpokeRequest, Spoke, OperationMetadata> createSpokeOperationCallable() {
        return this.stub.createSpokeOperationCallable();
    }

    public final UnaryCallable<CreateSpokeRequest, Operation> createSpokeCallable() {
        return this.stub.createSpokeCallable();
    }

    public final OperationFuture<Spoke, OperationMetadata> updateSpokeAsync(Spoke spoke, FieldMask updateMask) {
        UpdateSpokeRequest request = UpdateSpokeRequest.newBuilder().setSpoke(spoke).setUpdateMask(updateMask).build();
        return this.updateSpokeAsync(request);
    }

    public final OperationFuture<Spoke, OperationMetadata> updateSpokeAsync(UpdateSpokeRequest request) {
        return this.updateSpokeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateSpokeRequest, Spoke, OperationMetadata> updateSpokeOperationCallable() {
        return this.stub.updateSpokeOperationCallable();
    }

    public final UnaryCallable<UpdateSpokeRequest, Operation> updateSpokeCallable() {
        return this.stub.updateSpokeCallable();
    }

    public final OperationFuture<RejectHubSpokeResponse, OperationMetadata> rejectHubSpokeAsync(HubName name, SpokeName spokeUri) {
        RejectHubSpokeRequest request = RejectHubSpokeRequest.newBuilder().setName(name == null ? null : name.toString()).setSpokeUri(spokeUri == null ? null : spokeUri.toString()).build();
        return this.rejectHubSpokeAsync(request);
    }

    public final OperationFuture<RejectHubSpokeResponse, OperationMetadata> rejectHubSpokeAsync(HubName name, String spokeUri) {
        RejectHubSpokeRequest request = RejectHubSpokeRequest.newBuilder().setName(name == null ? null : name.toString()).setSpokeUri(spokeUri).build();
        return this.rejectHubSpokeAsync(request);
    }

    public final OperationFuture<RejectHubSpokeResponse, OperationMetadata> rejectHubSpokeAsync(String name, SpokeName spokeUri) {
        RejectHubSpokeRequest request = RejectHubSpokeRequest.newBuilder().setName(name).setSpokeUri(spokeUri == null ? null : spokeUri.toString()).build();
        return this.rejectHubSpokeAsync(request);
    }

    public final OperationFuture<RejectHubSpokeResponse, OperationMetadata> rejectHubSpokeAsync(String name, String spokeUri) {
        RejectHubSpokeRequest request = RejectHubSpokeRequest.newBuilder().setName(name).setSpokeUri(spokeUri).build();
        return this.rejectHubSpokeAsync(request);
    }

    public final OperationFuture<RejectHubSpokeResponse, OperationMetadata> rejectHubSpokeAsync(RejectHubSpokeRequest request) {
        return this.rejectHubSpokeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RejectHubSpokeRequest, RejectHubSpokeResponse, OperationMetadata> rejectHubSpokeOperationCallable() {
        return this.stub.rejectHubSpokeOperationCallable();
    }

    public final UnaryCallable<RejectHubSpokeRequest, Operation> rejectHubSpokeCallable() {
        return this.stub.rejectHubSpokeCallable();
    }

    public final OperationFuture<AcceptHubSpokeResponse, OperationMetadata> acceptHubSpokeAsync(HubName name, SpokeName spokeUri) {
        AcceptHubSpokeRequest request = AcceptHubSpokeRequest.newBuilder().setName(name == null ? null : name.toString()).setSpokeUri(spokeUri == null ? null : spokeUri.toString()).build();
        return this.acceptHubSpokeAsync(request);
    }

    public final OperationFuture<AcceptHubSpokeResponse, OperationMetadata> acceptHubSpokeAsync(HubName name, String spokeUri) {
        AcceptHubSpokeRequest request = AcceptHubSpokeRequest.newBuilder().setName(name == null ? null : name.toString()).setSpokeUri(spokeUri).build();
        return this.acceptHubSpokeAsync(request);
    }

    public final OperationFuture<AcceptHubSpokeResponse, OperationMetadata> acceptHubSpokeAsync(String name, SpokeName spokeUri) {
        AcceptHubSpokeRequest request = AcceptHubSpokeRequest.newBuilder().setName(name).setSpokeUri(spokeUri == null ? null : spokeUri.toString()).build();
        return this.acceptHubSpokeAsync(request);
    }

    public final OperationFuture<AcceptHubSpokeResponse, OperationMetadata> acceptHubSpokeAsync(String name, String spokeUri) {
        AcceptHubSpokeRequest request = AcceptHubSpokeRequest.newBuilder().setName(name).setSpokeUri(spokeUri).build();
        return this.acceptHubSpokeAsync(request);
    }

    public final OperationFuture<AcceptHubSpokeResponse, OperationMetadata> acceptHubSpokeAsync(AcceptHubSpokeRequest request) {
        return this.acceptHubSpokeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AcceptHubSpokeRequest, AcceptHubSpokeResponse, OperationMetadata> acceptHubSpokeOperationCallable() {
        return this.stub.acceptHubSpokeOperationCallable();
    }

    public final UnaryCallable<AcceptHubSpokeRequest, Operation> acceptHubSpokeCallable() {
        return this.stub.acceptHubSpokeCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSpokeAsync(SpokeName name) {
        DeleteSpokeRequest request = DeleteSpokeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteSpokeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSpokeAsync(String name) {
        DeleteSpokeRequest request = DeleteSpokeRequest.newBuilder().setName(name).build();
        return this.deleteSpokeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSpokeAsync(DeleteSpokeRequest request) {
        return this.deleteSpokeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteSpokeRequest, Empty, OperationMetadata> deleteSpokeOperationCallable() {
        return this.stub.deleteSpokeOperationCallable();
    }

    public final UnaryCallable<DeleteSpokeRequest, Operation> deleteSpokeCallable() {
        return this.stub.deleteSpokeCallable();
    }

    public final RouteTable getRouteTable(RouteTableName name) {
        GetRouteTableRequest request = GetRouteTableRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRouteTable(request);
    }

    public final RouteTable getRouteTable(String name) {
        GetRouteTableRequest request = GetRouteTableRequest.newBuilder().setName(name).build();
        return this.getRouteTable(request);
    }

    public final RouteTable getRouteTable(GetRouteTableRequest request) {
        return (RouteTable)this.getRouteTableCallable().call((Object)request);
    }

    public final UnaryCallable<GetRouteTableRequest, RouteTable> getRouteTableCallable() {
        return this.stub.getRouteTableCallable();
    }

    public final Route getRoute(HubRouteName name) {
        GetRouteRequest request = GetRouteRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRoute(request);
    }

    public final Route getRoute(String name) {
        GetRouteRequest request = GetRouteRequest.newBuilder().setName(name).build();
        return this.getRoute(request);
    }

    public final Route getRoute(GetRouteRequest request) {
        return (Route)this.getRouteCallable().call((Object)request);
    }

    public final UnaryCallable<GetRouteRequest, Route> getRouteCallable() {
        return this.stub.getRouteCallable();
    }

    public final ListRoutesPagedResponse listRoutes(RouteTableName parent) {
        ListRoutesRequest request = ListRoutesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRoutes(request);
    }

    public final ListRoutesPagedResponse listRoutes(String parent) {
        ListRoutesRequest request = ListRoutesRequest.newBuilder().setParent(parent).build();
        return this.listRoutes(request);
    }

    public final ListRoutesPagedResponse listRoutes(ListRoutesRequest request) {
        return (ListRoutesPagedResponse)((Object)this.listRoutesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRoutesRequest, ListRoutesPagedResponse> listRoutesPagedCallable() {
        return this.stub.listRoutesPagedCallable();
    }

    public final UnaryCallable<ListRoutesRequest, ListRoutesResponse> listRoutesCallable() {
        return this.stub.listRoutesCallable();
    }

    public final ListRouteTablesPagedResponse listRouteTables(HubName parent) {
        ListRouteTablesRequest request = ListRouteTablesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRouteTables(request);
    }

    public final ListRouteTablesPagedResponse listRouteTables(String parent) {
        ListRouteTablesRequest request = ListRouteTablesRequest.newBuilder().setParent(parent).build();
        return this.listRouteTables(request);
    }

    public final ListRouteTablesPagedResponse listRouteTables(ListRouteTablesRequest request) {
        return (ListRouteTablesPagedResponse)((Object)this.listRouteTablesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRouteTablesRequest, ListRouteTablesPagedResponse> listRouteTablesPagedCallable() {
        return this.stub.listRouteTablesPagedCallable();
    }

    public final UnaryCallable<ListRouteTablesRequest, ListRouteTablesResponse> listRouteTablesCallable() {
        return this.stub.listRouteTablesCallable();
    }

    public final Group getGroup(GroupName name) {
        GetGroupRequest request = GetGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGroup(request);
    }

    public final Group getGroup(String name) {
        GetGroupRequest request = GetGroupRequest.newBuilder().setName(name).build();
        return this.getGroup(request);
    }

    public final Group getGroup(GetGroupRequest request) {
        return (Group)this.getGroupCallable().call((Object)request);
    }

    public final UnaryCallable<GetGroupRequest, Group> getGroupCallable() {
        return this.stub.getGroupCallable();
    }

    public final ListGroupsPagedResponse listGroups(HubName parent) {
        ListGroupsRequest request = ListGroupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGroups(request);
    }

    public final ListGroupsPagedResponse listGroups(String parent) {
        ListGroupsRequest request = ListGroupsRequest.newBuilder().setParent(parent).build();
        return this.listGroups(request);
    }

    public final ListGroupsPagedResponse listGroups(ListGroupsRequest request) {
        return (ListGroupsPagedResponse)((Object)this.listGroupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGroupsRequest, ListGroupsPagedResponse> listGroupsPagedCallable() {
        return this.stub.listGroupsPagedCallable();
    }

    public final UnaryCallable<ListGroupsRequest, ListGroupsResponse> listGroupsCallable() {
        return this.stub.listGroupsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGroupsRequest, ListGroupsResponse, Group, ListGroupsPage, ListGroupsFixedSizeCollection> {
        private ListGroupsFixedSizeCollection(List<ListGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGroupsFixedSizeCollection createEmptyCollection() {
            return new ListGroupsFixedSizeCollection(null, 0);
        }

        protected ListGroupsFixedSizeCollection createCollection(List<ListGroupsPage> pages, int collectionSize) {
            return new ListGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGroupsPage
    extends AbstractPage<ListGroupsRequest, ListGroupsResponse, Group, ListGroupsPage> {
        private ListGroupsPage(PageContext<ListGroupsRequest, ListGroupsResponse, Group> context, ListGroupsResponse response) {
            super(context, (Object)response);
        }

        private static ListGroupsPage createEmptyPage() {
            return new ListGroupsPage(null, null);
        }

        protected ListGroupsPage createPage(PageContext<ListGroupsRequest, ListGroupsResponse, Group> context, ListGroupsResponse response) {
            return new ListGroupsPage(context, response);
        }

        public ApiFuture<ListGroupsPage> createPageAsync(PageContext<ListGroupsRequest, ListGroupsResponse, Group> context, ApiFuture<ListGroupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGroupsPagedResponse
    extends AbstractPagedListResponse<ListGroupsRequest, ListGroupsResponse, Group, ListGroupsPage, ListGroupsFixedSizeCollection> {
        public static ApiFuture<ListGroupsPagedResponse> createAsync(PageContext<ListGroupsRequest, ListGroupsResponse, Group> context, ApiFuture<ListGroupsResponse> futureResponse) {
            ApiFuture<ListGroupsPage> futurePage = ListGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGroupsPagedResponse((ListGroupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGroupsPagedResponse(ListGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGroupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRouteTablesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRouteTablesRequest, ListRouteTablesResponse, RouteTable, ListRouteTablesPage, ListRouteTablesFixedSizeCollection> {
        private ListRouteTablesFixedSizeCollection(List<ListRouteTablesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRouteTablesFixedSizeCollection createEmptyCollection() {
            return new ListRouteTablesFixedSizeCollection(null, 0);
        }

        protected ListRouteTablesFixedSizeCollection createCollection(List<ListRouteTablesPage> pages, int collectionSize) {
            return new ListRouteTablesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRouteTablesPage
    extends AbstractPage<ListRouteTablesRequest, ListRouteTablesResponse, RouteTable, ListRouteTablesPage> {
        private ListRouteTablesPage(PageContext<ListRouteTablesRequest, ListRouteTablesResponse, RouteTable> context, ListRouteTablesResponse response) {
            super(context, (Object)response);
        }

        private static ListRouteTablesPage createEmptyPage() {
            return new ListRouteTablesPage(null, null);
        }

        protected ListRouteTablesPage createPage(PageContext<ListRouteTablesRequest, ListRouteTablesResponse, RouteTable> context, ListRouteTablesResponse response) {
            return new ListRouteTablesPage(context, response);
        }

        public ApiFuture<ListRouteTablesPage> createPageAsync(PageContext<ListRouteTablesRequest, ListRouteTablesResponse, RouteTable> context, ApiFuture<ListRouteTablesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRouteTablesPagedResponse
    extends AbstractPagedListResponse<ListRouteTablesRequest, ListRouteTablesResponse, RouteTable, ListRouteTablesPage, ListRouteTablesFixedSizeCollection> {
        public static ApiFuture<ListRouteTablesPagedResponse> createAsync(PageContext<ListRouteTablesRequest, ListRouteTablesResponse, RouteTable> context, ApiFuture<ListRouteTablesResponse> futureResponse) {
            ApiFuture<ListRouteTablesPage> futurePage = ListRouteTablesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRouteTablesPagedResponse((ListRouteTablesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRouteTablesPagedResponse(ListRouteTablesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRouteTablesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRoutesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRoutesRequest, ListRoutesResponse, Route, ListRoutesPage, ListRoutesFixedSizeCollection> {
        private ListRoutesFixedSizeCollection(List<ListRoutesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRoutesFixedSizeCollection createEmptyCollection() {
            return new ListRoutesFixedSizeCollection(null, 0);
        }

        protected ListRoutesFixedSizeCollection createCollection(List<ListRoutesPage> pages, int collectionSize) {
            return new ListRoutesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRoutesPage
    extends AbstractPage<ListRoutesRequest, ListRoutesResponse, Route, ListRoutesPage> {
        private ListRoutesPage(PageContext<ListRoutesRequest, ListRoutesResponse, Route> context, ListRoutesResponse response) {
            super(context, (Object)response);
        }

        private static ListRoutesPage createEmptyPage() {
            return new ListRoutesPage(null, null);
        }

        protected ListRoutesPage createPage(PageContext<ListRoutesRequest, ListRoutesResponse, Route> context, ListRoutesResponse response) {
            return new ListRoutesPage(context, response);
        }

        public ApiFuture<ListRoutesPage> createPageAsync(PageContext<ListRoutesRequest, ListRoutesResponse, Route> context, ApiFuture<ListRoutesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRoutesPagedResponse
    extends AbstractPagedListResponse<ListRoutesRequest, ListRoutesResponse, Route, ListRoutesPage, ListRoutesFixedSizeCollection> {
        public static ApiFuture<ListRoutesPagedResponse> createAsync(PageContext<ListRoutesRequest, ListRoutesResponse, Route> context, ApiFuture<ListRoutesResponse> futureResponse) {
            ApiFuture<ListRoutesPage> futurePage = ListRoutesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRoutesPagedResponse((ListRoutesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRoutesPagedResponse(ListRoutesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRoutesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSpokesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSpokesRequest, ListSpokesResponse, Spoke, ListSpokesPage, ListSpokesFixedSizeCollection> {
        private ListSpokesFixedSizeCollection(List<ListSpokesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSpokesFixedSizeCollection createEmptyCollection() {
            return new ListSpokesFixedSizeCollection(null, 0);
        }

        protected ListSpokesFixedSizeCollection createCollection(List<ListSpokesPage> pages, int collectionSize) {
            return new ListSpokesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSpokesPage
    extends AbstractPage<ListSpokesRequest, ListSpokesResponse, Spoke, ListSpokesPage> {
        private ListSpokesPage(PageContext<ListSpokesRequest, ListSpokesResponse, Spoke> context, ListSpokesResponse response) {
            super(context, (Object)response);
        }

        private static ListSpokesPage createEmptyPage() {
            return new ListSpokesPage(null, null);
        }

        protected ListSpokesPage createPage(PageContext<ListSpokesRequest, ListSpokesResponse, Spoke> context, ListSpokesResponse response) {
            return new ListSpokesPage(context, response);
        }

        public ApiFuture<ListSpokesPage> createPageAsync(PageContext<ListSpokesRequest, ListSpokesResponse, Spoke> context, ApiFuture<ListSpokesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSpokesPagedResponse
    extends AbstractPagedListResponse<ListSpokesRequest, ListSpokesResponse, Spoke, ListSpokesPage, ListSpokesFixedSizeCollection> {
        public static ApiFuture<ListSpokesPagedResponse> createAsync(PageContext<ListSpokesRequest, ListSpokesResponse, Spoke> context, ApiFuture<ListSpokesResponse> futureResponse) {
            ApiFuture<ListSpokesPage> futurePage = ListSpokesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSpokesPagedResponse((ListSpokesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSpokesPagedResponse(ListSpokesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSpokesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListHubSpokesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListHubSpokesRequest, ListHubSpokesResponse, Spoke, ListHubSpokesPage, ListHubSpokesFixedSizeCollection> {
        private ListHubSpokesFixedSizeCollection(List<ListHubSpokesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListHubSpokesFixedSizeCollection createEmptyCollection() {
            return new ListHubSpokesFixedSizeCollection(null, 0);
        }

        protected ListHubSpokesFixedSizeCollection createCollection(List<ListHubSpokesPage> pages, int collectionSize) {
            return new ListHubSpokesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListHubSpokesPage
    extends AbstractPage<ListHubSpokesRequest, ListHubSpokesResponse, Spoke, ListHubSpokesPage> {
        private ListHubSpokesPage(PageContext<ListHubSpokesRequest, ListHubSpokesResponse, Spoke> context, ListHubSpokesResponse response) {
            super(context, (Object)response);
        }

        private static ListHubSpokesPage createEmptyPage() {
            return new ListHubSpokesPage(null, null);
        }

        protected ListHubSpokesPage createPage(PageContext<ListHubSpokesRequest, ListHubSpokesResponse, Spoke> context, ListHubSpokesResponse response) {
            return new ListHubSpokesPage(context, response);
        }

        public ApiFuture<ListHubSpokesPage> createPageAsync(PageContext<ListHubSpokesRequest, ListHubSpokesResponse, Spoke> context, ApiFuture<ListHubSpokesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListHubSpokesPagedResponse
    extends AbstractPagedListResponse<ListHubSpokesRequest, ListHubSpokesResponse, Spoke, ListHubSpokesPage, ListHubSpokesFixedSizeCollection> {
        public static ApiFuture<ListHubSpokesPagedResponse> createAsync(PageContext<ListHubSpokesRequest, ListHubSpokesResponse, Spoke> context, ApiFuture<ListHubSpokesResponse> futureResponse) {
            ApiFuture<ListHubSpokesPage> futurePage = ListHubSpokesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListHubSpokesPagedResponse((ListHubSpokesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListHubSpokesPagedResponse(ListHubSpokesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListHubSpokesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListHubsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListHubsRequest, ListHubsResponse, Hub, ListHubsPage, ListHubsFixedSizeCollection> {
        private ListHubsFixedSizeCollection(List<ListHubsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListHubsFixedSizeCollection createEmptyCollection() {
            return new ListHubsFixedSizeCollection(null, 0);
        }

        protected ListHubsFixedSizeCollection createCollection(List<ListHubsPage> pages, int collectionSize) {
            return new ListHubsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListHubsPage
    extends AbstractPage<ListHubsRequest, ListHubsResponse, Hub, ListHubsPage> {
        private ListHubsPage(PageContext<ListHubsRequest, ListHubsResponse, Hub> context, ListHubsResponse response) {
            super(context, (Object)response);
        }

        private static ListHubsPage createEmptyPage() {
            return new ListHubsPage(null, null);
        }

        protected ListHubsPage createPage(PageContext<ListHubsRequest, ListHubsResponse, Hub> context, ListHubsResponse response) {
            return new ListHubsPage(context, response);
        }

        public ApiFuture<ListHubsPage> createPageAsync(PageContext<ListHubsRequest, ListHubsResponse, Hub> context, ApiFuture<ListHubsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListHubsPagedResponse
    extends AbstractPagedListResponse<ListHubsRequest, ListHubsResponse, Hub, ListHubsPage, ListHubsFixedSizeCollection> {
        public static ApiFuture<ListHubsPagedResponse> createAsync(PageContext<ListHubsRequest, ListHubsResponse, Hub> context, ApiFuture<ListHubsResponse> futureResponse) {
            ApiFuture<ListHubsPage> futurePage = ListHubsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListHubsPagedResponse((ListHubsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListHubsPagedResponse(ListHubsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListHubsFixedSizeCollection.createEmptyCollection());
        }
    }
}

