/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networksecurity.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.networksecurity.v1.AddAddressGroupItemsRequest;
import com.google.cloud.networksecurity.v1.AddressGroup;
import com.google.cloud.networksecurity.v1.AddressGroupName;
import com.google.cloud.networksecurity.v1.AddressGroupServiceSettings;
import com.google.cloud.networksecurity.v1.CloneAddressGroupItemsRequest;
import com.google.cloud.networksecurity.v1.CreateAddressGroupRequest;
import com.google.cloud.networksecurity.v1.DeleteAddressGroupRequest;
import com.google.cloud.networksecurity.v1.GetAddressGroupRequest;
import com.google.cloud.networksecurity.v1.ListAddressGroupReferencesRequest;
import com.google.cloud.networksecurity.v1.ListAddressGroupReferencesResponse;
import com.google.cloud.networksecurity.v1.ListAddressGroupsRequest;
import com.google.cloud.networksecurity.v1.ListAddressGroupsResponse;
import com.google.cloud.networksecurity.v1.LocationName;
import com.google.cloud.networksecurity.v1.OperationMetadata;
import com.google.cloud.networksecurity.v1.OrganizationLocationName;
import com.google.cloud.networksecurity.v1.RemoveAddressGroupItemsRequest;
import com.google.cloud.networksecurity.v1.UpdateAddressGroupRequest;
import com.google.cloud.networksecurity.v1.stub.AddressGroupServiceStub;
import com.google.cloud.networksecurity.v1.stub.AddressGroupServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AddressGroupServiceClient
implements BackgroundResource {
    private final AddressGroupServiceSettings settings;
    private final AddressGroupServiceStub stub;
    private final OperationsClient operationsClient;

    public static final AddressGroupServiceClient create() throws IOException {
        return AddressGroupServiceClient.create(AddressGroupServiceSettings.newBuilder().build());
    }

    public static final AddressGroupServiceClient create(AddressGroupServiceSettings settings) throws IOException {
        return new AddressGroupServiceClient(settings);
    }

    public static final AddressGroupServiceClient create(AddressGroupServiceStub stub) {
        return new AddressGroupServiceClient(stub);
    }

    protected AddressGroupServiceClient(AddressGroupServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AddressGroupServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected AddressGroupServiceClient(AddressGroupServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final AddressGroupServiceSettings getSettings() {
        return this.settings;
    }

    public AddressGroupServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListAddressGroupsPagedResponse listAddressGroups(LocationName parent) {
        ListAddressGroupsRequest request = ListAddressGroupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAddressGroups(request);
    }

    public final ListAddressGroupsPagedResponse listAddressGroups(String parent) {
        ListAddressGroupsRequest request = ListAddressGroupsRequest.newBuilder().setParent(parent).build();
        return this.listAddressGroups(request);
    }

    public final ListAddressGroupsPagedResponse listAddressGroups(ListAddressGroupsRequest request) {
        return (ListAddressGroupsPagedResponse)((Object)this.listAddressGroupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAddressGroupsRequest, ListAddressGroupsPagedResponse> listAddressGroupsPagedCallable() {
        return this.stub.listAddressGroupsPagedCallable();
    }

    public final UnaryCallable<ListAddressGroupsRequest, ListAddressGroupsResponse> listAddressGroupsCallable() {
        return this.stub.listAddressGroupsCallable();
    }

    public final AddressGroup getAddressGroup(AddressGroupName name) {
        GetAddressGroupRequest request = GetAddressGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAddressGroup(request);
    }

    public final AddressGroup getAddressGroup(String name) {
        GetAddressGroupRequest request = GetAddressGroupRequest.newBuilder().setName(name).build();
        return this.getAddressGroup(request);
    }

    public final AddressGroup getAddressGroup(GetAddressGroupRequest request) {
        return (AddressGroup)this.getAddressGroupCallable().call((Object)request);
    }

    public final UnaryCallable<GetAddressGroupRequest, AddressGroup> getAddressGroupCallable() {
        return this.stub.getAddressGroupCallable();
    }

    public final OperationFuture<AddressGroup, OperationMetadata> createAddressGroupAsync(LocationName parent, AddressGroup addressGroup, String addressGroupId) {
        CreateAddressGroupRequest request = CreateAddressGroupRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAddressGroup(addressGroup).setAddressGroupId(addressGroupId).build();
        return this.createAddressGroupAsync(request);
    }

    public final OperationFuture<AddressGroup, OperationMetadata> createAddressGroupAsync(OrganizationLocationName parent, AddressGroup addressGroup, String addressGroupId) {
        CreateAddressGroupRequest request = CreateAddressGroupRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAddressGroup(addressGroup).setAddressGroupId(addressGroupId).build();
        return this.createAddressGroupAsync(request);
    }

    public final OperationFuture<AddressGroup, OperationMetadata> createAddressGroupAsync(String parent, AddressGroup addressGroup, String addressGroupId) {
        CreateAddressGroupRequest request = CreateAddressGroupRequest.newBuilder().setParent(parent).setAddressGroup(addressGroup).setAddressGroupId(addressGroupId).build();
        return this.createAddressGroupAsync(request);
    }

    public final OperationFuture<AddressGroup, OperationMetadata> createAddressGroupAsync(CreateAddressGroupRequest request) {
        return this.createAddressGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAddressGroupRequest, AddressGroup, OperationMetadata> createAddressGroupOperationCallable() {
        return this.stub.createAddressGroupOperationCallable();
    }

    public final UnaryCallable<CreateAddressGroupRequest, Operation> createAddressGroupCallable() {
        return this.stub.createAddressGroupCallable();
    }

    public final OperationFuture<AddressGroup, OperationMetadata> updateAddressGroupAsync(AddressGroup addressGroup, FieldMask updateMask) {
        UpdateAddressGroupRequest request = UpdateAddressGroupRequest.newBuilder().setAddressGroup(addressGroup).setUpdateMask(updateMask).build();
        return this.updateAddressGroupAsync(request);
    }

    public final OperationFuture<AddressGroup, OperationMetadata> updateAddressGroupAsync(UpdateAddressGroupRequest request) {
        return this.updateAddressGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateAddressGroupRequest, AddressGroup, OperationMetadata> updateAddressGroupOperationCallable() {
        return this.stub.updateAddressGroupOperationCallable();
    }

    public final UnaryCallable<UpdateAddressGroupRequest, Operation> updateAddressGroupCallable() {
        return this.stub.updateAddressGroupCallable();
    }

    public final OperationFuture<AddressGroup, OperationMetadata> addAddressGroupItemsAsync(AddressGroupName addressGroup, List<String> items) {
        AddAddressGroupItemsRequest request = AddAddressGroupItemsRequest.newBuilder().setAddressGroup(addressGroup == null ? null : addressGroup.toString()).addAllItems(items).build();
        return this.addAddressGroupItemsAsync(request);
    }

    public final OperationFuture<AddressGroup, OperationMetadata> addAddressGroupItemsAsync(String addressGroup, List<String> items) {
        AddAddressGroupItemsRequest request = AddAddressGroupItemsRequest.newBuilder().setAddressGroup(addressGroup).addAllItems(items).build();
        return this.addAddressGroupItemsAsync(request);
    }

    public final OperationFuture<AddressGroup, OperationMetadata> addAddressGroupItemsAsync(AddAddressGroupItemsRequest request) {
        return this.addAddressGroupItemsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AddAddressGroupItemsRequest, AddressGroup, OperationMetadata> addAddressGroupItemsOperationCallable() {
        return this.stub.addAddressGroupItemsOperationCallable();
    }

    public final UnaryCallable<AddAddressGroupItemsRequest, Operation> addAddressGroupItemsCallable() {
        return this.stub.addAddressGroupItemsCallable();
    }

    public final OperationFuture<AddressGroup, OperationMetadata> removeAddressGroupItemsAsync(AddressGroupName addressGroup, List<String> items) {
        RemoveAddressGroupItemsRequest request = RemoveAddressGroupItemsRequest.newBuilder().setAddressGroup(addressGroup == null ? null : addressGroup.toString()).addAllItems(items).build();
        return this.removeAddressGroupItemsAsync(request);
    }

    public final OperationFuture<AddressGroup, OperationMetadata> removeAddressGroupItemsAsync(String addressGroup, List<String> items) {
        RemoveAddressGroupItemsRequest request = RemoveAddressGroupItemsRequest.newBuilder().setAddressGroup(addressGroup).addAllItems(items).build();
        return this.removeAddressGroupItemsAsync(request);
    }

    public final OperationFuture<AddressGroup, OperationMetadata> removeAddressGroupItemsAsync(RemoveAddressGroupItemsRequest request) {
        return this.removeAddressGroupItemsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RemoveAddressGroupItemsRequest, AddressGroup, OperationMetadata> removeAddressGroupItemsOperationCallable() {
        return this.stub.removeAddressGroupItemsOperationCallable();
    }

    public final UnaryCallable<RemoveAddressGroupItemsRequest, Operation> removeAddressGroupItemsCallable() {
        return this.stub.removeAddressGroupItemsCallable();
    }

    public final OperationFuture<AddressGroup, OperationMetadata> cloneAddressGroupItemsAsync(AddressGroupName addressGroup, AddressGroupName sourceAddressGroup) {
        CloneAddressGroupItemsRequest request = CloneAddressGroupItemsRequest.newBuilder().setAddressGroup(addressGroup == null ? null : addressGroup.toString()).setSourceAddressGroup(sourceAddressGroup == null ? null : sourceAddressGroup.toString()).build();
        return this.cloneAddressGroupItemsAsync(request);
    }

    public final OperationFuture<AddressGroup, OperationMetadata> cloneAddressGroupItemsAsync(AddressGroupName addressGroup, String sourceAddressGroup) {
        CloneAddressGroupItemsRequest request = CloneAddressGroupItemsRequest.newBuilder().setAddressGroup(addressGroup == null ? null : addressGroup.toString()).setSourceAddressGroup(sourceAddressGroup).build();
        return this.cloneAddressGroupItemsAsync(request);
    }

    public final OperationFuture<AddressGroup, OperationMetadata> cloneAddressGroupItemsAsync(String addressGroup, AddressGroupName sourceAddressGroup) {
        CloneAddressGroupItemsRequest request = CloneAddressGroupItemsRequest.newBuilder().setAddressGroup(addressGroup).setSourceAddressGroup(sourceAddressGroup == null ? null : sourceAddressGroup.toString()).build();
        return this.cloneAddressGroupItemsAsync(request);
    }

    public final OperationFuture<AddressGroup, OperationMetadata> cloneAddressGroupItemsAsync(String addressGroup, String sourceAddressGroup) {
        CloneAddressGroupItemsRequest request = CloneAddressGroupItemsRequest.newBuilder().setAddressGroup(addressGroup).setSourceAddressGroup(sourceAddressGroup).build();
        return this.cloneAddressGroupItemsAsync(request);
    }

    public final OperationFuture<AddressGroup, OperationMetadata> cloneAddressGroupItemsAsync(CloneAddressGroupItemsRequest request) {
        return this.cloneAddressGroupItemsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CloneAddressGroupItemsRequest, AddressGroup, OperationMetadata> cloneAddressGroupItemsOperationCallable() {
        return this.stub.cloneAddressGroupItemsOperationCallable();
    }

    public final UnaryCallable<CloneAddressGroupItemsRequest, Operation> cloneAddressGroupItemsCallable() {
        return this.stub.cloneAddressGroupItemsCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAddressGroupAsync(AddressGroupName name) {
        DeleteAddressGroupRequest request = DeleteAddressGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteAddressGroupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAddressGroupAsync(String name) {
        DeleteAddressGroupRequest request = DeleteAddressGroupRequest.newBuilder().setName(name).build();
        return this.deleteAddressGroupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAddressGroupAsync(DeleteAddressGroupRequest request) {
        return this.deleteAddressGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteAddressGroupRequest, Empty, OperationMetadata> deleteAddressGroupOperationCallable() {
        return this.stub.deleteAddressGroupOperationCallable();
    }

    public final UnaryCallable<DeleteAddressGroupRequest, Operation> deleteAddressGroupCallable() {
        return this.stub.deleteAddressGroupCallable();
    }

    public final ListAddressGroupReferencesPagedResponse listAddressGroupReferences(AddressGroupName addressGroup) {
        ListAddressGroupReferencesRequest request = ListAddressGroupReferencesRequest.newBuilder().setAddressGroup(addressGroup == null ? null : addressGroup.toString()).build();
        return this.listAddressGroupReferences(request);
    }

    public final ListAddressGroupReferencesPagedResponse listAddressGroupReferences(String addressGroup) {
        ListAddressGroupReferencesRequest request = ListAddressGroupReferencesRequest.newBuilder().setAddressGroup(addressGroup).build();
        return this.listAddressGroupReferences(request);
    }

    public final ListAddressGroupReferencesPagedResponse listAddressGroupReferences(ListAddressGroupReferencesRequest request) {
        return (ListAddressGroupReferencesPagedResponse)((Object)this.listAddressGroupReferencesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAddressGroupReferencesRequest, ListAddressGroupReferencesPagedResponse> listAddressGroupReferencesPagedCallable() {
        return this.stub.listAddressGroupReferencesPagedCallable();
    }

    public final UnaryCallable<ListAddressGroupReferencesRequest, ListAddressGroupReferencesResponse> listAddressGroupReferencesCallable() {
        return this.stub.listAddressGroupReferencesCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAddressGroupReferencesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAddressGroupReferencesRequest, ListAddressGroupReferencesResponse, ListAddressGroupReferencesResponse.AddressGroupReference, ListAddressGroupReferencesPage, ListAddressGroupReferencesFixedSizeCollection> {
        private ListAddressGroupReferencesFixedSizeCollection(List<ListAddressGroupReferencesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAddressGroupReferencesFixedSizeCollection createEmptyCollection() {
            return new ListAddressGroupReferencesFixedSizeCollection(null, 0);
        }

        protected ListAddressGroupReferencesFixedSizeCollection createCollection(List<ListAddressGroupReferencesPage> pages, int collectionSize) {
            return new ListAddressGroupReferencesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAddressGroupReferencesPage
    extends AbstractPage<ListAddressGroupReferencesRequest, ListAddressGroupReferencesResponse, ListAddressGroupReferencesResponse.AddressGroupReference, ListAddressGroupReferencesPage> {
        private ListAddressGroupReferencesPage(PageContext<ListAddressGroupReferencesRequest, ListAddressGroupReferencesResponse, ListAddressGroupReferencesResponse.AddressGroupReference> context, ListAddressGroupReferencesResponse response) {
            super(context, (Object)response);
        }

        private static ListAddressGroupReferencesPage createEmptyPage() {
            return new ListAddressGroupReferencesPage(null, null);
        }

        protected ListAddressGroupReferencesPage createPage(PageContext<ListAddressGroupReferencesRequest, ListAddressGroupReferencesResponse, ListAddressGroupReferencesResponse.AddressGroupReference> context, ListAddressGroupReferencesResponse response) {
            return new ListAddressGroupReferencesPage(context, response);
        }

        public ApiFuture<ListAddressGroupReferencesPage> createPageAsync(PageContext<ListAddressGroupReferencesRequest, ListAddressGroupReferencesResponse, ListAddressGroupReferencesResponse.AddressGroupReference> context, ApiFuture<ListAddressGroupReferencesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAddressGroupReferencesPagedResponse
    extends AbstractPagedListResponse<ListAddressGroupReferencesRequest, ListAddressGroupReferencesResponse, ListAddressGroupReferencesResponse.AddressGroupReference, ListAddressGroupReferencesPage, ListAddressGroupReferencesFixedSizeCollection> {
        public static ApiFuture<ListAddressGroupReferencesPagedResponse> createAsync(PageContext<ListAddressGroupReferencesRequest, ListAddressGroupReferencesResponse, ListAddressGroupReferencesResponse.AddressGroupReference> context, ApiFuture<ListAddressGroupReferencesResponse> futureResponse) {
            ApiFuture<ListAddressGroupReferencesPage> futurePage = ListAddressGroupReferencesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAddressGroupReferencesPagedResponse((ListAddressGroupReferencesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAddressGroupReferencesPagedResponse(ListAddressGroupReferencesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAddressGroupReferencesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAddressGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAddressGroupsRequest, ListAddressGroupsResponse, AddressGroup, ListAddressGroupsPage, ListAddressGroupsFixedSizeCollection> {
        private ListAddressGroupsFixedSizeCollection(List<ListAddressGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAddressGroupsFixedSizeCollection createEmptyCollection() {
            return new ListAddressGroupsFixedSizeCollection(null, 0);
        }

        protected ListAddressGroupsFixedSizeCollection createCollection(List<ListAddressGroupsPage> pages, int collectionSize) {
            return new ListAddressGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAddressGroupsPage
    extends AbstractPage<ListAddressGroupsRequest, ListAddressGroupsResponse, AddressGroup, ListAddressGroupsPage> {
        private ListAddressGroupsPage(PageContext<ListAddressGroupsRequest, ListAddressGroupsResponse, AddressGroup> context, ListAddressGroupsResponse response) {
            super(context, (Object)response);
        }

        private static ListAddressGroupsPage createEmptyPage() {
            return new ListAddressGroupsPage(null, null);
        }

        protected ListAddressGroupsPage createPage(PageContext<ListAddressGroupsRequest, ListAddressGroupsResponse, AddressGroup> context, ListAddressGroupsResponse response) {
            return new ListAddressGroupsPage(context, response);
        }

        public ApiFuture<ListAddressGroupsPage> createPageAsync(PageContext<ListAddressGroupsRequest, ListAddressGroupsResponse, AddressGroup> context, ApiFuture<ListAddressGroupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAddressGroupsPagedResponse
    extends AbstractPagedListResponse<ListAddressGroupsRequest, ListAddressGroupsResponse, AddressGroup, ListAddressGroupsPage, ListAddressGroupsFixedSizeCollection> {
        public static ApiFuture<ListAddressGroupsPagedResponse> createAsync(PageContext<ListAddressGroupsRequest, ListAddressGroupsResponse, AddressGroup> context, ApiFuture<ListAddressGroupsResponse> futureResponse) {
            ApiFuture<ListAddressGroupsPage> futurePage = ListAddressGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAddressGroupsPagedResponse((ListAddressGroupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAddressGroupsPagedResponse(ListAddressGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAddressGroupsFixedSizeCollection.createEmptyCollection());
        }
    }
}

