/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkmanagement.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.networkmanagement.v1.ConnectivityTest;
import com.google.cloud.networkmanagement.v1.CreateConnectivityTestRequest;
import com.google.cloud.networkmanagement.v1.DeleteConnectivityTestRequest;
import com.google.cloud.networkmanagement.v1.GetConnectivityTestRequest;
import com.google.cloud.networkmanagement.v1.ListConnectivityTestsRequest;
import com.google.cloud.networkmanagement.v1.ListConnectivityTestsResponse;
import com.google.cloud.networkmanagement.v1.OperationMetadata;
import com.google.cloud.networkmanagement.v1.ReachabilityServiceClient;
import com.google.cloud.networkmanagement.v1.RerunConnectivityTestRequest;
import com.google.cloud.networkmanagement.v1.UpdateConnectivityTestRequest;
import com.google.cloud.networkmanagement.v1.stub.GrpcReachabilityServiceCallableFactory;
import com.google.cloud.networkmanagement.v1.stub.ReachabilityServiceStub;
import com.google.cloud.networkmanagement.v1.stub.ReachabilityServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcReachabilityServiceStub
extends ReachabilityServiceStub {
    private static final MethodDescriptor<ListConnectivityTestsRequest, ListConnectivityTestsResponse> listConnectivityTestsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkmanagement.v1.ReachabilityService/ListConnectivityTests").setRequestMarshaller(ProtoUtils.marshaller((Message)ListConnectivityTestsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListConnectivityTestsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetConnectivityTestRequest, ConnectivityTest> getConnectivityTestMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkmanagement.v1.ReachabilityService/GetConnectivityTest").setRequestMarshaller(ProtoUtils.marshaller((Message)GetConnectivityTestRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ConnectivityTest.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateConnectivityTestRequest, Operation> createConnectivityTestMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkmanagement.v1.ReachabilityService/CreateConnectivityTest").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateConnectivityTestRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateConnectivityTestRequest, Operation> updateConnectivityTestMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkmanagement.v1.ReachabilityService/UpdateConnectivityTest").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateConnectivityTestRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<RerunConnectivityTestRequest, Operation> rerunConnectivityTestMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkmanagement.v1.ReachabilityService/RerunConnectivityTest").setRequestMarshaller(ProtoUtils.marshaller((Message)RerunConnectivityTestRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteConnectivityTestRequest, Operation> deleteConnectivityTestMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkmanagement.v1.ReachabilityService/DeleteConnectivityTest").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteConnectivityTestRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<ListConnectivityTestsRequest, ListConnectivityTestsResponse> listConnectivityTestsCallable;
    private final UnaryCallable<ListConnectivityTestsRequest, ReachabilityServiceClient.ListConnectivityTestsPagedResponse> listConnectivityTestsPagedCallable;
    private final UnaryCallable<GetConnectivityTestRequest, ConnectivityTest> getConnectivityTestCallable;
    private final UnaryCallable<CreateConnectivityTestRequest, Operation> createConnectivityTestCallable;
    private final OperationCallable<CreateConnectivityTestRequest, ConnectivityTest, OperationMetadata> createConnectivityTestOperationCallable;
    private final UnaryCallable<UpdateConnectivityTestRequest, Operation> updateConnectivityTestCallable;
    private final OperationCallable<UpdateConnectivityTestRequest, ConnectivityTest, OperationMetadata> updateConnectivityTestOperationCallable;
    private final UnaryCallable<RerunConnectivityTestRequest, Operation> rerunConnectivityTestCallable;
    private final OperationCallable<RerunConnectivityTestRequest, ConnectivityTest, OperationMetadata> rerunConnectivityTestOperationCallable;
    private final UnaryCallable<DeleteConnectivityTestRequest, Operation> deleteConnectivityTestCallable;
    private final OperationCallable<DeleteConnectivityTestRequest, Empty, OperationMetadata> deleteConnectivityTestOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcReachabilityServiceStub create(ReachabilityServiceStubSettings settings) throws IOException {
        return new GrpcReachabilityServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcReachabilityServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcReachabilityServiceStub(ReachabilityServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcReachabilityServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcReachabilityServiceStub(ReachabilityServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcReachabilityServiceStub(ReachabilityServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcReachabilityServiceCallableFactory());
    }

    protected GrpcReachabilityServiceStub(ReachabilityServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listConnectivityTestsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listConnectivityTestsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListConnectivityTestsRequest>(){

            public Map<String, String> extract(ListConnectivityTestsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getConnectivityTestTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getConnectivityTestMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetConnectivityTestRequest>(){

            public Map<String, String> extract(GetConnectivityTestRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings createConnectivityTestTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createConnectivityTestMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateConnectivityTestRequest>(){

            public Map<String, String> extract(CreateConnectivityTestRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateConnectivityTestTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateConnectivityTestMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateConnectivityTestRequest>(){

            public Map<String, String> extract(UpdateConnectivityTestRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource.name", (Object)String.valueOf(request.getResource().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings rerunConnectivityTestTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(rerunConnectivityTestMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<RerunConnectivityTestRequest>(){

            public Map<String, String> extract(RerunConnectivityTestRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteConnectivityTestTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteConnectivityTestMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteConnectivityTestRequest>(){

            public Map<String, String> extract(DeleteConnectivityTestRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        this.listConnectivityTestsCallable = callableFactory.createUnaryCallable(listConnectivityTestsTransportSettings, settings.listConnectivityTestsSettings(), clientContext);
        this.listConnectivityTestsPagedCallable = callableFactory.createPagedCallable(listConnectivityTestsTransportSettings, settings.listConnectivityTestsSettings(), clientContext);
        this.getConnectivityTestCallable = callableFactory.createUnaryCallable(getConnectivityTestTransportSettings, settings.getConnectivityTestSettings(), clientContext);
        this.createConnectivityTestCallable = callableFactory.createUnaryCallable(createConnectivityTestTransportSettings, settings.createConnectivityTestSettings(), clientContext);
        this.createConnectivityTestOperationCallable = callableFactory.createOperationCallable(createConnectivityTestTransportSettings, settings.createConnectivityTestOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateConnectivityTestCallable = callableFactory.createUnaryCallable(updateConnectivityTestTransportSettings, settings.updateConnectivityTestSettings(), clientContext);
        this.updateConnectivityTestOperationCallable = callableFactory.createOperationCallable(updateConnectivityTestTransportSettings, settings.updateConnectivityTestOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.rerunConnectivityTestCallable = callableFactory.createUnaryCallable(rerunConnectivityTestTransportSettings, settings.rerunConnectivityTestSettings(), clientContext);
        this.rerunConnectivityTestOperationCallable = callableFactory.createOperationCallable(rerunConnectivityTestTransportSettings, settings.rerunConnectivityTestOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteConnectivityTestCallable = callableFactory.createUnaryCallable(deleteConnectivityTestTransportSettings, settings.deleteConnectivityTestSettings(), clientContext);
        this.deleteConnectivityTestOperationCallable = callableFactory.createOperationCallable(deleteConnectivityTestTransportSettings, settings.deleteConnectivityTestOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListConnectivityTestsRequest, ListConnectivityTestsResponse> listConnectivityTestsCallable() {
        return this.listConnectivityTestsCallable;
    }

    @Override
    public UnaryCallable<ListConnectivityTestsRequest, ReachabilityServiceClient.ListConnectivityTestsPagedResponse> listConnectivityTestsPagedCallable() {
        return this.listConnectivityTestsPagedCallable;
    }

    @Override
    public UnaryCallable<GetConnectivityTestRequest, ConnectivityTest> getConnectivityTestCallable() {
        return this.getConnectivityTestCallable;
    }

    @Override
    public UnaryCallable<CreateConnectivityTestRequest, Operation> createConnectivityTestCallable() {
        return this.createConnectivityTestCallable;
    }

    @Override
    public OperationCallable<CreateConnectivityTestRequest, ConnectivityTest, OperationMetadata> createConnectivityTestOperationCallable() {
        return this.createConnectivityTestOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateConnectivityTestRequest, Operation> updateConnectivityTestCallable() {
        return this.updateConnectivityTestCallable;
    }

    @Override
    public OperationCallable<UpdateConnectivityTestRequest, ConnectivityTest, OperationMetadata> updateConnectivityTestOperationCallable() {
        return this.updateConnectivityTestOperationCallable;
    }

    @Override
    public UnaryCallable<RerunConnectivityTestRequest, Operation> rerunConnectivityTestCallable() {
        return this.rerunConnectivityTestCallable;
    }

    @Override
    public OperationCallable<RerunConnectivityTestRequest, ConnectivityTest, OperationMetadata> rerunConnectivityTestOperationCallable() {
        return this.rerunConnectivityTestOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteConnectivityTestRequest, Operation> deleteConnectivityTestCallable() {
        return this.deleteConnectivityTestCallable;
    }

    @Override
    public OperationCallable<DeleteConnectivityTestRequest, Empty, OperationMetadata> deleteConnectivityTestOperationCallable() {
        return this.deleteConnectivityTestOperationCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

