/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.monitoring.v3.AlertPolicyServiceSettings;
import com.google.cloud.monitoring.v3.stub.AlertPolicyServiceStub;
import com.google.cloud.monitoring.v3.stub.AlertPolicyServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.monitoring.v3.AlertPolicy;
import com.google.monitoring.v3.AlertPolicyName;
import com.google.monitoring.v3.CreateAlertPolicyRequest;
import com.google.monitoring.v3.DeleteAlertPolicyRequest;
import com.google.monitoring.v3.GetAlertPolicyRequest;
import com.google.monitoring.v3.ListAlertPoliciesRequest;
import com.google.monitoring.v3.ListAlertPoliciesResponse;
import com.google.monitoring.v3.OrganizationName;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.UpdateAlertPolicyRequest;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AlertPolicyServiceClient
implements BackgroundResource {
    private final AlertPolicyServiceSettings settings;
    private final AlertPolicyServiceStub stub;

    public static final AlertPolicyServiceClient create() throws IOException {
        return AlertPolicyServiceClient.create(AlertPolicyServiceSettings.newBuilder().build());
    }

    public static final AlertPolicyServiceClient create(AlertPolicyServiceSettings settings) throws IOException {
        return new AlertPolicyServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AlertPolicyServiceClient create(AlertPolicyServiceStub stub) {
        return new AlertPolicyServiceClient(stub);
    }

    protected AlertPolicyServiceClient(AlertPolicyServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AlertPolicyServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AlertPolicyServiceClient(AlertPolicyServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AlertPolicyServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AlertPolicyServiceStub getStub() {
        return this.stub;
    }

    public final ListAlertPoliciesPagedResponse listAlertPolicies(ResourceName name) {
        ListAlertPoliciesRequest request = ListAlertPoliciesRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listAlertPolicies(request);
    }

    public final ListAlertPoliciesPagedResponse listAlertPolicies(OrganizationName name) {
        ListAlertPoliciesRequest request = ListAlertPoliciesRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listAlertPolicies(request);
    }

    public final ListAlertPoliciesPagedResponse listAlertPolicies(ProjectName name) {
        ListAlertPoliciesRequest request = ListAlertPoliciesRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listAlertPolicies(request);
    }

    public final ListAlertPoliciesPagedResponse listAlertPolicies(String name) {
        ListAlertPoliciesRequest request = ListAlertPoliciesRequest.newBuilder().setName(name).build();
        return this.listAlertPolicies(request);
    }

    public final ListAlertPoliciesPagedResponse listAlertPolicies(ListAlertPoliciesRequest request) {
        return (ListAlertPoliciesPagedResponse)((Object)this.listAlertPoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAlertPoliciesRequest, ListAlertPoliciesPagedResponse> listAlertPoliciesPagedCallable() {
        return this.stub.listAlertPoliciesPagedCallable();
    }

    public final UnaryCallable<ListAlertPoliciesRequest, ListAlertPoliciesResponse> listAlertPoliciesCallable() {
        return this.stub.listAlertPoliciesCallable();
    }

    public final AlertPolicy getAlertPolicy(AlertPolicyName name) {
        GetAlertPolicyRequest request = GetAlertPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAlertPolicy(request);
    }

    public final AlertPolicy getAlertPolicy(String name) {
        GetAlertPolicyRequest request = GetAlertPolicyRequest.newBuilder().setName(name).build();
        return this.getAlertPolicy(request);
    }

    public final AlertPolicy getAlertPolicy(GetAlertPolicyRequest request) {
        return (AlertPolicy)this.getAlertPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetAlertPolicyRequest, AlertPolicy> getAlertPolicyCallable() {
        return this.stub.getAlertPolicyCallable();
    }

    public final AlertPolicy createAlertPolicy(ResourceName name, AlertPolicy alertPolicy) {
        CreateAlertPolicyRequest request = CreateAlertPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).setAlertPolicy(alertPolicy).build();
        return this.createAlertPolicy(request);
    }

    public final AlertPolicy createAlertPolicy(OrganizationName name, AlertPolicy alertPolicy) {
        CreateAlertPolicyRequest request = CreateAlertPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).setAlertPolicy(alertPolicy).build();
        return this.createAlertPolicy(request);
    }

    public final AlertPolicy createAlertPolicy(ProjectName name, AlertPolicy alertPolicy) {
        CreateAlertPolicyRequest request = CreateAlertPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).setAlertPolicy(alertPolicy).build();
        return this.createAlertPolicy(request);
    }

    public final AlertPolicy createAlertPolicy(String name, AlertPolicy alertPolicy) {
        CreateAlertPolicyRequest request = CreateAlertPolicyRequest.newBuilder().setName(name).setAlertPolicy(alertPolicy).build();
        return this.createAlertPolicy(request);
    }

    public final AlertPolicy createAlertPolicy(CreateAlertPolicyRequest request) {
        return (AlertPolicy)this.createAlertPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<CreateAlertPolicyRequest, AlertPolicy> createAlertPolicyCallable() {
        return this.stub.createAlertPolicyCallable();
    }

    public final void deleteAlertPolicy(AlertPolicyName name) {
        DeleteAlertPolicyRequest request = DeleteAlertPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteAlertPolicy(request);
    }

    public final void deleteAlertPolicy(String name) {
        DeleteAlertPolicyRequest request = DeleteAlertPolicyRequest.newBuilder().setName(name).build();
        this.deleteAlertPolicy(request);
    }

    public final void deleteAlertPolicy(DeleteAlertPolicyRequest request) {
        this.deleteAlertPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAlertPolicyRequest, Empty> deleteAlertPolicyCallable() {
        return this.stub.deleteAlertPolicyCallable();
    }

    public final AlertPolicy updateAlertPolicy(FieldMask updateMask, AlertPolicy alertPolicy) {
        UpdateAlertPolicyRequest request = UpdateAlertPolicyRequest.newBuilder().setUpdateMask(updateMask).setAlertPolicy(alertPolicy).build();
        return this.updateAlertPolicy(request);
    }

    public final AlertPolicy updateAlertPolicy(UpdateAlertPolicyRequest request) {
        return (AlertPolicy)this.updateAlertPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateAlertPolicyRequest, AlertPolicy> updateAlertPolicyCallable() {
        return this.stub.updateAlertPolicyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAlertPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAlertPoliciesRequest, ListAlertPoliciesResponse, AlertPolicy, ListAlertPoliciesPage, ListAlertPoliciesFixedSizeCollection> {
        private ListAlertPoliciesFixedSizeCollection(List<ListAlertPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAlertPoliciesFixedSizeCollection createEmptyCollection() {
            return new ListAlertPoliciesFixedSizeCollection(null, 0);
        }

        protected ListAlertPoliciesFixedSizeCollection createCollection(List<ListAlertPoliciesPage> pages, int collectionSize) {
            return new ListAlertPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAlertPoliciesPage
    extends AbstractPage<ListAlertPoliciesRequest, ListAlertPoliciesResponse, AlertPolicy, ListAlertPoliciesPage> {
        private ListAlertPoliciesPage(PageContext<ListAlertPoliciesRequest, ListAlertPoliciesResponse, AlertPolicy> context, ListAlertPoliciesResponse response) {
            super(context, (Object)response);
        }

        private static ListAlertPoliciesPage createEmptyPage() {
            return new ListAlertPoliciesPage(null, null);
        }

        protected ListAlertPoliciesPage createPage(PageContext<ListAlertPoliciesRequest, ListAlertPoliciesResponse, AlertPolicy> context, ListAlertPoliciesResponse response) {
            return new ListAlertPoliciesPage(context, response);
        }

        public ApiFuture<ListAlertPoliciesPage> createPageAsync(PageContext<ListAlertPoliciesRequest, ListAlertPoliciesResponse, AlertPolicy> context, ApiFuture<ListAlertPoliciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAlertPoliciesPagedResponse
    extends AbstractPagedListResponse<ListAlertPoliciesRequest, ListAlertPoliciesResponse, AlertPolicy, ListAlertPoliciesPage, ListAlertPoliciesFixedSizeCollection> {
        public static ApiFuture<ListAlertPoliciesPagedResponse> createAsync(PageContext<ListAlertPoliciesRequest, ListAlertPoliciesResponse, AlertPolicy> context, ApiFuture<ListAlertPoliciesResponse> futureResponse) {
            ApiFuture<ListAlertPoliciesPage> futurePage = ListAlertPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAlertPoliciesPagedResponse((ListAlertPoliciesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAlertPoliciesPagedResponse(ListAlertPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAlertPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }
}

