/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.modelarmor.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.modelarmor.v1beta.CreateTemplateRequest;
import com.google.cloud.modelarmor.v1beta.DeleteTemplateRequest;
import com.google.cloud.modelarmor.v1beta.FloorSetting;
import com.google.cloud.modelarmor.v1beta.GetFloorSettingRequest;
import com.google.cloud.modelarmor.v1beta.GetTemplateRequest;
import com.google.cloud.modelarmor.v1beta.ListTemplatesRequest;
import com.google.cloud.modelarmor.v1beta.ListTemplatesResponse;
import com.google.cloud.modelarmor.v1beta.ModelArmorClient;
import com.google.cloud.modelarmor.v1beta.SanitizeModelResponseRequest;
import com.google.cloud.modelarmor.v1beta.SanitizeModelResponseResponse;
import com.google.cloud.modelarmor.v1beta.SanitizeUserPromptRequest;
import com.google.cloud.modelarmor.v1beta.SanitizeUserPromptResponse;
import com.google.cloud.modelarmor.v1beta.Template;
import com.google.cloud.modelarmor.v1beta.UpdateFloorSettingRequest;
import com.google.cloud.modelarmor.v1beta.UpdateTemplateRequest;
import com.google.cloud.modelarmor.v1beta.stub.GrpcModelArmorCallableFactory;
import com.google.cloud.modelarmor.v1beta.stub.ModelArmorStub;
import com.google.cloud.modelarmor.v1beta.stub.ModelArmorStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcModelArmorStub
extends ModelArmorStub {
    private static final MethodDescriptor<ListTemplatesRequest, ListTemplatesResponse> listTemplatesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.modelarmor.v1beta.ModelArmor/ListTemplates").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTemplatesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTemplatesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetTemplateRequest, Template> getTemplateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.modelarmor.v1beta.ModelArmor/GetTemplate").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTemplateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Template.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateTemplateRequest, Template> createTemplateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.modelarmor.v1beta.ModelArmor/CreateTemplate").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateTemplateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Template.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateTemplateRequest, Template> updateTemplateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.modelarmor.v1beta.ModelArmor/UpdateTemplate").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateTemplateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Template.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteTemplateRequest, Empty> deleteTemplateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.modelarmor.v1beta.ModelArmor/DeleteTemplate").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteTemplateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetFloorSettingRequest, FloorSetting> getFloorSettingMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.modelarmor.v1beta.ModelArmor/GetFloorSetting").setRequestMarshaller(ProtoUtils.marshaller((Message)GetFloorSettingRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)FloorSetting.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateFloorSettingRequest, FloorSetting> updateFloorSettingMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.modelarmor.v1beta.ModelArmor/UpdateFloorSetting").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateFloorSettingRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)FloorSetting.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SanitizeUserPromptRequest, SanitizeUserPromptResponse> sanitizeUserPromptMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.modelarmor.v1beta.ModelArmor/SanitizeUserPrompt").setRequestMarshaller(ProtoUtils.marshaller((Message)SanitizeUserPromptRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SanitizeUserPromptResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SanitizeModelResponseRequest, SanitizeModelResponseResponse> sanitizeModelResponseMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.modelarmor.v1beta.ModelArmor/SanitizeModelResponse").setRequestMarshaller(ProtoUtils.marshaller((Message)SanitizeModelResponseRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SanitizeModelResponseResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListTemplatesRequest, ListTemplatesResponse> listTemplatesCallable;
    private final UnaryCallable<ListTemplatesRequest, ModelArmorClient.ListTemplatesPagedResponse> listTemplatesPagedCallable;
    private final UnaryCallable<GetTemplateRequest, Template> getTemplateCallable;
    private final UnaryCallable<CreateTemplateRequest, Template> createTemplateCallable;
    private final UnaryCallable<UpdateTemplateRequest, Template> updateTemplateCallable;
    private final UnaryCallable<DeleteTemplateRequest, Empty> deleteTemplateCallable;
    private final UnaryCallable<GetFloorSettingRequest, FloorSetting> getFloorSettingCallable;
    private final UnaryCallable<UpdateFloorSettingRequest, FloorSetting> updateFloorSettingCallable;
    private final UnaryCallable<SanitizeUserPromptRequest, SanitizeUserPromptResponse> sanitizeUserPromptCallable;
    private final UnaryCallable<SanitizeModelResponseRequest, SanitizeModelResponseResponse> sanitizeModelResponseCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ModelArmorClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcModelArmorStub create(ModelArmorStubSettings settings) throws IOException {
        return new GrpcModelArmorStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcModelArmorStub create(ClientContext clientContext) throws IOException {
        return new GrpcModelArmorStub(ModelArmorStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcModelArmorStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcModelArmorStub(ModelArmorStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcModelArmorStub(ModelArmorStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcModelArmorCallableFactory());
    }

    protected GrpcModelArmorStub(ModelArmorStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listTemplatesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTemplatesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getTemplateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTemplateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createTemplateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createTemplateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateTemplateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateTemplateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("template.name", String.valueOf(request.getTemplate().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteTemplateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteTemplateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getFloorSettingTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getFloorSettingMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateFloorSettingTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateFloorSettingMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("floor_setting.name", String.valueOf(request.getFloorSetting().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings sanitizeUserPromptTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(sanitizeUserPromptMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings sanitizeModelResponseTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(sanitizeModelResponseMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listTemplatesCallable = callableFactory.createUnaryCallable(listTemplatesTransportSettings, settings.listTemplatesSettings(), clientContext);
        this.listTemplatesPagedCallable = callableFactory.createPagedCallable(listTemplatesTransportSettings, settings.listTemplatesSettings(), clientContext);
        this.getTemplateCallable = callableFactory.createUnaryCallable(getTemplateTransportSettings, settings.getTemplateSettings(), clientContext);
        this.createTemplateCallable = callableFactory.createUnaryCallable(createTemplateTransportSettings, settings.createTemplateSettings(), clientContext);
        this.updateTemplateCallable = callableFactory.createUnaryCallable(updateTemplateTransportSettings, settings.updateTemplateSettings(), clientContext);
        this.deleteTemplateCallable = callableFactory.createUnaryCallable(deleteTemplateTransportSettings, settings.deleteTemplateSettings(), clientContext);
        this.getFloorSettingCallable = callableFactory.createUnaryCallable(getFloorSettingTransportSettings, settings.getFloorSettingSettings(), clientContext);
        this.updateFloorSettingCallable = callableFactory.createUnaryCallable(updateFloorSettingTransportSettings, settings.updateFloorSettingSettings(), clientContext);
        this.sanitizeUserPromptCallable = callableFactory.createUnaryCallable(sanitizeUserPromptTransportSettings, settings.sanitizeUserPromptSettings(), clientContext);
        this.sanitizeModelResponseCallable = callableFactory.createUnaryCallable(sanitizeModelResponseTransportSettings, settings.sanitizeModelResponseSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListTemplatesRequest, ListTemplatesResponse> listTemplatesCallable() {
        return this.listTemplatesCallable;
    }

    @Override
    public UnaryCallable<ListTemplatesRequest, ModelArmorClient.ListTemplatesPagedResponse> listTemplatesPagedCallable() {
        return this.listTemplatesPagedCallable;
    }

    @Override
    public UnaryCallable<GetTemplateRequest, Template> getTemplateCallable() {
        return this.getTemplateCallable;
    }

    @Override
    public UnaryCallable<CreateTemplateRequest, Template> createTemplateCallable() {
        return this.createTemplateCallable;
    }

    @Override
    public UnaryCallable<UpdateTemplateRequest, Template> updateTemplateCallable() {
        return this.updateTemplateCallable;
    }

    @Override
    public UnaryCallable<DeleteTemplateRequest, Empty> deleteTemplateCallable() {
        return this.deleteTemplateCallable;
    }

    @Override
    public UnaryCallable<GetFloorSettingRequest, FloorSetting> getFloorSettingCallable() {
        return this.getFloorSettingCallable;
    }

    @Override
    public UnaryCallable<UpdateFloorSettingRequest, FloorSetting> updateFloorSettingCallable() {
        return this.updateFloorSettingCallable;
    }

    @Override
    public UnaryCallable<SanitizeUserPromptRequest, SanitizeUserPromptResponse> sanitizeUserPromptCallable() {
        return this.sanitizeUserPromptCallable;
    }

    @Override
    public UnaryCallable<SanitizeModelResponseRequest, SanitizeModelResponseResponse> sanitizeModelResponseCallable() {
        return this.sanitizeModelResponseCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ModelArmorClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

