/*
 * Decompiled with CFR 0.152.
 */
package com.google.apps.meet.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.apps.meet.v2.ConferenceRecord;
import com.google.apps.meet.v2.ConferenceRecordName;
import com.google.apps.meet.v2.ConferenceRecordsServiceSettings;
import com.google.apps.meet.v2.GetConferenceRecordRequest;
import com.google.apps.meet.v2.GetParticipantRequest;
import com.google.apps.meet.v2.GetParticipantSessionRequest;
import com.google.apps.meet.v2.GetRecordingRequest;
import com.google.apps.meet.v2.GetTranscriptEntryRequest;
import com.google.apps.meet.v2.GetTranscriptRequest;
import com.google.apps.meet.v2.ListConferenceRecordsRequest;
import com.google.apps.meet.v2.ListConferenceRecordsResponse;
import com.google.apps.meet.v2.ListParticipantSessionsRequest;
import com.google.apps.meet.v2.ListParticipantSessionsResponse;
import com.google.apps.meet.v2.ListParticipantsRequest;
import com.google.apps.meet.v2.ListParticipantsResponse;
import com.google.apps.meet.v2.ListRecordingsRequest;
import com.google.apps.meet.v2.ListRecordingsResponse;
import com.google.apps.meet.v2.ListTranscriptEntriesRequest;
import com.google.apps.meet.v2.ListTranscriptEntriesResponse;
import com.google.apps.meet.v2.ListTranscriptsRequest;
import com.google.apps.meet.v2.ListTranscriptsResponse;
import com.google.apps.meet.v2.Participant;
import com.google.apps.meet.v2.ParticipantName;
import com.google.apps.meet.v2.ParticipantSession;
import com.google.apps.meet.v2.ParticipantSessionName;
import com.google.apps.meet.v2.Recording;
import com.google.apps.meet.v2.RecordingName;
import com.google.apps.meet.v2.Transcript;
import com.google.apps.meet.v2.TranscriptEntry;
import com.google.apps.meet.v2.TranscriptEntryName;
import com.google.apps.meet.v2.TranscriptName;
import com.google.apps.meet.v2.stub.ConferenceRecordsServiceStub;
import com.google.apps.meet.v2.stub.ConferenceRecordsServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ConferenceRecordsServiceClient
implements BackgroundResource {
    private final ConferenceRecordsServiceSettings settings;
    private final ConferenceRecordsServiceStub stub;

    public static final ConferenceRecordsServiceClient create() throws IOException {
        return ConferenceRecordsServiceClient.create(ConferenceRecordsServiceSettings.newBuilder().build());
    }

    public static final ConferenceRecordsServiceClient create(ConferenceRecordsServiceSettings settings) throws IOException {
        return new ConferenceRecordsServiceClient(settings);
    }

    public static final ConferenceRecordsServiceClient create(ConferenceRecordsServiceStub stub) {
        return new ConferenceRecordsServiceClient(stub);
    }

    protected ConferenceRecordsServiceClient(ConferenceRecordsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ConferenceRecordsServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ConferenceRecordsServiceClient(ConferenceRecordsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ConferenceRecordsServiceSettings getSettings() {
        return this.settings;
    }

    public ConferenceRecordsServiceStub getStub() {
        return this.stub;
    }

    public final ConferenceRecord getConferenceRecord(ConferenceRecordName name) {
        GetConferenceRecordRequest request = GetConferenceRecordRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConferenceRecord(request);
    }

    public final ConferenceRecord getConferenceRecord(String name) {
        GetConferenceRecordRequest request = GetConferenceRecordRequest.newBuilder().setName(name).build();
        return this.getConferenceRecord(request);
    }

    public final ConferenceRecord getConferenceRecord(GetConferenceRecordRequest request) {
        return (ConferenceRecord)this.getConferenceRecordCallable().call((Object)request);
    }

    public final UnaryCallable<GetConferenceRecordRequest, ConferenceRecord> getConferenceRecordCallable() {
        return this.stub.getConferenceRecordCallable();
    }

    public final ListConferenceRecordsPagedResponse listConferenceRecords(ListConferenceRecordsRequest request) {
        return (ListConferenceRecordsPagedResponse)((Object)this.listConferenceRecordsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConferenceRecordsRequest, ListConferenceRecordsPagedResponse> listConferenceRecordsPagedCallable() {
        return this.stub.listConferenceRecordsPagedCallable();
    }

    public final UnaryCallable<ListConferenceRecordsRequest, ListConferenceRecordsResponse> listConferenceRecordsCallable() {
        return this.stub.listConferenceRecordsCallable();
    }

    public final Participant getParticipant(ParticipantName name) {
        GetParticipantRequest request = GetParticipantRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getParticipant(request);
    }

    public final Participant getParticipant(String name) {
        GetParticipantRequest request = GetParticipantRequest.newBuilder().setName(name).build();
        return this.getParticipant(request);
    }

    public final Participant getParticipant(GetParticipantRequest request) {
        return (Participant)this.getParticipantCallable().call((Object)request);
    }

    public final UnaryCallable<GetParticipantRequest, Participant> getParticipantCallable() {
        return this.stub.getParticipantCallable();
    }

    public final ListParticipantsPagedResponse listParticipants(ConferenceRecordName parent) {
        ListParticipantsRequest request = ListParticipantsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listParticipants(request);
    }

    public final ListParticipantsPagedResponse listParticipants(String parent) {
        ListParticipantsRequest request = ListParticipantsRequest.newBuilder().setParent(parent).build();
        return this.listParticipants(request);
    }

    public final ListParticipantsPagedResponse listParticipants(ListParticipantsRequest request) {
        return (ListParticipantsPagedResponse)((Object)this.listParticipantsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListParticipantsRequest, ListParticipantsPagedResponse> listParticipantsPagedCallable() {
        return this.stub.listParticipantsPagedCallable();
    }

    public final UnaryCallable<ListParticipantsRequest, ListParticipantsResponse> listParticipantsCallable() {
        return this.stub.listParticipantsCallable();
    }

    public final ParticipantSession getParticipantSession(ParticipantSessionName name) {
        GetParticipantSessionRequest request = GetParticipantSessionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getParticipantSession(request);
    }

    public final ParticipantSession getParticipantSession(String name) {
        GetParticipantSessionRequest request = GetParticipantSessionRequest.newBuilder().setName(name).build();
        return this.getParticipantSession(request);
    }

    public final ParticipantSession getParticipantSession(GetParticipantSessionRequest request) {
        return (ParticipantSession)this.getParticipantSessionCallable().call((Object)request);
    }

    public final UnaryCallable<GetParticipantSessionRequest, ParticipantSession> getParticipantSessionCallable() {
        return this.stub.getParticipantSessionCallable();
    }

    public final ListParticipantSessionsPagedResponse listParticipantSessions(ParticipantName parent) {
        ListParticipantSessionsRequest request = ListParticipantSessionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listParticipantSessions(request);
    }

    public final ListParticipantSessionsPagedResponse listParticipantSessions(String parent) {
        ListParticipantSessionsRequest request = ListParticipantSessionsRequest.newBuilder().setParent(parent).build();
        return this.listParticipantSessions(request);
    }

    public final ListParticipantSessionsPagedResponse listParticipantSessions(ListParticipantSessionsRequest request) {
        return (ListParticipantSessionsPagedResponse)((Object)this.listParticipantSessionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListParticipantSessionsRequest, ListParticipantSessionsPagedResponse> listParticipantSessionsPagedCallable() {
        return this.stub.listParticipantSessionsPagedCallable();
    }

    public final UnaryCallable<ListParticipantSessionsRequest, ListParticipantSessionsResponse> listParticipantSessionsCallable() {
        return this.stub.listParticipantSessionsCallable();
    }

    public final Recording getRecording(RecordingName name) {
        GetRecordingRequest request = GetRecordingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRecording(request);
    }

    public final Recording getRecording(String name) {
        GetRecordingRequest request = GetRecordingRequest.newBuilder().setName(name).build();
        return this.getRecording(request);
    }

    public final Recording getRecording(GetRecordingRequest request) {
        return (Recording)this.getRecordingCallable().call((Object)request);
    }

    public final UnaryCallable<GetRecordingRequest, Recording> getRecordingCallable() {
        return this.stub.getRecordingCallable();
    }

    public final ListRecordingsPagedResponse listRecordings(ConferenceRecordName parent) {
        ListRecordingsRequest request = ListRecordingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRecordings(request);
    }

    public final ListRecordingsPagedResponse listRecordings(String parent) {
        ListRecordingsRequest request = ListRecordingsRequest.newBuilder().setParent(parent).build();
        return this.listRecordings(request);
    }

    public final ListRecordingsPagedResponse listRecordings(ListRecordingsRequest request) {
        return (ListRecordingsPagedResponse)((Object)this.listRecordingsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRecordingsRequest, ListRecordingsPagedResponse> listRecordingsPagedCallable() {
        return this.stub.listRecordingsPagedCallable();
    }

    public final UnaryCallable<ListRecordingsRequest, ListRecordingsResponse> listRecordingsCallable() {
        return this.stub.listRecordingsCallable();
    }

    public final Transcript getTranscript(TranscriptName name) {
        GetTranscriptRequest request = GetTranscriptRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTranscript(request);
    }

    public final Transcript getTranscript(String name) {
        GetTranscriptRequest request = GetTranscriptRequest.newBuilder().setName(name).build();
        return this.getTranscript(request);
    }

    public final Transcript getTranscript(GetTranscriptRequest request) {
        return (Transcript)this.getTranscriptCallable().call((Object)request);
    }

    public final UnaryCallable<GetTranscriptRequest, Transcript> getTranscriptCallable() {
        return this.stub.getTranscriptCallable();
    }

    public final ListTranscriptsPagedResponse listTranscripts(ConferenceRecordName parent) {
        ListTranscriptsRequest request = ListTranscriptsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTranscripts(request);
    }

    public final ListTranscriptsPagedResponse listTranscripts(String parent) {
        ListTranscriptsRequest request = ListTranscriptsRequest.newBuilder().setParent(parent).build();
        return this.listTranscripts(request);
    }

    public final ListTranscriptsPagedResponse listTranscripts(ListTranscriptsRequest request) {
        return (ListTranscriptsPagedResponse)((Object)this.listTranscriptsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTranscriptsRequest, ListTranscriptsPagedResponse> listTranscriptsPagedCallable() {
        return this.stub.listTranscriptsPagedCallable();
    }

    public final UnaryCallable<ListTranscriptsRequest, ListTranscriptsResponse> listTranscriptsCallable() {
        return this.stub.listTranscriptsCallable();
    }

    public final TranscriptEntry getTranscriptEntry(TranscriptEntryName name) {
        GetTranscriptEntryRequest request = GetTranscriptEntryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTranscriptEntry(request);
    }

    public final TranscriptEntry getTranscriptEntry(String name) {
        GetTranscriptEntryRequest request = GetTranscriptEntryRequest.newBuilder().setName(name).build();
        return this.getTranscriptEntry(request);
    }

    public final TranscriptEntry getTranscriptEntry(GetTranscriptEntryRequest request) {
        return (TranscriptEntry)this.getTranscriptEntryCallable().call((Object)request);
    }

    public final UnaryCallable<GetTranscriptEntryRequest, TranscriptEntry> getTranscriptEntryCallable() {
        return this.stub.getTranscriptEntryCallable();
    }

    public final ListTranscriptEntriesPagedResponse listTranscriptEntries(TranscriptName parent) {
        ListTranscriptEntriesRequest request = ListTranscriptEntriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTranscriptEntries(request);
    }

    public final ListTranscriptEntriesPagedResponse listTranscriptEntries(String parent) {
        ListTranscriptEntriesRequest request = ListTranscriptEntriesRequest.newBuilder().setParent(parent).build();
        return this.listTranscriptEntries(request);
    }

    public final ListTranscriptEntriesPagedResponse listTranscriptEntries(ListTranscriptEntriesRequest request) {
        return (ListTranscriptEntriesPagedResponse)((Object)this.listTranscriptEntriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTranscriptEntriesRequest, ListTranscriptEntriesPagedResponse> listTranscriptEntriesPagedCallable() {
        return this.stub.listTranscriptEntriesPagedCallable();
    }

    public final UnaryCallable<ListTranscriptEntriesRequest, ListTranscriptEntriesResponse> listTranscriptEntriesCallable() {
        return this.stub.listTranscriptEntriesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTranscriptEntriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTranscriptEntriesRequest, ListTranscriptEntriesResponse, TranscriptEntry, ListTranscriptEntriesPage, ListTranscriptEntriesFixedSizeCollection> {
        private ListTranscriptEntriesFixedSizeCollection(List<ListTranscriptEntriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTranscriptEntriesFixedSizeCollection createEmptyCollection() {
            return new ListTranscriptEntriesFixedSizeCollection(null, 0);
        }

        protected ListTranscriptEntriesFixedSizeCollection createCollection(List<ListTranscriptEntriesPage> pages, int collectionSize) {
            return new ListTranscriptEntriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTranscriptEntriesPage
    extends AbstractPage<ListTranscriptEntriesRequest, ListTranscriptEntriesResponse, TranscriptEntry, ListTranscriptEntriesPage> {
        private ListTranscriptEntriesPage(PageContext<ListTranscriptEntriesRequest, ListTranscriptEntriesResponse, TranscriptEntry> context, ListTranscriptEntriesResponse response) {
            super(context, (Object)response);
        }

        private static ListTranscriptEntriesPage createEmptyPage() {
            return new ListTranscriptEntriesPage(null, null);
        }

        protected ListTranscriptEntriesPage createPage(PageContext<ListTranscriptEntriesRequest, ListTranscriptEntriesResponse, TranscriptEntry> context, ListTranscriptEntriesResponse response) {
            return new ListTranscriptEntriesPage(context, response);
        }

        public ApiFuture<ListTranscriptEntriesPage> createPageAsync(PageContext<ListTranscriptEntriesRequest, ListTranscriptEntriesResponse, TranscriptEntry> context, ApiFuture<ListTranscriptEntriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTranscriptEntriesPagedResponse
    extends AbstractPagedListResponse<ListTranscriptEntriesRequest, ListTranscriptEntriesResponse, TranscriptEntry, ListTranscriptEntriesPage, ListTranscriptEntriesFixedSizeCollection> {
        public static ApiFuture<ListTranscriptEntriesPagedResponse> createAsync(PageContext<ListTranscriptEntriesRequest, ListTranscriptEntriesResponse, TranscriptEntry> context, ApiFuture<ListTranscriptEntriesResponse> futureResponse) {
            ApiFuture<ListTranscriptEntriesPage> futurePage = ListTranscriptEntriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTranscriptEntriesPagedResponse((ListTranscriptEntriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTranscriptEntriesPagedResponse(ListTranscriptEntriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTranscriptEntriesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTranscriptsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTranscriptsRequest, ListTranscriptsResponse, Transcript, ListTranscriptsPage, ListTranscriptsFixedSizeCollection> {
        private ListTranscriptsFixedSizeCollection(List<ListTranscriptsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTranscriptsFixedSizeCollection createEmptyCollection() {
            return new ListTranscriptsFixedSizeCollection(null, 0);
        }

        protected ListTranscriptsFixedSizeCollection createCollection(List<ListTranscriptsPage> pages, int collectionSize) {
            return new ListTranscriptsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTranscriptsPage
    extends AbstractPage<ListTranscriptsRequest, ListTranscriptsResponse, Transcript, ListTranscriptsPage> {
        private ListTranscriptsPage(PageContext<ListTranscriptsRequest, ListTranscriptsResponse, Transcript> context, ListTranscriptsResponse response) {
            super(context, (Object)response);
        }

        private static ListTranscriptsPage createEmptyPage() {
            return new ListTranscriptsPage(null, null);
        }

        protected ListTranscriptsPage createPage(PageContext<ListTranscriptsRequest, ListTranscriptsResponse, Transcript> context, ListTranscriptsResponse response) {
            return new ListTranscriptsPage(context, response);
        }

        public ApiFuture<ListTranscriptsPage> createPageAsync(PageContext<ListTranscriptsRequest, ListTranscriptsResponse, Transcript> context, ApiFuture<ListTranscriptsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTranscriptsPagedResponse
    extends AbstractPagedListResponse<ListTranscriptsRequest, ListTranscriptsResponse, Transcript, ListTranscriptsPage, ListTranscriptsFixedSizeCollection> {
        public static ApiFuture<ListTranscriptsPagedResponse> createAsync(PageContext<ListTranscriptsRequest, ListTranscriptsResponse, Transcript> context, ApiFuture<ListTranscriptsResponse> futureResponse) {
            ApiFuture<ListTranscriptsPage> futurePage = ListTranscriptsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTranscriptsPagedResponse((ListTranscriptsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTranscriptsPagedResponse(ListTranscriptsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTranscriptsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRecordingsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRecordingsRequest, ListRecordingsResponse, Recording, ListRecordingsPage, ListRecordingsFixedSizeCollection> {
        private ListRecordingsFixedSizeCollection(List<ListRecordingsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRecordingsFixedSizeCollection createEmptyCollection() {
            return new ListRecordingsFixedSizeCollection(null, 0);
        }

        protected ListRecordingsFixedSizeCollection createCollection(List<ListRecordingsPage> pages, int collectionSize) {
            return new ListRecordingsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRecordingsPage
    extends AbstractPage<ListRecordingsRequest, ListRecordingsResponse, Recording, ListRecordingsPage> {
        private ListRecordingsPage(PageContext<ListRecordingsRequest, ListRecordingsResponse, Recording> context, ListRecordingsResponse response) {
            super(context, (Object)response);
        }

        private static ListRecordingsPage createEmptyPage() {
            return new ListRecordingsPage(null, null);
        }

        protected ListRecordingsPage createPage(PageContext<ListRecordingsRequest, ListRecordingsResponse, Recording> context, ListRecordingsResponse response) {
            return new ListRecordingsPage(context, response);
        }

        public ApiFuture<ListRecordingsPage> createPageAsync(PageContext<ListRecordingsRequest, ListRecordingsResponse, Recording> context, ApiFuture<ListRecordingsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRecordingsPagedResponse
    extends AbstractPagedListResponse<ListRecordingsRequest, ListRecordingsResponse, Recording, ListRecordingsPage, ListRecordingsFixedSizeCollection> {
        public static ApiFuture<ListRecordingsPagedResponse> createAsync(PageContext<ListRecordingsRequest, ListRecordingsResponse, Recording> context, ApiFuture<ListRecordingsResponse> futureResponse) {
            ApiFuture<ListRecordingsPage> futurePage = ListRecordingsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRecordingsPagedResponse((ListRecordingsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRecordingsPagedResponse(ListRecordingsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRecordingsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListParticipantSessionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListParticipantSessionsRequest, ListParticipantSessionsResponse, ParticipantSession, ListParticipantSessionsPage, ListParticipantSessionsFixedSizeCollection> {
        private ListParticipantSessionsFixedSizeCollection(List<ListParticipantSessionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListParticipantSessionsFixedSizeCollection createEmptyCollection() {
            return new ListParticipantSessionsFixedSizeCollection(null, 0);
        }

        protected ListParticipantSessionsFixedSizeCollection createCollection(List<ListParticipantSessionsPage> pages, int collectionSize) {
            return new ListParticipantSessionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListParticipantSessionsPage
    extends AbstractPage<ListParticipantSessionsRequest, ListParticipantSessionsResponse, ParticipantSession, ListParticipantSessionsPage> {
        private ListParticipantSessionsPage(PageContext<ListParticipantSessionsRequest, ListParticipantSessionsResponse, ParticipantSession> context, ListParticipantSessionsResponse response) {
            super(context, (Object)response);
        }

        private static ListParticipantSessionsPage createEmptyPage() {
            return new ListParticipantSessionsPage(null, null);
        }

        protected ListParticipantSessionsPage createPage(PageContext<ListParticipantSessionsRequest, ListParticipantSessionsResponse, ParticipantSession> context, ListParticipantSessionsResponse response) {
            return new ListParticipantSessionsPage(context, response);
        }

        public ApiFuture<ListParticipantSessionsPage> createPageAsync(PageContext<ListParticipantSessionsRequest, ListParticipantSessionsResponse, ParticipantSession> context, ApiFuture<ListParticipantSessionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListParticipantSessionsPagedResponse
    extends AbstractPagedListResponse<ListParticipantSessionsRequest, ListParticipantSessionsResponse, ParticipantSession, ListParticipantSessionsPage, ListParticipantSessionsFixedSizeCollection> {
        public static ApiFuture<ListParticipantSessionsPagedResponse> createAsync(PageContext<ListParticipantSessionsRequest, ListParticipantSessionsResponse, ParticipantSession> context, ApiFuture<ListParticipantSessionsResponse> futureResponse) {
            ApiFuture<ListParticipantSessionsPage> futurePage = ListParticipantSessionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListParticipantSessionsPagedResponse((ListParticipantSessionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListParticipantSessionsPagedResponse(ListParticipantSessionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListParticipantSessionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListParticipantsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListParticipantsRequest, ListParticipantsResponse, Participant, ListParticipantsPage, ListParticipantsFixedSizeCollection> {
        private ListParticipantsFixedSizeCollection(List<ListParticipantsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListParticipantsFixedSizeCollection createEmptyCollection() {
            return new ListParticipantsFixedSizeCollection(null, 0);
        }

        protected ListParticipantsFixedSizeCollection createCollection(List<ListParticipantsPage> pages, int collectionSize) {
            return new ListParticipantsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListParticipantsPage
    extends AbstractPage<ListParticipantsRequest, ListParticipantsResponse, Participant, ListParticipantsPage> {
        private ListParticipantsPage(PageContext<ListParticipantsRequest, ListParticipantsResponse, Participant> context, ListParticipantsResponse response) {
            super(context, (Object)response);
        }

        private static ListParticipantsPage createEmptyPage() {
            return new ListParticipantsPage(null, null);
        }

        protected ListParticipantsPage createPage(PageContext<ListParticipantsRequest, ListParticipantsResponse, Participant> context, ListParticipantsResponse response) {
            return new ListParticipantsPage(context, response);
        }

        public ApiFuture<ListParticipantsPage> createPageAsync(PageContext<ListParticipantsRequest, ListParticipantsResponse, Participant> context, ApiFuture<ListParticipantsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListParticipantsPagedResponse
    extends AbstractPagedListResponse<ListParticipantsRequest, ListParticipantsResponse, Participant, ListParticipantsPage, ListParticipantsFixedSizeCollection> {
        public static ApiFuture<ListParticipantsPagedResponse> createAsync(PageContext<ListParticipantsRequest, ListParticipantsResponse, Participant> context, ApiFuture<ListParticipantsResponse> futureResponse) {
            ApiFuture<ListParticipantsPage> futurePage = ListParticipantsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListParticipantsPagedResponse((ListParticipantsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListParticipantsPagedResponse(ListParticipantsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListParticipantsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListConferenceRecordsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConferenceRecordsRequest, ListConferenceRecordsResponse, ConferenceRecord, ListConferenceRecordsPage, ListConferenceRecordsFixedSizeCollection> {
        private ListConferenceRecordsFixedSizeCollection(List<ListConferenceRecordsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConferenceRecordsFixedSizeCollection createEmptyCollection() {
            return new ListConferenceRecordsFixedSizeCollection(null, 0);
        }

        protected ListConferenceRecordsFixedSizeCollection createCollection(List<ListConferenceRecordsPage> pages, int collectionSize) {
            return new ListConferenceRecordsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConferenceRecordsPage
    extends AbstractPage<ListConferenceRecordsRequest, ListConferenceRecordsResponse, ConferenceRecord, ListConferenceRecordsPage> {
        private ListConferenceRecordsPage(PageContext<ListConferenceRecordsRequest, ListConferenceRecordsResponse, ConferenceRecord> context, ListConferenceRecordsResponse response) {
            super(context, (Object)response);
        }

        private static ListConferenceRecordsPage createEmptyPage() {
            return new ListConferenceRecordsPage(null, null);
        }

        protected ListConferenceRecordsPage createPage(PageContext<ListConferenceRecordsRequest, ListConferenceRecordsResponse, ConferenceRecord> context, ListConferenceRecordsResponse response) {
            return new ListConferenceRecordsPage(context, response);
        }

        public ApiFuture<ListConferenceRecordsPage> createPageAsync(PageContext<ListConferenceRecordsRequest, ListConferenceRecordsResponse, ConferenceRecord> context, ApiFuture<ListConferenceRecordsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConferenceRecordsPagedResponse
    extends AbstractPagedListResponse<ListConferenceRecordsRequest, ListConferenceRecordsResponse, ConferenceRecord, ListConferenceRecordsPage, ListConferenceRecordsFixedSizeCollection> {
        public static ApiFuture<ListConferenceRecordsPagedResponse> createAsync(PageContext<ListConferenceRecordsRequest, ListConferenceRecordsResponse, ConferenceRecord> context, ApiFuture<ListConferenceRecordsResponse> futureResponse) {
            ApiFuture<ListConferenceRecordsPage> futurePage = ListConferenceRecordsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConferenceRecordsPagedResponse((ListConferenceRecordsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConferenceRecordsPagedResponse(ListConferenceRecordsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConferenceRecordsFixedSizeCollection.createEmptyCollection());
        }
    }
}

