/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.managedidentities.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.managedidentities.v1.AttachTrustRequest;
import com.google.cloud.managedidentities.v1.CreateMicrosoftAdDomainRequest;
import com.google.cloud.managedidentities.v1.DeleteDomainRequest;
import com.google.cloud.managedidentities.v1.DetachTrustRequest;
import com.google.cloud.managedidentities.v1.Domain;
import com.google.cloud.managedidentities.v1.GetDomainRequest;
import com.google.cloud.managedidentities.v1.ListDomainsRequest;
import com.google.cloud.managedidentities.v1.ListDomainsResponse;
import com.google.cloud.managedidentities.v1.ManagedIdentitiesServiceClient;
import com.google.cloud.managedidentities.v1.OpMetadata;
import com.google.cloud.managedidentities.v1.ReconfigureTrustRequest;
import com.google.cloud.managedidentities.v1.ResetAdminPasswordRequest;
import com.google.cloud.managedidentities.v1.ResetAdminPasswordResponse;
import com.google.cloud.managedidentities.v1.UpdateDomainRequest;
import com.google.cloud.managedidentities.v1.ValidateTrustRequest;
import com.google.cloud.managedidentities.v1.stub.GrpcManagedIdentitiesServiceStub;
import com.google.cloud.managedidentities.v1.stub.ManagedIdentitiesServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ManagedIdentitiesServiceStubSettings
extends StubSettings<ManagedIdentitiesServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateMicrosoftAdDomainRequest, Operation> createMicrosoftAdDomainSettings;
    private final OperationCallSettings<CreateMicrosoftAdDomainRequest, Domain, OpMetadata> createMicrosoftAdDomainOperationSettings;
    private final UnaryCallSettings<ResetAdminPasswordRequest, ResetAdminPasswordResponse> resetAdminPasswordSettings;
    private final PagedCallSettings<ListDomainsRequest, ListDomainsResponse, ManagedIdentitiesServiceClient.ListDomainsPagedResponse> listDomainsSettings;
    private final UnaryCallSettings<GetDomainRequest, Domain> getDomainSettings;
    private final UnaryCallSettings<UpdateDomainRequest, Operation> updateDomainSettings;
    private final OperationCallSettings<UpdateDomainRequest, Domain, OpMetadata> updateDomainOperationSettings;
    private final UnaryCallSettings<DeleteDomainRequest, Operation> deleteDomainSettings;
    private final OperationCallSettings<DeleteDomainRequest, Empty, OpMetadata> deleteDomainOperationSettings;
    private final UnaryCallSettings<AttachTrustRequest, Operation> attachTrustSettings;
    private final OperationCallSettings<AttachTrustRequest, Domain, OpMetadata> attachTrustOperationSettings;
    private final UnaryCallSettings<ReconfigureTrustRequest, Operation> reconfigureTrustSettings;
    private final OperationCallSettings<ReconfigureTrustRequest, Domain, OpMetadata> reconfigureTrustOperationSettings;
    private final UnaryCallSettings<DetachTrustRequest, Operation> detachTrustSettings;
    private final OperationCallSettings<DetachTrustRequest, Domain, OpMetadata> detachTrustOperationSettings;
    private final UnaryCallSettings<ValidateTrustRequest, Operation> validateTrustSettings;
    private final OperationCallSettings<ValidateTrustRequest, Domain, OpMetadata> validateTrustOperationSettings;
    private static final PagedListDescriptor<ListDomainsRequest, ListDomainsResponse, Domain> LIST_DOMAINS_PAGE_STR_DESC = new PagedListDescriptor<ListDomainsRequest, ListDomainsResponse, Domain>(){

        public String emptyToken() {
            return "";
        }

        public ListDomainsRequest injectToken(ListDomainsRequest payload, String token) {
            return ListDomainsRequest.newBuilder((ListDomainsRequest)payload).setPageToken(token).build();
        }

        public ListDomainsRequest injectPageSize(ListDomainsRequest payload, int pageSize) {
            return ListDomainsRequest.newBuilder((ListDomainsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDomainsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDomainsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Domain> extractResources(ListDomainsResponse payload) {
            return payload.getDomainsList() == null ? ImmutableList.of() : payload.getDomainsList();
        }
    };
    private static final PagedListResponseFactory<ListDomainsRequest, ListDomainsResponse, ManagedIdentitiesServiceClient.ListDomainsPagedResponse> LIST_DOMAINS_PAGE_STR_FACT = new PagedListResponseFactory<ListDomainsRequest, ListDomainsResponse, ManagedIdentitiesServiceClient.ListDomainsPagedResponse>(){

        public ApiFuture<ManagedIdentitiesServiceClient.ListDomainsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDomainsRequest, ListDomainsResponse> callable, ListDomainsRequest request, ApiCallContext context, ApiFuture<ListDomainsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DOMAINS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ManagedIdentitiesServiceClient.ListDomainsPagedResponse.createAsync((PageContext<ListDomainsRequest, ListDomainsResponse, Domain>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateMicrosoftAdDomainRequest, Operation> createMicrosoftAdDomainSettings() {
        return this.createMicrosoftAdDomainSettings;
    }

    public OperationCallSettings<CreateMicrosoftAdDomainRequest, Domain, OpMetadata> createMicrosoftAdDomainOperationSettings() {
        return this.createMicrosoftAdDomainOperationSettings;
    }

    public UnaryCallSettings<ResetAdminPasswordRequest, ResetAdminPasswordResponse> resetAdminPasswordSettings() {
        return this.resetAdminPasswordSettings;
    }

    public PagedCallSettings<ListDomainsRequest, ListDomainsResponse, ManagedIdentitiesServiceClient.ListDomainsPagedResponse> listDomainsSettings() {
        return this.listDomainsSettings;
    }

    public UnaryCallSettings<GetDomainRequest, Domain> getDomainSettings() {
        return this.getDomainSettings;
    }

    public UnaryCallSettings<UpdateDomainRequest, Operation> updateDomainSettings() {
        return this.updateDomainSettings;
    }

    public OperationCallSettings<UpdateDomainRequest, Domain, OpMetadata> updateDomainOperationSettings() {
        return this.updateDomainOperationSettings;
    }

    public UnaryCallSettings<DeleteDomainRequest, Operation> deleteDomainSettings() {
        return this.deleteDomainSettings;
    }

    public OperationCallSettings<DeleteDomainRequest, Empty, OpMetadata> deleteDomainOperationSettings() {
        return this.deleteDomainOperationSettings;
    }

    public UnaryCallSettings<AttachTrustRequest, Operation> attachTrustSettings() {
        return this.attachTrustSettings;
    }

    public OperationCallSettings<AttachTrustRequest, Domain, OpMetadata> attachTrustOperationSettings() {
        return this.attachTrustOperationSettings;
    }

    public UnaryCallSettings<ReconfigureTrustRequest, Operation> reconfigureTrustSettings() {
        return this.reconfigureTrustSettings;
    }

    public OperationCallSettings<ReconfigureTrustRequest, Domain, OpMetadata> reconfigureTrustOperationSettings() {
        return this.reconfigureTrustOperationSettings;
    }

    public UnaryCallSettings<DetachTrustRequest, Operation> detachTrustSettings() {
        return this.detachTrustSettings;
    }

    public OperationCallSettings<DetachTrustRequest, Domain, OpMetadata> detachTrustOperationSettings() {
        return this.detachTrustOperationSettings;
    }

    public UnaryCallSettings<ValidateTrustRequest, Operation> validateTrustSettings() {
        return this.validateTrustSettings;
    }

    public OperationCallSettings<ValidateTrustRequest, Domain, OpMetadata> validateTrustOperationSettings() {
        return this.validateTrustOperationSettings;
    }

    public ManagedIdentitiesServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcManagedIdentitiesServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return ManagedIdentitiesServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "managedidentities";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "managedidentities.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "managedidentities.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ManagedIdentitiesServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ManagedIdentitiesServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ManagedIdentitiesServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createMicrosoftAdDomainSettings = settingsBuilder.createMicrosoftAdDomainSettings().build();
        this.createMicrosoftAdDomainOperationSettings = settingsBuilder.createMicrosoftAdDomainOperationSettings().build();
        this.resetAdminPasswordSettings = settingsBuilder.resetAdminPasswordSettings().build();
        this.listDomainsSettings = settingsBuilder.listDomainsSettings().build();
        this.getDomainSettings = settingsBuilder.getDomainSettings().build();
        this.updateDomainSettings = settingsBuilder.updateDomainSettings().build();
        this.updateDomainOperationSettings = settingsBuilder.updateDomainOperationSettings().build();
        this.deleteDomainSettings = settingsBuilder.deleteDomainSettings().build();
        this.deleteDomainOperationSettings = settingsBuilder.deleteDomainOperationSettings().build();
        this.attachTrustSettings = settingsBuilder.attachTrustSettings().build();
        this.attachTrustOperationSettings = settingsBuilder.attachTrustOperationSettings().build();
        this.reconfigureTrustSettings = settingsBuilder.reconfigureTrustSettings().build();
        this.reconfigureTrustOperationSettings = settingsBuilder.reconfigureTrustOperationSettings().build();
        this.detachTrustSettings = settingsBuilder.detachTrustSettings().build();
        this.detachTrustOperationSettings = settingsBuilder.detachTrustOperationSettings().build();
        this.validateTrustSettings = settingsBuilder.validateTrustSettings().build();
        this.validateTrustOperationSettings = settingsBuilder.validateTrustOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ManagedIdentitiesServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateMicrosoftAdDomainRequest, Operation> createMicrosoftAdDomainSettings;
        private final OperationCallSettings.Builder<CreateMicrosoftAdDomainRequest, Domain, OpMetadata> createMicrosoftAdDomainOperationSettings;
        private final UnaryCallSettings.Builder<ResetAdminPasswordRequest, ResetAdminPasswordResponse> resetAdminPasswordSettings;
        private final PagedCallSettings.Builder<ListDomainsRequest, ListDomainsResponse, ManagedIdentitiesServiceClient.ListDomainsPagedResponse> listDomainsSettings;
        private final UnaryCallSettings.Builder<GetDomainRequest, Domain> getDomainSettings;
        private final UnaryCallSettings.Builder<UpdateDomainRequest, Operation> updateDomainSettings;
        private final OperationCallSettings.Builder<UpdateDomainRequest, Domain, OpMetadata> updateDomainOperationSettings;
        private final UnaryCallSettings.Builder<DeleteDomainRequest, Operation> deleteDomainSettings;
        private final OperationCallSettings.Builder<DeleteDomainRequest, Empty, OpMetadata> deleteDomainOperationSettings;
        private final UnaryCallSettings.Builder<AttachTrustRequest, Operation> attachTrustSettings;
        private final OperationCallSettings.Builder<AttachTrustRequest, Domain, OpMetadata> attachTrustOperationSettings;
        private final UnaryCallSettings.Builder<ReconfigureTrustRequest, Operation> reconfigureTrustSettings;
        private final OperationCallSettings.Builder<ReconfigureTrustRequest, Domain, OpMetadata> reconfigureTrustOperationSettings;
        private final UnaryCallSettings.Builder<DetachTrustRequest, Operation> detachTrustSettings;
        private final OperationCallSettings.Builder<DetachTrustRequest, Domain, OpMetadata> detachTrustOperationSettings;
        private final UnaryCallSettings.Builder<ValidateTrustRequest, Operation> validateTrustSettings;
        private final OperationCallSettings.Builder<ValidateTrustRequest, Domain, OpMetadata> validateTrustOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createMicrosoftAdDomainSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMicrosoftAdDomainOperationSettings = OperationCallSettings.newBuilder();
            this.resetAdminPasswordSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDomainsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DOMAINS_PAGE_STR_FACT);
            this.getDomainSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDomainSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDomainOperationSettings = OperationCallSettings.newBuilder();
            this.deleteDomainSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDomainOperationSettings = OperationCallSettings.newBuilder();
            this.attachTrustSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.attachTrustOperationSettings = OperationCallSettings.newBuilder();
            this.reconfigureTrustSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.reconfigureTrustOperationSettings = OperationCallSettings.newBuilder();
            this.detachTrustSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.detachTrustOperationSettings = OperationCallSettings.newBuilder();
            this.validateTrustSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.validateTrustOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createMicrosoftAdDomainSettings, this.resetAdminPasswordSettings, this.listDomainsSettings, this.getDomainSettings, this.updateDomainSettings, this.deleteDomainSettings, this.attachTrustSettings, this.reconfigureTrustSettings, this.detachTrustSettings, this.validateTrustSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ManagedIdentitiesServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createMicrosoftAdDomainSettings = settings.createMicrosoftAdDomainSettings.toBuilder();
            this.createMicrosoftAdDomainOperationSettings = settings.createMicrosoftAdDomainOperationSettings.toBuilder();
            this.resetAdminPasswordSettings = settings.resetAdminPasswordSettings.toBuilder();
            this.listDomainsSettings = settings.listDomainsSettings.toBuilder();
            this.getDomainSettings = settings.getDomainSettings.toBuilder();
            this.updateDomainSettings = settings.updateDomainSettings.toBuilder();
            this.updateDomainOperationSettings = settings.updateDomainOperationSettings.toBuilder();
            this.deleteDomainSettings = settings.deleteDomainSettings.toBuilder();
            this.deleteDomainOperationSettings = settings.deleteDomainOperationSettings.toBuilder();
            this.attachTrustSettings = settings.attachTrustSettings.toBuilder();
            this.attachTrustOperationSettings = settings.attachTrustOperationSettings.toBuilder();
            this.reconfigureTrustSettings = settings.reconfigureTrustSettings.toBuilder();
            this.reconfigureTrustOperationSettings = settings.reconfigureTrustOperationSettings.toBuilder();
            this.detachTrustSettings = settings.detachTrustSettings.toBuilder();
            this.detachTrustOperationSettings = settings.detachTrustOperationSettings.toBuilder();
            this.validateTrustSettings = settings.validateTrustSettings.toBuilder();
            this.validateTrustOperationSettings = settings.validateTrustOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createMicrosoftAdDomainSettings, this.resetAdminPasswordSettings, this.listDomainsSettings, this.getDomainSettings, this.updateDomainSettings, this.deleteDomainSettings, this.attachTrustSettings, this.reconfigureTrustSettings, this.detachTrustSettings, this.validateTrustSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ManagedIdentitiesServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ManagedIdentitiesServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ManagedIdentitiesServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ManagedIdentitiesServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createMicrosoftAdDomainSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.resetAdminPasswordSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listDomainsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getDomainSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateDomainSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteDomainSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.attachTrustSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.reconfigureTrustSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.detachTrustSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.validateTrustSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createMicrosoftAdDomainOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Domain.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OpMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateDomainOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Domain.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OpMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteDomainOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OpMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.attachTrustOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Domain.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OpMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.reconfigureTrustOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Domain.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OpMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.detachTrustOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Domain.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OpMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.validateTrustOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Domain.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OpMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateMicrosoftAdDomainRequest, Operation> createMicrosoftAdDomainSettings() {
            return this.createMicrosoftAdDomainSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateMicrosoftAdDomainRequest, Domain, OpMetadata> createMicrosoftAdDomainOperationSettings() {
            return this.createMicrosoftAdDomainOperationSettings;
        }

        public UnaryCallSettings.Builder<ResetAdminPasswordRequest, ResetAdminPasswordResponse> resetAdminPasswordSettings() {
            return this.resetAdminPasswordSettings;
        }

        public PagedCallSettings.Builder<ListDomainsRequest, ListDomainsResponse, ManagedIdentitiesServiceClient.ListDomainsPagedResponse> listDomainsSettings() {
            return this.listDomainsSettings;
        }

        public UnaryCallSettings.Builder<GetDomainRequest, Domain> getDomainSettings() {
            return this.getDomainSettings;
        }

        public UnaryCallSettings.Builder<UpdateDomainRequest, Operation> updateDomainSettings() {
            return this.updateDomainSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateDomainRequest, Domain, OpMetadata> updateDomainOperationSettings() {
            return this.updateDomainOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteDomainRequest, Operation> deleteDomainSettings() {
            return this.deleteDomainSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteDomainRequest, Empty, OpMetadata> deleteDomainOperationSettings() {
            return this.deleteDomainOperationSettings;
        }

        public UnaryCallSettings.Builder<AttachTrustRequest, Operation> attachTrustSettings() {
            return this.attachTrustSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<AttachTrustRequest, Domain, OpMetadata> attachTrustOperationSettings() {
            return this.attachTrustOperationSettings;
        }

        public UnaryCallSettings.Builder<ReconfigureTrustRequest, Operation> reconfigureTrustSettings() {
            return this.reconfigureTrustSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ReconfigureTrustRequest, Domain, OpMetadata> reconfigureTrustOperationSettings() {
            return this.reconfigureTrustOperationSettings;
        }

        public UnaryCallSettings.Builder<DetachTrustRequest, Operation> detachTrustSettings() {
            return this.detachTrustSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DetachTrustRequest, Domain, OpMetadata> detachTrustOperationSettings() {
            return this.detachTrustOperationSettings;
        }

        public UnaryCallSettings.Builder<ValidateTrustRequest, Operation> validateTrustSettings() {
            return this.validateTrustSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ValidateTrustRequest, Domain, OpMetadata> validateTrustOperationSettings() {
            return this.validateTrustOperationSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return ManagedIdentitiesServiceStubSettings.getDefaultEndpoint();
        }

        public ManagedIdentitiesServiceStubSettings build() throws IOException {
            return new ManagedIdentitiesServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

