/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.managedidentities.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.managedidentities.v1.AttachTrustRequest;
import com.google.cloud.managedidentities.v1.CreateMicrosoftAdDomainRequest;
import com.google.cloud.managedidentities.v1.DeleteDomainRequest;
import com.google.cloud.managedidentities.v1.DetachTrustRequest;
import com.google.cloud.managedidentities.v1.Domain;
import com.google.cloud.managedidentities.v1.DomainName;
import com.google.cloud.managedidentities.v1.GetDomainRequest;
import com.google.cloud.managedidentities.v1.ListDomainsRequest;
import com.google.cloud.managedidentities.v1.ListDomainsResponse;
import com.google.cloud.managedidentities.v1.LocationName;
import com.google.cloud.managedidentities.v1.ManagedIdentitiesServiceSettings;
import com.google.cloud.managedidentities.v1.OpMetadata;
import com.google.cloud.managedidentities.v1.ReconfigureTrustRequest;
import com.google.cloud.managedidentities.v1.ResetAdminPasswordRequest;
import com.google.cloud.managedidentities.v1.ResetAdminPasswordResponse;
import com.google.cloud.managedidentities.v1.Trust;
import com.google.cloud.managedidentities.v1.UpdateDomainRequest;
import com.google.cloud.managedidentities.v1.ValidateTrustRequest;
import com.google.cloud.managedidentities.v1.stub.ManagedIdentitiesServiceStub;
import com.google.cloud.managedidentities.v1.stub.ManagedIdentitiesServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ManagedIdentitiesServiceClient
implements BackgroundResource {
    private final ManagedIdentitiesServiceSettings settings;
    private final ManagedIdentitiesServiceStub stub;
    private final OperationsClient operationsClient;

    public static final ManagedIdentitiesServiceClient create() throws IOException {
        return ManagedIdentitiesServiceClient.create(ManagedIdentitiesServiceSettings.newBuilder().build());
    }

    public static final ManagedIdentitiesServiceClient create(ManagedIdentitiesServiceSettings settings) throws IOException {
        return new ManagedIdentitiesServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ManagedIdentitiesServiceClient create(ManagedIdentitiesServiceStub stub) {
        return new ManagedIdentitiesServiceClient(stub);
    }

    protected ManagedIdentitiesServiceClient(ManagedIdentitiesServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ManagedIdentitiesServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ManagedIdentitiesServiceClient(ManagedIdentitiesServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final ManagedIdentitiesServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ManagedIdentitiesServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<Domain, OpMetadata> createMicrosoftAdDomainAsync(LocationName parent, String domainName, Domain domain) {
        CreateMicrosoftAdDomainRequest request = CreateMicrosoftAdDomainRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDomainName(domainName).setDomain(domain).build();
        return this.createMicrosoftAdDomainAsync(request);
    }

    public final OperationFuture<Domain, OpMetadata> createMicrosoftAdDomainAsync(String parent, String domainName, Domain domain) {
        CreateMicrosoftAdDomainRequest request = CreateMicrosoftAdDomainRequest.newBuilder().setParent(parent).setDomainName(domainName).setDomain(domain).build();
        return this.createMicrosoftAdDomainAsync(request);
    }

    public final OperationFuture<Domain, OpMetadata> createMicrosoftAdDomainAsync(CreateMicrosoftAdDomainRequest request) {
        return this.createMicrosoftAdDomainOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateMicrosoftAdDomainRequest, Domain, OpMetadata> createMicrosoftAdDomainOperationCallable() {
        return this.stub.createMicrosoftAdDomainOperationCallable();
    }

    public final UnaryCallable<CreateMicrosoftAdDomainRequest, Operation> createMicrosoftAdDomainCallable() {
        return this.stub.createMicrosoftAdDomainCallable();
    }

    public final ResetAdminPasswordResponse resetAdminPassword(DomainName name) {
        ResetAdminPasswordRequest request = ResetAdminPasswordRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.resetAdminPassword(request);
    }

    public final ResetAdminPasswordResponse resetAdminPassword(String name) {
        ResetAdminPasswordRequest request = ResetAdminPasswordRequest.newBuilder().setName(name).build();
        return this.resetAdminPassword(request);
    }

    public final ResetAdminPasswordResponse resetAdminPassword(ResetAdminPasswordRequest request) {
        return (ResetAdminPasswordResponse)this.resetAdminPasswordCallable().call((Object)request);
    }

    public final UnaryCallable<ResetAdminPasswordRequest, ResetAdminPasswordResponse> resetAdminPasswordCallable() {
        return this.stub.resetAdminPasswordCallable();
    }

    public final ListDomainsPagedResponse listDomains(LocationName parent) {
        ListDomainsRequest request = ListDomainsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDomains(request);
    }

    public final ListDomainsPagedResponse listDomains(String parent) {
        ListDomainsRequest request = ListDomainsRequest.newBuilder().setParent(parent).build();
        return this.listDomains(request);
    }

    public final ListDomainsPagedResponse listDomains(ListDomainsRequest request) {
        return (ListDomainsPagedResponse)((Object)this.listDomainsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDomainsRequest, ListDomainsPagedResponse> listDomainsPagedCallable() {
        return this.stub.listDomainsPagedCallable();
    }

    public final UnaryCallable<ListDomainsRequest, ListDomainsResponse> listDomainsCallable() {
        return this.stub.listDomainsCallable();
    }

    public final Domain getDomain(DomainName name) {
        GetDomainRequest request = GetDomainRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDomain(request);
    }

    public final Domain getDomain(String name) {
        GetDomainRequest request = GetDomainRequest.newBuilder().setName(name).build();
        return this.getDomain(request);
    }

    public final Domain getDomain(GetDomainRequest request) {
        return (Domain)this.getDomainCallable().call((Object)request);
    }

    public final UnaryCallable<GetDomainRequest, Domain> getDomainCallable() {
        return this.stub.getDomainCallable();
    }

    public final OperationFuture<Domain, OpMetadata> updateDomainAsync(Domain domain, FieldMask updateMask) {
        UpdateDomainRequest request = UpdateDomainRequest.newBuilder().setDomain(domain).setUpdateMask(updateMask).build();
        return this.updateDomainAsync(request);
    }

    public final OperationFuture<Domain, OpMetadata> updateDomainAsync(UpdateDomainRequest request) {
        return this.updateDomainOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateDomainRequest, Domain, OpMetadata> updateDomainOperationCallable() {
        return this.stub.updateDomainOperationCallable();
    }

    public final UnaryCallable<UpdateDomainRequest, Operation> updateDomainCallable() {
        return this.stub.updateDomainCallable();
    }

    public final OperationFuture<Empty, OpMetadata> deleteDomainAsync(DomainName name) {
        DeleteDomainRequest request = DeleteDomainRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDomainAsync(request);
    }

    public final OperationFuture<Empty, OpMetadata> deleteDomainAsync(String name) {
        DeleteDomainRequest request = DeleteDomainRequest.newBuilder().setName(name).build();
        return this.deleteDomainAsync(request);
    }

    public final OperationFuture<Empty, OpMetadata> deleteDomainAsync(DeleteDomainRequest request) {
        return this.deleteDomainOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDomainRequest, Empty, OpMetadata> deleteDomainOperationCallable() {
        return this.stub.deleteDomainOperationCallable();
    }

    public final UnaryCallable<DeleteDomainRequest, Operation> deleteDomainCallable() {
        return this.stub.deleteDomainCallable();
    }

    public final OperationFuture<Domain, OpMetadata> attachTrustAsync(DomainName name, Trust trust) {
        AttachTrustRequest request = AttachTrustRequest.newBuilder().setName(name == null ? null : name.toString()).setTrust(trust).build();
        return this.attachTrustAsync(request);
    }

    public final OperationFuture<Domain, OpMetadata> attachTrustAsync(String name, Trust trust) {
        AttachTrustRequest request = AttachTrustRequest.newBuilder().setName(name).setTrust(trust).build();
        return this.attachTrustAsync(request);
    }

    public final OperationFuture<Domain, OpMetadata> attachTrustAsync(AttachTrustRequest request) {
        return this.attachTrustOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AttachTrustRequest, Domain, OpMetadata> attachTrustOperationCallable() {
        return this.stub.attachTrustOperationCallable();
    }

    public final UnaryCallable<AttachTrustRequest, Operation> attachTrustCallable() {
        return this.stub.attachTrustCallable();
    }

    public final OperationFuture<Domain, OpMetadata> reconfigureTrustAsync(DomainName name, String targetDomainName, List<String> targetDnsIpAddresses) {
        ReconfigureTrustRequest request = ReconfigureTrustRequest.newBuilder().setName(name == null ? null : name.toString()).setTargetDomainName(targetDomainName).addAllTargetDnsIpAddresses(targetDnsIpAddresses).build();
        return this.reconfigureTrustAsync(request);
    }

    public final OperationFuture<Domain, OpMetadata> reconfigureTrustAsync(String name, String targetDomainName, List<String> targetDnsIpAddresses) {
        ReconfigureTrustRequest request = ReconfigureTrustRequest.newBuilder().setName(name).setTargetDomainName(targetDomainName).addAllTargetDnsIpAddresses(targetDnsIpAddresses).build();
        return this.reconfigureTrustAsync(request);
    }

    public final OperationFuture<Domain, OpMetadata> reconfigureTrustAsync(ReconfigureTrustRequest request) {
        return this.reconfigureTrustOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ReconfigureTrustRequest, Domain, OpMetadata> reconfigureTrustOperationCallable() {
        return this.stub.reconfigureTrustOperationCallable();
    }

    public final UnaryCallable<ReconfigureTrustRequest, Operation> reconfigureTrustCallable() {
        return this.stub.reconfigureTrustCallable();
    }

    public final OperationFuture<Domain, OpMetadata> detachTrustAsync(DomainName name, Trust trust) {
        DetachTrustRequest request = DetachTrustRequest.newBuilder().setName(name == null ? null : name.toString()).setTrust(trust).build();
        return this.detachTrustAsync(request);
    }

    public final OperationFuture<Domain, OpMetadata> detachTrustAsync(String name, Trust trust) {
        DetachTrustRequest request = DetachTrustRequest.newBuilder().setName(name).setTrust(trust).build();
        return this.detachTrustAsync(request);
    }

    public final OperationFuture<Domain, OpMetadata> detachTrustAsync(DetachTrustRequest request) {
        return this.detachTrustOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DetachTrustRequest, Domain, OpMetadata> detachTrustOperationCallable() {
        return this.stub.detachTrustOperationCallable();
    }

    public final UnaryCallable<DetachTrustRequest, Operation> detachTrustCallable() {
        return this.stub.detachTrustCallable();
    }

    public final OperationFuture<Domain, OpMetadata> validateTrustAsync(DomainName name, Trust trust) {
        ValidateTrustRequest request = ValidateTrustRequest.newBuilder().setName(name == null ? null : name.toString()).setTrust(trust).build();
        return this.validateTrustAsync(request);
    }

    public final OperationFuture<Domain, OpMetadata> validateTrustAsync(String name, Trust trust) {
        ValidateTrustRequest request = ValidateTrustRequest.newBuilder().setName(name).setTrust(trust).build();
        return this.validateTrustAsync(request);
    }

    public final OperationFuture<Domain, OpMetadata> validateTrustAsync(ValidateTrustRequest request) {
        return this.validateTrustOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ValidateTrustRequest, Domain, OpMetadata> validateTrustOperationCallable() {
        return this.stub.validateTrustOperationCallable();
    }

    public final UnaryCallable<ValidateTrustRequest, Operation> validateTrustCallable() {
        return this.stub.validateTrustCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDomainsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDomainsRequest, ListDomainsResponse, Domain, ListDomainsPage, ListDomainsFixedSizeCollection> {
        private ListDomainsFixedSizeCollection(List<ListDomainsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDomainsFixedSizeCollection createEmptyCollection() {
            return new ListDomainsFixedSizeCollection(null, 0);
        }

        protected ListDomainsFixedSizeCollection createCollection(List<ListDomainsPage> pages, int collectionSize) {
            return new ListDomainsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDomainsPage
    extends AbstractPage<ListDomainsRequest, ListDomainsResponse, Domain, ListDomainsPage> {
        private ListDomainsPage(PageContext<ListDomainsRequest, ListDomainsResponse, Domain> context, ListDomainsResponse response) {
            super(context, (Object)response);
        }

        private static ListDomainsPage createEmptyPage() {
            return new ListDomainsPage(null, null);
        }

        protected ListDomainsPage createPage(PageContext<ListDomainsRequest, ListDomainsResponse, Domain> context, ListDomainsResponse response) {
            return new ListDomainsPage(context, response);
        }

        public ApiFuture<ListDomainsPage> createPageAsync(PageContext<ListDomainsRequest, ListDomainsResponse, Domain> context, ApiFuture<ListDomainsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDomainsPagedResponse
    extends AbstractPagedListResponse<ListDomainsRequest, ListDomainsResponse, Domain, ListDomainsPage, ListDomainsFixedSizeCollection> {
        public static ApiFuture<ListDomainsPagedResponse> createAsync(PageContext<ListDomainsRequest, ListDomainsResponse, Domain> context, ApiFuture<ListDomainsResponse> futureResponse) {
            ApiFuture<ListDomainsPage> futurePage = ListDomainsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListDomainsPage, ListDomainsPagedResponse>(){

                public ListDomainsPagedResponse apply(ListDomainsPage input) {
                    return new ListDomainsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListDomainsPagedResponse(ListDomainsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDomainsFixedSizeCollection.createEmptyCollection());
        }
    }
}

