/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.locationfinder.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.locationfinder.v1.CloudLocation;
import com.google.cloud.locationfinder.v1.CloudLocationFinderClient;
import com.google.cloud.locationfinder.v1.GetCloudLocationRequest;
import com.google.cloud.locationfinder.v1.ListCloudLocationsRequest;
import com.google.cloud.locationfinder.v1.ListCloudLocationsResponse;
import com.google.cloud.locationfinder.v1.SearchCloudLocationsRequest;
import com.google.cloud.locationfinder.v1.SearchCloudLocationsResponse;
import com.google.cloud.locationfinder.v1.stub.CloudLocationFinderStub;
import com.google.cloud.locationfinder.v1.stub.CloudLocationFinderStubSettings;
import com.google.cloud.locationfinder.v1.stub.GrpcCloudLocationFinderCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcCloudLocationFinderStub
extends CloudLocationFinderStub {
    private static final MethodDescriptor<ListCloudLocationsRequest, ListCloudLocationsResponse> listCloudLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.locationfinder.v1.CloudLocationFinder/ListCloudLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListCloudLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListCloudLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetCloudLocationRequest, CloudLocation> getCloudLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.locationfinder.v1.CloudLocationFinder/GetCloudLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetCloudLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CloudLocation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SearchCloudLocationsRequest, SearchCloudLocationsResponse> searchCloudLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.locationfinder.v1.CloudLocationFinder/SearchCloudLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchCloudLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchCloudLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListCloudLocationsRequest, ListCloudLocationsResponse> listCloudLocationsCallable;
    private final UnaryCallable<ListCloudLocationsRequest, CloudLocationFinderClient.ListCloudLocationsPagedResponse> listCloudLocationsPagedCallable;
    private final UnaryCallable<GetCloudLocationRequest, CloudLocation> getCloudLocationCallable;
    private final UnaryCallable<SearchCloudLocationsRequest, SearchCloudLocationsResponse> searchCloudLocationsCallable;
    private final UnaryCallable<SearchCloudLocationsRequest, CloudLocationFinderClient.SearchCloudLocationsPagedResponse> searchCloudLocationsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCloudLocationFinderStub create(CloudLocationFinderStubSettings settings) throws IOException {
        return new GrpcCloudLocationFinderStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCloudLocationFinderStub create(ClientContext clientContext) throws IOException {
        return new GrpcCloudLocationFinderStub(CloudLocationFinderStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCloudLocationFinderStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCloudLocationFinderStub(CloudLocationFinderStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCloudLocationFinderStub(CloudLocationFinderStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCloudLocationFinderCallableFactory());
    }

    protected GrpcCloudLocationFinderStub(CloudLocationFinderStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listCloudLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listCloudLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getCloudLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getCloudLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings searchCloudLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchCloudLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.listCloudLocationsCallable = callableFactory.createUnaryCallable(listCloudLocationsTransportSettings, settings.listCloudLocationsSettings(), clientContext);
        this.listCloudLocationsPagedCallable = callableFactory.createPagedCallable(listCloudLocationsTransportSettings, settings.listCloudLocationsSettings(), clientContext);
        this.getCloudLocationCallable = callableFactory.createUnaryCallable(getCloudLocationTransportSettings, settings.getCloudLocationSettings(), clientContext);
        this.searchCloudLocationsCallable = callableFactory.createUnaryCallable(searchCloudLocationsTransportSettings, settings.searchCloudLocationsSettings(), clientContext);
        this.searchCloudLocationsPagedCallable = callableFactory.createPagedCallable(searchCloudLocationsTransportSettings, settings.searchCloudLocationsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListCloudLocationsRequest, ListCloudLocationsResponse> listCloudLocationsCallable() {
        return this.listCloudLocationsCallable;
    }

    @Override
    public UnaryCallable<ListCloudLocationsRequest, CloudLocationFinderClient.ListCloudLocationsPagedResponse> listCloudLocationsPagedCallable() {
        return this.listCloudLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetCloudLocationRequest, CloudLocation> getCloudLocationCallable() {
        return this.getCloudLocationCallable;
    }

    @Override
    public UnaryCallable<SearchCloudLocationsRequest, SearchCloudLocationsResponse> searchCloudLocationsCallable() {
        return this.searchCloudLocationsCallable;
    }

    @Override
    public UnaryCallable<SearchCloudLocationsRequest, CloudLocationFinderClient.SearchCloudLocationsPagedResponse> searchCloudLocationsPagedCallable() {
        return this.searchCloudLocationsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

