/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.locationfinder.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.locationfinder.v1.CloudLocation;
import com.google.cloud.locationfinder.v1.CloudLocationFinderSettings;
import com.google.cloud.locationfinder.v1.CloudLocationName;
import com.google.cloud.locationfinder.v1.GetCloudLocationRequest;
import com.google.cloud.locationfinder.v1.ListCloudLocationsRequest;
import com.google.cloud.locationfinder.v1.ListCloudLocationsResponse;
import com.google.cloud.locationfinder.v1.LocationName;
import com.google.cloud.locationfinder.v1.SearchCloudLocationsRequest;
import com.google.cloud.locationfinder.v1.SearchCloudLocationsResponse;
import com.google.cloud.locationfinder.v1.stub.CloudLocationFinderStub;
import com.google.cloud.locationfinder.v1.stub.CloudLocationFinderStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CloudLocationFinderClient
implements BackgroundResource {
    private final CloudLocationFinderSettings settings;
    private final CloudLocationFinderStub stub;

    public static final CloudLocationFinderClient create() throws IOException {
        return CloudLocationFinderClient.create(CloudLocationFinderSettings.newBuilder().build());
    }

    public static final CloudLocationFinderClient create(CloudLocationFinderSettings settings) throws IOException {
        return new CloudLocationFinderClient(settings);
    }

    public static final CloudLocationFinderClient create(CloudLocationFinderStub stub) {
        return new CloudLocationFinderClient(stub);
    }

    protected CloudLocationFinderClient(CloudLocationFinderSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CloudLocationFinderStubSettings)settings.getStubSettings()).createStub();
    }

    protected CloudLocationFinderClient(CloudLocationFinderStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CloudLocationFinderSettings getSettings() {
        return this.settings;
    }

    public CloudLocationFinderStub getStub() {
        return this.stub;
    }

    public final ListCloudLocationsPagedResponse listCloudLocations(LocationName parent) {
        ListCloudLocationsRequest request = ListCloudLocationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCloudLocations(request);
    }

    public final ListCloudLocationsPagedResponse listCloudLocations(String parent) {
        ListCloudLocationsRequest request = ListCloudLocationsRequest.newBuilder().setParent(parent).build();
        return this.listCloudLocations(request);
    }

    public final ListCloudLocationsPagedResponse listCloudLocations(ListCloudLocationsRequest request) {
        return (ListCloudLocationsPagedResponse)((Object)this.listCloudLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCloudLocationsRequest, ListCloudLocationsPagedResponse> listCloudLocationsPagedCallable() {
        return this.stub.listCloudLocationsPagedCallable();
    }

    public final UnaryCallable<ListCloudLocationsRequest, ListCloudLocationsResponse> listCloudLocationsCallable() {
        return this.stub.listCloudLocationsCallable();
    }

    public final CloudLocation getCloudLocation(CloudLocationName name) {
        GetCloudLocationRequest request = GetCloudLocationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCloudLocation(request);
    }

    public final CloudLocation getCloudLocation(String name) {
        GetCloudLocationRequest request = GetCloudLocationRequest.newBuilder().setName(name).build();
        return this.getCloudLocation(request);
    }

    public final CloudLocation getCloudLocation(GetCloudLocationRequest request) {
        return (CloudLocation)this.getCloudLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetCloudLocationRequest, CloudLocation> getCloudLocationCallable() {
        return this.stub.getCloudLocationCallable();
    }

    public final SearchCloudLocationsPagedResponse searchCloudLocations(LocationName parent, CloudLocationName sourceCloudLocation, String query) {
        SearchCloudLocationsRequest request = SearchCloudLocationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSourceCloudLocation(sourceCloudLocation == null ? null : sourceCloudLocation.toString()).setQuery(query).build();
        return this.searchCloudLocations(request);
    }

    public final SearchCloudLocationsPagedResponse searchCloudLocations(LocationName parent, String sourceCloudLocation, String query) {
        SearchCloudLocationsRequest request = SearchCloudLocationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSourceCloudLocation(sourceCloudLocation).setQuery(query).build();
        return this.searchCloudLocations(request);
    }

    public final SearchCloudLocationsPagedResponse searchCloudLocations(String parent, CloudLocationName sourceCloudLocation, String query) {
        SearchCloudLocationsRequest request = SearchCloudLocationsRequest.newBuilder().setParent(parent).setSourceCloudLocation(sourceCloudLocation == null ? null : sourceCloudLocation.toString()).setQuery(query).build();
        return this.searchCloudLocations(request);
    }

    public final SearchCloudLocationsPagedResponse searchCloudLocations(String parent, String sourceCloudLocation, String query) {
        SearchCloudLocationsRequest request = SearchCloudLocationsRequest.newBuilder().setParent(parent).setSourceCloudLocation(sourceCloudLocation).setQuery(query).build();
        return this.searchCloudLocations(request);
    }

    public final SearchCloudLocationsPagedResponse searchCloudLocations(SearchCloudLocationsRequest request) {
        return (SearchCloudLocationsPagedResponse)((Object)this.searchCloudLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchCloudLocationsRequest, SearchCloudLocationsPagedResponse> searchCloudLocationsPagedCallable() {
        return this.stub.searchCloudLocationsPagedCallable();
    }

    public final UnaryCallable<SearchCloudLocationsRequest, SearchCloudLocationsResponse> searchCloudLocationsCallable() {
        return this.stub.searchCloudLocationsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchCloudLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchCloudLocationsRequest, SearchCloudLocationsResponse, CloudLocation, SearchCloudLocationsPage, SearchCloudLocationsFixedSizeCollection> {
        private SearchCloudLocationsFixedSizeCollection(List<SearchCloudLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchCloudLocationsFixedSizeCollection createEmptyCollection() {
            return new SearchCloudLocationsFixedSizeCollection(null, 0);
        }

        protected SearchCloudLocationsFixedSizeCollection createCollection(List<SearchCloudLocationsPage> pages, int collectionSize) {
            return new SearchCloudLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchCloudLocationsPage
    extends AbstractPage<SearchCloudLocationsRequest, SearchCloudLocationsResponse, CloudLocation, SearchCloudLocationsPage> {
        private SearchCloudLocationsPage(PageContext<SearchCloudLocationsRequest, SearchCloudLocationsResponse, CloudLocation> context, SearchCloudLocationsResponse response) {
            super(context, (Object)response);
        }

        private static SearchCloudLocationsPage createEmptyPage() {
            return new SearchCloudLocationsPage(null, null);
        }

        protected SearchCloudLocationsPage createPage(PageContext<SearchCloudLocationsRequest, SearchCloudLocationsResponse, CloudLocation> context, SearchCloudLocationsResponse response) {
            return new SearchCloudLocationsPage(context, response);
        }

        public ApiFuture<SearchCloudLocationsPage> createPageAsync(PageContext<SearchCloudLocationsRequest, SearchCloudLocationsResponse, CloudLocation> context, ApiFuture<SearchCloudLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchCloudLocationsPagedResponse
    extends AbstractPagedListResponse<SearchCloudLocationsRequest, SearchCloudLocationsResponse, CloudLocation, SearchCloudLocationsPage, SearchCloudLocationsFixedSizeCollection> {
        public static ApiFuture<SearchCloudLocationsPagedResponse> createAsync(PageContext<SearchCloudLocationsRequest, SearchCloudLocationsResponse, CloudLocation> context, ApiFuture<SearchCloudLocationsResponse> futureResponse) {
            ApiFuture<SearchCloudLocationsPage> futurePage = SearchCloudLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchCloudLocationsPagedResponse((SearchCloudLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchCloudLocationsPagedResponse(SearchCloudLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchCloudLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCloudLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCloudLocationsRequest, ListCloudLocationsResponse, CloudLocation, ListCloudLocationsPage, ListCloudLocationsFixedSizeCollection> {
        private ListCloudLocationsFixedSizeCollection(List<ListCloudLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCloudLocationsFixedSizeCollection createEmptyCollection() {
            return new ListCloudLocationsFixedSizeCollection(null, 0);
        }

        protected ListCloudLocationsFixedSizeCollection createCollection(List<ListCloudLocationsPage> pages, int collectionSize) {
            return new ListCloudLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCloudLocationsPage
    extends AbstractPage<ListCloudLocationsRequest, ListCloudLocationsResponse, CloudLocation, ListCloudLocationsPage> {
        private ListCloudLocationsPage(PageContext<ListCloudLocationsRequest, ListCloudLocationsResponse, CloudLocation> context, ListCloudLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListCloudLocationsPage createEmptyPage() {
            return new ListCloudLocationsPage(null, null);
        }

        protected ListCloudLocationsPage createPage(PageContext<ListCloudLocationsRequest, ListCloudLocationsResponse, CloudLocation> context, ListCloudLocationsResponse response) {
            return new ListCloudLocationsPage(context, response);
        }

        public ApiFuture<ListCloudLocationsPage> createPageAsync(PageContext<ListCloudLocationsRequest, ListCloudLocationsResponse, CloudLocation> context, ApiFuture<ListCloudLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCloudLocationsPagedResponse
    extends AbstractPagedListResponse<ListCloudLocationsRequest, ListCloudLocationsResponse, CloudLocation, ListCloudLocationsPage, ListCloudLocationsFixedSizeCollection> {
        public static ApiFuture<ListCloudLocationsPagedResponse> createAsync(PageContext<ListCloudLocationsRequest, ListCloudLocationsResponse, CloudLocation> context, ApiFuture<ListCloudLocationsResponse> futureResponse) {
            ApiFuture<ListCloudLocationsPage> futurePage = ListCloudLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCloudLocationsPagedResponse((ListCloudLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCloudLocationsPagedResponse(ListCloudLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCloudLocationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

