/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.livestream.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.video.livestream.v1.Asset;
import com.google.cloud.video.livestream.v1.Channel;
import com.google.cloud.video.livestream.v1.ChannelOperationResponse;
import com.google.cloud.video.livestream.v1.Clip;
import com.google.cloud.video.livestream.v1.CreateAssetRequest;
import com.google.cloud.video.livestream.v1.CreateChannelRequest;
import com.google.cloud.video.livestream.v1.CreateClipRequest;
import com.google.cloud.video.livestream.v1.CreateEventRequest;
import com.google.cloud.video.livestream.v1.CreateInputRequest;
import com.google.cloud.video.livestream.v1.DeleteAssetRequest;
import com.google.cloud.video.livestream.v1.DeleteChannelRequest;
import com.google.cloud.video.livestream.v1.DeleteClipRequest;
import com.google.cloud.video.livestream.v1.DeleteEventRequest;
import com.google.cloud.video.livestream.v1.DeleteInputRequest;
import com.google.cloud.video.livestream.v1.Event;
import com.google.cloud.video.livestream.v1.GetAssetRequest;
import com.google.cloud.video.livestream.v1.GetChannelRequest;
import com.google.cloud.video.livestream.v1.GetClipRequest;
import com.google.cloud.video.livestream.v1.GetEventRequest;
import com.google.cloud.video.livestream.v1.GetInputRequest;
import com.google.cloud.video.livestream.v1.GetPoolRequest;
import com.google.cloud.video.livestream.v1.Input;
import com.google.cloud.video.livestream.v1.ListAssetsRequest;
import com.google.cloud.video.livestream.v1.ListAssetsResponse;
import com.google.cloud.video.livestream.v1.ListChannelsRequest;
import com.google.cloud.video.livestream.v1.ListChannelsResponse;
import com.google.cloud.video.livestream.v1.ListClipsRequest;
import com.google.cloud.video.livestream.v1.ListClipsResponse;
import com.google.cloud.video.livestream.v1.ListEventsRequest;
import com.google.cloud.video.livestream.v1.ListEventsResponse;
import com.google.cloud.video.livestream.v1.ListInputsRequest;
import com.google.cloud.video.livestream.v1.ListInputsResponse;
import com.google.cloud.video.livestream.v1.LivestreamServiceClient;
import com.google.cloud.video.livestream.v1.OperationMetadata;
import com.google.cloud.video.livestream.v1.Pool;
import com.google.cloud.video.livestream.v1.StartChannelRequest;
import com.google.cloud.video.livestream.v1.StopChannelRequest;
import com.google.cloud.video.livestream.v1.UpdateChannelRequest;
import com.google.cloud.video.livestream.v1.UpdateInputRequest;
import com.google.cloud.video.livestream.v1.UpdatePoolRequest;
import com.google.cloud.video.livestream.v1.stub.GrpcLivestreamServiceStub;
import com.google.cloud.video.livestream.v1.stub.HttpJsonLivestreamServiceStub;
import com.google.cloud.video.livestream.v1.stub.LivestreamServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class LivestreamServiceStubSettings
extends StubSettings<LivestreamServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateChannelRequest, Operation> createChannelSettings;
    private final OperationCallSettings<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationSettings;
    private final PagedCallSettings<ListChannelsRequest, ListChannelsResponse, LivestreamServiceClient.ListChannelsPagedResponse> listChannelsSettings;
    private final UnaryCallSettings<GetChannelRequest, Channel> getChannelSettings;
    private final UnaryCallSettings<DeleteChannelRequest, Operation> deleteChannelSettings;
    private final OperationCallSettings<DeleteChannelRequest, Empty, OperationMetadata> deleteChannelOperationSettings;
    private final UnaryCallSettings<UpdateChannelRequest, Operation> updateChannelSettings;
    private final OperationCallSettings<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationSettings;
    private final UnaryCallSettings<StartChannelRequest, Operation> startChannelSettings;
    private final OperationCallSettings<StartChannelRequest, ChannelOperationResponse, OperationMetadata> startChannelOperationSettings;
    private final UnaryCallSettings<StopChannelRequest, Operation> stopChannelSettings;
    private final OperationCallSettings<StopChannelRequest, ChannelOperationResponse, OperationMetadata> stopChannelOperationSettings;
    private final UnaryCallSettings<CreateInputRequest, Operation> createInputSettings;
    private final OperationCallSettings<CreateInputRequest, Input, OperationMetadata> createInputOperationSettings;
    private final PagedCallSettings<ListInputsRequest, ListInputsResponse, LivestreamServiceClient.ListInputsPagedResponse> listInputsSettings;
    private final UnaryCallSettings<GetInputRequest, Input> getInputSettings;
    private final UnaryCallSettings<DeleteInputRequest, Operation> deleteInputSettings;
    private final OperationCallSettings<DeleteInputRequest, Empty, OperationMetadata> deleteInputOperationSettings;
    private final UnaryCallSettings<UpdateInputRequest, Operation> updateInputSettings;
    private final OperationCallSettings<UpdateInputRequest, Input, OperationMetadata> updateInputOperationSettings;
    private final UnaryCallSettings<CreateEventRequest, Event> createEventSettings;
    private final PagedCallSettings<ListEventsRequest, ListEventsResponse, LivestreamServiceClient.ListEventsPagedResponse> listEventsSettings;
    private final UnaryCallSettings<GetEventRequest, Event> getEventSettings;
    private final UnaryCallSettings<DeleteEventRequest, Empty> deleteEventSettings;
    private final PagedCallSettings<ListClipsRequest, ListClipsResponse, LivestreamServiceClient.ListClipsPagedResponse> listClipsSettings;
    private final UnaryCallSettings<GetClipRequest, Clip> getClipSettings;
    private final UnaryCallSettings<CreateClipRequest, Operation> createClipSettings;
    private final OperationCallSettings<CreateClipRequest, Clip, OperationMetadata> createClipOperationSettings;
    private final UnaryCallSettings<DeleteClipRequest, Operation> deleteClipSettings;
    private final OperationCallSettings<DeleteClipRequest, Empty, OperationMetadata> deleteClipOperationSettings;
    private final UnaryCallSettings<CreateAssetRequest, Operation> createAssetSettings;
    private final OperationCallSettings<CreateAssetRequest, Asset, OperationMetadata> createAssetOperationSettings;
    private final UnaryCallSettings<DeleteAssetRequest, Operation> deleteAssetSettings;
    private final OperationCallSettings<DeleteAssetRequest, Empty, OperationMetadata> deleteAssetOperationSettings;
    private final UnaryCallSettings<GetAssetRequest, Asset> getAssetSettings;
    private final PagedCallSettings<ListAssetsRequest, ListAssetsResponse, LivestreamServiceClient.ListAssetsPagedResponse> listAssetsSettings;
    private final UnaryCallSettings<GetPoolRequest, Pool> getPoolSettings;
    private final UnaryCallSettings<UpdatePoolRequest, Operation> updatePoolSettings;
    private final OperationCallSettings<UpdatePoolRequest, Pool, OperationMetadata> updatePoolOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, LivestreamServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListChannelsRequest, ListChannelsResponse, Channel> LIST_CHANNELS_PAGE_STR_DESC = new PagedListDescriptor<ListChannelsRequest, ListChannelsResponse, Channel>(){

        public String emptyToken() {
            return "";
        }

        public ListChannelsRequest injectToken(ListChannelsRequest payload, String token) {
            return ListChannelsRequest.newBuilder((ListChannelsRequest)payload).setPageToken(token).build();
        }

        public ListChannelsRequest injectPageSize(ListChannelsRequest payload, int pageSize) {
            return ListChannelsRequest.newBuilder((ListChannelsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListChannelsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListChannelsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Channel> extractResources(ListChannelsResponse payload) {
            return payload.getChannelsList() == null ? ImmutableList.of() : payload.getChannelsList();
        }
    };
    private static final PagedListDescriptor<ListInputsRequest, ListInputsResponse, Input> LIST_INPUTS_PAGE_STR_DESC = new PagedListDescriptor<ListInputsRequest, ListInputsResponse, Input>(){

        public String emptyToken() {
            return "";
        }

        public ListInputsRequest injectToken(ListInputsRequest payload, String token) {
            return ListInputsRequest.newBuilder((ListInputsRequest)payload).setPageToken(token).build();
        }

        public ListInputsRequest injectPageSize(ListInputsRequest payload, int pageSize) {
            return ListInputsRequest.newBuilder((ListInputsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListInputsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListInputsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Input> extractResources(ListInputsResponse payload) {
            return payload.getInputsList() == null ? ImmutableList.of() : payload.getInputsList();
        }
    };
    private static final PagedListDescriptor<ListEventsRequest, ListEventsResponse, Event> LIST_EVENTS_PAGE_STR_DESC = new PagedListDescriptor<ListEventsRequest, ListEventsResponse, Event>(){

        public String emptyToken() {
            return "";
        }

        public ListEventsRequest injectToken(ListEventsRequest payload, String token) {
            return ListEventsRequest.newBuilder((ListEventsRequest)payload).setPageToken(token).build();
        }

        public ListEventsRequest injectPageSize(ListEventsRequest payload, int pageSize) {
            return ListEventsRequest.newBuilder((ListEventsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEventsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEventsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Event> extractResources(ListEventsResponse payload) {
            return payload.getEventsList() == null ? ImmutableList.of() : payload.getEventsList();
        }
    };
    private static final PagedListDescriptor<ListClipsRequest, ListClipsResponse, Clip> LIST_CLIPS_PAGE_STR_DESC = new PagedListDescriptor<ListClipsRequest, ListClipsResponse, Clip>(){

        public String emptyToken() {
            return "";
        }

        public ListClipsRequest injectToken(ListClipsRequest payload, String token) {
            return ListClipsRequest.newBuilder((ListClipsRequest)payload).setPageToken(token).build();
        }

        public ListClipsRequest injectPageSize(ListClipsRequest payload, int pageSize) {
            return ListClipsRequest.newBuilder((ListClipsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListClipsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListClipsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Clip> extractResources(ListClipsResponse payload) {
            return payload.getClipsList() == null ? ImmutableList.of() : payload.getClipsList();
        }
    };
    private static final PagedListDescriptor<ListAssetsRequest, ListAssetsResponse, Asset> LIST_ASSETS_PAGE_STR_DESC = new PagedListDescriptor<ListAssetsRequest, ListAssetsResponse, Asset>(){

        public String emptyToken() {
            return "";
        }

        public ListAssetsRequest injectToken(ListAssetsRequest payload, String token) {
            return ListAssetsRequest.newBuilder((ListAssetsRequest)payload).setPageToken(token).build();
        }

        public ListAssetsRequest injectPageSize(ListAssetsRequest payload, int pageSize) {
            return ListAssetsRequest.newBuilder((ListAssetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAssetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAssetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Asset> extractResources(ListAssetsResponse payload) {
            return payload.getAssetsList() == null ? ImmutableList.of() : payload.getAssetsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListChannelsRequest, ListChannelsResponse, LivestreamServiceClient.ListChannelsPagedResponse> LIST_CHANNELS_PAGE_STR_FACT = new PagedListResponseFactory<ListChannelsRequest, ListChannelsResponse, LivestreamServiceClient.ListChannelsPagedResponse>(){

        public ApiFuture<LivestreamServiceClient.ListChannelsPagedResponse> getFuturePagedResponse(UnaryCallable<ListChannelsRequest, ListChannelsResponse> callable, ListChannelsRequest request, ApiCallContext context, ApiFuture<ListChannelsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CHANNELS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LivestreamServiceClient.ListChannelsPagedResponse.createAsync((PageContext<ListChannelsRequest, ListChannelsResponse, Channel>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInputsRequest, ListInputsResponse, LivestreamServiceClient.ListInputsPagedResponse> LIST_INPUTS_PAGE_STR_FACT = new PagedListResponseFactory<ListInputsRequest, ListInputsResponse, LivestreamServiceClient.ListInputsPagedResponse>(){

        public ApiFuture<LivestreamServiceClient.ListInputsPagedResponse> getFuturePagedResponse(UnaryCallable<ListInputsRequest, ListInputsResponse> callable, ListInputsRequest request, ApiCallContext context, ApiFuture<ListInputsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INPUTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LivestreamServiceClient.ListInputsPagedResponse.createAsync((PageContext<ListInputsRequest, ListInputsResponse, Input>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListEventsRequest, ListEventsResponse, LivestreamServiceClient.ListEventsPagedResponse> LIST_EVENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEventsRequest, ListEventsResponse, LivestreamServiceClient.ListEventsPagedResponse>(){

        public ApiFuture<LivestreamServiceClient.ListEventsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEventsRequest, ListEventsResponse> callable, ListEventsRequest request, ApiCallContext context, ApiFuture<ListEventsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_EVENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LivestreamServiceClient.ListEventsPagedResponse.createAsync((PageContext<ListEventsRequest, ListEventsResponse, Event>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListClipsRequest, ListClipsResponse, LivestreamServiceClient.ListClipsPagedResponse> LIST_CLIPS_PAGE_STR_FACT = new PagedListResponseFactory<ListClipsRequest, ListClipsResponse, LivestreamServiceClient.ListClipsPagedResponse>(){

        public ApiFuture<LivestreamServiceClient.ListClipsPagedResponse> getFuturePagedResponse(UnaryCallable<ListClipsRequest, ListClipsResponse> callable, ListClipsRequest request, ApiCallContext context, ApiFuture<ListClipsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CLIPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LivestreamServiceClient.ListClipsPagedResponse.createAsync((PageContext<ListClipsRequest, ListClipsResponse, Clip>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAssetsRequest, ListAssetsResponse, LivestreamServiceClient.ListAssetsPagedResponse> LIST_ASSETS_PAGE_STR_FACT = new PagedListResponseFactory<ListAssetsRequest, ListAssetsResponse, LivestreamServiceClient.ListAssetsPagedResponse>(){

        public ApiFuture<LivestreamServiceClient.ListAssetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAssetsRequest, ListAssetsResponse> callable, ListAssetsRequest request, ApiCallContext context, ApiFuture<ListAssetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ASSETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LivestreamServiceClient.ListAssetsPagedResponse.createAsync((PageContext<ListAssetsRequest, ListAssetsResponse, Asset>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, LivestreamServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, LivestreamServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<LivestreamServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LivestreamServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateChannelRequest, Operation> createChannelSettings() {
        return this.createChannelSettings;
    }

    public OperationCallSettings<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationSettings() {
        return this.createChannelOperationSettings;
    }

    public PagedCallSettings<ListChannelsRequest, ListChannelsResponse, LivestreamServiceClient.ListChannelsPagedResponse> listChannelsSettings() {
        return this.listChannelsSettings;
    }

    public UnaryCallSettings<GetChannelRequest, Channel> getChannelSettings() {
        return this.getChannelSettings;
    }

    public UnaryCallSettings<DeleteChannelRequest, Operation> deleteChannelSettings() {
        return this.deleteChannelSettings;
    }

    public OperationCallSettings<DeleteChannelRequest, Empty, OperationMetadata> deleteChannelOperationSettings() {
        return this.deleteChannelOperationSettings;
    }

    public UnaryCallSettings<UpdateChannelRequest, Operation> updateChannelSettings() {
        return this.updateChannelSettings;
    }

    public OperationCallSettings<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationSettings() {
        return this.updateChannelOperationSettings;
    }

    public UnaryCallSettings<StartChannelRequest, Operation> startChannelSettings() {
        return this.startChannelSettings;
    }

    public OperationCallSettings<StartChannelRequest, ChannelOperationResponse, OperationMetadata> startChannelOperationSettings() {
        return this.startChannelOperationSettings;
    }

    public UnaryCallSettings<StopChannelRequest, Operation> stopChannelSettings() {
        return this.stopChannelSettings;
    }

    public OperationCallSettings<StopChannelRequest, ChannelOperationResponse, OperationMetadata> stopChannelOperationSettings() {
        return this.stopChannelOperationSettings;
    }

    public UnaryCallSettings<CreateInputRequest, Operation> createInputSettings() {
        return this.createInputSettings;
    }

    public OperationCallSettings<CreateInputRequest, Input, OperationMetadata> createInputOperationSettings() {
        return this.createInputOperationSettings;
    }

    public PagedCallSettings<ListInputsRequest, ListInputsResponse, LivestreamServiceClient.ListInputsPagedResponse> listInputsSettings() {
        return this.listInputsSettings;
    }

    public UnaryCallSettings<GetInputRequest, Input> getInputSettings() {
        return this.getInputSettings;
    }

    public UnaryCallSettings<DeleteInputRequest, Operation> deleteInputSettings() {
        return this.deleteInputSettings;
    }

    public OperationCallSettings<DeleteInputRequest, Empty, OperationMetadata> deleteInputOperationSettings() {
        return this.deleteInputOperationSettings;
    }

    public UnaryCallSettings<UpdateInputRequest, Operation> updateInputSettings() {
        return this.updateInputSettings;
    }

    public OperationCallSettings<UpdateInputRequest, Input, OperationMetadata> updateInputOperationSettings() {
        return this.updateInputOperationSettings;
    }

    public UnaryCallSettings<CreateEventRequest, Event> createEventSettings() {
        return this.createEventSettings;
    }

    public PagedCallSettings<ListEventsRequest, ListEventsResponse, LivestreamServiceClient.ListEventsPagedResponse> listEventsSettings() {
        return this.listEventsSettings;
    }

    public UnaryCallSettings<GetEventRequest, Event> getEventSettings() {
        return this.getEventSettings;
    }

    public UnaryCallSettings<DeleteEventRequest, Empty> deleteEventSettings() {
        return this.deleteEventSettings;
    }

    public PagedCallSettings<ListClipsRequest, ListClipsResponse, LivestreamServiceClient.ListClipsPagedResponse> listClipsSettings() {
        return this.listClipsSettings;
    }

    public UnaryCallSettings<GetClipRequest, Clip> getClipSettings() {
        return this.getClipSettings;
    }

    public UnaryCallSettings<CreateClipRequest, Operation> createClipSettings() {
        return this.createClipSettings;
    }

    public OperationCallSettings<CreateClipRequest, Clip, OperationMetadata> createClipOperationSettings() {
        return this.createClipOperationSettings;
    }

    public UnaryCallSettings<DeleteClipRequest, Operation> deleteClipSettings() {
        return this.deleteClipSettings;
    }

    public OperationCallSettings<DeleteClipRequest, Empty, OperationMetadata> deleteClipOperationSettings() {
        return this.deleteClipOperationSettings;
    }

    public UnaryCallSettings<CreateAssetRequest, Operation> createAssetSettings() {
        return this.createAssetSettings;
    }

    public OperationCallSettings<CreateAssetRequest, Asset, OperationMetadata> createAssetOperationSettings() {
        return this.createAssetOperationSettings;
    }

    public UnaryCallSettings<DeleteAssetRequest, Operation> deleteAssetSettings() {
        return this.deleteAssetSettings;
    }

    public OperationCallSettings<DeleteAssetRequest, Empty, OperationMetadata> deleteAssetOperationSettings() {
        return this.deleteAssetOperationSettings;
    }

    public UnaryCallSettings<GetAssetRequest, Asset> getAssetSettings() {
        return this.getAssetSettings;
    }

    public PagedCallSettings<ListAssetsRequest, ListAssetsResponse, LivestreamServiceClient.ListAssetsPagedResponse> listAssetsSettings() {
        return this.listAssetsSettings;
    }

    public UnaryCallSettings<GetPoolRequest, Pool> getPoolSettings() {
        return this.getPoolSettings;
    }

    public UnaryCallSettings<UpdatePoolRequest, Operation> updatePoolSettings() {
        return this.updatePoolSettings;
    }

    public OperationCallSettings<UpdatePoolRequest, Pool, OperationMetadata> updatePoolOperationSettings() {
        return this.updatePoolOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, LivestreamServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public LivestreamServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcLivestreamServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonLivestreamServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "livestream";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "livestream.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "livestream.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return LivestreamServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(LivestreamServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(LivestreamServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return LivestreamServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected LivestreamServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createChannelSettings = settingsBuilder.createChannelSettings().build();
        this.createChannelOperationSettings = settingsBuilder.createChannelOperationSettings().build();
        this.listChannelsSettings = settingsBuilder.listChannelsSettings().build();
        this.getChannelSettings = settingsBuilder.getChannelSettings().build();
        this.deleteChannelSettings = settingsBuilder.deleteChannelSettings().build();
        this.deleteChannelOperationSettings = settingsBuilder.deleteChannelOperationSettings().build();
        this.updateChannelSettings = settingsBuilder.updateChannelSettings().build();
        this.updateChannelOperationSettings = settingsBuilder.updateChannelOperationSettings().build();
        this.startChannelSettings = settingsBuilder.startChannelSettings().build();
        this.startChannelOperationSettings = settingsBuilder.startChannelOperationSettings().build();
        this.stopChannelSettings = settingsBuilder.stopChannelSettings().build();
        this.stopChannelOperationSettings = settingsBuilder.stopChannelOperationSettings().build();
        this.createInputSettings = settingsBuilder.createInputSettings().build();
        this.createInputOperationSettings = settingsBuilder.createInputOperationSettings().build();
        this.listInputsSettings = settingsBuilder.listInputsSettings().build();
        this.getInputSettings = settingsBuilder.getInputSettings().build();
        this.deleteInputSettings = settingsBuilder.deleteInputSettings().build();
        this.deleteInputOperationSettings = settingsBuilder.deleteInputOperationSettings().build();
        this.updateInputSettings = settingsBuilder.updateInputSettings().build();
        this.updateInputOperationSettings = settingsBuilder.updateInputOperationSettings().build();
        this.createEventSettings = settingsBuilder.createEventSettings().build();
        this.listEventsSettings = settingsBuilder.listEventsSettings().build();
        this.getEventSettings = settingsBuilder.getEventSettings().build();
        this.deleteEventSettings = settingsBuilder.deleteEventSettings().build();
        this.listClipsSettings = settingsBuilder.listClipsSettings().build();
        this.getClipSettings = settingsBuilder.getClipSettings().build();
        this.createClipSettings = settingsBuilder.createClipSettings().build();
        this.createClipOperationSettings = settingsBuilder.createClipOperationSettings().build();
        this.deleteClipSettings = settingsBuilder.deleteClipSettings().build();
        this.deleteClipOperationSettings = settingsBuilder.deleteClipOperationSettings().build();
        this.createAssetSettings = settingsBuilder.createAssetSettings().build();
        this.createAssetOperationSettings = settingsBuilder.createAssetOperationSettings().build();
        this.deleteAssetSettings = settingsBuilder.deleteAssetSettings().build();
        this.deleteAssetOperationSettings = settingsBuilder.deleteAssetOperationSettings().build();
        this.getAssetSettings = settingsBuilder.getAssetSettings().build();
        this.listAssetsSettings = settingsBuilder.listAssetsSettings().build();
        this.getPoolSettings = settingsBuilder.getPoolSettings().build();
        this.updatePoolSettings = settingsBuilder.updatePoolSettings().build();
        this.updatePoolOperationSettings = settingsBuilder.updatePoolOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<LivestreamServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateChannelRequest, Operation> createChannelSettings;
        private final OperationCallSettings.Builder<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationSettings;
        private final PagedCallSettings.Builder<ListChannelsRequest, ListChannelsResponse, LivestreamServiceClient.ListChannelsPagedResponse> listChannelsSettings;
        private final UnaryCallSettings.Builder<GetChannelRequest, Channel> getChannelSettings;
        private final UnaryCallSettings.Builder<DeleteChannelRequest, Operation> deleteChannelSettings;
        private final OperationCallSettings.Builder<DeleteChannelRequest, Empty, OperationMetadata> deleteChannelOperationSettings;
        private final UnaryCallSettings.Builder<UpdateChannelRequest, Operation> updateChannelSettings;
        private final OperationCallSettings.Builder<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationSettings;
        private final UnaryCallSettings.Builder<StartChannelRequest, Operation> startChannelSettings;
        private final OperationCallSettings.Builder<StartChannelRequest, ChannelOperationResponse, OperationMetadata> startChannelOperationSettings;
        private final UnaryCallSettings.Builder<StopChannelRequest, Operation> stopChannelSettings;
        private final OperationCallSettings.Builder<StopChannelRequest, ChannelOperationResponse, OperationMetadata> stopChannelOperationSettings;
        private final UnaryCallSettings.Builder<CreateInputRequest, Operation> createInputSettings;
        private final OperationCallSettings.Builder<CreateInputRequest, Input, OperationMetadata> createInputOperationSettings;
        private final PagedCallSettings.Builder<ListInputsRequest, ListInputsResponse, LivestreamServiceClient.ListInputsPagedResponse> listInputsSettings;
        private final UnaryCallSettings.Builder<GetInputRequest, Input> getInputSettings;
        private final UnaryCallSettings.Builder<DeleteInputRequest, Operation> deleteInputSettings;
        private final OperationCallSettings.Builder<DeleteInputRequest, Empty, OperationMetadata> deleteInputOperationSettings;
        private final UnaryCallSettings.Builder<UpdateInputRequest, Operation> updateInputSettings;
        private final OperationCallSettings.Builder<UpdateInputRequest, Input, OperationMetadata> updateInputOperationSettings;
        private final UnaryCallSettings.Builder<CreateEventRequest, Event> createEventSettings;
        private final PagedCallSettings.Builder<ListEventsRequest, ListEventsResponse, LivestreamServiceClient.ListEventsPagedResponse> listEventsSettings;
        private final UnaryCallSettings.Builder<GetEventRequest, Event> getEventSettings;
        private final UnaryCallSettings.Builder<DeleteEventRequest, Empty> deleteEventSettings;
        private final PagedCallSettings.Builder<ListClipsRequest, ListClipsResponse, LivestreamServiceClient.ListClipsPagedResponse> listClipsSettings;
        private final UnaryCallSettings.Builder<GetClipRequest, Clip> getClipSettings;
        private final UnaryCallSettings.Builder<CreateClipRequest, Operation> createClipSettings;
        private final OperationCallSettings.Builder<CreateClipRequest, Clip, OperationMetadata> createClipOperationSettings;
        private final UnaryCallSettings.Builder<DeleteClipRequest, Operation> deleteClipSettings;
        private final OperationCallSettings.Builder<DeleteClipRequest, Empty, OperationMetadata> deleteClipOperationSettings;
        private final UnaryCallSettings.Builder<CreateAssetRequest, Operation> createAssetSettings;
        private final OperationCallSettings.Builder<CreateAssetRequest, Asset, OperationMetadata> createAssetOperationSettings;
        private final UnaryCallSettings.Builder<DeleteAssetRequest, Operation> deleteAssetSettings;
        private final OperationCallSettings.Builder<DeleteAssetRequest, Empty, OperationMetadata> deleteAssetOperationSettings;
        private final UnaryCallSettings.Builder<GetAssetRequest, Asset> getAssetSettings;
        private final PagedCallSettings.Builder<ListAssetsRequest, ListAssetsResponse, LivestreamServiceClient.ListAssetsPagedResponse> listAssetsSettings;
        private final UnaryCallSettings.Builder<GetPoolRequest, Pool> getPoolSettings;
        private final UnaryCallSettings.Builder<UpdatePoolRequest, Operation> updatePoolSettings;
        private final OperationCallSettings.Builder<UpdatePoolRequest, Pool, OperationMetadata> updatePoolOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, LivestreamServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createChannelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createChannelOperationSettings = OperationCallSettings.newBuilder();
            this.listChannelsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CHANNELS_PAGE_STR_FACT);
            this.getChannelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteChannelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteChannelOperationSettings = OperationCallSettings.newBuilder();
            this.updateChannelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateChannelOperationSettings = OperationCallSettings.newBuilder();
            this.startChannelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startChannelOperationSettings = OperationCallSettings.newBuilder();
            this.stopChannelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.stopChannelOperationSettings = OperationCallSettings.newBuilder();
            this.createInputSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInputOperationSettings = OperationCallSettings.newBuilder();
            this.listInputsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INPUTS_PAGE_STR_FACT);
            this.getInputSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteInputSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteInputOperationSettings = OperationCallSettings.newBuilder();
            this.updateInputSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateInputOperationSettings = OperationCallSettings.newBuilder();
            this.createEventSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listEventsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_EVENTS_PAGE_STR_FACT);
            this.getEventSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEventSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listClipsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CLIPS_PAGE_STR_FACT);
            this.getClipSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createClipSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createClipOperationSettings = OperationCallSettings.newBuilder();
            this.deleteClipSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteClipOperationSettings = OperationCallSettings.newBuilder();
            this.createAssetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAssetOperationSettings = OperationCallSettings.newBuilder();
            this.deleteAssetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAssetOperationSettings = OperationCallSettings.newBuilder();
            this.getAssetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAssetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ASSETS_PAGE_STR_FACT);
            this.getPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePoolOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createChannelSettings, this.listChannelsSettings, this.getChannelSettings, this.deleteChannelSettings, this.updateChannelSettings, this.startChannelSettings, this.stopChannelSettings, this.createInputSettings, this.listInputsSettings, this.getInputSettings, this.deleteInputSettings, this.updateInputSettings, (Object[])new UnaryCallSettings.Builder[]{this.createEventSettings, this.listEventsSettings, this.getEventSettings, this.deleteEventSettings, this.listClipsSettings, this.getClipSettings, this.createClipSettings, this.deleteClipSettings, this.createAssetSettings, this.deleteAssetSettings, this.getAssetSettings, this.listAssetsSettings, this.getPoolSettings, this.updatePoolSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(LivestreamServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createChannelSettings = settings.createChannelSettings.toBuilder();
            this.createChannelOperationSettings = settings.createChannelOperationSettings.toBuilder();
            this.listChannelsSettings = settings.listChannelsSettings.toBuilder();
            this.getChannelSettings = settings.getChannelSettings.toBuilder();
            this.deleteChannelSettings = settings.deleteChannelSettings.toBuilder();
            this.deleteChannelOperationSettings = settings.deleteChannelOperationSettings.toBuilder();
            this.updateChannelSettings = settings.updateChannelSettings.toBuilder();
            this.updateChannelOperationSettings = settings.updateChannelOperationSettings.toBuilder();
            this.startChannelSettings = settings.startChannelSettings.toBuilder();
            this.startChannelOperationSettings = settings.startChannelOperationSettings.toBuilder();
            this.stopChannelSettings = settings.stopChannelSettings.toBuilder();
            this.stopChannelOperationSettings = settings.stopChannelOperationSettings.toBuilder();
            this.createInputSettings = settings.createInputSettings.toBuilder();
            this.createInputOperationSettings = settings.createInputOperationSettings.toBuilder();
            this.listInputsSettings = settings.listInputsSettings.toBuilder();
            this.getInputSettings = settings.getInputSettings.toBuilder();
            this.deleteInputSettings = settings.deleteInputSettings.toBuilder();
            this.deleteInputOperationSettings = settings.deleteInputOperationSettings.toBuilder();
            this.updateInputSettings = settings.updateInputSettings.toBuilder();
            this.updateInputOperationSettings = settings.updateInputOperationSettings.toBuilder();
            this.createEventSettings = settings.createEventSettings.toBuilder();
            this.listEventsSettings = settings.listEventsSettings.toBuilder();
            this.getEventSettings = settings.getEventSettings.toBuilder();
            this.deleteEventSettings = settings.deleteEventSettings.toBuilder();
            this.listClipsSettings = settings.listClipsSettings.toBuilder();
            this.getClipSettings = settings.getClipSettings.toBuilder();
            this.createClipSettings = settings.createClipSettings.toBuilder();
            this.createClipOperationSettings = settings.createClipOperationSettings.toBuilder();
            this.deleteClipSettings = settings.deleteClipSettings.toBuilder();
            this.deleteClipOperationSettings = settings.deleteClipOperationSettings.toBuilder();
            this.createAssetSettings = settings.createAssetSettings.toBuilder();
            this.createAssetOperationSettings = settings.createAssetOperationSettings.toBuilder();
            this.deleteAssetSettings = settings.deleteAssetSettings.toBuilder();
            this.deleteAssetOperationSettings = settings.deleteAssetOperationSettings.toBuilder();
            this.getAssetSettings = settings.getAssetSettings.toBuilder();
            this.listAssetsSettings = settings.listAssetsSettings.toBuilder();
            this.getPoolSettings = settings.getPoolSettings.toBuilder();
            this.updatePoolSettings = settings.updatePoolSettings.toBuilder();
            this.updatePoolOperationSettings = settings.updatePoolOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createChannelSettings, this.listChannelsSettings, this.getChannelSettings, this.deleteChannelSettings, this.updateChannelSettings, this.startChannelSettings, this.stopChannelSettings, this.createInputSettings, this.listInputsSettings, this.getInputSettings, this.deleteInputSettings, this.updateInputSettings, (Object[])new UnaryCallSettings.Builder[]{this.createEventSettings, this.listEventsSettings, this.getEventSettings, this.deleteEventSettings, this.listClipsSettings, this.getClipSettings, this.createClipSettings, this.deleteClipSettings, this.createAssetSettings, this.deleteAssetSettings, this.getAssetSettings, this.listAssetsSettings, this.getPoolSettings, this.updatePoolSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(LivestreamServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)LivestreamServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)LivestreamServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(LivestreamServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)LivestreamServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)LivestreamServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)LivestreamServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(LivestreamServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createChannelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listChannelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getChannelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteChannelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateChannelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.startChannelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.stopChannelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createInputSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listInputsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getInputSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteInputSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateInputSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listEventsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listClipsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getClipSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createClipSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteClipSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createAssetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteAssetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getAssetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listAssetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updatePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createChannelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Channel.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteChannelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateChannelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Channel.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.startChannelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ChannelOperationResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.stopChannelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ChannelOperationResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createInputOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Input.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteInputOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateInputOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Input.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createClipOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Clip.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteClipOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createAssetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Asset.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteAssetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updatePoolOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Pool.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateChannelRequest, Operation> createChannelSettings() {
            return this.createChannelSettings;
        }

        public OperationCallSettings.Builder<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationSettings() {
            return this.createChannelOperationSettings;
        }

        public PagedCallSettings.Builder<ListChannelsRequest, ListChannelsResponse, LivestreamServiceClient.ListChannelsPagedResponse> listChannelsSettings() {
            return this.listChannelsSettings;
        }

        public UnaryCallSettings.Builder<GetChannelRequest, Channel> getChannelSettings() {
            return this.getChannelSettings;
        }

        public UnaryCallSettings.Builder<DeleteChannelRequest, Operation> deleteChannelSettings() {
            return this.deleteChannelSettings;
        }

        public OperationCallSettings.Builder<DeleteChannelRequest, Empty, OperationMetadata> deleteChannelOperationSettings() {
            return this.deleteChannelOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateChannelRequest, Operation> updateChannelSettings() {
            return this.updateChannelSettings;
        }

        public OperationCallSettings.Builder<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationSettings() {
            return this.updateChannelOperationSettings;
        }

        public UnaryCallSettings.Builder<StartChannelRequest, Operation> startChannelSettings() {
            return this.startChannelSettings;
        }

        public OperationCallSettings.Builder<StartChannelRequest, ChannelOperationResponse, OperationMetadata> startChannelOperationSettings() {
            return this.startChannelOperationSettings;
        }

        public UnaryCallSettings.Builder<StopChannelRequest, Operation> stopChannelSettings() {
            return this.stopChannelSettings;
        }

        public OperationCallSettings.Builder<StopChannelRequest, ChannelOperationResponse, OperationMetadata> stopChannelOperationSettings() {
            return this.stopChannelOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateInputRequest, Operation> createInputSettings() {
            return this.createInputSettings;
        }

        public OperationCallSettings.Builder<CreateInputRequest, Input, OperationMetadata> createInputOperationSettings() {
            return this.createInputOperationSettings;
        }

        public PagedCallSettings.Builder<ListInputsRequest, ListInputsResponse, LivestreamServiceClient.ListInputsPagedResponse> listInputsSettings() {
            return this.listInputsSettings;
        }

        public UnaryCallSettings.Builder<GetInputRequest, Input> getInputSettings() {
            return this.getInputSettings;
        }

        public UnaryCallSettings.Builder<DeleteInputRequest, Operation> deleteInputSettings() {
            return this.deleteInputSettings;
        }

        public OperationCallSettings.Builder<DeleteInputRequest, Empty, OperationMetadata> deleteInputOperationSettings() {
            return this.deleteInputOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateInputRequest, Operation> updateInputSettings() {
            return this.updateInputSettings;
        }

        public OperationCallSettings.Builder<UpdateInputRequest, Input, OperationMetadata> updateInputOperationSettings() {
            return this.updateInputOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateEventRequest, Event> createEventSettings() {
            return this.createEventSettings;
        }

        public PagedCallSettings.Builder<ListEventsRequest, ListEventsResponse, LivestreamServiceClient.ListEventsPagedResponse> listEventsSettings() {
            return this.listEventsSettings;
        }

        public UnaryCallSettings.Builder<GetEventRequest, Event> getEventSettings() {
            return this.getEventSettings;
        }

        public UnaryCallSettings.Builder<DeleteEventRequest, Empty> deleteEventSettings() {
            return this.deleteEventSettings;
        }

        public PagedCallSettings.Builder<ListClipsRequest, ListClipsResponse, LivestreamServiceClient.ListClipsPagedResponse> listClipsSettings() {
            return this.listClipsSettings;
        }

        public UnaryCallSettings.Builder<GetClipRequest, Clip> getClipSettings() {
            return this.getClipSettings;
        }

        public UnaryCallSettings.Builder<CreateClipRequest, Operation> createClipSettings() {
            return this.createClipSettings;
        }

        public OperationCallSettings.Builder<CreateClipRequest, Clip, OperationMetadata> createClipOperationSettings() {
            return this.createClipOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteClipRequest, Operation> deleteClipSettings() {
            return this.deleteClipSettings;
        }

        public OperationCallSettings.Builder<DeleteClipRequest, Empty, OperationMetadata> deleteClipOperationSettings() {
            return this.deleteClipOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateAssetRequest, Operation> createAssetSettings() {
            return this.createAssetSettings;
        }

        public OperationCallSettings.Builder<CreateAssetRequest, Asset, OperationMetadata> createAssetOperationSettings() {
            return this.createAssetOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteAssetRequest, Operation> deleteAssetSettings() {
            return this.deleteAssetSettings;
        }

        public OperationCallSettings.Builder<DeleteAssetRequest, Empty, OperationMetadata> deleteAssetOperationSettings() {
            return this.deleteAssetOperationSettings;
        }

        public UnaryCallSettings.Builder<GetAssetRequest, Asset> getAssetSettings() {
            return this.getAssetSettings;
        }

        public PagedCallSettings.Builder<ListAssetsRequest, ListAssetsResponse, LivestreamServiceClient.ListAssetsPagedResponse> listAssetsSettings() {
            return this.listAssetsSettings;
        }

        public UnaryCallSettings.Builder<GetPoolRequest, Pool> getPoolSettings() {
            return this.getPoolSettings;
        }

        public UnaryCallSettings.Builder<UpdatePoolRequest, Operation> updatePoolSettings() {
            return this.updatePoolSettings;
        }

        public OperationCallSettings.Builder<UpdatePoolRequest, Pool, OperationMetadata> updatePoolOperationSettings() {
            return this.updatePoolOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, LivestreamServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public LivestreamServiceStubSettings build() throws IOException {
            return new LivestreamServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

