/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.language.v1beta2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.language.v1beta2.AnalyzeEntitiesRequest;
import com.google.cloud.language.v1beta2.AnalyzeEntitiesResponse;
import com.google.cloud.language.v1beta2.AnalyzeEntitySentimentRequest;
import com.google.cloud.language.v1beta2.AnalyzeEntitySentimentResponse;
import com.google.cloud.language.v1beta2.AnalyzeSentimentRequest;
import com.google.cloud.language.v1beta2.AnalyzeSentimentResponse;
import com.google.cloud.language.v1beta2.AnalyzeSyntaxRequest;
import com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse;
import com.google.cloud.language.v1beta2.AnnotateTextRequest;
import com.google.cloud.language.v1beta2.AnnotateTextResponse;
import com.google.cloud.language.v1beta2.ClassifyTextRequest;
import com.google.cloud.language.v1beta2.ClassifyTextResponse;
import com.google.cloud.language.v1beta2.stub.GrpcLanguageServiceStub;
import com.google.cloud.language.v1beta2.stub.LanguageServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class LanguageServiceStubSettings
extends StubSettings<LanguageServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentSettings;
    private final UnaryCallSettings<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesSettings;
    private final UnaryCallSettings<AnalyzeEntitySentimentRequest, AnalyzeEntitySentimentResponse> analyzeEntitySentimentSettings;
    private final UnaryCallSettings<AnalyzeSyntaxRequest, AnalyzeSyntaxResponse> analyzeSyntaxSettings;
    private final UnaryCallSettings<ClassifyTextRequest, ClassifyTextResponse> classifyTextSettings;
    private final UnaryCallSettings<AnnotateTextRequest, AnnotateTextResponse> annotateTextSettings;

    public UnaryCallSettings<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentSettings() {
        return this.analyzeSentimentSettings;
    }

    public UnaryCallSettings<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesSettings() {
        return this.analyzeEntitiesSettings;
    }

    public UnaryCallSettings<AnalyzeEntitySentimentRequest, AnalyzeEntitySentimentResponse> analyzeEntitySentimentSettings() {
        return this.analyzeEntitySentimentSettings;
    }

    public UnaryCallSettings<AnalyzeSyntaxRequest, AnalyzeSyntaxResponse> analyzeSyntaxSettings() {
        return this.analyzeSyntaxSettings;
    }

    public UnaryCallSettings<ClassifyTextRequest, ClassifyTextResponse> classifyTextSettings() {
        return this.classifyTextSettings;
    }

    public UnaryCallSettings<AnnotateTextRequest, AnnotateTextResponse> annotateTextSettings() {
        return this.annotateTextSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public LanguageServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcLanguageServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "language.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return LanguageServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(LanguageServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected LanguageServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.analyzeSentimentSettings = settingsBuilder.analyzeSentimentSettings().build();
        this.analyzeEntitiesSettings = settingsBuilder.analyzeEntitiesSettings().build();
        this.analyzeEntitySentimentSettings = settingsBuilder.analyzeEntitySentimentSettings().build();
        this.analyzeSyntaxSettings = settingsBuilder.analyzeSyntaxSettings().build();
        this.classifyTextSettings = settingsBuilder.classifyTextSettings().build();
        this.annotateTextSettings = settingsBuilder.annotateTextSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<LanguageServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentSettings;
        private final UnaryCallSettings.Builder<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesSettings;
        private final UnaryCallSettings.Builder<AnalyzeEntitySentimentRequest, AnalyzeEntitySentimentResponse> analyzeEntitySentimentSettings;
        private final UnaryCallSettings.Builder<AnalyzeSyntaxRequest, AnalyzeSyntaxResponse> analyzeSyntaxSettings;
        private final UnaryCallSettings.Builder<ClassifyTextRequest, ClassifyTextResponse> classifyTextSettings;
        private final UnaryCallSettings.Builder<AnnotateTextRequest, AnnotateTextResponse> annotateTextSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.analyzeSentimentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.analyzeEntitiesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.analyzeEntitySentimentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.analyzeSyntaxSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.classifyTextSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.annotateTextSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.analyzeSentimentSettings, this.analyzeEntitiesSettings, this.analyzeEntitySentimentSettings, this.analyzeSyntaxSettings, this.classifyTextSettings, this.annotateTextSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(LanguageServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)LanguageServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)LanguageServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(LanguageServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.analyzeSentimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.analyzeEntitiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.analyzeEntitySentimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.analyzeSyntaxSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.classifyTextSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.annotateTextSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(LanguageServiceStubSettings settings) {
            super((StubSettings)settings);
            this.analyzeSentimentSettings = settings.analyzeSentimentSettings.toBuilder();
            this.analyzeEntitiesSettings = settings.analyzeEntitiesSettings.toBuilder();
            this.analyzeEntitySentimentSettings = settings.analyzeEntitySentimentSettings.toBuilder();
            this.analyzeSyntaxSettings = settings.analyzeSyntaxSettings.toBuilder();
            this.classifyTextSettings = settings.classifyTextSettings.toBuilder();
            this.annotateTextSettings = settings.annotateTextSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.analyzeSentimentSettings, this.analyzeEntitiesSettings, this.analyzeEntitySentimentSettings, this.analyzeSyntaxSettings, this.classifyTextSettings, this.annotateTextSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentSettings() {
            return this.analyzeSentimentSettings;
        }

        public UnaryCallSettings.Builder<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesSettings() {
            return this.analyzeEntitiesSettings;
        }

        public UnaryCallSettings.Builder<AnalyzeEntitySentimentRequest, AnalyzeEntitySentimentResponse> analyzeEntitySentimentSettings() {
            return this.analyzeEntitySentimentSettings;
        }

        public UnaryCallSettings.Builder<AnalyzeSyntaxRequest, AnalyzeSyntaxResponse> analyzeSyntaxSettings() {
            return this.analyzeSyntaxSettings;
        }

        public UnaryCallSettings.Builder<ClassifyTextRequest, ClassifyTextResponse> classifyTextSettings() {
            return this.classifyTextSettings;
        }

        public UnaryCallSettings.Builder<AnnotateTextRequest, AnnotateTextResponse> annotateTextSettings() {
            return this.annotateTextSettings;
        }

        public LanguageServiceStubSettings build() throws IOException {
            return new LanguageServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

