/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.language.spi.v1beta1;

import com.google.api.gax.grpc.ApiCallable;
import com.google.cloud.language.spi.v1beta1.LanguageServiceSettings;
import com.google.cloud.language.v1beta1.AnalyzeEntitiesRequest;
import com.google.cloud.language.v1beta1.AnalyzeEntitiesResponse;
import com.google.cloud.language.v1beta1.AnalyzeSentimentRequest;
import com.google.cloud.language.v1beta1.AnalyzeSentimentResponse;
import com.google.cloud.language.v1beta1.AnnotateTextRequest;
import com.google.cloud.language.v1beta1.AnnotateTextResponse;
import com.google.cloud.language.v1beta1.Document;
import com.google.cloud.language.v1beta1.EncodingType;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public class LanguageServiceApi
implements AutoCloseable {
    private final LanguageServiceSettings settings;
    private final ManagedChannel channel;
    private final ScheduledExecutorService executor;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final ApiCallable<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentCallable;
    private final ApiCallable<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesCallable;
    private final ApiCallable<AnnotateTextRequest, AnnotateTextResponse> annotateTextCallable;

    public final LanguageServiceSettings getSettings() {
        return this.settings;
    }

    public static final LanguageServiceApi create() throws IOException {
        return LanguageServiceApi.create(LanguageServiceSettings.defaultBuilder().build());
    }

    public static final LanguageServiceApi create(LanguageServiceSettings settings) throws IOException {
        return new LanguageServiceApi(settings);
    }

    protected LanguageServiceApi(LanguageServiceSettings settings) throws IOException {
        this.settings = settings;
        this.executor = settings.getExecutorProvider().getOrBuildExecutor();
        this.channel = settings.getChannelProvider().getOrBuildChannel((Executor)this.executor);
        this.analyzeSentimentCallable = ApiCallable.create(settings.analyzeSentimentSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.analyzeEntitiesCallable = ApiCallable.create(settings.analyzeEntitiesSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.annotateTextCallable = ApiCallable.create(settings.annotateTextSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    LanguageServiceApi.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    LanguageServiceApi.this.executor.shutdown();
                }
            });
        }
    }

    public final AnalyzeSentimentResponse analyzeSentiment(Document document) {
        AnalyzeSentimentRequest request = AnalyzeSentimentRequest.newBuilder().setDocument(document).build();
        return this.analyzeSentiment(request);
    }

    private final AnalyzeSentimentResponse analyzeSentiment(AnalyzeSentimentRequest request) {
        return (AnalyzeSentimentResponse)this.analyzeSentimentCallable().call((Object)request);
    }

    public final ApiCallable<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentCallable() {
        return this.analyzeSentimentCallable;
    }

    public final AnalyzeEntitiesResponse analyzeEntities(Document document, EncodingType encodingType) {
        AnalyzeEntitiesRequest request = AnalyzeEntitiesRequest.newBuilder().setDocument(document).setEncodingType(encodingType).build();
        return this.analyzeEntities(request);
    }

    public final AnalyzeEntitiesResponse analyzeEntities(AnalyzeEntitiesRequest request) {
        return (AnalyzeEntitiesResponse)this.analyzeEntitiesCallable().call((Object)request);
    }

    public final ApiCallable<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesCallable() {
        return this.analyzeEntitiesCallable;
    }

    public final AnnotateTextResponse annotateText(Document document, AnnotateTextRequest.Features features, EncodingType encodingType) {
        AnnotateTextRequest request = AnnotateTextRequest.newBuilder().setDocument(document).setFeatures(features).setEncodingType(encodingType).build();
        return this.annotateText(request);
    }

    public final AnnotateTextResponse annotateText(AnnotateTextRequest request) {
        return (AnnotateTextResponse)this.annotateTextCallable().call((Object)request);
    }

    public final ApiCallable<AnnotateTextRequest, AnnotateTextResponse> annotateTextCallable() {
        return this.annotateTextCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

