/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.language.spi.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ClientSettings;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.cloud.language.v1.AnalyzeEntitiesRequest;
import com.google.cloud.language.v1.AnalyzeEntitiesResponse;
import com.google.cloud.language.v1.AnalyzeSentimentRequest;
import com.google.cloud.language.v1.AnalyzeSentimentResponse;
import com.google.cloud.language.v1.AnalyzeSyntaxRequest;
import com.google.cloud.language.v1.AnalyzeSyntaxResponse;
import com.google.cloud.language.v1.AnnotateTextRequest;
import com.google.cloud.language.v1.AnnotateTextResponse;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.joda.time.Duration;

public class LanguageServiceSettings
extends ClientSettings {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/com/google/cloud/language/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private static final MethodDescriptor<AnalyzeSentimentRequest, AnalyzeSentimentResponse> METHOD_ANALYZE_SENTIMENT;
    private static final MethodDescriptor<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> METHOD_ANALYZE_ENTITIES;
    private static final MethodDescriptor<AnalyzeSyntaxRequest, AnalyzeSyntaxResponse> METHOD_ANALYZE_SYNTAX;
    private static final MethodDescriptor<AnnotateTextRequest, AnnotateTextResponse> METHOD_ANNOTATE_TEXT;
    private final SimpleCallSettings<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentSettings;
    private final SimpleCallSettings<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesSettings;
    private final SimpleCallSettings<AnalyzeSyntaxRequest, AnalyzeSyntaxResponse> analyzeSyntaxSettings;
    private final SimpleCallSettings<AnnotateTextRequest, AnnotateTextResponse> annotateTextSettings;

    public SimpleCallSettings<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentSettings() {
        return this.analyzeSentimentSettings;
    }

    public SimpleCallSettings<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesSettings() {
        return this.analyzeEntitiesSettings;
    }

    public SimpleCallSettings<AnalyzeSyntaxRequest, AnalyzeSyntaxResponse> analyzeSyntaxSettings() {
        return this.analyzeSyntaxSettings;
    }

    public SimpleCallSettings<AnnotateTextRequest, AnnotateTextResponse> annotateTextSettings() {
        return this.annotateTextSettings;
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "language.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setEndpoint(LanguageServiceSettings.getDefaultEndpoint()).setGeneratorHeader(DEFAULT_GAPIC_NAME, LanguageServiceSettings.getGapicVersion()).setCredentialsProvider((CredentialsProvider)LanguageServiceSettings.defaultCredentialsProviderBuilder().build());
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(LanguageServiceSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private LanguageServiceSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getChannelProvider());
        this.analyzeSentimentSettings = settingsBuilder.analyzeSentimentSettings().build();
        this.analyzeEntitiesSettings = settingsBuilder.analyzeEntitiesSettings().build();
        this.analyzeSyntaxSettings = settingsBuilder.analyzeSyntaxSettings().build();
        this.annotateTextSettings = settingsBuilder.annotateTextSettings().build();
    }

    static {
        METHOD_ANALYZE_SENTIMENT = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.cloud.language.v1.LanguageService/AnalyzeSentiment", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)AnalyzeSentimentRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)AnalyzeSentimentResponse.getDefaultInstance()));
        METHOD_ANALYZE_ENTITIES = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.cloud.language.v1.LanguageService/AnalyzeEntities", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)AnalyzeEntitiesRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)AnalyzeEntitiesResponse.getDefaultInstance()));
        METHOD_ANALYZE_SYNTAX = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.cloud.language.v1.LanguageService/AnalyzeSyntax", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)AnalyzeSyntaxRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)AnalyzeSyntaxResponse.getDefaultInstance()));
        METHOD_ANNOTATE_TEXT = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.cloud.language.v1.LanguageService/AnnotateText", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)AnnotateTextRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)AnnotateTextResponse.getDefaultInstance()));
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final SimpleCallSettings.Builder<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentSettings;
        private final SimpleCallSettings.Builder<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesSettings;
        private final SimpleCallSettings.Builder<AnalyzeSyntaxRequest, AnalyzeSyntaxResponse> analyzeSyntaxSettings;
        private final SimpleCallSettings.Builder<AnnotateTextRequest, AnnotateTextResponse> annotateTextSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(LanguageServiceSettings.defaultChannelProviderBuilder().build());
            this.analyzeSentimentSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_ANALYZE_SENTIMENT);
            this.analyzeEntitiesSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_ANALYZE_ENTITIES);
            this.analyzeSyntaxSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_ANALYZE_SYNTAX);
            this.annotateTextSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_ANNOTATE_TEXT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.analyzeSentimentSettings, this.analyzeEntitiesSettings, this.analyzeSyntaxSettings, this.annotateTextSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.analyzeSentimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.analyzeEntitiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.analyzeSyntaxSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.annotateTextSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(LanguageServiceSettings settings) {
            super((ClientSettings)settings);
            this.analyzeSentimentSettings = settings.analyzeSentimentSettings.toBuilder();
            this.analyzeEntitiesSettings = settings.analyzeEntitiesSettings.toBuilder();
            this.analyzeSyntaxSettings = settings.analyzeSyntaxSettings.toBuilder();
            this.annotateTextSettings = settings.annotateTextSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.analyzeSentimentSettings, this.analyzeEntitiesSettings, this.analyzeSyntaxSettings, this.annotateTextSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setChannelProvider(ChannelProvider channelProvider) {
            super.setChannelProvider(channelProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(UnaryCallSettings.Builder unaryCallSettings) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, unaryCallSettings);
            return this;
        }

        public SimpleCallSettings.Builder<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentSettings() {
            return this.analyzeSentimentSettings;
        }

        public SimpleCallSettings.Builder<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesSettings() {
            return this.analyzeEntitiesSettings;
        }

        public SimpleCallSettings.Builder<AnalyzeSyntaxRequest, AnalyzeSyntaxResponse> analyzeSyntaxSettings() {
            return this.analyzeSyntaxSettings;
        }

        public SimpleCallSettings.Builder<AnnotateTextRequest, AnnotateTextResponse> annotateTextSettings() {
            return this.annotateTextSettings;
        }

        public LanguageServiceSettings build() throws IOException {
            return new LanguageServiceSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.millis((long)60000L)).setInitialRpcTimeout(Duration.millis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.millis((long)60000L)).setTotalTimeout(Duration.millis((long)600000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

