/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.inventory.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.kms.inventory.v1.GetProtectedResourcesSummaryRequest;
import com.google.cloud.kms.inventory.v1.KeyTrackingServiceClient;
import com.google.cloud.kms.inventory.v1.ProtectedResourcesSummary;
import com.google.cloud.kms.inventory.v1.SearchProtectedResourcesRequest;
import com.google.cloud.kms.inventory.v1.SearchProtectedResourcesResponse;
import com.google.cloud.kms.inventory.v1.stub.GrpcKeyTrackingServiceCallableFactory;
import com.google.cloud.kms.inventory.v1.stub.KeyTrackingServiceStub;
import com.google.cloud.kms.inventory.v1.stub.KeyTrackingServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcKeyTrackingServiceStub
extends KeyTrackingServiceStub {
    private static final MethodDescriptor<GetProtectedResourcesSummaryRequest, ProtectedResourcesSummary> getProtectedResourcesSummaryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.kms.inventory.v1.KeyTrackingService/GetProtectedResourcesSummary").setRequestMarshaller(ProtoUtils.marshaller((Message)GetProtectedResourcesSummaryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ProtectedResourcesSummary.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse> searchProtectedResourcesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.kms.inventory.v1.KeyTrackingService/SearchProtectedResources").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchProtectedResourcesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchProtectedResourcesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<GetProtectedResourcesSummaryRequest, ProtectedResourcesSummary> getProtectedResourcesSummaryCallable;
    private final UnaryCallable<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse> searchProtectedResourcesCallable;
    private final UnaryCallable<SearchProtectedResourcesRequest, KeyTrackingServiceClient.SearchProtectedResourcesPagedResponse> searchProtectedResourcesPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcKeyTrackingServiceStub create(KeyTrackingServiceStubSettings settings) throws IOException {
        return new GrpcKeyTrackingServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcKeyTrackingServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcKeyTrackingServiceStub(KeyTrackingServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcKeyTrackingServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcKeyTrackingServiceStub(KeyTrackingServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcKeyTrackingServiceStub(KeyTrackingServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcKeyTrackingServiceCallableFactory());
    }

    protected GrpcKeyTrackingServiceStub(KeyTrackingServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getProtectedResourcesSummaryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getProtectedResourcesSummaryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings searchProtectedResourcesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchProtectedResourcesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("scope", String.valueOf(request.getScope()));
            return builder.build();
        }).build();
        this.getProtectedResourcesSummaryCallable = callableFactory.createUnaryCallable(getProtectedResourcesSummaryTransportSettings, settings.getProtectedResourcesSummarySettings(), clientContext);
        this.searchProtectedResourcesCallable = callableFactory.createUnaryCallable(searchProtectedResourcesTransportSettings, settings.searchProtectedResourcesSettings(), clientContext);
        this.searchProtectedResourcesPagedCallable = callableFactory.createPagedCallable(searchProtectedResourcesTransportSettings, settings.searchProtectedResourcesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetProtectedResourcesSummaryRequest, ProtectedResourcesSummary> getProtectedResourcesSummaryCallable() {
        return this.getProtectedResourcesSummaryCallable;
    }

    @Override
    public UnaryCallable<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse> searchProtectedResourcesCallable() {
        return this.searchProtectedResourcesCallable;
    }

    @Override
    public UnaryCallable<SearchProtectedResourcesRequest, KeyTrackingServiceClient.SearchProtectedResourcesPagedResponse> searchProtectedResourcesPagedCallable() {
        return this.searchProtectedResourcesPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

