/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.kms.v1.AsymmetricDecryptRequest;
import com.google.cloud.kms.v1.AsymmetricDecryptResponse;
import com.google.cloud.kms.v1.AsymmetricSignRequest;
import com.google.cloud.kms.v1.AsymmetricSignResponse;
import com.google.cloud.kms.v1.CreateCryptoKeyRequest;
import com.google.cloud.kms.v1.CreateCryptoKeyVersionRequest;
import com.google.cloud.kms.v1.CreateKeyRingRequest;
import com.google.cloud.kms.v1.CryptoKey;
import com.google.cloud.kms.v1.CryptoKeyName;
import com.google.cloud.kms.v1.CryptoKeyPathName;
import com.google.cloud.kms.v1.CryptoKeyVersion;
import com.google.cloud.kms.v1.CryptoKeyVersionName;
import com.google.cloud.kms.v1.DecryptRequest;
import com.google.cloud.kms.v1.DecryptResponse;
import com.google.cloud.kms.v1.DestroyCryptoKeyVersionRequest;
import com.google.cloud.kms.v1.Digest;
import com.google.cloud.kms.v1.EncryptRequest;
import com.google.cloud.kms.v1.EncryptResponse;
import com.google.cloud.kms.v1.GetCryptoKeyRequest;
import com.google.cloud.kms.v1.GetCryptoKeyVersionRequest;
import com.google.cloud.kms.v1.GetKeyRingRequest;
import com.google.cloud.kms.v1.GetPublicKeyRequest;
import com.google.cloud.kms.v1.KeyManagementServiceSettings;
import com.google.cloud.kms.v1.KeyName;
import com.google.cloud.kms.v1.KeyRing;
import com.google.cloud.kms.v1.KeyRingName;
import com.google.cloud.kms.v1.ListCryptoKeyVersionsRequest;
import com.google.cloud.kms.v1.ListCryptoKeyVersionsResponse;
import com.google.cloud.kms.v1.ListCryptoKeysRequest;
import com.google.cloud.kms.v1.ListCryptoKeysResponse;
import com.google.cloud.kms.v1.ListKeyRingsRequest;
import com.google.cloud.kms.v1.ListKeyRingsResponse;
import com.google.cloud.kms.v1.LocationName;
import com.google.cloud.kms.v1.PublicKey;
import com.google.cloud.kms.v1.RestoreCryptoKeyVersionRequest;
import com.google.cloud.kms.v1.UpdateCryptoKeyPrimaryVersionRequest;
import com.google.cloud.kms.v1.UpdateCryptoKeyRequest;
import com.google.cloud.kms.v1.UpdateCryptoKeyVersionRequest;
import com.google.cloud.kms.v1.stub.KeyManagementServiceStub;
import com.google.cloud.kms.v1.stub.KeyManagementServiceStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.ByteString;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class KeyManagementServiceClient
implements BackgroundResource {
    private final KeyManagementServiceSettings settings;
    private final KeyManagementServiceStub stub;

    public static final KeyManagementServiceClient create() throws IOException {
        return KeyManagementServiceClient.create(KeyManagementServiceSettings.newBuilder().build());
    }

    public static final KeyManagementServiceClient create(KeyManagementServiceSettings settings) throws IOException {
        return new KeyManagementServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final KeyManagementServiceClient create(KeyManagementServiceStub stub) {
        return new KeyManagementServiceClient(stub);
    }

    protected KeyManagementServiceClient(KeyManagementServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((KeyManagementServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected KeyManagementServiceClient(KeyManagementServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final KeyManagementServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public KeyManagementServiceStub getStub() {
        return this.stub;
    }

    public final ListKeyRingsPagedResponse listKeyRings(LocationName parent) {
        ListKeyRingsRequest request = ListKeyRingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listKeyRings(request);
    }

    public final ListKeyRingsPagedResponse listKeyRings(String parent) {
        ListKeyRingsRequest request = ListKeyRingsRequest.newBuilder().setParent(parent).build();
        return this.listKeyRings(request);
    }

    public final ListKeyRingsPagedResponse listKeyRings(ListKeyRingsRequest request) {
        return (ListKeyRingsPagedResponse)((Object)this.listKeyRingsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListKeyRingsRequest, ListKeyRingsPagedResponse> listKeyRingsPagedCallable() {
        return this.stub.listKeyRingsPagedCallable();
    }

    public final UnaryCallable<ListKeyRingsRequest, ListKeyRingsResponse> listKeyRingsCallable() {
        return this.stub.listKeyRingsCallable();
    }

    public final ListCryptoKeysPagedResponse listCryptoKeys(KeyRingName parent) {
        ListCryptoKeysRequest request = ListCryptoKeysRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCryptoKeys(request);
    }

    public final ListCryptoKeysPagedResponse listCryptoKeys(String parent) {
        ListCryptoKeysRequest request = ListCryptoKeysRequest.newBuilder().setParent(parent).build();
        return this.listCryptoKeys(request);
    }

    public final ListCryptoKeysPagedResponse listCryptoKeys(ListCryptoKeysRequest request) {
        return (ListCryptoKeysPagedResponse)((Object)this.listCryptoKeysPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCryptoKeysRequest, ListCryptoKeysPagedResponse> listCryptoKeysPagedCallable() {
        return this.stub.listCryptoKeysPagedCallable();
    }

    public final UnaryCallable<ListCryptoKeysRequest, ListCryptoKeysResponse> listCryptoKeysCallable() {
        return this.stub.listCryptoKeysCallable();
    }

    public final ListCryptoKeyVersionsPagedResponse listCryptoKeyVersions(CryptoKeyName parent) {
        ListCryptoKeyVersionsRequest request = ListCryptoKeyVersionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCryptoKeyVersions(request);
    }

    public final ListCryptoKeyVersionsPagedResponse listCryptoKeyVersions(String parent) {
        ListCryptoKeyVersionsRequest request = ListCryptoKeyVersionsRequest.newBuilder().setParent(parent).build();
        return this.listCryptoKeyVersions(request);
    }

    public final ListCryptoKeyVersionsPagedResponse listCryptoKeyVersions(ListCryptoKeyVersionsRequest request) {
        return (ListCryptoKeyVersionsPagedResponse)((Object)this.listCryptoKeyVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsPagedResponse> listCryptoKeyVersionsPagedCallable() {
        return this.stub.listCryptoKeyVersionsPagedCallable();
    }

    public final UnaryCallable<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsResponse> listCryptoKeyVersionsCallable() {
        return this.stub.listCryptoKeyVersionsCallable();
    }

    public final KeyRing getKeyRing(KeyRingName name) {
        GetKeyRingRequest request = GetKeyRingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getKeyRing(request);
    }

    public final KeyRing getKeyRing(String name) {
        GetKeyRingRequest request = GetKeyRingRequest.newBuilder().setName(name).build();
        return this.getKeyRing(request);
    }

    public final KeyRing getKeyRing(GetKeyRingRequest request) {
        return (KeyRing)this.getKeyRingCallable().call((Object)request);
    }

    public final UnaryCallable<GetKeyRingRequest, KeyRing> getKeyRingCallable() {
        return this.stub.getKeyRingCallable();
    }

    public final CryptoKey getCryptoKey(CryptoKeyName name) {
        GetCryptoKeyRequest request = GetCryptoKeyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCryptoKey(request);
    }

    public final CryptoKey getCryptoKey(String name) {
        GetCryptoKeyRequest request = GetCryptoKeyRequest.newBuilder().setName(name).build();
        return this.getCryptoKey(request);
    }

    public final CryptoKey getCryptoKey(GetCryptoKeyRequest request) {
        return (CryptoKey)this.getCryptoKeyCallable().call((Object)request);
    }

    public final UnaryCallable<GetCryptoKeyRequest, CryptoKey> getCryptoKeyCallable() {
        return this.stub.getCryptoKeyCallable();
    }

    public final CryptoKeyVersion getCryptoKeyVersion(CryptoKeyVersionName name) {
        GetCryptoKeyVersionRequest request = GetCryptoKeyVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCryptoKeyVersion(request);
    }

    public final CryptoKeyVersion getCryptoKeyVersion(String name) {
        GetCryptoKeyVersionRequest request = GetCryptoKeyVersionRequest.newBuilder().setName(name).build();
        return this.getCryptoKeyVersion(request);
    }

    public final CryptoKeyVersion getCryptoKeyVersion(GetCryptoKeyVersionRequest request) {
        return (CryptoKeyVersion)this.getCryptoKeyVersionCallable().call((Object)request);
    }

    public final UnaryCallable<GetCryptoKeyVersionRequest, CryptoKeyVersion> getCryptoKeyVersionCallable() {
        return this.stub.getCryptoKeyVersionCallable();
    }

    public final KeyRing createKeyRing(LocationName parent, String keyRingId, KeyRing keyRing) {
        CreateKeyRingRequest request = CreateKeyRingRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setKeyRingId(keyRingId).setKeyRing(keyRing).build();
        return this.createKeyRing(request);
    }

    public final KeyRing createKeyRing(String parent, String keyRingId, KeyRing keyRing) {
        CreateKeyRingRequest request = CreateKeyRingRequest.newBuilder().setParent(parent).setKeyRingId(keyRingId).setKeyRing(keyRing).build();
        return this.createKeyRing(request);
    }

    public final KeyRing createKeyRing(CreateKeyRingRequest request) {
        return (KeyRing)this.createKeyRingCallable().call((Object)request);
    }

    public final UnaryCallable<CreateKeyRingRequest, KeyRing> createKeyRingCallable() {
        return this.stub.createKeyRingCallable();
    }

    public final CryptoKey createCryptoKey(KeyRingName parent, String cryptoKeyId, CryptoKey cryptoKey) {
        CreateCryptoKeyRequest request = CreateCryptoKeyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCryptoKeyId(cryptoKeyId).setCryptoKey(cryptoKey).build();
        return this.createCryptoKey(request);
    }

    public final CryptoKey createCryptoKey(String parent, String cryptoKeyId, CryptoKey cryptoKey) {
        CreateCryptoKeyRequest request = CreateCryptoKeyRequest.newBuilder().setParent(parent).setCryptoKeyId(cryptoKeyId).setCryptoKey(cryptoKey).build();
        return this.createCryptoKey(request);
    }

    public final CryptoKey createCryptoKey(CreateCryptoKeyRequest request) {
        return (CryptoKey)this.createCryptoKeyCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCryptoKeyRequest, CryptoKey> createCryptoKeyCallable() {
        return this.stub.createCryptoKeyCallable();
    }

    public final CryptoKeyVersion createCryptoKeyVersion(CryptoKeyName parent, CryptoKeyVersion cryptoKeyVersion) {
        CreateCryptoKeyVersionRequest request = CreateCryptoKeyVersionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCryptoKeyVersion(cryptoKeyVersion).build();
        return this.createCryptoKeyVersion(request);
    }

    public final CryptoKeyVersion createCryptoKeyVersion(String parent, CryptoKeyVersion cryptoKeyVersion) {
        CreateCryptoKeyVersionRequest request = CreateCryptoKeyVersionRequest.newBuilder().setParent(parent).setCryptoKeyVersion(cryptoKeyVersion).build();
        return this.createCryptoKeyVersion(request);
    }

    public final CryptoKeyVersion createCryptoKeyVersion(CreateCryptoKeyVersionRequest request) {
        return (CryptoKeyVersion)this.createCryptoKeyVersionCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCryptoKeyVersionRequest, CryptoKeyVersion> createCryptoKeyVersionCallable() {
        return this.stub.createCryptoKeyVersionCallable();
    }

    public final CryptoKey updateCryptoKey(CryptoKey cryptoKey, FieldMask updateMask) {
        UpdateCryptoKeyRequest request = UpdateCryptoKeyRequest.newBuilder().setCryptoKey(cryptoKey).setUpdateMask(updateMask).build();
        return this.updateCryptoKey(request);
    }

    public final CryptoKey updateCryptoKey(UpdateCryptoKeyRequest request) {
        return (CryptoKey)this.updateCryptoKeyCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateCryptoKeyRequest, CryptoKey> updateCryptoKeyCallable() {
        return this.stub.updateCryptoKeyCallable();
    }

    public final CryptoKeyVersion updateCryptoKeyVersion(CryptoKeyVersion cryptoKeyVersion, FieldMask updateMask) {
        UpdateCryptoKeyVersionRequest request = UpdateCryptoKeyVersionRequest.newBuilder().setCryptoKeyVersion(cryptoKeyVersion).setUpdateMask(updateMask).build();
        return this.updateCryptoKeyVersion(request);
    }

    public final CryptoKeyVersion updateCryptoKeyVersion(UpdateCryptoKeyVersionRequest request) {
        return (CryptoKeyVersion)this.updateCryptoKeyVersionCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateCryptoKeyVersionRequest, CryptoKeyVersion> updateCryptoKeyVersionCallable() {
        return this.stub.updateCryptoKeyVersionCallable();
    }

    public final EncryptResponse encrypt(CryptoKeyPathName name, ByteString plaintext) {
        EncryptRequest request = EncryptRequest.newBuilder().setName(name == null ? null : name.toString()).setPlaintext(plaintext).build();
        return this.encrypt(request);
    }

    public final EncryptResponse encrypt(String name, ByteString plaintext) {
        EncryptRequest request = EncryptRequest.newBuilder().setName(name).setPlaintext(plaintext).build();
        return this.encrypt(request);
    }

    public final EncryptResponse encrypt(EncryptRequest request) {
        return (EncryptResponse)this.encryptCallable().call((Object)request);
    }

    public final UnaryCallable<EncryptRequest, EncryptResponse> encryptCallable() {
        return this.stub.encryptCallable();
    }

    public final DecryptResponse decrypt(CryptoKeyName name, ByteString ciphertext) {
        DecryptRequest request = DecryptRequest.newBuilder().setName(name == null ? null : name.toString()).setCiphertext(ciphertext).build();
        return this.decrypt(request);
    }

    public final DecryptResponse decrypt(String name, ByteString ciphertext) {
        DecryptRequest request = DecryptRequest.newBuilder().setName(name).setCiphertext(ciphertext).build();
        return this.decrypt(request);
    }

    public final DecryptResponse decrypt(DecryptRequest request) {
        return (DecryptResponse)this.decryptCallable().call((Object)request);
    }

    public final UnaryCallable<DecryptRequest, DecryptResponse> decryptCallable() {
        return this.stub.decryptCallable();
    }

    public final CryptoKey updateCryptoKeyPrimaryVersion(CryptoKeyName name, String cryptoKeyVersionId) {
        UpdateCryptoKeyPrimaryVersionRequest request = UpdateCryptoKeyPrimaryVersionRequest.newBuilder().setName(name == null ? null : name.toString()).setCryptoKeyVersionId(cryptoKeyVersionId).build();
        return this.updateCryptoKeyPrimaryVersion(request);
    }

    public final CryptoKey updateCryptoKeyPrimaryVersion(String name, String cryptoKeyVersionId) {
        UpdateCryptoKeyPrimaryVersionRequest request = UpdateCryptoKeyPrimaryVersionRequest.newBuilder().setName(name).setCryptoKeyVersionId(cryptoKeyVersionId).build();
        return this.updateCryptoKeyPrimaryVersion(request);
    }

    public final CryptoKey updateCryptoKeyPrimaryVersion(UpdateCryptoKeyPrimaryVersionRequest request) {
        return (CryptoKey)this.updateCryptoKeyPrimaryVersionCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateCryptoKeyPrimaryVersionRequest, CryptoKey> updateCryptoKeyPrimaryVersionCallable() {
        return this.stub.updateCryptoKeyPrimaryVersionCallable();
    }

    public final CryptoKeyVersion destroyCryptoKeyVersion(CryptoKeyVersionName name) {
        DestroyCryptoKeyVersionRequest request = DestroyCryptoKeyVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.destroyCryptoKeyVersion(request);
    }

    public final CryptoKeyVersion destroyCryptoKeyVersion(String name) {
        DestroyCryptoKeyVersionRequest request = DestroyCryptoKeyVersionRequest.newBuilder().setName(name).build();
        return this.destroyCryptoKeyVersion(request);
    }

    public final CryptoKeyVersion destroyCryptoKeyVersion(DestroyCryptoKeyVersionRequest request) {
        return (CryptoKeyVersion)this.destroyCryptoKeyVersionCallable().call((Object)request);
    }

    public final UnaryCallable<DestroyCryptoKeyVersionRequest, CryptoKeyVersion> destroyCryptoKeyVersionCallable() {
        return this.stub.destroyCryptoKeyVersionCallable();
    }

    public final CryptoKeyVersion restoreCryptoKeyVersion(CryptoKeyVersionName name) {
        RestoreCryptoKeyVersionRequest request = RestoreCryptoKeyVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.restoreCryptoKeyVersion(request);
    }

    public final CryptoKeyVersion restoreCryptoKeyVersion(String name) {
        RestoreCryptoKeyVersionRequest request = RestoreCryptoKeyVersionRequest.newBuilder().setName(name).build();
        return this.restoreCryptoKeyVersion(request);
    }

    public final CryptoKeyVersion restoreCryptoKeyVersion(RestoreCryptoKeyVersionRequest request) {
        return (CryptoKeyVersion)this.restoreCryptoKeyVersionCallable().call((Object)request);
    }

    public final UnaryCallable<RestoreCryptoKeyVersionRequest, CryptoKeyVersion> restoreCryptoKeyVersionCallable() {
        return this.stub.restoreCryptoKeyVersionCallable();
    }

    public final PublicKey getPublicKey(CryptoKeyVersionName name) {
        GetPublicKeyRequest request = GetPublicKeyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPublicKey(request);
    }

    public final PublicKey getPublicKey(String name) {
        GetPublicKeyRequest request = GetPublicKeyRequest.newBuilder().setName(name).build();
        return this.getPublicKey(request);
    }

    public final PublicKey getPublicKey(GetPublicKeyRequest request) {
        return (PublicKey)this.getPublicKeyCallable().call((Object)request);
    }

    public final UnaryCallable<GetPublicKeyRequest, PublicKey> getPublicKeyCallable() {
        return this.stub.getPublicKeyCallable();
    }

    public final AsymmetricDecryptResponse asymmetricDecrypt(CryptoKeyVersionName name, ByteString ciphertext) {
        AsymmetricDecryptRequest request = AsymmetricDecryptRequest.newBuilder().setName(name == null ? null : name.toString()).setCiphertext(ciphertext).build();
        return this.asymmetricDecrypt(request);
    }

    public final AsymmetricDecryptResponse asymmetricDecrypt(String name, ByteString ciphertext) {
        AsymmetricDecryptRequest request = AsymmetricDecryptRequest.newBuilder().setName(name).setCiphertext(ciphertext).build();
        return this.asymmetricDecrypt(request);
    }

    public final AsymmetricDecryptResponse asymmetricDecrypt(AsymmetricDecryptRequest request) {
        return (AsymmetricDecryptResponse)this.asymmetricDecryptCallable().call((Object)request);
    }

    public final UnaryCallable<AsymmetricDecryptRequest, AsymmetricDecryptResponse> asymmetricDecryptCallable() {
        return this.stub.asymmetricDecryptCallable();
    }

    public final AsymmetricSignResponse asymmetricSign(CryptoKeyVersionName name, Digest digest) {
        AsymmetricSignRequest request = AsymmetricSignRequest.newBuilder().setName(name == null ? null : name.toString()).setDigest(digest).build();
        return this.asymmetricSign(request);
    }

    public final AsymmetricSignResponse asymmetricSign(String name, Digest digest) {
        AsymmetricSignRequest request = AsymmetricSignRequest.newBuilder().setName(name).setDigest(digest).build();
        return this.asymmetricSign(request);
    }

    public final AsymmetricSignResponse asymmetricSign(AsymmetricSignRequest request) {
        return (AsymmetricSignResponse)this.asymmetricSignCallable().call((Object)request);
    }

    public final UnaryCallable<AsymmetricSignRequest, AsymmetricSignResponse> asymmetricSignCallable() {
        return this.stub.asymmetricSignCallable();
    }

    public final Policy setIamPolicy(KeyName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(KeyName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(KeyName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListCryptoKeyVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsResponse, CryptoKeyVersion, ListCryptoKeyVersionsPage, ListCryptoKeyVersionsFixedSizeCollection> {
        private ListCryptoKeyVersionsFixedSizeCollection(List<ListCryptoKeyVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCryptoKeyVersionsFixedSizeCollection createEmptyCollection() {
            return new ListCryptoKeyVersionsFixedSizeCollection(null, 0);
        }

        protected ListCryptoKeyVersionsFixedSizeCollection createCollection(List<ListCryptoKeyVersionsPage> pages, int collectionSize) {
            return new ListCryptoKeyVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCryptoKeyVersionsPage
    extends AbstractPage<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsResponse, CryptoKeyVersion, ListCryptoKeyVersionsPage> {
        private ListCryptoKeyVersionsPage(PageContext<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsResponse, CryptoKeyVersion> context, ListCryptoKeyVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListCryptoKeyVersionsPage createEmptyPage() {
            return new ListCryptoKeyVersionsPage(null, null);
        }

        protected ListCryptoKeyVersionsPage createPage(PageContext<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsResponse, CryptoKeyVersion> context, ListCryptoKeyVersionsResponse response) {
            return new ListCryptoKeyVersionsPage(context, response);
        }

        public ApiFuture<ListCryptoKeyVersionsPage> createPageAsync(PageContext<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsResponse, CryptoKeyVersion> context, ApiFuture<ListCryptoKeyVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCryptoKeyVersionsPagedResponse
    extends AbstractPagedListResponse<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsResponse, CryptoKeyVersion, ListCryptoKeyVersionsPage, ListCryptoKeyVersionsFixedSizeCollection> {
        public static ApiFuture<ListCryptoKeyVersionsPagedResponse> createAsync(PageContext<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsResponse, CryptoKeyVersion> context, ApiFuture<ListCryptoKeyVersionsResponse> futureResponse) {
            ApiFuture<ListCryptoKeyVersionsPage> futurePage = ListCryptoKeyVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListCryptoKeyVersionsPage, ListCryptoKeyVersionsPagedResponse>(){

                public ListCryptoKeyVersionsPagedResponse apply(ListCryptoKeyVersionsPage input) {
                    return new ListCryptoKeyVersionsPagedResponse(input);
                }
            });
        }

        private ListCryptoKeyVersionsPagedResponse(ListCryptoKeyVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCryptoKeyVersionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCryptoKeysFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCryptoKeysRequest, ListCryptoKeysResponse, CryptoKey, ListCryptoKeysPage, ListCryptoKeysFixedSizeCollection> {
        private ListCryptoKeysFixedSizeCollection(List<ListCryptoKeysPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCryptoKeysFixedSizeCollection createEmptyCollection() {
            return new ListCryptoKeysFixedSizeCollection(null, 0);
        }

        protected ListCryptoKeysFixedSizeCollection createCollection(List<ListCryptoKeysPage> pages, int collectionSize) {
            return new ListCryptoKeysFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCryptoKeysPage
    extends AbstractPage<ListCryptoKeysRequest, ListCryptoKeysResponse, CryptoKey, ListCryptoKeysPage> {
        private ListCryptoKeysPage(PageContext<ListCryptoKeysRequest, ListCryptoKeysResponse, CryptoKey> context, ListCryptoKeysResponse response) {
            super(context, (Object)response);
        }

        private static ListCryptoKeysPage createEmptyPage() {
            return new ListCryptoKeysPage(null, null);
        }

        protected ListCryptoKeysPage createPage(PageContext<ListCryptoKeysRequest, ListCryptoKeysResponse, CryptoKey> context, ListCryptoKeysResponse response) {
            return new ListCryptoKeysPage(context, response);
        }

        public ApiFuture<ListCryptoKeysPage> createPageAsync(PageContext<ListCryptoKeysRequest, ListCryptoKeysResponse, CryptoKey> context, ApiFuture<ListCryptoKeysResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCryptoKeysPagedResponse
    extends AbstractPagedListResponse<ListCryptoKeysRequest, ListCryptoKeysResponse, CryptoKey, ListCryptoKeysPage, ListCryptoKeysFixedSizeCollection> {
        public static ApiFuture<ListCryptoKeysPagedResponse> createAsync(PageContext<ListCryptoKeysRequest, ListCryptoKeysResponse, CryptoKey> context, ApiFuture<ListCryptoKeysResponse> futureResponse) {
            ApiFuture<ListCryptoKeysPage> futurePage = ListCryptoKeysPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListCryptoKeysPage, ListCryptoKeysPagedResponse>(){

                public ListCryptoKeysPagedResponse apply(ListCryptoKeysPage input) {
                    return new ListCryptoKeysPagedResponse(input);
                }
            });
        }

        private ListCryptoKeysPagedResponse(ListCryptoKeysPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCryptoKeysFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListKeyRingsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListKeyRingsRequest, ListKeyRingsResponse, KeyRing, ListKeyRingsPage, ListKeyRingsFixedSizeCollection> {
        private ListKeyRingsFixedSizeCollection(List<ListKeyRingsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListKeyRingsFixedSizeCollection createEmptyCollection() {
            return new ListKeyRingsFixedSizeCollection(null, 0);
        }

        protected ListKeyRingsFixedSizeCollection createCollection(List<ListKeyRingsPage> pages, int collectionSize) {
            return new ListKeyRingsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListKeyRingsPage
    extends AbstractPage<ListKeyRingsRequest, ListKeyRingsResponse, KeyRing, ListKeyRingsPage> {
        private ListKeyRingsPage(PageContext<ListKeyRingsRequest, ListKeyRingsResponse, KeyRing> context, ListKeyRingsResponse response) {
            super(context, (Object)response);
        }

        private static ListKeyRingsPage createEmptyPage() {
            return new ListKeyRingsPage(null, null);
        }

        protected ListKeyRingsPage createPage(PageContext<ListKeyRingsRequest, ListKeyRingsResponse, KeyRing> context, ListKeyRingsResponse response) {
            return new ListKeyRingsPage(context, response);
        }

        public ApiFuture<ListKeyRingsPage> createPageAsync(PageContext<ListKeyRingsRequest, ListKeyRingsResponse, KeyRing> context, ApiFuture<ListKeyRingsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListKeyRingsPagedResponse
    extends AbstractPagedListResponse<ListKeyRingsRequest, ListKeyRingsResponse, KeyRing, ListKeyRingsPage, ListKeyRingsFixedSizeCollection> {
        public static ApiFuture<ListKeyRingsPagedResponse> createAsync(PageContext<ListKeyRingsRequest, ListKeyRingsResponse, KeyRing> context, ApiFuture<ListKeyRingsResponse> futureResponse) {
            ApiFuture<ListKeyRingsPage> futurePage = ListKeyRingsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListKeyRingsPage, ListKeyRingsPagedResponse>(){

                public ListKeyRingsPagedResponse apply(ListKeyRingsPage input) {
                    return new ListKeyRingsPagedResponse(input);
                }
            });
        }

        private ListKeyRingsPagedResponse(ListKeyRingsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListKeyRingsFixedSizeCollection.createEmptyCollection());
        }
    }
}

