/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.iot.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.iot.v1.BindDeviceToGatewayRequest;
import com.google.cloud.iot.v1.BindDeviceToGatewayResponse;
import com.google.cloud.iot.v1.CreateDeviceRegistryRequest;
import com.google.cloud.iot.v1.CreateDeviceRequest;
import com.google.cloud.iot.v1.DeleteDeviceRegistryRequest;
import com.google.cloud.iot.v1.DeleteDeviceRequest;
import com.google.cloud.iot.v1.Device;
import com.google.cloud.iot.v1.DeviceConfig;
import com.google.cloud.iot.v1.DeviceManagerSettings;
import com.google.cloud.iot.v1.DeviceName;
import com.google.cloud.iot.v1.DeviceRegistry;
import com.google.cloud.iot.v1.GetDeviceRegistryRequest;
import com.google.cloud.iot.v1.GetDeviceRequest;
import com.google.cloud.iot.v1.ListDeviceConfigVersionsRequest;
import com.google.cloud.iot.v1.ListDeviceConfigVersionsResponse;
import com.google.cloud.iot.v1.ListDeviceRegistriesRequest;
import com.google.cloud.iot.v1.ListDeviceRegistriesResponse;
import com.google.cloud.iot.v1.ListDeviceStatesRequest;
import com.google.cloud.iot.v1.ListDeviceStatesResponse;
import com.google.cloud.iot.v1.ListDevicesRequest;
import com.google.cloud.iot.v1.ListDevicesResponse;
import com.google.cloud.iot.v1.LocationName;
import com.google.cloud.iot.v1.ModifyCloudToDeviceConfigRequest;
import com.google.cloud.iot.v1.RegistryName;
import com.google.cloud.iot.v1.SendCommandToDeviceRequest;
import com.google.cloud.iot.v1.SendCommandToDeviceResponse;
import com.google.cloud.iot.v1.UnbindDeviceFromGatewayRequest;
import com.google.cloud.iot.v1.UnbindDeviceFromGatewayResponse;
import com.google.cloud.iot.v1.UpdateDeviceRegistryRequest;
import com.google.cloud.iot.v1.UpdateDeviceRequest;
import com.google.cloud.iot.v1.stub.DeviceManagerStub;
import com.google.cloud.iot.v1.stub.DeviceManagerStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DeviceManagerClient
implements BackgroundResource {
    private final DeviceManagerSettings settings;
    private final DeviceManagerStub stub;

    public static final DeviceManagerClient create() throws IOException {
        return DeviceManagerClient.create(DeviceManagerSettings.newBuilder().build());
    }

    public static final DeviceManagerClient create(DeviceManagerSettings settings) throws IOException {
        return new DeviceManagerClient(settings);
    }

    public static final DeviceManagerClient create(DeviceManagerStub stub) {
        return new DeviceManagerClient(stub);
    }

    protected DeviceManagerClient(DeviceManagerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DeviceManagerStubSettings)settings.getStubSettings()).createStub();
    }

    protected DeviceManagerClient(DeviceManagerStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DeviceManagerSettings getSettings() {
        return this.settings;
    }

    public DeviceManagerStub getStub() {
        return this.stub;
    }

    public final DeviceRegistry createDeviceRegistry(LocationName parent, DeviceRegistry deviceRegistry) {
        CreateDeviceRegistryRequest request = CreateDeviceRegistryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDeviceRegistry(deviceRegistry).build();
        return this.createDeviceRegistry(request);
    }

    public final DeviceRegistry createDeviceRegistry(String parent, DeviceRegistry deviceRegistry) {
        CreateDeviceRegistryRequest request = CreateDeviceRegistryRequest.newBuilder().setParent(parent).setDeviceRegistry(deviceRegistry).build();
        return this.createDeviceRegistry(request);
    }

    public final DeviceRegistry createDeviceRegistry(CreateDeviceRegistryRequest request) {
        return (DeviceRegistry)this.createDeviceRegistryCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDeviceRegistryRequest, DeviceRegistry> createDeviceRegistryCallable() {
        return this.stub.createDeviceRegistryCallable();
    }

    public final DeviceRegistry getDeviceRegistry(RegistryName name) {
        GetDeviceRegistryRequest request = GetDeviceRegistryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDeviceRegistry(request);
    }

    public final DeviceRegistry getDeviceRegistry(String name) {
        GetDeviceRegistryRequest request = GetDeviceRegistryRequest.newBuilder().setName(name).build();
        return this.getDeviceRegistry(request);
    }

    public final DeviceRegistry getDeviceRegistry(GetDeviceRegistryRequest request) {
        return (DeviceRegistry)this.getDeviceRegistryCallable().call((Object)request);
    }

    public final UnaryCallable<GetDeviceRegistryRequest, DeviceRegistry> getDeviceRegistryCallable() {
        return this.stub.getDeviceRegistryCallable();
    }

    public final DeviceRegistry updateDeviceRegistry(DeviceRegistry deviceRegistry, FieldMask updateMask) {
        UpdateDeviceRegistryRequest request = UpdateDeviceRegistryRequest.newBuilder().setDeviceRegistry(deviceRegistry).setUpdateMask(updateMask).build();
        return this.updateDeviceRegistry(request);
    }

    public final DeviceRegistry updateDeviceRegistry(UpdateDeviceRegistryRequest request) {
        return (DeviceRegistry)this.updateDeviceRegistryCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDeviceRegistryRequest, DeviceRegistry> updateDeviceRegistryCallable() {
        return this.stub.updateDeviceRegistryCallable();
    }

    public final void deleteDeviceRegistry(RegistryName name) {
        DeleteDeviceRegistryRequest request = DeleteDeviceRegistryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDeviceRegistry(request);
    }

    public final void deleteDeviceRegistry(String name) {
        DeleteDeviceRegistryRequest request = DeleteDeviceRegistryRequest.newBuilder().setName(name).build();
        this.deleteDeviceRegistry(request);
    }

    public final void deleteDeviceRegistry(DeleteDeviceRegistryRequest request) {
        this.deleteDeviceRegistryCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDeviceRegistryRequest, Empty> deleteDeviceRegistryCallable() {
        return this.stub.deleteDeviceRegistryCallable();
    }

    public final ListDeviceRegistriesPagedResponse listDeviceRegistries(LocationName parent) {
        ListDeviceRegistriesRequest request = ListDeviceRegistriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDeviceRegistries(request);
    }

    public final ListDeviceRegistriesPagedResponse listDeviceRegistries(String parent) {
        ListDeviceRegistriesRequest request = ListDeviceRegistriesRequest.newBuilder().setParent(parent).build();
        return this.listDeviceRegistries(request);
    }

    public final ListDeviceRegistriesPagedResponse listDeviceRegistries(ListDeviceRegistriesRequest request) {
        return (ListDeviceRegistriesPagedResponse)((Object)this.listDeviceRegistriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDeviceRegistriesRequest, ListDeviceRegistriesPagedResponse> listDeviceRegistriesPagedCallable() {
        return this.stub.listDeviceRegistriesPagedCallable();
    }

    public final UnaryCallable<ListDeviceRegistriesRequest, ListDeviceRegistriesResponse> listDeviceRegistriesCallable() {
        return this.stub.listDeviceRegistriesCallable();
    }

    public final Device createDevice(RegistryName parent, Device device) {
        CreateDeviceRequest request = CreateDeviceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDevice(device).build();
        return this.createDevice(request);
    }

    public final Device createDevice(String parent, Device device) {
        CreateDeviceRequest request = CreateDeviceRequest.newBuilder().setParent(parent).setDevice(device).build();
        return this.createDevice(request);
    }

    public final Device createDevice(CreateDeviceRequest request) {
        return (Device)this.createDeviceCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDeviceRequest, Device> createDeviceCallable() {
        return this.stub.createDeviceCallable();
    }

    public final Device getDevice(DeviceName name) {
        GetDeviceRequest request = GetDeviceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDevice(request);
    }

    public final Device getDevice(String name) {
        GetDeviceRequest request = GetDeviceRequest.newBuilder().setName(name).build();
        return this.getDevice(request);
    }

    public final Device getDevice(GetDeviceRequest request) {
        return (Device)this.getDeviceCallable().call((Object)request);
    }

    public final UnaryCallable<GetDeviceRequest, Device> getDeviceCallable() {
        return this.stub.getDeviceCallable();
    }

    public final Device updateDevice(Device device, FieldMask updateMask) {
        UpdateDeviceRequest request = UpdateDeviceRequest.newBuilder().setDevice(device).setUpdateMask(updateMask).build();
        return this.updateDevice(request);
    }

    public final Device updateDevice(UpdateDeviceRequest request) {
        return (Device)this.updateDeviceCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDeviceRequest, Device> updateDeviceCallable() {
        return this.stub.updateDeviceCallable();
    }

    public final void deleteDevice(DeviceName name) {
        DeleteDeviceRequest request = DeleteDeviceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDevice(request);
    }

    public final void deleteDevice(String name) {
        DeleteDeviceRequest request = DeleteDeviceRequest.newBuilder().setName(name).build();
        this.deleteDevice(request);
    }

    public final void deleteDevice(DeleteDeviceRequest request) {
        this.deleteDeviceCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDeviceRequest, Empty> deleteDeviceCallable() {
        return this.stub.deleteDeviceCallable();
    }

    public final ListDevicesPagedResponse listDevices(RegistryName parent) {
        ListDevicesRequest request = ListDevicesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDevices(request);
    }

    public final ListDevicesPagedResponse listDevices(String parent) {
        ListDevicesRequest request = ListDevicesRequest.newBuilder().setParent(parent).build();
        return this.listDevices(request);
    }

    public final ListDevicesPagedResponse listDevices(ListDevicesRequest request) {
        return (ListDevicesPagedResponse)((Object)this.listDevicesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDevicesRequest, ListDevicesPagedResponse> listDevicesPagedCallable() {
        return this.stub.listDevicesPagedCallable();
    }

    public final UnaryCallable<ListDevicesRequest, ListDevicesResponse> listDevicesCallable() {
        return this.stub.listDevicesCallable();
    }

    public final DeviceConfig modifyCloudToDeviceConfig(DeviceName name, ByteString binaryData) {
        ModifyCloudToDeviceConfigRequest request = ModifyCloudToDeviceConfigRequest.newBuilder().setName(name == null ? null : name.toString()).setBinaryData(binaryData).build();
        return this.modifyCloudToDeviceConfig(request);
    }

    public final DeviceConfig modifyCloudToDeviceConfig(String name, ByteString binaryData) {
        ModifyCloudToDeviceConfigRequest request = ModifyCloudToDeviceConfigRequest.newBuilder().setName(name).setBinaryData(binaryData).build();
        return this.modifyCloudToDeviceConfig(request);
    }

    public final DeviceConfig modifyCloudToDeviceConfig(ModifyCloudToDeviceConfigRequest request) {
        return (DeviceConfig)this.modifyCloudToDeviceConfigCallable().call((Object)request);
    }

    public final UnaryCallable<ModifyCloudToDeviceConfigRequest, DeviceConfig> modifyCloudToDeviceConfigCallable() {
        return this.stub.modifyCloudToDeviceConfigCallable();
    }

    public final ListDeviceConfigVersionsResponse listDeviceConfigVersions(DeviceName name) {
        ListDeviceConfigVersionsRequest request = ListDeviceConfigVersionsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listDeviceConfigVersions(request);
    }

    public final ListDeviceConfigVersionsResponse listDeviceConfigVersions(String name) {
        ListDeviceConfigVersionsRequest request = ListDeviceConfigVersionsRequest.newBuilder().setName(name).build();
        return this.listDeviceConfigVersions(request);
    }

    public final ListDeviceConfigVersionsResponse listDeviceConfigVersions(ListDeviceConfigVersionsRequest request) {
        return (ListDeviceConfigVersionsResponse)this.listDeviceConfigVersionsCallable().call((Object)request);
    }

    public final UnaryCallable<ListDeviceConfigVersionsRequest, ListDeviceConfigVersionsResponse> listDeviceConfigVersionsCallable() {
        return this.stub.listDeviceConfigVersionsCallable();
    }

    public final ListDeviceStatesResponse listDeviceStates(DeviceName name) {
        ListDeviceStatesRequest request = ListDeviceStatesRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listDeviceStates(request);
    }

    public final ListDeviceStatesResponse listDeviceStates(String name) {
        ListDeviceStatesRequest request = ListDeviceStatesRequest.newBuilder().setName(name).build();
        return this.listDeviceStates(request);
    }

    public final ListDeviceStatesResponse listDeviceStates(ListDeviceStatesRequest request) {
        return (ListDeviceStatesResponse)this.listDeviceStatesCallable().call((Object)request);
    }

    public final UnaryCallable<ListDeviceStatesRequest, ListDeviceStatesResponse> listDeviceStatesCallable() {
        return this.stub.listDeviceStatesCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final SendCommandToDeviceResponse sendCommandToDevice(DeviceName name, ByteString binaryData) {
        SendCommandToDeviceRequest request = SendCommandToDeviceRequest.newBuilder().setName(name == null ? null : name.toString()).setBinaryData(binaryData).build();
        return this.sendCommandToDevice(request);
    }

    public final SendCommandToDeviceResponse sendCommandToDevice(String name, ByteString binaryData) {
        SendCommandToDeviceRequest request = SendCommandToDeviceRequest.newBuilder().setName(name).setBinaryData(binaryData).build();
        return this.sendCommandToDevice(request);
    }

    public final SendCommandToDeviceResponse sendCommandToDevice(DeviceName name, ByteString binaryData, String subfolder) {
        SendCommandToDeviceRequest request = SendCommandToDeviceRequest.newBuilder().setName(name == null ? null : name.toString()).setBinaryData(binaryData).setSubfolder(subfolder).build();
        return this.sendCommandToDevice(request);
    }

    public final SendCommandToDeviceResponse sendCommandToDevice(String name, ByteString binaryData, String subfolder) {
        SendCommandToDeviceRequest request = SendCommandToDeviceRequest.newBuilder().setName(name).setBinaryData(binaryData).setSubfolder(subfolder).build();
        return this.sendCommandToDevice(request);
    }

    public final SendCommandToDeviceResponse sendCommandToDevice(SendCommandToDeviceRequest request) {
        return (SendCommandToDeviceResponse)this.sendCommandToDeviceCallable().call((Object)request);
    }

    public final UnaryCallable<SendCommandToDeviceRequest, SendCommandToDeviceResponse> sendCommandToDeviceCallable() {
        return this.stub.sendCommandToDeviceCallable();
    }

    public final BindDeviceToGatewayResponse bindDeviceToGateway(RegistryName parent, String gatewayId, String deviceId) {
        BindDeviceToGatewayRequest request = BindDeviceToGatewayRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGatewayId(gatewayId).setDeviceId(deviceId).build();
        return this.bindDeviceToGateway(request);
    }

    public final BindDeviceToGatewayResponse bindDeviceToGateway(String parent, String gatewayId, String deviceId) {
        BindDeviceToGatewayRequest request = BindDeviceToGatewayRequest.newBuilder().setParent(parent).setGatewayId(gatewayId).setDeviceId(deviceId).build();
        return this.bindDeviceToGateway(request);
    }

    public final BindDeviceToGatewayResponse bindDeviceToGateway(BindDeviceToGatewayRequest request) {
        return (BindDeviceToGatewayResponse)this.bindDeviceToGatewayCallable().call((Object)request);
    }

    public final UnaryCallable<BindDeviceToGatewayRequest, BindDeviceToGatewayResponse> bindDeviceToGatewayCallable() {
        return this.stub.bindDeviceToGatewayCallable();
    }

    public final UnbindDeviceFromGatewayResponse unbindDeviceFromGateway(RegistryName parent, String gatewayId, String deviceId) {
        UnbindDeviceFromGatewayRequest request = UnbindDeviceFromGatewayRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGatewayId(gatewayId).setDeviceId(deviceId).build();
        return this.unbindDeviceFromGateway(request);
    }

    public final UnbindDeviceFromGatewayResponse unbindDeviceFromGateway(String parent, String gatewayId, String deviceId) {
        UnbindDeviceFromGatewayRequest request = UnbindDeviceFromGatewayRequest.newBuilder().setParent(parent).setGatewayId(gatewayId).setDeviceId(deviceId).build();
        return this.unbindDeviceFromGateway(request);
    }

    public final UnbindDeviceFromGatewayResponse unbindDeviceFromGateway(UnbindDeviceFromGatewayRequest request) {
        return (UnbindDeviceFromGatewayResponse)this.unbindDeviceFromGatewayCallable().call((Object)request);
    }

    public final UnaryCallable<UnbindDeviceFromGatewayRequest, UnbindDeviceFromGatewayResponse> unbindDeviceFromGatewayCallable() {
        return this.stub.unbindDeviceFromGatewayCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDevicesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDevicesRequest, ListDevicesResponse, Device, ListDevicesPage, ListDevicesFixedSizeCollection> {
        private ListDevicesFixedSizeCollection(List<ListDevicesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDevicesFixedSizeCollection createEmptyCollection() {
            return new ListDevicesFixedSizeCollection(null, 0);
        }

        protected ListDevicesFixedSizeCollection createCollection(List<ListDevicesPage> pages, int collectionSize) {
            return new ListDevicesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDevicesPage
    extends AbstractPage<ListDevicesRequest, ListDevicesResponse, Device, ListDevicesPage> {
        private ListDevicesPage(PageContext<ListDevicesRequest, ListDevicesResponse, Device> context, ListDevicesResponse response) {
            super(context, (Object)response);
        }

        private static ListDevicesPage createEmptyPage() {
            return new ListDevicesPage(null, null);
        }

        protected ListDevicesPage createPage(PageContext<ListDevicesRequest, ListDevicesResponse, Device> context, ListDevicesResponse response) {
            return new ListDevicesPage(context, response);
        }

        public ApiFuture<ListDevicesPage> createPageAsync(PageContext<ListDevicesRequest, ListDevicesResponse, Device> context, ApiFuture<ListDevicesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDevicesPagedResponse
    extends AbstractPagedListResponse<ListDevicesRequest, ListDevicesResponse, Device, ListDevicesPage, ListDevicesFixedSizeCollection> {
        public static ApiFuture<ListDevicesPagedResponse> createAsync(PageContext<ListDevicesRequest, ListDevicesResponse, Device> context, ApiFuture<ListDevicesResponse> futureResponse) {
            ApiFuture<ListDevicesPage> futurePage = ListDevicesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDevicesPagedResponse((ListDevicesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDevicesPagedResponse(ListDevicesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDevicesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDeviceRegistriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDeviceRegistriesRequest, ListDeviceRegistriesResponse, DeviceRegistry, ListDeviceRegistriesPage, ListDeviceRegistriesFixedSizeCollection> {
        private ListDeviceRegistriesFixedSizeCollection(List<ListDeviceRegistriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDeviceRegistriesFixedSizeCollection createEmptyCollection() {
            return new ListDeviceRegistriesFixedSizeCollection(null, 0);
        }

        protected ListDeviceRegistriesFixedSizeCollection createCollection(List<ListDeviceRegistriesPage> pages, int collectionSize) {
            return new ListDeviceRegistriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDeviceRegistriesPage
    extends AbstractPage<ListDeviceRegistriesRequest, ListDeviceRegistriesResponse, DeviceRegistry, ListDeviceRegistriesPage> {
        private ListDeviceRegistriesPage(PageContext<ListDeviceRegistriesRequest, ListDeviceRegistriesResponse, DeviceRegistry> context, ListDeviceRegistriesResponse response) {
            super(context, (Object)response);
        }

        private static ListDeviceRegistriesPage createEmptyPage() {
            return new ListDeviceRegistriesPage(null, null);
        }

        protected ListDeviceRegistriesPage createPage(PageContext<ListDeviceRegistriesRequest, ListDeviceRegistriesResponse, DeviceRegistry> context, ListDeviceRegistriesResponse response) {
            return new ListDeviceRegistriesPage(context, response);
        }

        public ApiFuture<ListDeviceRegistriesPage> createPageAsync(PageContext<ListDeviceRegistriesRequest, ListDeviceRegistriesResponse, DeviceRegistry> context, ApiFuture<ListDeviceRegistriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDeviceRegistriesPagedResponse
    extends AbstractPagedListResponse<ListDeviceRegistriesRequest, ListDeviceRegistriesResponse, DeviceRegistry, ListDeviceRegistriesPage, ListDeviceRegistriesFixedSizeCollection> {
        public static ApiFuture<ListDeviceRegistriesPagedResponse> createAsync(PageContext<ListDeviceRegistriesRequest, ListDeviceRegistriesResponse, DeviceRegistry> context, ApiFuture<ListDeviceRegistriesResponse> futureResponse) {
            ApiFuture<ListDeviceRegistriesPage> futurePage = ListDeviceRegistriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDeviceRegistriesPagedResponse((ListDeviceRegistriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDeviceRegistriesPagedResponse(ListDeviceRegistriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDeviceRegistriesFixedSizeCollection.createEmptyCollection());
        }
    }
}

