/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.iot.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.iot.v1.BindDeviceToGatewayRequest;
import com.google.cloud.iot.v1.BindDeviceToGatewayResponse;
import com.google.cloud.iot.v1.CreateDeviceRegistryRequest;
import com.google.cloud.iot.v1.CreateDeviceRequest;
import com.google.cloud.iot.v1.DeleteDeviceRegistryRequest;
import com.google.cloud.iot.v1.DeleteDeviceRequest;
import com.google.cloud.iot.v1.Device;
import com.google.cloud.iot.v1.DeviceConfig;
import com.google.cloud.iot.v1.DeviceManagerClient;
import com.google.cloud.iot.v1.DeviceRegistry;
import com.google.cloud.iot.v1.GetDeviceRegistryRequest;
import com.google.cloud.iot.v1.GetDeviceRequest;
import com.google.cloud.iot.v1.ListDeviceConfigVersionsRequest;
import com.google.cloud.iot.v1.ListDeviceConfigVersionsResponse;
import com.google.cloud.iot.v1.ListDeviceRegistriesRequest;
import com.google.cloud.iot.v1.ListDeviceRegistriesResponse;
import com.google.cloud.iot.v1.ListDeviceStatesRequest;
import com.google.cloud.iot.v1.ListDeviceStatesResponse;
import com.google.cloud.iot.v1.ListDevicesRequest;
import com.google.cloud.iot.v1.ListDevicesResponse;
import com.google.cloud.iot.v1.ModifyCloudToDeviceConfigRequest;
import com.google.cloud.iot.v1.SendCommandToDeviceRequest;
import com.google.cloud.iot.v1.SendCommandToDeviceResponse;
import com.google.cloud.iot.v1.UnbindDeviceFromGatewayRequest;
import com.google.cloud.iot.v1.UnbindDeviceFromGatewayResponse;
import com.google.cloud.iot.v1.UpdateDeviceRegistryRequest;
import com.google.cloud.iot.v1.UpdateDeviceRequest;
import com.google.cloud.iot.v1.stub.DeviceManagerStub;
import com.google.cloud.iot.v1.stub.GrpcDeviceManagerStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class DeviceManagerStubSettings
extends StubSettings<DeviceManagerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloudiot").build();
    private final UnaryCallSettings<CreateDeviceRegistryRequest, DeviceRegistry> createDeviceRegistrySettings;
    private final UnaryCallSettings<GetDeviceRegistryRequest, DeviceRegistry> getDeviceRegistrySettings;
    private final UnaryCallSettings<UpdateDeviceRegistryRequest, DeviceRegistry> updateDeviceRegistrySettings;
    private final UnaryCallSettings<DeleteDeviceRegistryRequest, Empty> deleteDeviceRegistrySettings;
    private final PagedCallSettings<ListDeviceRegistriesRequest, ListDeviceRegistriesResponse, DeviceManagerClient.ListDeviceRegistriesPagedResponse> listDeviceRegistriesSettings;
    private final UnaryCallSettings<CreateDeviceRequest, Device> createDeviceSettings;
    private final UnaryCallSettings<GetDeviceRequest, Device> getDeviceSettings;
    private final UnaryCallSettings<UpdateDeviceRequest, Device> updateDeviceSettings;
    private final UnaryCallSettings<DeleteDeviceRequest, Empty> deleteDeviceSettings;
    private final PagedCallSettings<ListDevicesRequest, ListDevicesResponse, DeviceManagerClient.ListDevicesPagedResponse> listDevicesSettings;
    private final UnaryCallSettings<ModifyCloudToDeviceConfigRequest, DeviceConfig> modifyCloudToDeviceConfigSettings;
    private final UnaryCallSettings<ListDeviceConfigVersionsRequest, ListDeviceConfigVersionsResponse> listDeviceConfigVersionsSettings;
    private final UnaryCallSettings<ListDeviceStatesRequest, ListDeviceStatesResponse> listDeviceStatesSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private final UnaryCallSettings<SendCommandToDeviceRequest, SendCommandToDeviceResponse> sendCommandToDeviceSettings;
    private final UnaryCallSettings<BindDeviceToGatewayRequest, BindDeviceToGatewayResponse> bindDeviceToGatewaySettings;
    private final UnaryCallSettings<UnbindDeviceFromGatewayRequest, UnbindDeviceFromGatewayResponse> unbindDeviceFromGatewaySettings;
    private static final PagedListDescriptor<ListDeviceRegistriesRequest, ListDeviceRegistriesResponse, DeviceRegistry> LIST_DEVICE_REGISTRIES_PAGE_STR_DESC = new PagedListDescriptor<ListDeviceRegistriesRequest, ListDeviceRegistriesResponse, DeviceRegistry>(){

        public String emptyToken() {
            return "";
        }

        public ListDeviceRegistriesRequest injectToken(ListDeviceRegistriesRequest payload, String token) {
            return ListDeviceRegistriesRequest.newBuilder((ListDeviceRegistriesRequest)payload).setPageToken(token).build();
        }

        public ListDeviceRegistriesRequest injectPageSize(ListDeviceRegistriesRequest payload, int pageSize) {
            return ListDeviceRegistriesRequest.newBuilder((ListDeviceRegistriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDeviceRegistriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDeviceRegistriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DeviceRegistry> extractResources(ListDeviceRegistriesResponse payload) {
            return payload.getDeviceRegistriesList() == null ? ImmutableList.of() : payload.getDeviceRegistriesList();
        }
    };
    private static final PagedListDescriptor<ListDevicesRequest, ListDevicesResponse, Device> LIST_DEVICES_PAGE_STR_DESC = new PagedListDescriptor<ListDevicesRequest, ListDevicesResponse, Device>(){

        public String emptyToken() {
            return "";
        }

        public ListDevicesRequest injectToken(ListDevicesRequest payload, String token) {
            return ListDevicesRequest.newBuilder((ListDevicesRequest)payload).setPageToken(token).build();
        }

        public ListDevicesRequest injectPageSize(ListDevicesRequest payload, int pageSize) {
            return ListDevicesRequest.newBuilder((ListDevicesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDevicesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDevicesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Device> extractResources(ListDevicesResponse payload) {
            return payload.getDevicesList() == null ? ImmutableList.of() : payload.getDevicesList();
        }
    };
    private static final PagedListResponseFactory<ListDeviceRegistriesRequest, ListDeviceRegistriesResponse, DeviceManagerClient.ListDeviceRegistriesPagedResponse> LIST_DEVICE_REGISTRIES_PAGE_STR_FACT = new PagedListResponseFactory<ListDeviceRegistriesRequest, ListDeviceRegistriesResponse, DeviceManagerClient.ListDeviceRegistriesPagedResponse>(){

        public ApiFuture<DeviceManagerClient.ListDeviceRegistriesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDeviceRegistriesRequest, ListDeviceRegistriesResponse> callable, ListDeviceRegistriesRequest request, ApiCallContext context, ApiFuture<ListDeviceRegistriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DEVICE_REGISTRIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DeviceManagerClient.ListDeviceRegistriesPagedResponse.createAsync((PageContext<ListDeviceRegistriesRequest, ListDeviceRegistriesResponse, DeviceRegistry>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDevicesRequest, ListDevicesResponse, DeviceManagerClient.ListDevicesPagedResponse> LIST_DEVICES_PAGE_STR_FACT = new PagedListResponseFactory<ListDevicesRequest, ListDevicesResponse, DeviceManagerClient.ListDevicesPagedResponse>(){

        public ApiFuture<DeviceManagerClient.ListDevicesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDevicesRequest, ListDevicesResponse> callable, ListDevicesRequest request, ApiCallContext context, ApiFuture<ListDevicesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DEVICES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DeviceManagerClient.ListDevicesPagedResponse.createAsync((PageContext<ListDevicesRequest, ListDevicesResponse, Device>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateDeviceRegistryRequest, DeviceRegistry> createDeviceRegistrySettings() {
        return this.createDeviceRegistrySettings;
    }

    public UnaryCallSettings<GetDeviceRegistryRequest, DeviceRegistry> getDeviceRegistrySettings() {
        return this.getDeviceRegistrySettings;
    }

    public UnaryCallSettings<UpdateDeviceRegistryRequest, DeviceRegistry> updateDeviceRegistrySettings() {
        return this.updateDeviceRegistrySettings;
    }

    public UnaryCallSettings<DeleteDeviceRegistryRequest, Empty> deleteDeviceRegistrySettings() {
        return this.deleteDeviceRegistrySettings;
    }

    public PagedCallSettings<ListDeviceRegistriesRequest, ListDeviceRegistriesResponse, DeviceManagerClient.ListDeviceRegistriesPagedResponse> listDeviceRegistriesSettings() {
        return this.listDeviceRegistriesSettings;
    }

    public UnaryCallSettings<CreateDeviceRequest, Device> createDeviceSettings() {
        return this.createDeviceSettings;
    }

    public UnaryCallSettings<GetDeviceRequest, Device> getDeviceSettings() {
        return this.getDeviceSettings;
    }

    public UnaryCallSettings<UpdateDeviceRequest, Device> updateDeviceSettings() {
        return this.updateDeviceSettings;
    }

    public UnaryCallSettings<DeleteDeviceRequest, Empty> deleteDeviceSettings() {
        return this.deleteDeviceSettings;
    }

    public PagedCallSettings<ListDevicesRequest, ListDevicesResponse, DeviceManagerClient.ListDevicesPagedResponse> listDevicesSettings() {
        return this.listDevicesSettings;
    }

    public UnaryCallSettings<ModifyCloudToDeviceConfigRequest, DeviceConfig> modifyCloudToDeviceConfigSettings() {
        return this.modifyCloudToDeviceConfigSettings;
    }

    public UnaryCallSettings<ListDeviceConfigVersionsRequest, ListDeviceConfigVersionsResponse> listDeviceConfigVersionsSettings() {
        return this.listDeviceConfigVersionsSettings;
    }

    public UnaryCallSettings<ListDeviceStatesRequest, ListDeviceStatesResponse> listDeviceStatesSettings() {
        return this.listDeviceStatesSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public UnaryCallSettings<SendCommandToDeviceRequest, SendCommandToDeviceResponse> sendCommandToDeviceSettings() {
        return this.sendCommandToDeviceSettings;
    }

    public UnaryCallSettings<BindDeviceToGatewayRequest, BindDeviceToGatewayResponse> bindDeviceToGatewaySettings() {
        return this.bindDeviceToGatewaySettings;
    }

    public UnaryCallSettings<UnbindDeviceFromGatewayRequest, UnbindDeviceFromGatewayResponse> unbindDeviceFromGatewaySettings() {
        return this.unbindDeviceFromGatewaySettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DeviceManagerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDeviceManagerStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudiot.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudiot.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DeviceManagerStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DeviceManagerStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DeviceManagerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createDeviceRegistrySettings = settingsBuilder.createDeviceRegistrySettings().build();
        this.getDeviceRegistrySettings = settingsBuilder.getDeviceRegistrySettings().build();
        this.updateDeviceRegistrySettings = settingsBuilder.updateDeviceRegistrySettings().build();
        this.deleteDeviceRegistrySettings = settingsBuilder.deleteDeviceRegistrySettings().build();
        this.listDeviceRegistriesSettings = settingsBuilder.listDeviceRegistriesSettings().build();
        this.createDeviceSettings = settingsBuilder.createDeviceSettings().build();
        this.getDeviceSettings = settingsBuilder.getDeviceSettings().build();
        this.updateDeviceSettings = settingsBuilder.updateDeviceSettings().build();
        this.deleteDeviceSettings = settingsBuilder.deleteDeviceSettings().build();
        this.listDevicesSettings = settingsBuilder.listDevicesSettings().build();
        this.modifyCloudToDeviceConfigSettings = settingsBuilder.modifyCloudToDeviceConfigSettings().build();
        this.listDeviceConfigVersionsSettings = settingsBuilder.listDeviceConfigVersionsSettings().build();
        this.listDeviceStatesSettings = settingsBuilder.listDeviceStatesSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
        this.sendCommandToDeviceSettings = settingsBuilder.sendCommandToDeviceSettings().build();
        this.bindDeviceToGatewaySettings = settingsBuilder.bindDeviceToGatewaySettings().build();
        this.unbindDeviceFromGatewaySettings = settingsBuilder.unbindDeviceFromGatewaySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DeviceManagerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateDeviceRegistryRequest, DeviceRegistry> createDeviceRegistrySettings;
        private final UnaryCallSettings.Builder<GetDeviceRegistryRequest, DeviceRegistry> getDeviceRegistrySettings;
        private final UnaryCallSettings.Builder<UpdateDeviceRegistryRequest, DeviceRegistry> updateDeviceRegistrySettings;
        private final UnaryCallSettings.Builder<DeleteDeviceRegistryRequest, Empty> deleteDeviceRegistrySettings;
        private final PagedCallSettings.Builder<ListDeviceRegistriesRequest, ListDeviceRegistriesResponse, DeviceManagerClient.ListDeviceRegistriesPagedResponse> listDeviceRegistriesSettings;
        private final UnaryCallSettings.Builder<CreateDeviceRequest, Device> createDeviceSettings;
        private final UnaryCallSettings.Builder<GetDeviceRequest, Device> getDeviceSettings;
        private final UnaryCallSettings.Builder<UpdateDeviceRequest, Device> updateDeviceSettings;
        private final UnaryCallSettings.Builder<DeleteDeviceRequest, Empty> deleteDeviceSettings;
        private final PagedCallSettings.Builder<ListDevicesRequest, ListDevicesResponse, DeviceManagerClient.ListDevicesPagedResponse> listDevicesSettings;
        private final UnaryCallSettings.Builder<ModifyCloudToDeviceConfigRequest, DeviceConfig> modifyCloudToDeviceConfigSettings;
        private final UnaryCallSettings.Builder<ListDeviceConfigVersionsRequest, ListDeviceConfigVersionsResponse> listDeviceConfigVersionsSettings;
        private final UnaryCallSettings.Builder<ListDeviceStatesRequest, ListDeviceStatesResponse> listDeviceStatesSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private final UnaryCallSettings.Builder<SendCommandToDeviceRequest, SendCommandToDeviceResponse> sendCommandToDeviceSettings;
        private final UnaryCallSettings.Builder<BindDeviceToGatewayRequest, BindDeviceToGatewayResponse> bindDeviceToGatewaySettings;
        private final UnaryCallSettings.Builder<UnbindDeviceFromGatewayRequest, UnbindDeviceFromGatewayResponse> unbindDeviceFromGatewaySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createDeviceRegistrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDeviceRegistrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDeviceRegistrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDeviceRegistrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDeviceRegistriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DEVICE_REGISTRIES_PAGE_STR_FACT);
            this.createDeviceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDeviceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDeviceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDeviceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDevicesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DEVICES_PAGE_STR_FACT);
            this.modifyCloudToDeviceConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDeviceConfigVersionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDeviceStatesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.sendCommandToDeviceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.bindDeviceToGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unbindDeviceFromGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDeviceRegistrySettings, this.getDeviceRegistrySettings, this.updateDeviceRegistrySettings, this.deleteDeviceRegistrySettings, this.listDeviceRegistriesSettings, this.createDeviceSettings, this.getDeviceSettings, this.updateDeviceSettings, this.deleteDeviceSettings, this.listDevicesSettings, this.modifyCloudToDeviceConfigSettings, this.listDeviceConfigVersionsSettings, (Object[])new UnaryCallSettings.Builder[]{this.listDeviceStatesSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings, this.sendCommandToDeviceSettings, this.bindDeviceToGatewaySettings, this.unbindDeviceFromGatewaySettings});
            Builder.initDefaults(this);
        }

        protected Builder(DeviceManagerStubSettings settings) {
            super((StubSettings)settings);
            this.createDeviceRegistrySettings = settings.createDeviceRegistrySettings.toBuilder();
            this.getDeviceRegistrySettings = settings.getDeviceRegistrySettings.toBuilder();
            this.updateDeviceRegistrySettings = settings.updateDeviceRegistrySettings.toBuilder();
            this.deleteDeviceRegistrySettings = settings.deleteDeviceRegistrySettings.toBuilder();
            this.listDeviceRegistriesSettings = settings.listDeviceRegistriesSettings.toBuilder();
            this.createDeviceSettings = settings.createDeviceSettings.toBuilder();
            this.getDeviceSettings = settings.getDeviceSettings.toBuilder();
            this.updateDeviceSettings = settings.updateDeviceSettings.toBuilder();
            this.deleteDeviceSettings = settings.deleteDeviceSettings.toBuilder();
            this.listDevicesSettings = settings.listDevicesSettings.toBuilder();
            this.modifyCloudToDeviceConfigSettings = settings.modifyCloudToDeviceConfigSettings.toBuilder();
            this.listDeviceConfigVersionsSettings = settings.listDeviceConfigVersionsSettings.toBuilder();
            this.listDeviceStatesSettings = settings.listDeviceStatesSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.sendCommandToDeviceSettings = settings.sendCommandToDeviceSettings.toBuilder();
            this.bindDeviceToGatewaySettings = settings.bindDeviceToGatewaySettings.toBuilder();
            this.unbindDeviceFromGatewaySettings = settings.unbindDeviceFromGatewaySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDeviceRegistrySettings, this.getDeviceRegistrySettings, this.updateDeviceRegistrySettings, this.deleteDeviceRegistrySettings, this.listDeviceRegistriesSettings, this.createDeviceSettings, this.getDeviceSettings, this.updateDeviceSettings, this.deleteDeviceSettings, this.listDevicesSettings, this.modifyCloudToDeviceConfigSettings, this.listDeviceConfigVersionsSettings, (Object[])new UnaryCallSettings.Builder[]{this.listDeviceStatesSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings, this.sendCommandToDeviceSettings, this.bindDeviceToGatewaySettings, this.unbindDeviceFromGatewaySettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DeviceManagerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DeviceManagerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DeviceManagerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DeviceManagerStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DeviceManagerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createDeviceRegistrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getDeviceRegistrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateDeviceRegistrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteDeviceRegistrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listDeviceRegistriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createDeviceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getDeviceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateDeviceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteDeviceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listDevicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.modifyCloudToDeviceConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.listDeviceConfigVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listDeviceStatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.sendCommandToDeviceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.bindDeviceToGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.unbindDeviceFromGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateDeviceRegistryRequest, DeviceRegistry> createDeviceRegistrySettings() {
            return this.createDeviceRegistrySettings;
        }

        public UnaryCallSettings.Builder<GetDeviceRegistryRequest, DeviceRegistry> getDeviceRegistrySettings() {
            return this.getDeviceRegistrySettings;
        }

        public UnaryCallSettings.Builder<UpdateDeviceRegistryRequest, DeviceRegistry> updateDeviceRegistrySettings() {
            return this.updateDeviceRegistrySettings;
        }

        public UnaryCallSettings.Builder<DeleteDeviceRegistryRequest, Empty> deleteDeviceRegistrySettings() {
            return this.deleteDeviceRegistrySettings;
        }

        public PagedCallSettings.Builder<ListDeviceRegistriesRequest, ListDeviceRegistriesResponse, DeviceManagerClient.ListDeviceRegistriesPagedResponse> listDeviceRegistriesSettings() {
            return this.listDeviceRegistriesSettings;
        }

        public UnaryCallSettings.Builder<CreateDeviceRequest, Device> createDeviceSettings() {
            return this.createDeviceSettings;
        }

        public UnaryCallSettings.Builder<GetDeviceRequest, Device> getDeviceSettings() {
            return this.getDeviceSettings;
        }

        public UnaryCallSettings.Builder<UpdateDeviceRequest, Device> updateDeviceSettings() {
            return this.updateDeviceSettings;
        }

        public UnaryCallSettings.Builder<DeleteDeviceRequest, Empty> deleteDeviceSettings() {
            return this.deleteDeviceSettings;
        }

        public PagedCallSettings.Builder<ListDevicesRequest, ListDevicesResponse, DeviceManagerClient.ListDevicesPagedResponse> listDevicesSettings() {
            return this.listDevicesSettings;
        }

        public UnaryCallSettings.Builder<ModifyCloudToDeviceConfigRequest, DeviceConfig> modifyCloudToDeviceConfigSettings() {
            return this.modifyCloudToDeviceConfigSettings;
        }

        public UnaryCallSettings.Builder<ListDeviceConfigVersionsRequest, ListDeviceConfigVersionsResponse> listDeviceConfigVersionsSettings() {
            return this.listDeviceConfigVersionsSettings;
        }

        public UnaryCallSettings.Builder<ListDeviceStatesRequest, ListDeviceStatesResponse> listDeviceStatesSettings() {
            return this.listDeviceStatesSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public UnaryCallSettings.Builder<SendCommandToDeviceRequest, SendCommandToDeviceResponse> sendCommandToDeviceSettings() {
            return this.sendCommandToDeviceSettings;
        }

        public UnaryCallSettings.Builder<BindDeviceToGatewayRequest, BindDeviceToGatewayResponse> bindDeviceToGatewaySettings() {
            return this.bindDeviceToGatewaySettings;
        }

        public UnaryCallSettings.Builder<UnbindDeviceFromGatewayRequest, UnbindDeviceFromGatewayResponse> unbindDeviceFromGatewaySettings() {
            return this.unbindDeviceFromGatewaySettings;
        }

        public DeviceManagerStubSettings build() throws IOException {
            return new DeviceManagerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            definitions.put((Object)"retry_policy_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.RESOURCE_EXHAUSTED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)120000L)).setTotalTimeout(Duration.ofMillis((long)120000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)120000L)).setTotalTimeout(Duration.ofMillis((long)120000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)120000L)).setTotalTimeout(Duration.ofMillis((long)120000L)).build();
            definitions.put((Object)"retry_policy_2_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

