/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.config.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.config.v1.ConfigClient;
import com.google.cloud.config.v1.CreateDeploymentRequest;
import com.google.cloud.config.v1.DeleteDeploymentRequest;
import com.google.cloud.config.v1.DeleteStatefileRequest;
import com.google.cloud.config.v1.Deployment;
import com.google.cloud.config.v1.ExportDeploymentStatefileRequest;
import com.google.cloud.config.v1.ExportLockInfoRequest;
import com.google.cloud.config.v1.ExportRevisionStatefileRequest;
import com.google.cloud.config.v1.GetDeploymentRequest;
import com.google.cloud.config.v1.GetResourceRequest;
import com.google.cloud.config.v1.GetRevisionRequest;
import com.google.cloud.config.v1.ImportStatefileRequest;
import com.google.cloud.config.v1.ListDeploymentsRequest;
import com.google.cloud.config.v1.ListDeploymentsResponse;
import com.google.cloud.config.v1.ListResourcesRequest;
import com.google.cloud.config.v1.ListResourcesResponse;
import com.google.cloud.config.v1.ListRevisionsRequest;
import com.google.cloud.config.v1.ListRevisionsResponse;
import com.google.cloud.config.v1.LockDeploymentRequest;
import com.google.cloud.config.v1.LockInfo;
import com.google.cloud.config.v1.OperationMetadata;
import com.google.cloud.config.v1.Resource;
import com.google.cloud.config.v1.Revision;
import com.google.cloud.config.v1.Statefile;
import com.google.cloud.config.v1.UnlockDeploymentRequest;
import com.google.cloud.config.v1.UpdateDeploymentRequest;
import com.google.cloud.config.v1.stub.ConfigStub;
import com.google.cloud.config.v1.stub.GrpcConfigStub;
import com.google.cloud.config.v1.stub.HttpJsonConfigStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ConfigStubSettings
extends StubSettings<ConfigStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListDeploymentsRequest, ListDeploymentsResponse, ConfigClient.ListDeploymentsPagedResponse> listDeploymentsSettings;
    private final UnaryCallSettings<GetDeploymentRequest, Deployment> getDeploymentSettings;
    private final UnaryCallSettings<CreateDeploymentRequest, Operation> createDeploymentSettings;
    private final OperationCallSettings<CreateDeploymentRequest, Deployment, OperationMetadata> createDeploymentOperationSettings;
    private final UnaryCallSettings<UpdateDeploymentRequest, Operation> updateDeploymentSettings;
    private final OperationCallSettings<UpdateDeploymentRequest, Deployment, OperationMetadata> updateDeploymentOperationSettings;
    private final UnaryCallSettings<DeleteDeploymentRequest, Operation> deleteDeploymentSettings;
    private final OperationCallSettings<DeleteDeploymentRequest, Deployment, OperationMetadata> deleteDeploymentOperationSettings;
    private final PagedCallSettings<ListRevisionsRequest, ListRevisionsResponse, ConfigClient.ListRevisionsPagedResponse> listRevisionsSettings;
    private final UnaryCallSettings<GetRevisionRequest, Revision> getRevisionSettings;
    private final UnaryCallSettings<GetResourceRequest, Resource> getResourceSettings;
    private final PagedCallSettings<ListResourcesRequest, ListResourcesResponse, ConfigClient.ListResourcesPagedResponse> listResourcesSettings;
    private final UnaryCallSettings<ExportDeploymentStatefileRequest, Statefile> exportDeploymentStatefileSettings;
    private final UnaryCallSettings<ExportRevisionStatefileRequest, Statefile> exportRevisionStatefileSettings;
    private final UnaryCallSettings<ImportStatefileRequest, Statefile> importStatefileSettings;
    private final UnaryCallSettings<DeleteStatefileRequest, Empty> deleteStatefileSettings;
    private final UnaryCallSettings<LockDeploymentRequest, Operation> lockDeploymentSettings;
    private final OperationCallSettings<LockDeploymentRequest, Deployment, OperationMetadata> lockDeploymentOperationSettings;
    private final UnaryCallSettings<UnlockDeploymentRequest, Operation> unlockDeploymentSettings;
    private final OperationCallSettings<UnlockDeploymentRequest, Deployment, OperationMetadata> unlockDeploymentOperationSettings;
    private final UnaryCallSettings<ExportLockInfoRequest, LockInfo> exportLockInfoSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ConfigClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> LIST_DEPLOYMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListDeploymentsRequest, ListDeploymentsResponse, Deployment>(){

        public String emptyToken() {
            return "";
        }

        public ListDeploymentsRequest injectToken(ListDeploymentsRequest payload, String token) {
            return ListDeploymentsRequest.newBuilder((ListDeploymentsRequest)payload).setPageToken(token).build();
        }

        public ListDeploymentsRequest injectPageSize(ListDeploymentsRequest payload, int pageSize) {
            return ListDeploymentsRequest.newBuilder((ListDeploymentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDeploymentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDeploymentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Deployment> extractResources(ListDeploymentsResponse payload) {
            return payload.getDeploymentsList() == null ? ImmutableList.of() : payload.getDeploymentsList();
        }
    };
    private static final PagedListDescriptor<ListRevisionsRequest, ListRevisionsResponse, Revision> LIST_REVISIONS_PAGE_STR_DESC = new PagedListDescriptor<ListRevisionsRequest, ListRevisionsResponse, Revision>(){

        public String emptyToken() {
            return "";
        }

        public ListRevisionsRequest injectToken(ListRevisionsRequest payload, String token) {
            return ListRevisionsRequest.newBuilder((ListRevisionsRequest)payload).setPageToken(token).build();
        }

        public ListRevisionsRequest injectPageSize(ListRevisionsRequest payload, int pageSize) {
            return ListRevisionsRequest.newBuilder((ListRevisionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRevisionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRevisionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Revision> extractResources(ListRevisionsResponse payload) {
            return payload.getRevisionsList() == null ? ImmutableList.of() : payload.getRevisionsList();
        }
    };
    private static final PagedListDescriptor<ListResourcesRequest, ListResourcesResponse, Resource> LIST_RESOURCES_PAGE_STR_DESC = new PagedListDescriptor<ListResourcesRequest, ListResourcesResponse, Resource>(){

        public String emptyToken() {
            return "";
        }

        public ListResourcesRequest injectToken(ListResourcesRequest payload, String token) {
            return ListResourcesRequest.newBuilder((ListResourcesRequest)payload).setPageToken(token).build();
        }

        public ListResourcesRequest injectPageSize(ListResourcesRequest payload, int pageSize) {
            return ListResourcesRequest.newBuilder((ListResourcesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListResourcesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListResourcesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Resource> extractResources(ListResourcesResponse payload) {
            return payload.getResourcesList() == null ? ImmutableList.of() : payload.getResourcesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListDeploymentsRequest, ListDeploymentsResponse, ConfigClient.ListDeploymentsPagedResponse> LIST_DEPLOYMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListDeploymentsRequest, ListDeploymentsResponse, ConfigClient.ListDeploymentsPagedResponse>(){

        public ApiFuture<ConfigClient.ListDeploymentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDeploymentsRequest, ListDeploymentsResponse> callable, ListDeploymentsRequest request, ApiCallContext context, ApiFuture<ListDeploymentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DEPLOYMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConfigClient.ListDeploymentsPagedResponse.createAsync((PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRevisionsRequest, ListRevisionsResponse, ConfigClient.ListRevisionsPagedResponse> LIST_REVISIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListRevisionsRequest, ListRevisionsResponse, ConfigClient.ListRevisionsPagedResponse>(){

        public ApiFuture<ConfigClient.ListRevisionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRevisionsRequest, ListRevisionsResponse> callable, ListRevisionsRequest request, ApiCallContext context, ApiFuture<ListRevisionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REVISIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConfigClient.ListRevisionsPagedResponse.createAsync((PageContext<ListRevisionsRequest, ListRevisionsResponse, Revision>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListResourcesRequest, ListResourcesResponse, ConfigClient.ListResourcesPagedResponse> LIST_RESOURCES_PAGE_STR_FACT = new PagedListResponseFactory<ListResourcesRequest, ListResourcesResponse, ConfigClient.ListResourcesPagedResponse>(){

        public ApiFuture<ConfigClient.ListResourcesPagedResponse> getFuturePagedResponse(UnaryCallable<ListResourcesRequest, ListResourcesResponse> callable, ListResourcesRequest request, ApiCallContext context, ApiFuture<ListResourcesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RESOURCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConfigClient.ListResourcesPagedResponse.createAsync((PageContext<ListResourcesRequest, ListResourcesResponse, Resource>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ConfigClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ConfigClient.ListLocationsPagedResponse>(){

        public ApiFuture<ConfigClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConfigClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListDeploymentsRequest, ListDeploymentsResponse, ConfigClient.ListDeploymentsPagedResponse> listDeploymentsSettings() {
        return this.listDeploymentsSettings;
    }

    public UnaryCallSettings<GetDeploymentRequest, Deployment> getDeploymentSettings() {
        return this.getDeploymentSettings;
    }

    public UnaryCallSettings<CreateDeploymentRequest, Operation> createDeploymentSettings() {
        return this.createDeploymentSettings;
    }

    public OperationCallSettings<CreateDeploymentRequest, Deployment, OperationMetadata> createDeploymentOperationSettings() {
        return this.createDeploymentOperationSettings;
    }

    public UnaryCallSettings<UpdateDeploymentRequest, Operation> updateDeploymentSettings() {
        return this.updateDeploymentSettings;
    }

    public OperationCallSettings<UpdateDeploymentRequest, Deployment, OperationMetadata> updateDeploymentOperationSettings() {
        return this.updateDeploymentOperationSettings;
    }

    public UnaryCallSettings<DeleteDeploymentRequest, Operation> deleteDeploymentSettings() {
        return this.deleteDeploymentSettings;
    }

    public OperationCallSettings<DeleteDeploymentRequest, Deployment, OperationMetadata> deleteDeploymentOperationSettings() {
        return this.deleteDeploymentOperationSettings;
    }

    public PagedCallSettings<ListRevisionsRequest, ListRevisionsResponse, ConfigClient.ListRevisionsPagedResponse> listRevisionsSettings() {
        return this.listRevisionsSettings;
    }

    public UnaryCallSettings<GetRevisionRequest, Revision> getRevisionSettings() {
        return this.getRevisionSettings;
    }

    public UnaryCallSettings<GetResourceRequest, Resource> getResourceSettings() {
        return this.getResourceSettings;
    }

    public PagedCallSettings<ListResourcesRequest, ListResourcesResponse, ConfigClient.ListResourcesPagedResponse> listResourcesSettings() {
        return this.listResourcesSettings;
    }

    public UnaryCallSettings<ExportDeploymentStatefileRequest, Statefile> exportDeploymentStatefileSettings() {
        return this.exportDeploymentStatefileSettings;
    }

    public UnaryCallSettings<ExportRevisionStatefileRequest, Statefile> exportRevisionStatefileSettings() {
        return this.exportRevisionStatefileSettings;
    }

    public UnaryCallSettings<ImportStatefileRequest, Statefile> importStatefileSettings() {
        return this.importStatefileSettings;
    }

    public UnaryCallSettings<DeleteStatefileRequest, Empty> deleteStatefileSettings() {
        return this.deleteStatefileSettings;
    }

    public UnaryCallSettings<LockDeploymentRequest, Operation> lockDeploymentSettings() {
        return this.lockDeploymentSettings;
    }

    public OperationCallSettings<LockDeploymentRequest, Deployment, OperationMetadata> lockDeploymentOperationSettings() {
        return this.lockDeploymentOperationSettings;
    }

    public UnaryCallSettings<UnlockDeploymentRequest, Operation> unlockDeploymentSettings() {
        return this.unlockDeploymentSettings;
    }

    public OperationCallSettings<UnlockDeploymentRequest, Deployment, OperationMetadata> unlockDeploymentOperationSettings() {
        return this.unlockDeploymentOperationSettings;
    }

    public UnaryCallSettings<ExportLockInfoRequest, LockInfo> exportLockInfoSettings() {
        return this.exportLockInfoSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ConfigClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public ConfigStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcConfigStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonConfigStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "config";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "config.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "config.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ConfigStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConfigStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConfigStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ConfigStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ConfigStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listDeploymentsSettings = settingsBuilder.listDeploymentsSettings().build();
        this.getDeploymentSettings = settingsBuilder.getDeploymentSettings().build();
        this.createDeploymentSettings = settingsBuilder.createDeploymentSettings().build();
        this.createDeploymentOperationSettings = settingsBuilder.createDeploymentOperationSettings().build();
        this.updateDeploymentSettings = settingsBuilder.updateDeploymentSettings().build();
        this.updateDeploymentOperationSettings = settingsBuilder.updateDeploymentOperationSettings().build();
        this.deleteDeploymentSettings = settingsBuilder.deleteDeploymentSettings().build();
        this.deleteDeploymentOperationSettings = settingsBuilder.deleteDeploymentOperationSettings().build();
        this.listRevisionsSettings = settingsBuilder.listRevisionsSettings().build();
        this.getRevisionSettings = settingsBuilder.getRevisionSettings().build();
        this.getResourceSettings = settingsBuilder.getResourceSettings().build();
        this.listResourcesSettings = settingsBuilder.listResourcesSettings().build();
        this.exportDeploymentStatefileSettings = settingsBuilder.exportDeploymentStatefileSettings().build();
        this.exportRevisionStatefileSettings = settingsBuilder.exportRevisionStatefileSettings().build();
        this.importStatefileSettings = settingsBuilder.importStatefileSettings().build();
        this.deleteStatefileSettings = settingsBuilder.deleteStatefileSettings().build();
        this.lockDeploymentSettings = settingsBuilder.lockDeploymentSettings().build();
        this.lockDeploymentOperationSettings = settingsBuilder.lockDeploymentOperationSettings().build();
        this.unlockDeploymentSettings = settingsBuilder.unlockDeploymentSettings().build();
        this.unlockDeploymentOperationSettings = settingsBuilder.unlockDeploymentOperationSettings().build();
        this.exportLockInfoSettings = settingsBuilder.exportLockInfoSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ConfigStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListDeploymentsRequest, ListDeploymentsResponse, ConfigClient.ListDeploymentsPagedResponse> listDeploymentsSettings;
        private final UnaryCallSettings.Builder<GetDeploymentRequest, Deployment> getDeploymentSettings;
        private final UnaryCallSettings.Builder<CreateDeploymentRequest, Operation> createDeploymentSettings;
        private final OperationCallSettings.Builder<CreateDeploymentRequest, Deployment, OperationMetadata> createDeploymentOperationSettings;
        private final UnaryCallSettings.Builder<UpdateDeploymentRequest, Operation> updateDeploymentSettings;
        private final OperationCallSettings.Builder<UpdateDeploymentRequest, Deployment, OperationMetadata> updateDeploymentOperationSettings;
        private final UnaryCallSettings.Builder<DeleteDeploymentRequest, Operation> deleteDeploymentSettings;
        private final OperationCallSettings.Builder<DeleteDeploymentRequest, Deployment, OperationMetadata> deleteDeploymentOperationSettings;
        private final PagedCallSettings.Builder<ListRevisionsRequest, ListRevisionsResponse, ConfigClient.ListRevisionsPagedResponse> listRevisionsSettings;
        private final UnaryCallSettings.Builder<GetRevisionRequest, Revision> getRevisionSettings;
        private final UnaryCallSettings.Builder<GetResourceRequest, Resource> getResourceSettings;
        private final PagedCallSettings.Builder<ListResourcesRequest, ListResourcesResponse, ConfigClient.ListResourcesPagedResponse> listResourcesSettings;
        private final UnaryCallSettings.Builder<ExportDeploymentStatefileRequest, Statefile> exportDeploymentStatefileSettings;
        private final UnaryCallSettings.Builder<ExportRevisionStatefileRequest, Statefile> exportRevisionStatefileSettings;
        private final UnaryCallSettings.Builder<ImportStatefileRequest, Statefile> importStatefileSettings;
        private final UnaryCallSettings.Builder<DeleteStatefileRequest, Empty> deleteStatefileSettings;
        private final UnaryCallSettings.Builder<LockDeploymentRequest, Operation> lockDeploymentSettings;
        private final OperationCallSettings.Builder<LockDeploymentRequest, Deployment, OperationMetadata> lockDeploymentOperationSettings;
        private final UnaryCallSettings.Builder<UnlockDeploymentRequest, Operation> unlockDeploymentSettings;
        private final OperationCallSettings.Builder<UnlockDeploymentRequest, Deployment, OperationMetadata> unlockDeploymentOperationSettings;
        private final UnaryCallSettings.Builder<ExportLockInfoRequest, LockInfo> exportLockInfoSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ConfigClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listDeploymentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DEPLOYMENTS_PAGE_STR_FACT);
            this.getDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDeploymentOperationSettings = OperationCallSettings.newBuilder();
            this.updateDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDeploymentOperationSettings = OperationCallSettings.newBuilder();
            this.deleteDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDeploymentOperationSettings = OperationCallSettings.newBuilder();
            this.listRevisionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REVISIONS_PAGE_STR_FACT);
            this.getRevisionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getResourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listResourcesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RESOURCES_PAGE_STR_FACT);
            this.exportDeploymentStatefileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportRevisionStatefileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importStatefileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteStatefileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.lockDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.lockDeploymentOperationSettings = OperationCallSettings.newBuilder();
            this.unlockDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unlockDeploymentOperationSettings = OperationCallSettings.newBuilder();
            this.exportLockInfoSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDeploymentsSettings, this.getDeploymentSettings, this.createDeploymentSettings, this.updateDeploymentSettings, this.deleteDeploymentSettings, this.listRevisionsSettings, this.getRevisionSettings, this.getResourceSettings, this.listResourcesSettings, this.exportDeploymentStatefileSettings, this.exportRevisionStatefileSettings, this.importStatefileSettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteStatefileSettings, this.lockDeploymentSettings, this.unlockDeploymentSettings, this.exportLockInfoSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(ConfigStubSettings settings) {
            super((StubSettings)settings);
            this.listDeploymentsSettings = settings.listDeploymentsSettings.toBuilder();
            this.getDeploymentSettings = settings.getDeploymentSettings.toBuilder();
            this.createDeploymentSettings = settings.createDeploymentSettings.toBuilder();
            this.createDeploymentOperationSettings = settings.createDeploymentOperationSettings.toBuilder();
            this.updateDeploymentSettings = settings.updateDeploymentSettings.toBuilder();
            this.updateDeploymentOperationSettings = settings.updateDeploymentOperationSettings.toBuilder();
            this.deleteDeploymentSettings = settings.deleteDeploymentSettings.toBuilder();
            this.deleteDeploymentOperationSettings = settings.deleteDeploymentOperationSettings.toBuilder();
            this.listRevisionsSettings = settings.listRevisionsSettings.toBuilder();
            this.getRevisionSettings = settings.getRevisionSettings.toBuilder();
            this.getResourceSettings = settings.getResourceSettings.toBuilder();
            this.listResourcesSettings = settings.listResourcesSettings.toBuilder();
            this.exportDeploymentStatefileSettings = settings.exportDeploymentStatefileSettings.toBuilder();
            this.exportRevisionStatefileSettings = settings.exportRevisionStatefileSettings.toBuilder();
            this.importStatefileSettings = settings.importStatefileSettings.toBuilder();
            this.deleteStatefileSettings = settings.deleteStatefileSettings.toBuilder();
            this.lockDeploymentSettings = settings.lockDeploymentSettings.toBuilder();
            this.lockDeploymentOperationSettings = settings.lockDeploymentOperationSettings.toBuilder();
            this.unlockDeploymentSettings = settings.unlockDeploymentSettings.toBuilder();
            this.unlockDeploymentOperationSettings = settings.unlockDeploymentOperationSettings.toBuilder();
            this.exportLockInfoSettings = settings.exportLockInfoSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDeploymentsSettings, this.getDeploymentSettings, this.createDeploymentSettings, this.updateDeploymentSettings, this.deleteDeploymentSettings, this.listRevisionsSettings, this.getRevisionSettings, this.getResourceSettings, this.listResourcesSettings, this.exportDeploymentStatefileSettings, this.exportRevisionStatefileSettings, this.importStatefileSettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteStatefileSettings, this.lockDeploymentSettings, this.unlockDeploymentSettings, this.exportLockInfoSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ConfigStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ConfigStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConfigStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ConfigStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ConfigStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ConfigStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ConfigStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConfigStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ConfigStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ConfigStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listDeploymentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listRevisionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getRevisionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getResourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listResourcesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.exportDeploymentStatefileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.exportRevisionStatefileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.importStatefileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteStatefileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.lockDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.unlockDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.exportLockInfoSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createDeploymentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Deployment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)300000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)3600000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)43200000L)).build()));
            builder.updateDeploymentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Deployment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)300000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)3600000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)43200000L)).build()));
            builder.deleteDeploymentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Deployment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)300000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)3600000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)43200000L)).build()));
            builder.lockDeploymentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Deployment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.unlockDeploymentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Deployment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListDeploymentsRequest, ListDeploymentsResponse, ConfigClient.ListDeploymentsPagedResponse> listDeploymentsSettings() {
            return this.listDeploymentsSettings;
        }

        public UnaryCallSettings.Builder<GetDeploymentRequest, Deployment> getDeploymentSettings() {
            return this.getDeploymentSettings;
        }

        public UnaryCallSettings.Builder<CreateDeploymentRequest, Operation> createDeploymentSettings() {
            return this.createDeploymentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateDeploymentRequest, Deployment, OperationMetadata> createDeploymentOperationSettings() {
            return this.createDeploymentOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateDeploymentRequest, Operation> updateDeploymentSettings() {
            return this.updateDeploymentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateDeploymentRequest, Deployment, OperationMetadata> updateDeploymentOperationSettings() {
            return this.updateDeploymentOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteDeploymentRequest, Operation> deleteDeploymentSettings() {
            return this.deleteDeploymentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteDeploymentRequest, Deployment, OperationMetadata> deleteDeploymentOperationSettings() {
            return this.deleteDeploymentOperationSettings;
        }

        public PagedCallSettings.Builder<ListRevisionsRequest, ListRevisionsResponse, ConfigClient.ListRevisionsPagedResponse> listRevisionsSettings() {
            return this.listRevisionsSettings;
        }

        public UnaryCallSettings.Builder<GetRevisionRequest, Revision> getRevisionSettings() {
            return this.getRevisionSettings;
        }

        public UnaryCallSettings.Builder<GetResourceRequest, Resource> getResourceSettings() {
            return this.getResourceSettings;
        }

        public PagedCallSettings.Builder<ListResourcesRequest, ListResourcesResponse, ConfigClient.ListResourcesPagedResponse> listResourcesSettings() {
            return this.listResourcesSettings;
        }

        public UnaryCallSettings.Builder<ExportDeploymentStatefileRequest, Statefile> exportDeploymentStatefileSettings() {
            return this.exportDeploymentStatefileSettings;
        }

        public UnaryCallSettings.Builder<ExportRevisionStatefileRequest, Statefile> exportRevisionStatefileSettings() {
            return this.exportRevisionStatefileSettings;
        }

        public UnaryCallSettings.Builder<ImportStatefileRequest, Statefile> importStatefileSettings() {
            return this.importStatefileSettings;
        }

        public UnaryCallSettings.Builder<DeleteStatefileRequest, Empty> deleteStatefileSettings() {
            return this.deleteStatefileSettings;
        }

        public UnaryCallSettings.Builder<LockDeploymentRequest, Operation> lockDeploymentSettings() {
            return this.lockDeploymentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<LockDeploymentRequest, Deployment, OperationMetadata> lockDeploymentOperationSettings() {
            return this.lockDeploymentOperationSettings;
        }

        public UnaryCallSettings.Builder<UnlockDeploymentRequest, Operation> unlockDeploymentSettings() {
            return this.unlockDeploymentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UnlockDeploymentRequest, Deployment, OperationMetadata> unlockDeploymentOperationSettings() {
            return this.unlockDeploymentOperationSettings;
        }

        public UnaryCallSettings.Builder<ExportLockInfoRequest, LockInfo> exportLockInfoSettings() {
            return this.exportLockInfoSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ConfigClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public ConfigStubSettings build() throws IOException {
            return new ConfigStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

