/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.ids.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.ids.v1.CreateEndpointRequest;
import com.google.cloud.ids.v1.DeleteEndpointRequest;
import com.google.cloud.ids.v1.Endpoint;
import com.google.cloud.ids.v1.GetEndpointRequest;
import com.google.cloud.ids.v1.IDSClient;
import com.google.cloud.ids.v1.ListEndpointsRequest;
import com.google.cloud.ids.v1.ListEndpointsResponse;
import com.google.cloud.ids.v1.OperationMetadata;
import com.google.cloud.ids.v1.stub.GrpcIDSCallableFactory;
import com.google.cloud.ids.v1.stub.IDSStub;
import com.google.cloud.ids.v1.stub.IDSStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcIDSStub
extends IDSStub {
    private static final MethodDescriptor<ListEndpointsRequest, ListEndpointsResponse> listEndpointsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.ids.v1.IDS/ListEndpoints").setRequestMarshaller(ProtoUtils.marshaller((Message)ListEndpointsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListEndpointsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetEndpointRequest, Endpoint> getEndpointMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.ids.v1.IDS/GetEndpoint").setRequestMarshaller(ProtoUtils.marshaller((Message)GetEndpointRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Endpoint.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateEndpointRequest, Operation> createEndpointMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.ids.v1.IDS/CreateEndpoint").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateEndpointRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteEndpointRequest, Operation> deleteEndpointMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.ids.v1.IDS/DeleteEndpoint").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteEndpointRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<ListEndpointsRequest, ListEndpointsResponse> listEndpointsCallable;
    private final UnaryCallable<ListEndpointsRequest, IDSClient.ListEndpointsPagedResponse> listEndpointsPagedCallable;
    private final UnaryCallable<GetEndpointRequest, Endpoint> getEndpointCallable;
    private final UnaryCallable<CreateEndpointRequest, Operation> createEndpointCallable;
    private final OperationCallable<CreateEndpointRequest, Endpoint, OperationMetadata> createEndpointOperationCallable;
    private final UnaryCallable<DeleteEndpointRequest, Operation> deleteEndpointCallable;
    private final OperationCallable<DeleteEndpointRequest, Empty, OperationMetadata> deleteEndpointOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcIDSStub create(IDSStubSettings settings) throws IOException {
        return new GrpcIDSStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcIDSStub create(ClientContext clientContext) throws IOException {
        return new GrpcIDSStub(IDSStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcIDSStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcIDSStub(IDSStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcIDSStub(IDSStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcIDSCallableFactory());
    }

    protected GrpcIDSStub(IDSStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listEndpointsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listEndpointsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getEndpointTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getEndpointMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createEndpointTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createEndpointMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteEndpointTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteEndpointMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listEndpointsCallable = callableFactory.createUnaryCallable(listEndpointsTransportSettings, settings.listEndpointsSettings(), clientContext);
        this.listEndpointsPagedCallable = callableFactory.createPagedCallable(listEndpointsTransportSettings, settings.listEndpointsSettings(), clientContext);
        this.getEndpointCallable = callableFactory.createUnaryCallable(getEndpointTransportSettings, settings.getEndpointSettings(), clientContext);
        this.createEndpointCallable = callableFactory.createUnaryCallable(createEndpointTransportSettings, settings.createEndpointSettings(), clientContext);
        this.createEndpointOperationCallable = callableFactory.createOperationCallable(createEndpointTransportSettings, settings.createEndpointOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteEndpointCallable = callableFactory.createUnaryCallable(deleteEndpointTransportSettings, settings.deleteEndpointSettings(), clientContext);
        this.deleteEndpointOperationCallable = callableFactory.createOperationCallable(deleteEndpointTransportSettings, settings.deleteEndpointOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListEndpointsRequest, ListEndpointsResponse> listEndpointsCallable() {
        return this.listEndpointsCallable;
    }

    @Override
    public UnaryCallable<ListEndpointsRequest, IDSClient.ListEndpointsPagedResponse> listEndpointsPagedCallable() {
        return this.listEndpointsPagedCallable;
    }

    @Override
    public UnaryCallable<GetEndpointRequest, Endpoint> getEndpointCallable() {
        return this.getEndpointCallable;
    }

    @Override
    public UnaryCallable<CreateEndpointRequest, Operation> createEndpointCallable() {
        return this.createEndpointCallable;
    }

    @Override
    public OperationCallable<CreateEndpointRequest, Endpoint, OperationMetadata> createEndpointOperationCallable() {
        return this.createEndpointOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteEndpointRequest, Operation> deleteEndpointCallable() {
        return this.deleteEndpointCallable;
    }

    @Override
    public OperationCallable<DeleteEndpointRequest, Empty, OperationMetadata> deleteEndpointOperationCallable() {
        return this.deleteEndpointOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

