/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.ids.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.ids.v1.CreateEndpointRequest;
import com.google.cloud.ids.v1.DeleteEndpointRequest;
import com.google.cloud.ids.v1.Endpoint;
import com.google.cloud.ids.v1.GetEndpointRequest;
import com.google.cloud.ids.v1.IDSClient;
import com.google.cloud.ids.v1.ListEndpointsRequest;
import com.google.cloud.ids.v1.ListEndpointsResponse;
import com.google.cloud.ids.v1.OperationMetadata;
import com.google.cloud.ids.v1.stub.GrpcIDSStub;
import com.google.cloud.ids.v1.stub.HttpJsonIDSStub;
import com.google.cloud.ids.v1.stub.IDSStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class IDSStubSettings
extends StubSettings<IDSStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListEndpointsRequest, ListEndpointsResponse, IDSClient.ListEndpointsPagedResponse> listEndpointsSettings;
    private final UnaryCallSettings<GetEndpointRequest, Endpoint> getEndpointSettings;
    private final UnaryCallSettings<CreateEndpointRequest, Operation> createEndpointSettings;
    private final OperationCallSettings<CreateEndpointRequest, Endpoint, OperationMetadata> createEndpointOperationSettings;
    private final UnaryCallSettings<DeleteEndpointRequest, Operation> deleteEndpointSettings;
    private final OperationCallSettings<DeleteEndpointRequest, Empty, OperationMetadata> deleteEndpointOperationSettings;
    private static final PagedListDescriptor<ListEndpointsRequest, ListEndpointsResponse, Endpoint> LIST_ENDPOINTS_PAGE_STR_DESC = new PagedListDescriptor<ListEndpointsRequest, ListEndpointsResponse, Endpoint>(){

        public String emptyToken() {
            return "";
        }

        public ListEndpointsRequest injectToken(ListEndpointsRequest payload, String token) {
            return ListEndpointsRequest.newBuilder((ListEndpointsRequest)payload).setPageToken(token).build();
        }

        public ListEndpointsRequest injectPageSize(ListEndpointsRequest payload, int pageSize) {
            return ListEndpointsRequest.newBuilder((ListEndpointsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEndpointsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEndpointsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Endpoint> extractResources(ListEndpointsResponse payload) {
            return payload.getEndpointsList() == null ? ImmutableList.of() : payload.getEndpointsList();
        }
    };
    private static final PagedListResponseFactory<ListEndpointsRequest, ListEndpointsResponse, IDSClient.ListEndpointsPagedResponse> LIST_ENDPOINTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEndpointsRequest, ListEndpointsResponse, IDSClient.ListEndpointsPagedResponse>(){

        public ApiFuture<IDSClient.ListEndpointsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEndpointsRequest, ListEndpointsResponse> callable, ListEndpointsRequest request, ApiCallContext context, ApiFuture<ListEndpointsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENDPOINTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return IDSClient.ListEndpointsPagedResponse.createAsync((PageContext<ListEndpointsRequest, ListEndpointsResponse, Endpoint>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListEndpointsRequest, ListEndpointsResponse, IDSClient.ListEndpointsPagedResponse> listEndpointsSettings() {
        return this.listEndpointsSettings;
    }

    public UnaryCallSettings<GetEndpointRequest, Endpoint> getEndpointSettings() {
        return this.getEndpointSettings;
    }

    public UnaryCallSettings<CreateEndpointRequest, Operation> createEndpointSettings() {
        return this.createEndpointSettings;
    }

    public OperationCallSettings<CreateEndpointRequest, Endpoint, OperationMetadata> createEndpointOperationSettings() {
        return this.createEndpointOperationSettings;
    }

    public UnaryCallSettings<DeleteEndpointRequest, Operation> deleteEndpointSettings() {
        return this.deleteEndpointSettings;
    }

    public OperationCallSettings<DeleteEndpointRequest, Empty, OperationMetadata> deleteEndpointOperationSettings() {
        return this.deleteEndpointOperationSettings;
    }

    public IDSStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcIDSStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonIDSStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "ids";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "ids.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "ids.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return IDSStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(IDSStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(IDSStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return IDSStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected IDSStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listEndpointsSettings = settingsBuilder.listEndpointsSettings().build();
        this.getEndpointSettings = settingsBuilder.getEndpointSettings().build();
        this.createEndpointSettings = settingsBuilder.createEndpointSettings().build();
        this.createEndpointOperationSettings = settingsBuilder.createEndpointOperationSettings().build();
        this.deleteEndpointSettings = settingsBuilder.deleteEndpointSettings().build();
        this.deleteEndpointOperationSettings = settingsBuilder.deleteEndpointOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<IDSStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListEndpointsRequest, ListEndpointsResponse, IDSClient.ListEndpointsPagedResponse> listEndpointsSettings;
        private final UnaryCallSettings.Builder<GetEndpointRequest, Endpoint> getEndpointSettings;
        private final UnaryCallSettings.Builder<CreateEndpointRequest, Operation> createEndpointSettings;
        private final OperationCallSettings.Builder<CreateEndpointRequest, Endpoint, OperationMetadata> createEndpointOperationSettings;
        private final UnaryCallSettings.Builder<DeleteEndpointRequest, Operation> deleteEndpointSettings;
        private final OperationCallSettings.Builder<DeleteEndpointRequest, Empty, OperationMetadata> deleteEndpointOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listEndpointsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENDPOINTS_PAGE_STR_FACT);
            this.getEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEndpointOperationSettings = OperationCallSettings.newBuilder();
            this.deleteEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEndpointOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listEndpointsSettings, this.getEndpointSettings, this.createEndpointSettings, this.deleteEndpointSettings);
            Builder.initDefaults(this);
        }

        protected Builder(IDSStubSettings settings) {
            super((StubSettings)settings);
            this.listEndpointsSettings = settings.listEndpointsSettings.toBuilder();
            this.getEndpointSettings = settings.getEndpointSettings.toBuilder();
            this.createEndpointSettings = settings.createEndpointSettings.toBuilder();
            this.createEndpointOperationSettings = settings.createEndpointOperationSettings.toBuilder();
            this.deleteEndpointSettings = settings.deleteEndpointSettings.toBuilder();
            this.deleteEndpointOperationSettings = settings.deleteEndpointOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listEndpointsSettings, this.getEndpointSettings, this.createEndpointSettings, this.deleteEndpointSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(IDSStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)IDSStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)IDSStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(IDSStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)IDSStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)IDSStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)IDSStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(IDSStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listEndpointsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.createEndpointOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Endpoint.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)3600000L)).build()));
            builder.deleteEndpointOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)3600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListEndpointsRequest, ListEndpointsResponse, IDSClient.ListEndpointsPagedResponse> listEndpointsSettings() {
            return this.listEndpointsSettings;
        }

        public UnaryCallSettings.Builder<GetEndpointRequest, Endpoint> getEndpointSettings() {
            return this.getEndpointSettings;
        }

        public UnaryCallSettings.Builder<CreateEndpointRequest, Operation> createEndpointSettings() {
            return this.createEndpointSettings;
        }

        public OperationCallSettings.Builder<CreateEndpointRequest, Endpoint, OperationMetadata> createEndpointOperationSettings() {
            return this.createEndpointOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteEndpointRequest, Operation> deleteEndpointSettings() {
            return this.deleteEndpointSettings;
        }

        public OperationCallSettings.Builder<DeleteEndpointRequest, Empty, OperationMetadata> deleteEndpointOperationSettings() {
            return this.deleteEndpointOperationSettings;
        }

        public IDSStubSettings build() throws IOException {
            return new IDSStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)250L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)32000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)3600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)3600000L)).setTotalTimeout(Duration.ofMillis((long)3600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)3600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)3600000L)).setTotalTimeout(Duration.ofMillis((long)3600000L)).build();
            definitions.put((Object)"no_retry_2_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

