/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hypercomputecluster.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.hypercomputecluster.v1beta.Cluster;
import com.google.cloud.hypercomputecluster.v1beta.CreateClusterRequest;
import com.google.cloud.hypercomputecluster.v1beta.DeleteClusterRequest;
import com.google.cloud.hypercomputecluster.v1beta.GetClusterRequest;
import com.google.cloud.hypercomputecluster.v1beta.HypercomputeClusterClient;
import com.google.cloud.hypercomputecluster.v1beta.ListClustersRequest;
import com.google.cloud.hypercomputecluster.v1beta.ListClustersResponse;
import com.google.cloud.hypercomputecluster.v1beta.OperationMetadata;
import com.google.cloud.hypercomputecluster.v1beta.UpdateClusterRequest;
import com.google.cloud.hypercomputecluster.v1beta.stub.GrpcHypercomputeClusterStub;
import com.google.cloud.hypercomputecluster.v1beta.stub.HttpJsonHypercomputeClusterStub;
import com.google.cloud.hypercomputecluster.v1beta.stub.HypercomputeClusterStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class HypercomputeClusterStubSettings
extends StubSettings<HypercomputeClusterStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListClustersRequest, ListClustersResponse, HypercomputeClusterClient.ListClustersPagedResponse> listClustersSettings;
    private final UnaryCallSettings<GetClusterRequest, Cluster> getClusterSettings;
    private final UnaryCallSettings<CreateClusterRequest, Operation> createClusterSettings;
    private final OperationCallSettings<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationSettings;
    private final UnaryCallSettings<UpdateClusterRequest, Operation> updateClusterSettings;
    private final OperationCallSettings<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationSettings;
    private final UnaryCallSettings<DeleteClusterRequest, Operation> deleteClusterSettings;
    private final OperationCallSettings<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, HypercomputeClusterClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListClustersRequest, ListClustersResponse, Cluster> LIST_CLUSTERS_PAGE_STR_DESC = new PagedListDescriptor<ListClustersRequest, ListClustersResponse, Cluster>(){

        public String emptyToken() {
            return "";
        }

        public ListClustersRequest injectToken(ListClustersRequest payload, String token) {
            return ListClustersRequest.newBuilder((ListClustersRequest)payload).setPageToken(token).build();
        }

        public ListClustersRequest injectPageSize(ListClustersRequest payload, int pageSize) {
            return ListClustersRequest.newBuilder((ListClustersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListClustersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListClustersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Cluster> extractResources(ListClustersResponse payload) {
            return payload.getClustersList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListClustersRequest, ListClustersResponse, HypercomputeClusterClient.ListClustersPagedResponse> LIST_CLUSTERS_PAGE_STR_FACT = new PagedListResponseFactory<ListClustersRequest, ListClustersResponse, HypercomputeClusterClient.ListClustersPagedResponse>(){

        public ApiFuture<HypercomputeClusterClient.ListClustersPagedResponse> getFuturePagedResponse(UnaryCallable<ListClustersRequest, ListClustersResponse> callable, ListClustersRequest request, ApiCallContext context, ApiFuture<ListClustersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CLUSTERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return HypercomputeClusterClient.ListClustersPagedResponse.createAsync((PageContext<ListClustersRequest, ListClustersResponse, Cluster>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, HypercomputeClusterClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, HypercomputeClusterClient.ListLocationsPagedResponse>(){

        public ApiFuture<HypercomputeClusterClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return HypercomputeClusterClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListClustersRequest, ListClustersResponse, HypercomputeClusterClient.ListClustersPagedResponse> listClustersSettings() {
        return this.listClustersSettings;
    }

    public UnaryCallSettings<GetClusterRequest, Cluster> getClusterSettings() {
        return this.getClusterSettings;
    }

    public UnaryCallSettings<CreateClusterRequest, Operation> createClusterSettings() {
        return this.createClusterSettings;
    }

    public OperationCallSettings<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationSettings() {
        return this.createClusterOperationSettings;
    }

    public UnaryCallSettings<UpdateClusterRequest, Operation> updateClusterSettings() {
        return this.updateClusterSettings;
    }

    public OperationCallSettings<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationSettings() {
        return this.updateClusterOperationSettings;
    }

    public UnaryCallSettings<DeleteClusterRequest, Operation> deleteClusterSettings() {
        return this.deleteClusterSettings;
    }

    public OperationCallSettings<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationSettings() {
        return this.deleteClusterOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, HypercomputeClusterClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public HypercomputeClusterStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcHypercomputeClusterStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonHypercomputeClusterStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "hypercomputecluster";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "hypercomputecluster.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "hypercomputecluster.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return HypercomputeClusterStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(HypercomputeClusterStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(HypercomputeClusterStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return HypercomputeClusterStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected HypercomputeClusterStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listClustersSettings = settingsBuilder.listClustersSettings().build();
        this.getClusterSettings = settingsBuilder.getClusterSettings().build();
        this.createClusterSettings = settingsBuilder.createClusterSettings().build();
        this.createClusterOperationSettings = settingsBuilder.createClusterOperationSettings().build();
        this.updateClusterSettings = settingsBuilder.updateClusterSettings().build();
        this.updateClusterOperationSettings = settingsBuilder.updateClusterOperationSettings().build();
        this.deleteClusterSettings = settingsBuilder.deleteClusterSettings().build();
        this.deleteClusterOperationSettings = settingsBuilder.deleteClusterOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<HypercomputeClusterStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListClustersRequest, ListClustersResponse, HypercomputeClusterClient.ListClustersPagedResponse> listClustersSettings;
        private final UnaryCallSettings.Builder<GetClusterRequest, Cluster> getClusterSettings;
        private final UnaryCallSettings.Builder<CreateClusterRequest, Operation> createClusterSettings;
        private final OperationCallSettings.Builder<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationSettings;
        private final UnaryCallSettings.Builder<UpdateClusterRequest, Operation> updateClusterSettings;
        private final OperationCallSettings.Builder<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationSettings;
        private final UnaryCallSettings.Builder<DeleteClusterRequest, Operation> deleteClusterSettings;
        private final OperationCallSettings.Builder<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, HypercomputeClusterClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listClustersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CLUSTERS_PAGE_STR_FACT);
            this.getClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createClusterOperationSettings = OperationCallSettings.newBuilder();
            this.updateClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateClusterOperationSettings = OperationCallSettings.newBuilder();
            this.deleteClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteClusterOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listClustersSettings, this.getClusterSettings, this.createClusterSettings, this.updateClusterSettings, this.deleteClusterSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(HypercomputeClusterStubSettings settings) {
            super((StubSettings)settings);
            this.listClustersSettings = settings.listClustersSettings.toBuilder();
            this.getClusterSettings = settings.getClusterSettings.toBuilder();
            this.createClusterSettings = settings.createClusterSettings.toBuilder();
            this.createClusterOperationSettings = settings.createClusterOperationSettings.toBuilder();
            this.updateClusterSettings = settings.updateClusterSettings.toBuilder();
            this.updateClusterOperationSettings = settings.updateClusterOperationSettings.toBuilder();
            this.deleteClusterSettings = settings.deleteClusterSettings.toBuilder();
            this.deleteClusterOperationSettings = settings.deleteClusterOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listClustersSettings, this.getClusterSettings, this.createClusterSettings, this.updateClusterSettings, this.deleteClusterSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(HypercomputeClusterStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)HypercomputeClusterStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)HypercomputeClusterStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(HypercomputeClusterStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)HypercomputeClusterStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)HypercomputeClusterStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)HypercomputeClusterStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(HypercomputeClusterStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listClustersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Cluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Cluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListClustersRequest, ListClustersResponse, HypercomputeClusterClient.ListClustersPagedResponse> listClustersSettings() {
            return this.listClustersSettings;
        }

        public UnaryCallSettings.Builder<GetClusterRequest, Cluster> getClusterSettings() {
            return this.getClusterSettings;
        }

        public UnaryCallSettings.Builder<CreateClusterRequest, Operation> createClusterSettings() {
            return this.createClusterSettings;
        }

        public OperationCallSettings.Builder<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationSettings() {
            return this.createClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateClusterRequest, Operation> updateClusterSettings() {
            return this.updateClusterSettings;
        }

        public OperationCallSettings.Builder<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationSettings() {
            return this.updateClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteClusterRequest, Operation> deleteClusterSettings() {
            return this.deleteClusterSettings;
        }

        public OperationCallSettings.Builder<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationSettings() {
            return this.deleteClusterOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, HypercomputeClusterClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public HypercomputeClusterStubSettings build() throws IOException {
            return new HypercomputeClusterStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(3600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(3600000L)).setTotalTimeoutDuration(Duration.ofMillis(3600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

