/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkehub.v1alpha.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gkehub.v1alpha.CreateFeatureRequest;
import com.google.cloud.gkehub.v1alpha.DeleteFeatureRequest;
import com.google.cloud.gkehub.v1alpha.Feature;
import com.google.cloud.gkehub.v1alpha.GetFeatureRequest;
import com.google.cloud.gkehub.v1alpha.GkeHubClient;
import com.google.cloud.gkehub.v1alpha.ListFeaturesRequest;
import com.google.cloud.gkehub.v1alpha.ListFeaturesResponse;
import com.google.cloud.gkehub.v1alpha.OperationMetadata;
import com.google.cloud.gkehub.v1alpha.UpdateFeatureRequest;
import com.google.cloud.gkehub.v1alpha.stub.GkeHubStub;
import com.google.cloud.gkehub.v1alpha.stub.GrpcGkeHubStub;
import com.google.cloud.gkehub.v1alpha.stub.HttpJsonGkeHubStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class GkeHubStubSettings
extends StubSettings<GkeHubStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListFeaturesRequest, ListFeaturesResponse, GkeHubClient.ListFeaturesPagedResponse> listFeaturesSettings;
    private final UnaryCallSettings<GetFeatureRequest, Feature> getFeatureSettings;
    private final UnaryCallSettings<CreateFeatureRequest, Operation> createFeatureSettings;
    private final OperationCallSettings<CreateFeatureRequest, Feature, OperationMetadata> createFeatureOperationSettings;
    private final UnaryCallSettings<DeleteFeatureRequest, Operation> deleteFeatureSettings;
    private final OperationCallSettings<DeleteFeatureRequest, Empty, OperationMetadata> deleteFeatureOperationSettings;
    private final UnaryCallSettings<UpdateFeatureRequest, Operation> updateFeatureSettings;
    private final OperationCallSettings<UpdateFeatureRequest, Feature, OperationMetadata> updateFeatureOperationSettings;
    private static final PagedListDescriptor<ListFeaturesRequest, ListFeaturesResponse, Feature> LIST_FEATURES_PAGE_STR_DESC = new PagedListDescriptor<ListFeaturesRequest, ListFeaturesResponse, Feature>(){

        public String emptyToken() {
            return "";
        }

        public ListFeaturesRequest injectToken(ListFeaturesRequest payload, String token) {
            return ListFeaturesRequest.newBuilder((ListFeaturesRequest)payload).setPageToken(token).build();
        }

        public ListFeaturesRequest injectPageSize(ListFeaturesRequest payload, int pageSize) {
            return ListFeaturesRequest.newBuilder((ListFeaturesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListFeaturesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListFeaturesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Feature> extractResources(ListFeaturesResponse payload) {
            return payload.getResourcesList() == null ? ImmutableList.of() : payload.getResourcesList();
        }
    };
    private static final PagedListResponseFactory<ListFeaturesRequest, ListFeaturesResponse, GkeHubClient.ListFeaturesPagedResponse> LIST_FEATURES_PAGE_STR_FACT = new PagedListResponseFactory<ListFeaturesRequest, ListFeaturesResponse, GkeHubClient.ListFeaturesPagedResponse>(){

        public ApiFuture<GkeHubClient.ListFeaturesPagedResponse> getFuturePagedResponse(UnaryCallable<ListFeaturesRequest, ListFeaturesResponse> callable, ListFeaturesRequest request, ApiCallContext context, ApiFuture<ListFeaturesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FEATURES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GkeHubClient.ListFeaturesPagedResponse.createAsync((PageContext<ListFeaturesRequest, ListFeaturesResponse, Feature>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListFeaturesRequest, ListFeaturesResponse, GkeHubClient.ListFeaturesPagedResponse> listFeaturesSettings() {
        return this.listFeaturesSettings;
    }

    public UnaryCallSettings<GetFeatureRequest, Feature> getFeatureSettings() {
        return this.getFeatureSettings;
    }

    public UnaryCallSettings<CreateFeatureRequest, Operation> createFeatureSettings() {
        return this.createFeatureSettings;
    }

    public OperationCallSettings<CreateFeatureRequest, Feature, OperationMetadata> createFeatureOperationSettings() {
        return this.createFeatureOperationSettings;
    }

    public UnaryCallSettings<DeleteFeatureRequest, Operation> deleteFeatureSettings() {
        return this.deleteFeatureSettings;
    }

    public OperationCallSettings<DeleteFeatureRequest, Empty, OperationMetadata> deleteFeatureOperationSettings() {
        return this.deleteFeatureOperationSettings;
    }

    public UnaryCallSettings<UpdateFeatureRequest, Operation> updateFeatureSettings() {
        return this.updateFeatureSettings;
    }

    public OperationCallSettings<UpdateFeatureRequest, Feature, OperationMetadata> updateFeatureOperationSettings() {
        return this.updateFeatureOperationSettings;
    }

    public GkeHubStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcGkeHubStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonGkeHubStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return GkeHubStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "gkehub";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "gkehub.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "gkehub.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return GkeHubStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GkeHubStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GkeHubStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return GkeHubStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected GkeHubStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listFeaturesSettings = settingsBuilder.listFeaturesSettings().build();
        this.getFeatureSettings = settingsBuilder.getFeatureSettings().build();
        this.createFeatureSettings = settingsBuilder.createFeatureSettings().build();
        this.createFeatureOperationSettings = settingsBuilder.createFeatureOperationSettings().build();
        this.deleteFeatureSettings = settingsBuilder.deleteFeatureSettings().build();
        this.deleteFeatureOperationSettings = settingsBuilder.deleteFeatureOperationSettings().build();
        this.updateFeatureSettings = settingsBuilder.updateFeatureSettings().build();
        this.updateFeatureOperationSettings = settingsBuilder.updateFeatureOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<GkeHubStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListFeaturesRequest, ListFeaturesResponse, GkeHubClient.ListFeaturesPagedResponse> listFeaturesSettings;
        private final UnaryCallSettings.Builder<GetFeatureRequest, Feature> getFeatureSettings;
        private final UnaryCallSettings.Builder<CreateFeatureRequest, Operation> createFeatureSettings;
        private final OperationCallSettings.Builder<CreateFeatureRequest, Feature, OperationMetadata> createFeatureOperationSettings;
        private final UnaryCallSettings.Builder<DeleteFeatureRequest, Operation> deleteFeatureSettings;
        private final OperationCallSettings.Builder<DeleteFeatureRequest, Empty, OperationMetadata> deleteFeatureOperationSettings;
        private final UnaryCallSettings.Builder<UpdateFeatureRequest, Operation> updateFeatureSettings;
        private final OperationCallSettings.Builder<UpdateFeatureRequest, Feature, OperationMetadata> updateFeatureOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listFeaturesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FEATURES_PAGE_STR_FACT);
            this.getFeatureSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createFeatureSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createFeatureOperationSettings = OperationCallSettings.newBuilder();
            this.deleteFeatureSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteFeatureOperationSettings = OperationCallSettings.newBuilder();
            this.updateFeatureSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateFeatureOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listFeaturesSettings, this.getFeatureSettings, this.createFeatureSettings, this.deleteFeatureSettings, this.updateFeatureSettings);
            Builder.initDefaults(this);
        }

        protected Builder(GkeHubStubSettings settings) {
            super((StubSettings)settings);
            this.listFeaturesSettings = settings.listFeaturesSettings.toBuilder();
            this.getFeatureSettings = settings.getFeatureSettings.toBuilder();
            this.createFeatureSettings = settings.createFeatureSettings.toBuilder();
            this.createFeatureOperationSettings = settings.createFeatureOperationSettings.toBuilder();
            this.deleteFeatureSettings = settings.deleteFeatureSettings.toBuilder();
            this.deleteFeatureOperationSettings = settings.deleteFeatureOperationSettings.toBuilder();
            this.updateFeatureSettings = settings.updateFeatureSettings.toBuilder();
            this.updateFeatureOperationSettings = settings.updateFeatureOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listFeaturesSettings, this.getFeatureSettings, this.createFeatureSettings, this.deleteFeatureSettings, this.updateFeatureSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(GkeHubStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)GkeHubStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GkeHubStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(GkeHubStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)GkeHubStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)GkeHubStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GkeHubStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(GkeHubStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listFeaturesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getFeatureSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createFeatureSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteFeatureSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateFeatureSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createFeatureOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Feature.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteFeatureOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateFeatureOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Feature.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListFeaturesRequest, ListFeaturesResponse, GkeHubClient.ListFeaturesPagedResponse> listFeaturesSettings() {
            return this.listFeaturesSettings;
        }

        public UnaryCallSettings.Builder<GetFeatureRequest, Feature> getFeatureSettings() {
            return this.getFeatureSettings;
        }

        public UnaryCallSettings.Builder<CreateFeatureRequest, Operation> createFeatureSettings() {
            return this.createFeatureSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateFeatureRequest, Feature, OperationMetadata> createFeatureOperationSettings() {
            return this.createFeatureOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteFeatureRequest, Operation> deleteFeatureSettings() {
            return this.deleteFeatureSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteFeatureRequest, Empty, OperationMetadata> deleteFeatureOperationSettings() {
            return this.deleteFeatureOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateFeatureRequest, Operation> updateFeatureSettings() {
            return this.updateFeatureSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateFeatureRequest, Feature, OperationMetadata> updateFeatureOperationSettings() {
            return this.updateFeatureOperationSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return GkeHubStubSettings.getDefaultEndpoint();
        }

        public GkeHubStubSettings build() throws IOException {
            return new GkeHubStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

