/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkebackup.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gkebackup.v1.Backup;
import com.google.cloud.gkebackup.v1.BackupChannel;
import com.google.cloud.gkebackup.v1.BackupChannelName;
import com.google.cloud.gkebackup.v1.BackupForGKESettings;
import com.google.cloud.gkebackup.v1.BackupName;
import com.google.cloud.gkebackup.v1.BackupPlan;
import com.google.cloud.gkebackup.v1.BackupPlanBinding;
import com.google.cloud.gkebackup.v1.BackupPlanBindingName;
import com.google.cloud.gkebackup.v1.BackupPlanName;
import com.google.cloud.gkebackup.v1.CreateBackupChannelRequest;
import com.google.cloud.gkebackup.v1.CreateBackupPlanRequest;
import com.google.cloud.gkebackup.v1.CreateBackupRequest;
import com.google.cloud.gkebackup.v1.CreateRestoreChannelRequest;
import com.google.cloud.gkebackup.v1.CreateRestorePlanRequest;
import com.google.cloud.gkebackup.v1.CreateRestoreRequest;
import com.google.cloud.gkebackup.v1.DeleteBackupChannelRequest;
import com.google.cloud.gkebackup.v1.DeleteBackupPlanRequest;
import com.google.cloud.gkebackup.v1.DeleteBackupRequest;
import com.google.cloud.gkebackup.v1.DeleteRestoreChannelRequest;
import com.google.cloud.gkebackup.v1.DeleteRestorePlanRequest;
import com.google.cloud.gkebackup.v1.DeleteRestoreRequest;
import com.google.cloud.gkebackup.v1.GetBackupChannelRequest;
import com.google.cloud.gkebackup.v1.GetBackupIndexDownloadUrlRequest;
import com.google.cloud.gkebackup.v1.GetBackupIndexDownloadUrlResponse;
import com.google.cloud.gkebackup.v1.GetBackupPlanBindingRequest;
import com.google.cloud.gkebackup.v1.GetBackupPlanRequest;
import com.google.cloud.gkebackup.v1.GetBackupRequest;
import com.google.cloud.gkebackup.v1.GetRestoreChannelRequest;
import com.google.cloud.gkebackup.v1.GetRestorePlanBindingRequest;
import com.google.cloud.gkebackup.v1.GetRestorePlanRequest;
import com.google.cloud.gkebackup.v1.GetRestoreRequest;
import com.google.cloud.gkebackup.v1.GetVolumeBackupRequest;
import com.google.cloud.gkebackup.v1.GetVolumeRestoreRequest;
import com.google.cloud.gkebackup.v1.ListBackupChannelsRequest;
import com.google.cloud.gkebackup.v1.ListBackupChannelsResponse;
import com.google.cloud.gkebackup.v1.ListBackupPlanBindingsRequest;
import com.google.cloud.gkebackup.v1.ListBackupPlanBindingsResponse;
import com.google.cloud.gkebackup.v1.ListBackupPlansRequest;
import com.google.cloud.gkebackup.v1.ListBackupPlansResponse;
import com.google.cloud.gkebackup.v1.ListBackupsRequest;
import com.google.cloud.gkebackup.v1.ListBackupsResponse;
import com.google.cloud.gkebackup.v1.ListRestoreChannelsRequest;
import com.google.cloud.gkebackup.v1.ListRestoreChannelsResponse;
import com.google.cloud.gkebackup.v1.ListRestorePlanBindingsRequest;
import com.google.cloud.gkebackup.v1.ListRestorePlanBindingsResponse;
import com.google.cloud.gkebackup.v1.ListRestorePlansRequest;
import com.google.cloud.gkebackup.v1.ListRestorePlansResponse;
import com.google.cloud.gkebackup.v1.ListRestoresRequest;
import com.google.cloud.gkebackup.v1.ListRestoresResponse;
import com.google.cloud.gkebackup.v1.ListVolumeBackupsRequest;
import com.google.cloud.gkebackup.v1.ListVolumeBackupsResponse;
import com.google.cloud.gkebackup.v1.ListVolumeRestoresRequest;
import com.google.cloud.gkebackup.v1.ListVolumeRestoresResponse;
import com.google.cloud.gkebackup.v1.LocationName;
import com.google.cloud.gkebackup.v1.OperationMetadata;
import com.google.cloud.gkebackup.v1.Restore;
import com.google.cloud.gkebackup.v1.RestoreChannel;
import com.google.cloud.gkebackup.v1.RestoreChannelName;
import com.google.cloud.gkebackup.v1.RestoreName;
import com.google.cloud.gkebackup.v1.RestorePlan;
import com.google.cloud.gkebackup.v1.RestorePlanBinding;
import com.google.cloud.gkebackup.v1.RestorePlanBindingName;
import com.google.cloud.gkebackup.v1.RestorePlanName;
import com.google.cloud.gkebackup.v1.UpdateBackupChannelRequest;
import com.google.cloud.gkebackup.v1.UpdateBackupPlanRequest;
import com.google.cloud.gkebackup.v1.UpdateBackupRequest;
import com.google.cloud.gkebackup.v1.UpdateRestoreChannelRequest;
import com.google.cloud.gkebackup.v1.UpdateRestorePlanRequest;
import com.google.cloud.gkebackup.v1.UpdateRestoreRequest;
import com.google.cloud.gkebackup.v1.VolumeBackup;
import com.google.cloud.gkebackup.v1.VolumeBackupName;
import com.google.cloud.gkebackup.v1.VolumeRestore;
import com.google.cloud.gkebackup.v1.VolumeRestoreName;
import com.google.cloud.gkebackup.v1.stub.BackupForGKEStub;
import com.google.cloud.gkebackup.v1.stub.BackupForGKEStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class BackupForGKEClient
implements BackgroundResource {
    private final BackupForGKESettings settings;
    private final BackupForGKEStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final BackupForGKEClient create() throws IOException {
        return BackupForGKEClient.create(BackupForGKESettings.newBuilder().build());
    }

    public static final BackupForGKEClient create(BackupForGKESettings settings) throws IOException {
        return new BackupForGKEClient(settings);
    }

    public static final BackupForGKEClient create(BackupForGKEStub stub) {
        return new BackupForGKEClient(stub);
    }

    protected BackupForGKEClient(BackupForGKESettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BackupForGKEStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected BackupForGKEClient(BackupForGKEStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final BackupForGKESettings getSettings() {
        return this.settings;
    }

    public BackupForGKEStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<BackupPlan, OperationMetadata> createBackupPlanAsync(LocationName parent, BackupPlan backupPlan, String backupPlanId) {
        CreateBackupPlanRequest request = CreateBackupPlanRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBackupPlan(backupPlan).setBackupPlanId(backupPlanId).build();
        return this.createBackupPlanAsync(request);
    }

    public final OperationFuture<BackupPlan, OperationMetadata> createBackupPlanAsync(String parent, BackupPlan backupPlan, String backupPlanId) {
        CreateBackupPlanRequest request = CreateBackupPlanRequest.newBuilder().setParent(parent).setBackupPlan(backupPlan).setBackupPlanId(backupPlanId).build();
        return this.createBackupPlanAsync(request);
    }

    public final OperationFuture<BackupPlan, OperationMetadata> createBackupPlanAsync(CreateBackupPlanRequest request) {
        return this.createBackupPlanOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateBackupPlanRequest, BackupPlan, OperationMetadata> createBackupPlanOperationCallable() {
        return this.stub.createBackupPlanOperationCallable();
    }

    public final UnaryCallable<CreateBackupPlanRequest, Operation> createBackupPlanCallable() {
        return this.stub.createBackupPlanCallable();
    }

    public final ListBackupPlansPagedResponse listBackupPlans(LocationName parent) {
        ListBackupPlansRequest request = ListBackupPlansRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBackupPlans(request);
    }

    public final ListBackupPlansPagedResponse listBackupPlans(String parent) {
        ListBackupPlansRequest request = ListBackupPlansRequest.newBuilder().setParent(parent).build();
        return this.listBackupPlans(request);
    }

    public final ListBackupPlansPagedResponse listBackupPlans(ListBackupPlansRequest request) {
        return (ListBackupPlansPagedResponse)((Object)this.listBackupPlansPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBackupPlansRequest, ListBackupPlansPagedResponse> listBackupPlansPagedCallable() {
        return this.stub.listBackupPlansPagedCallable();
    }

    public final UnaryCallable<ListBackupPlansRequest, ListBackupPlansResponse> listBackupPlansCallable() {
        return this.stub.listBackupPlansCallable();
    }

    public final BackupPlan getBackupPlan(BackupPlanName name) {
        GetBackupPlanRequest request = GetBackupPlanRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBackupPlan(request);
    }

    public final BackupPlan getBackupPlan(String name) {
        GetBackupPlanRequest request = GetBackupPlanRequest.newBuilder().setName(name).build();
        return this.getBackupPlan(request);
    }

    public final BackupPlan getBackupPlan(GetBackupPlanRequest request) {
        return (BackupPlan)this.getBackupPlanCallable().call((Object)request);
    }

    public final UnaryCallable<GetBackupPlanRequest, BackupPlan> getBackupPlanCallable() {
        return this.stub.getBackupPlanCallable();
    }

    public final OperationFuture<BackupPlan, OperationMetadata> updateBackupPlanAsync(BackupPlan backupPlan, FieldMask updateMask) {
        UpdateBackupPlanRequest request = UpdateBackupPlanRequest.newBuilder().setBackupPlan(backupPlan).setUpdateMask(updateMask).build();
        return this.updateBackupPlanAsync(request);
    }

    public final OperationFuture<BackupPlan, OperationMetadata> updateBackupPlanAsync(UpdateBackupPlanRequest request) {
        return this.updateBackupPlanOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateBackupPlanRequest, BackupPlan, OperationMetadata> updateBackupPlanOperationCallable() {
        return this.stub.updateBackupPlanOperationCallable();
    }

    public final UnaryCallable<UpdateBackupPlanRequest, Operation> updateBackupPlanCallable() {
        return this.stub.updateBackupPlanCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupPlanAsync(BackupPlanName name) {
        DeleteBackupPlanRequest request = DeleteBackupPlanRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteBackupPlanAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupPlanAsync(String name) {
        DeleteBackupPlanRequest request = DeleteBackupPlanRequest.newBuilder().setName(name).build();
        return this.deleteBackupPlanAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupPlanAsync(DeleteBackupPlanRequest request) {
        return this.deleteBackupPlanOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteBackupPlanRequest, Empty, OperationMetadata> deleteBackupPlanOperationCallable() {
        return this.stub.deleteBackupPlanOperationCallable();
    }

    public final UnaryCallable<DeleteBackupPlanRequest, Operation> deleteBackupPlanCallable() {
        return this.stub.deleteBackupPlanCallable();
    }

    public final OperationFuture<BackupChannel, OperationMetadata> createBackupChannelAsync(LocationName parent, BackupChannel backupChannel, String backupChannelId) {
        CreateBackupChannelRequest request = CreateBackupChannelRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBackupChannel(backupChannel).setBackupChannelId(backupChannelId).build();
        return this.createBackupChannelAsync(request);
    }

    public final OperationFuture<BackupChannel, OperationMetadata> createBackupChannelAsync(String parent, BackupChannel backupChannel, String backupChannelId) {
        CreateBackupChannelRequest request = CreateBackupChannelRequest.newBuilder().setParent(parent).setBackupChannel(backupChannel).setBackupChannelId(backupChannelId).build();
        return this.createBackupChannelAsync(request);
    }

    public final OperationFuture<BackupChannel, OperationMetadata> createBackupChannelAsync(CreateBackupChannelRequest request) {
        return this.createBackupChannelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateBackupChannelRequest, BackupChannel, OperationMetadata> createBackupChannelOperationCallable() {
        return this.stub.createBackupChannelOperationCallable();
    }

    public final UnaryCallable<CreateBackupChannelRequest, Operation> createBackupChannelCallable() {
        return this.stub.createBackupChannelCallable();
    }

    public final ListBackupChannelsPagedResponse listBackupChannels(LocationName parent) {
        ListBackupChannelsRequest request = ListBackupChannelsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBackupChannels(request);
    }

    public final ListBackupChannelsPagedResponse listBackupChannels(String parent) {
        ListBackupChannelsRequest request = ListBackupChannelsRequest.newBuilder().setParent(parent).build();
        return this.listBackupChannels(request);
    }

    public final ListBackupChannelsPagedResponse listBackupChannels(ListBackupChannelsRequest request) {
        return (ListBackupChannelsPagedResponse)((Object)this.listBackupChannelsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBackupChannelsRequest, ListBackupChannelsPagedResponse> listBackupChannelsPagedCallable() {
        return this.stub.listBackupChannelsPagedCallable();
    }

    public final UnaryCallable<ListBackupChannelsRequest, ListBackupChannelsResponse> listBackupChannelsCallable() {
        return this.stub.listBackupChannelsCallable();
    }

    public final BackupChannel getBackupChannel(BackupChannelName name) {
        GetBackupChannelRequest request = GetBackupChannelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBackupChannel(request);
    }

    public final BackupChannel getBackupChannel(String name) {
        GetBackupChannelRequest request = GetBackupChannelRequest.newBuilder().setName(name).build();
        return this.getBackupChannel(request);
    }

    public final BackupChannel getBackupChannel(GetBackupChannelRequest request) {
        return (BackupChannel)this.getBackupChannelCallable().call((Object)request);
    }

    public final UnaryCallable<GetBackupChannelRequest, BackupChannel> getBackupChannelCallable() {
        return this.stub.getBackupChannelCallable();
    }

    public final OperationFuture<BackupChannel, OperationMetadata> updateBackupChannelAsync(BackupChannel backupChannel, FieldMask updateMask) {
        UpdateBackupChannelRequest request = UpdateBackupChannelRequest.newBuilder().setBackupChannel(backupChannel).setUpdateMask(updateMask).build();
        return this.updateBackupChannelAsync(request);
    }

    public final OperationFuture<BackupChannel, OperationMetadata> updateBackupChannelAsync(UpdateBackupChannelRequest request) {
        return this.updateBackupChannelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateBackupChannelRequest, BackupChannel, OperationMetadata> updateBackupChannelOperationCallable() {
        return this.stub.updateBackupChannelOperationCallable();
    }

    public final UnaryCallable<UpdateBackupChannelRequest, Operation> updateBackupChannelCallable() {
        return this.stub.updateBackupChannelCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupChannelAsync(BackupChannelName name) {
        DeleteBackupChannelRequest request = DeleteBackupChannelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteBackupChannelAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupChannelAsync(String name) {
        DeleteBackupChannelRequest request = DeleteBackupChannelRequest.newBuilder().setName(name).build();
        return this.deleteBackupChannelAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupChannelAsync(DeleteBackupChannelRequest request) {
        return this.deleteBackupChannelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteBackupChannelRequest, Empty, OperationMetadata> deleteBackupChannelOperationCallable() {
        return this.stub.deleteBackupChannelOperationCallable();
    }

    public final UnaryCallable<DeleteBackupChannelRequest, Operation> deleteBackupChannelCallable() {
        return this.stub.deleteBackupChannelCallable();
    }

    public final ListBackupPlanBindingsPagedResponse listBackupPlanBindings(BackupChannelName parent) {
        ListBackupPlanBindingsRequest request = ListBackupPlanBindingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBackupPlanBindings(request);
    }

    public final ListBackupPlanBindingsPagedResponse listBackupPlanBindings(String parent) {
        ListBackupPlanBindingsRequest request = ListBackupPlanBindingsRequest.newBuilder().setParent(parent).build();
        return this.listBackupPlanBindings(request);
    }

    public final ListBackupPlanBindingsPagedResponse listBackupPlanBindings(ListBackupPlanBindingsRequest request) {
        return (ListBackupPlanBindingsPagedResponse)((Object)this.listBackupPlanBindingsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBackupPlanBindingsRequest, ListBackupPlanBindingsPagedResponse> listBackupPlanBindingsPagedCallable() {
        return this.stub.listBackupPlanBindingsPagedCallable();
    }

    public final UnaryCallable<ListBackupPlanBindingsRequest, ListBackupPlanBindingsResponse> listBackupPlanBindingsCallable() {
        return this.stub.listBackupPlanBindingsCallable();
    }

    public final BackupPlanBinding getBackupPlanBinding(BackupPlanBindingName name) {
        GetBackupPlanBindingRequest request = GetBackupPlanBindingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBackupPlanBinding(request);
    }

    public final BackupPlanBinding getBackupPlanBinding(String name) {
        GetBackupPlanBindingRequest request = GetBackupPlanBindingRequest.newBuilder().setName(name).build();
        return this.getBackupPlanBinding(request);
    }

    public final BackupPlanBinding getBackupPlanBinding(GetBackupPlanBindingRequest request) {
        return (BackupPlanBinding)this.getBackupPlanBindingCallable().call((Object)request);
    }

    public final UnaryCallable<GetBackupPlanBindingRequest, BackupPlanBinding> getBackupPlanBindingCallable() {
        return this.stub.getBackupPlanBindingCallable();
    }

    public final OperationFuture<Backup, OperationMetadata> createBackupAsync(BackupPlanName parent, Backup backup, String backupId) {
        CreateBackupRequest request = CreateBackupRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBackup(backup).setBackupId(backupId).build();
        return this.createBackupAsync(request);
    }

    public final OperationFuture<Backup, OperationMetadata> createBackupAsync(String parent, Backup backup, String backupId) {
        CreateBackupRequest request = CreateBackupRequest.newBuilder().setParent(parent).setBackup(backup).setBackupId(backupId).build();
        return this.createBackupAsync(request);
    }

    public final OperationFuture<Backup, OperationMetadata> createBackupAsync(CreateBackupRequest request) {
        return this.createBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationCallable() {
        return this.stub.createBackupOperationCallable();
    }

    public final UnaryCallable<CreateBackupRequest, Operation> createBackupCallable() {
        return this.stub.createBackupCallable();
    }

    public final ListBackupsPagedResponse listBackups(BackupPlanName parent) {
        ListBackupsRequest request = ListBackupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBackups(request);
    }

    public final ListBackupsPagedResponse listBackups(String parent) {
        ListBackupsRequest request = ListBackupsRequest.newBuilder().setParent(parent).build();
        return this.listBackups(request);
    }

    public final ListBackupsPagedResponse listBackups(ListBackupsRequest request) {
        return (ListBackupsPagedResponse)((Object)this.listBackupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBackupsRequest, ListBackupsPagedResponse> listBackupsPagedCallable() {
        return this.stub.listBackupsPagedCallable();
    }

    public final UnaryCallable<ListBackupsRequest, ListBackupsResponse> listBackupsCallable() {
        return this.stub.listBackupsCallable();
    }

    public final Backup getBackup(BackupName name) {
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBackup(request);
    }

    public final Backup getBackup(String name) {
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(name).build();
        return this.getBackup(request);
    }

    public final Backup getBackup(GetBackupRequest request) {
        return (Backup)this.getBackupCallable().call((Object)request);
    }

    public final UnaryCallable<GetBackupRequest, Backup> getBackupCallable() {
        return this.stub.getBackupCallable();
    }

    public final OperationFuture<Backup, OperationMetadata> updateBackupAsync(Backup backup, FieldMask updateMask) {
        UpdateBackupRequest request = UpdateBackupRequest.newBuilder().setBackup(backup).setUpdateMask(updateMask).build();
        return this.updateBackupAsync(request);
    }

    public final OperationFuture<Backup, OperationMetadata> updateBackupAsync(UpdateBackupRequest request) {
        return this.updateBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationCallable() {
        return this.stub.updateBackupOperationCallable();
    }

    public final UnaryCallable<UpdateBackupRequest, Operation> updateBackupCallable() {
        return this.stub.updateBackupCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupAsync(BackupName name) {
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteBackupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupAsync(String name) {
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(name).build();
        return this.deleteBackupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupAsync(DeleteBackupRequest request) {
        return this.deleteBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationCallable() {
        return this.stub.deleteBackupOperationCallable();
    }

    public final UnaryCallable<DeleteBackupRequest, Operation> deleteBackupCallable() {
        return this.stub.deleteBackupCallable();
    }

    public final ListVolumeBackupsPagedResponse listVolumeBackups(BackupName parent) {
        ListVolumeBackupsRequest request = ListVolumeBackupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listVolumeBackups(request);
    }

    public final ListVolumeBackupsPagedResponse listVolumeBackups(String parent) {
        ListVolumeBackupsRequest request = ListVolumeBackupsRequest.newBuilder().setParent(parent).build();
        return this.listVolumeBackups(request);
    }

    public final ListVolumeBackupsPagedResponse listVolumeBackups(ListVolumeBackupsRequest request) {
        return (ListVolumeBackupsPagedResponse)((Object)this.listVolumeBackupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVolumeBackupsRequest, ListVolumeBackupsPagedResponse> listVolumeBackupsPagedCallable() {
        return this.stub.listVolumeBackupsPagedCallable();
    }

    public final UnaryCallable<ListVolumeBackupsRequest, ListVolumeBackupsResponse> listVolumeBackupsCallable() {
        return this.stub.listVolumeBackupsCallable();
    }

    public final VolumeBackup getVolumeBackup(VolumeBackupName name) {
        GetVolumeBackupRequest request = GetVolumeBackupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getVolumeBackup(request);
    }

    public final VolumeBackup getVolumeBackup(String name) {
        GetVolumeBackupRequest request = GetVolumeBackupRequest.newBuilder().setName(name).build();
        return this.getVolumeBackup(request);
    }

    public final VolumeBackup getVolumeBackup(GetVolumeBackupRequest request) {
        return (VolumeBackup)this.getVolumeBackupCallable().call((Object)request);
    }

    public final UnaryCallable<GetVolumeBackupRequest, VolumeBackup> getVolumeBackupCallable() {
        return this.stub.getVolumeBackupCallable();
    }

    public final OperationFuture<RestorePlan, OperationMetadata> createRestorePlanAsync(LocationName parent, RestorePlan restorePlan, String restorePlanId) {
        CreateRestorePlanRequest request = CreateRestorePlanRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRestorePlan(restorePlan).setRestorePlanId(restorePlanId).build();
        return this.createRestorePlanAsync(request);
    }

    public final OperationFuture<RestorePlan, OperationMetadata> createRestorePlanAsync(String parent, RestorePlan restorePlan, String restorePlanId) {
        CreateRestorePlanRequest request = CreateRestorePlanRequest.newBuilder().setParent(parent).setRestorePlan(restorePlan).setRestorePlanId(restorePlanId).build();
        return this.createRestorePlanAsync(request);
    }

    public final OperationFuture<RestorePlan, OperationMetadata> createRestorePlanAsync(CreateRestorePlanRequest request) {
        return this.createRestorePlanOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateRestorePlanRequest, RestorePlan, OperationMetadata> createRestorePlanOperationCallable() {
        return this.stub.createRestorePlanOperationCallable();
    }

    public final UnaryCallable<CreateRestorePlanRequest, Operation> createRestorePlanCallable() {
        return this.stub.createRestorePlanCallable();
    }

    public final ListRestorePlansPagedResponse listRestorePlans(LocationName parent) {
        ListRestorePlansRequest request = ListRestorePlansRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRestorePlans(request);
    }

    public final ListRestorePlansPagedResponse listRestorePlans(String parent) {
        ListRestorePlansRequest request = ListRestorePlansRequest.newBuilder().setParent(parent).build();
        return this.listRestorePlans(request);
    }

    public final ListRestorePlansPagedResponse listRestorePlans(ListRestorePlansRequest request) {
        return (ListRestorePlansPagedResponse)((Object)this.listRestorePlansPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRestorePlansRequest, ListRestorePlansPagedResponse> listRestorePlansPagedCallable() {
        return this.stub.listRestorePlansPagedCallable();
    }

    public final UnaryCallable<ListRestorePlansRequest, ListRestorePlansResponse> listRestorePlansCallable() {
        return this.stub.listRestorePlansCallable();
    }

    public final RestorePlan getRestorePlan(RestorePlanName name) {
        GetRestorePlanRequest request = GetRestorePlanRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRestorePlan(request);
    }

    public final RestorePlan getRestorePlan(String name) {
        GetRestorePlanRequest request = GetRestorePlanRequest.newBuilder().setName(name).build();
        return this.getRestorePlan(request);
    }

    public final RestorePlan getRestorePlan(GetRestorePlanRequest request) {
        return (RestorePlan)this.getRestorePlanCallable().call((Object)request);
    }

    public final UnaryCallable<GetRestorePlanRequest, RestorePlan> getRestorePlanCallable() {
        return this.stub.getRestorePlanCallable();
    }

    public final OperationFuture<RestorePlan, OperationMetadata> updateRestorePlanAsync(RestorePlan restorePlan, FieldMask updateMask) {
        UpdateRestorePlanRequest request = UpdateRestorePlanRequest.newBuilder().setRestorePlan(restorePlan).setUpdateMask(updateMask).build();
        return this.updateRestorePlanAsync(request);
    }

    public final OperationFuture<RestorePlan, OperationMetadata> updateRestorePlanAsync(UpdateRestorePlanRequest request) {
        return this.updateRestorePlanOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateRestorePlanRequest, RestorePlan, OperationMetadata> updateRestorePlanOperationCallable() {
        return this.stub.updateRestorePlanOperationCallable();
    }

    public final UnaryCallable<UpdateRestorePlanRequest, Operation> updateRestorePlanCallable() {
        return this.stub.updateRestorePlanCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRestorePlanAsync(RestorePlanName name) {
        DeleteRestorePlanRequest request = DeleteRestorePlanRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteRestorePlanAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRestorePlanAsync(String name) {
        DeleteRestorePlanRequest request = DeleteRestorePlanRequest.newBuilder().setName(name).build();
        return this.deleteRestorePlanAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRestorePlanAsync(DeleteRestorePlanRequest request) {
        return this.deleteRestorePlanOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRestorePlanRequest, Empty, OperationMetadata> deleteRestorePlanOperationCallable() {
        return this.stub.deleteRestorePlanOperationCallable();
    }

    public final UnaryCallable<DeleteRestorePlanRequest, Operation> deleteRestorePlanCallable() {
        return this.stub.deleteRestorePlanCallable();
    }

    public final OperationFuture<RestoreChannel, OperationMetadata> createRestoreChannelAsync(LocationName parent, RestoreChannel restoreChannel, String restoreChannelId) {
        CreateRestoreChannelRequest request = CreateRestoreChannelRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRestoreChannel(restoreChannel).setRestoreChannelId(restoreChannelId).build();
        return this.createRestoreChannelAsync(request);
    }

    public final OperationFuture<RestoreChannel, OperationMetadata> createRestoreChannelAsync(String parent, RestoreChannel restoreChannel, String restoreChannelId) {
        CreateRestoreChannelRequest request = CreateRestoreChannelRequest.newBuilder().setParent(parent).setRestoreChannel(restoreChannel).setRestoreChannelId(restoreChannelId).build();
        return this.createRestoreChannelAsync(request);
    }

    public final OperationFuture<RestoreChannel, OperationMetadata> createRestoreChannelAsync(CreateRestoreChannelRequest request) {
        return this.createRestoreChannelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateRestoreChannelRequest, RestoreChannel, OperationMetadata> createRestoreChannelOperationCallable() {
        return this.stub.createRestoreChannelOperationCallable();
    }

    public final UnaryCallable<CreateRestoreChannelRequest, Operation> createRestoreChannelCallable() {
        return this.stub.createRestoreChannelCallable();
    }

    public final ListRestoreChannelsPagedResponse listRestoreChannels(LocationName parent) {
        ListRestoreChannelsRequest request = ListRestoreChannelsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRestoreChannels(request);
    }

    public final ListRestoreChannelsPagedResponse listRestoreChannels(String parent) {
        ListRestoreChannelsRequest request = ListRestoreChannelsRequest.newBuilder().setParent(parent).build();
        return this.listRestoreChannels(request);
    }

    public final ListRestoreChannelsPagedResponse listRestoreChannels(ListRestoreChannelsRequest request) {
        return (ListRestoreChannelsPagedResponse)((Object)this.listRestoreChannelsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRestoreChannelsRequest, ListRestoreChannelsPagedResponse> listRestoreChannelsPagedCallable() {
        return this.stub.listRestoreChannelsPagedCallable();
    }

    public final UnaryCallable<ListRestoreChannelsRequest, ListRestoreChannelsResponse> listRestoreChannelsCallable() {
        return this.stub.listRestoreChannelsCallable();
    }

    public final RestoreChannel getRestoreChannel(RestoreChannelName name) {
        GetRestoreChannelRequest request = GetRestoreChannelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRestoreChannel(request);
    }

    public final RestoreChannel getRestoreChannel(String name) {
        GetRestoreChannelRequest request = GetRestoreChannelRequest.newBuilder().setName(name).build();
        return this.getRestoreChannel(request);
    }

    public final RestoreChannel getRestoreChannel(GetRestoreChannelRequest request) {
        return (RestoreChannel)this.getRestoreChannelCallable().call((Object)request);
    }

    public final UnaryCallable<GetRestoreChannelRequest, RestoreChannel> getRestoreChannelCallable() {
        return this.stub.getRestoreChannelCallable();
    }

    public final OperationFuture<RestoreChannel, OperationMetadata> updateRestoreChannelAsync(RestoreChannel restoreChannel, FieldMask updateMask) {
        UpdateRestoreChannelRequest request = UpdateRestoreChannelRequest.newBuilder().setRestoreChannel(restoreChannel).setUpdateMask(updateMask).build();
        return this.updateRestoreChannelAsync(request);
    }

    public final OperationFuture<RestoreChannel, OperationMetadata> updateRestoreChannelAsync(UpdateRestoreChannelRequest request) {
        return this.updateRestoreChannelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateRestoreChannelRequest, RestoreChannel, OperationMetadata> updateRestoreChannelOperationCallable() {
        return this.stub.updateRestoreChannelOperationCallable();
    }

    public final UnaryCallable<UpdateRestoreChannelRequest, Operation> updateRestoreChannelCallable() {
        return this.stub.updateRestoreChannelCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRestoreChannelAsync(RestoreChannelName name) {
        DeleteRestoreChannelRequest request = DeleteRestoreChannelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteRestoreChannelAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRestoreChannelAsync(String name) {
        DeleteRestoreChannelRequest request = DeleteRestoreChannelRequest.newBuilder().setName(name).build();
        return this.deleteRestoreChannelAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRestoreChannelAsync(DeleteRestoreChannelRequest request) {
        return this.deleteRestoreChannelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRestoreChannelRequest, Empty, OperationMetadata> deleteRestoreChannelOperationCallable() {
        return this.stub.deleteRestoreChannelOperationCallable();
    }

    public final UnaryCallable<DeleteRestoreChannelRequest, Operation> deleteRestoreChannelCallable() {
        return this.stub.deleteRestoreChannelCallable();
    }

    public final ListRestorePlanBindingsPagedResponse listRestorePlanBindings(RestoreChannelName parent) {
        ListRestorePlanBindingsRequest request = ListRestorePlanBindingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRestorePlanBindings(request);
    }

    public final ListRestorePlanBindingsPagedResponse listRestorePlanBindings(String parent) {
        ListRestorePlanBindingsRequest request = ListRestorePlanBindingsRequest.newBuilder().setParent(parent).build();
        return this.listRestorePlanBindings(request);
    }

    public final ListRestorePlanBindingsPagedResponse listRestorePlanBindings(ListRestorePlanBindingsRequest request) {
        return (ListRestorePlanBindingsPagedResponse)((Object)this.listRestorePlanBindingsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRestorePlanBindingsRequest, ListRestorePlanBindingsPagedResponse> listRestorePlanBindingsPagedCallable() {
        return this.stub.listRestorePlanBindingsPagedCallable();
    }

    public final UnaryCallable<ListRestorePlanBindingsRequest, ListRestorePlanBindingsResponse> listRestorePlanBindingsCallable() {
        return this.stub.listRestorePlanBindingsCallable();
    }

    public final RestorePlanBinding getRestorePlanBinding(RestorePlanBindingName name) {
        GetRestorePlanBindingRequest request = GetRestorePlanBindingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRestorePlanBinding(request);
    }

    public final RestorePlanBinding getRestorePlanBinding(String name) {
        GetRestorePlanBindingRequest request = GetRestorePlanBindingRequest.newBuilder().setName(name).build();
        return this.getRestorePlanBinding(request);
    }

    public final RestorePlanBinding getRestorePlanBinding(GetRestorePlanBindingRequest request) {
        return (RestorePlanBinding)this.getRestorePlanBindingCallable().call((Object)request);
    }

    public final UnaryCallable<GetRestorePlanBindingRequest, RestorePlanBinding> getRestorePlanBindingCallable() {
        return this.stub.getRestorePlanBindingCallable();
    }

    public final OperationFuture<Restore, OperationMetadata> createRestoreAsync(RestorePlanName parent, Restore restore, String restoreId) {
        CreateRestoreRequest request = CreateRestoreRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRestore(restore).setRestoreId(restoreId).build();
        return this.createRestoreAsync(request);
    }

    public final OperationFuture<Restore, OperationMetadata> createRestoreAsync(String parent, Restore restore, String restoreId) {
        CreateRestoreRequest request = CreateRestoreRequest.newBuilder().setParent(parent).setRestore(restore).setRestoreId(restoreId).build();
        return this.createRestoreAsync(request);
    }

    public final OperationFuture<Restore, OperationMetadata> createRestoreAsync(CreateRestoreRequest request) {
        return this.createRestoreOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateRestoreRequest, Restore, OperationMetadata> createRestoreOperationCallable() {
        return this.stub.createRestoreOperationCallable();
    }

    public final UnaryCallable<CreateRestoreRequest, Operation> createRestoreCallable() {
        return this.stub.createRestoreCallable();
    }

    public final ListRestoresPagedResponse listRestores(RestorePlanName parent) {
        ListRestoresRequest request = ListRestoresRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRestores(request);
    }

    public final ListRestoresPagedResponse listRestores(String parent) {
        ListRestoresRequest request = ListRestoresRequest.newBuilder().setParent(parent).build();
        return this.listRestores(request);
    }

    public final ListRestoresPagedResponse listRestores(ListRestoresRequest request) {
        return (ListRestoresPagedResponse)((Object)this.listRestoresPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRestoresRequest, ListRestoresPagedResponse> listRestoresPagedCallable() {
        return this.stub.listRestoresPagedCallable();
    }

    public final UnaryCallable<ListRestoresRequest, ListRestoresResponse> listRestoresCallable() {
        return this.stub.listRestoresCallable();
    }

    public final Restore getRestore(RestoreName name) {
        GetRestoreRequest request = GetRestoreRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRestore(request);
    }

    public final Restore getRestore(String name) {
        GetRestoreRequest request = GetRestoreRequest.newBuilder().setName(name).build();
        return this.getRestore(request);
    }

    public final Restore getRestore(GetRestoreRequest request) {
        return (Restore)this.getRestoreCallable().call((Object)request);
    }

    public final UnaryCallable<GetRestoreRequest, Restore> getRestoreCallable() {
        return this.stub.getRestoreCallable();
    }

    public final OperationFuture<Restore, OperationMetadata> updateRestoreAsync(Restore restore, FieldMask updateMask) {
        UpdateRestoreRequest request = UpdateRestoreRequest.newBuilder().setRestore(restore).setUpdateMask(updateMask).build();
        return this.updateRestoreAsync(request);
    }

    public final OperationFuture<Restore, OperationMetadata> updateRestoreAsync(UpdateRestoreRequest request) {
        return this.updateRestoreOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateRestoreRequest, Restore, OperationMetadata> updateRestoreOperationCallable() {
        return this.stub.updateRestoreOperationCallable();
    }

    public final UnaryCallable<UpdateRestoreRequest, Operation> updateRestoreCallable() {
        return this.stub.updateRestoreCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRestoreAsync(RestoreName name) {
        DeleteRestoreRequest request = DeleteRestoreRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteRestoreAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRestoreAsync(String name) {
        DeleteRestoreRequest request = DeleteRestoreRequest.newBuilder().setName(name).build();
        return this.deleteRestoreAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRestoreAsync(DeleteRestoreRequest request) {
        return this.deleteRestoreOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRestoreRequest, Empty, OperationMetadata> deleteRestoreOperationCallable() {
        return this.stub.deleteRestoreOperationCallable();
    }

    public final UnaryCallable<DeleteRestoreRequest, Operation> deleteRestoreCallable() {
        return this.stub.deleteRestoreCallable();
    }

    public final ListVolumeRestoresPagedResponse listVolumeRestores(RestoreName parent) {
        ListVolumeRestoresRequest request = ListVolumeRestoresRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listVolumeRestores(request);
    }

    public final ListVolumeRestoresPagedResponse listVolumeRestores(String parent) {
        ListVolumeRestoresRequest request = ListVolumeRestoresRequest.newBuilder().setParent(parent).build();
        return this.listVolumeRestores(request);
    }

    public final ListVolumeRestoresPagedResponse listVolumeRestores(ListVolumeRestoresRequest request) {
        return (ListVolumeRestoresPagedResponse)((Object)this.listVolumeRestoresPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVolumeRestoresRequest, ListVolumeRestoresPagedResponse> listVolumeRestoresPagedCallable() {
        return this.stub.listVolumeRestoresPagedCallable();
    }

    public final UnaryCallable<ListVolumeRestoresRequest, ListVolumeRestoresResponse> listVolumeRestoresCallable() {
        return this.stub.listVolumeRestoresCallable();
    }

    public final VolumeRestore getVolumeRestore(VolumeRestoreName name) {
        GetVolumeRestoreRequest request = GetVolumeRestoreRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getVolumeRestore(request);
    }

    public final VolumeRestore getVolumeRestore(String name) {
        GetVolumeRestoreRequest request = GetVolumeRestoreRequest.newBuilder().setName(name).build();
        return this.getVolumeRestore(request);
    }

    public final VolumeRestore getVolumeRestore(GetVolumeRestoreRequest request) {
        return (VolumeRestore)this.getVolumeRestoreCallable().call((Object)request);
    }

    public final UnaryCallable<GetVolumeRestoreRequest, VolumeRestore> getVolumeRestoreCallable() {
        return this.stub.getVolumeRestoreCallable();
    }

    public final GetBackupIndexDownloadUrlResponse getBackupIndexDownloadUrl(BackupName backup) {
        GetBackupIndexDownloadUrlRequest request = GetBackupIndexDownloadUrlRequest.newBuilder().setBackup(backup == null ? null : backup.toString()).build();
        return this.getBackupIndexDownloadUrl(request);
    }

    public final GetBackupIndexDownloadUrlResponse getBackupIndexDownloadUrl(String backup) {
        GetBackupIndexDownloadUrlRequest request = GetBackupIndexDownloadUrlRequest.newBuilder().setBackup(backup).build();
        return this.getBackupIndexDownloadUrl(request);
    }

    public final GetBackupIndexDownloadUrlResponse getBackupIndexDownloadUrl(GetBackupIndexDownloadUrlRequest request) {
        return (GetBackupIndexDownloadUrlResponse)this.getBackupIndexDownloadUrlCallable().call((Object)request);
    }

    public final UnaryCallable<GetBackupIndexDownloadUrlRequest, GetBackupIndexDownloadUrlResponse> getBackupIndexDownloadUrlCallable() {
        return this.stub.getBackupIndexDownloadUrlCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListVolumeRestoresFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVolumeRestoresRequest, ListVolumeRestoresResponse, VolumeRestore, ListVolumeRestoresPage, ListVolumeRestoresFixedSizeCollection> {
        private ListVolumeRestoresFixedSizeCollection(List<ListVolumeRestoresPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVolumeRestoresFixedSizeCollection createEmptyCollection() {
            return new ListVolumeRestoresFixedSizeCollection(null, 0);
        }

        protected ListVolumeRestoresFixedSizeCollection createCollection(List<ListVolumeRestoresPage> pages, int collectionSize) {
            return new ListVolumeRestoresFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVolumeRestoresPage
    extends AbstractPage<ListVolumeRestoresRequest, ListVolumeRestoresResponse, VolumeRestore, ListVolumeRestoresPage> {
        private ListVolumeRestoresPage(PageContext<ListVolumeRestoresRequest, ListVolumeRestoresResponse, VolumeRestore> context, ListVolumeRestoresResponse response) {
            super(context, (Object)response);
        }

        private static ListVolumeRestoresPage createEmptyPage() {
            return new ListVolumeRestoresPage(null, null);
        }

        protected ListVolumeRestoresPage createPage(PageContext<ListVolumeRestoresRequest, ListVolumeRestoresResponse, VolumeRestore> context, ListVolumeRestoresResponse response) {
            return new ListVolumeRestoresPage(context, response);
        }

        public ApiFuture<ListVolumeRestoresPage> createPageAsync(PageContext<ListVolumeRestoresRequest, ListVolumeRestoresResponse, VolumeRestore> context, ApiFuture<ListVolumeRestoresResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVolumeRestoresPagedResponse
    extends AbstractPagedListResponse<ListVolumeRestoresRequest, ListVolumeRestoresResponse, VolumeRestore, ListVolumeRestoresPage, ListVolumeRestoresFixedSizeCollection> {
        public static ApiFuture<ListVolumeRestoresPagedResponse> createAsync(PageContext<ListVolumeRestoresRequest, ListVolumeRestoresResponse, VolumeRestore> context, ApiFuture<ListVolumeRestoresResponse> futureResponse) {
            ApiFuture<ListVolumeRestoresPage> futurePage = ListVolumeRestoresPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListVolumeRestoresPagedResponse((ListVolumeRestoresPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListVolumeRestoresPagedResponse(ListVolumeRestoresPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVolumeRestoresFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRestoresFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRestoresRequest, ListRestoresResponse, Restore, ListRestoresPage, ListRestoresFixedSizeCollection> {
        private ListRestoresFixedSizeCollection(List<ListRestoresPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRestoresFixedSizeCollection createEmptyCollection() {
            return new ListRestoresFixedSizeCollection(null, 0);
        }

        protected ListRestoresFixedSizeCollection createCollection(List<ListRestoresPage> pages, int collectionSize) {
            return new ListRestoresFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRestoresPage
    extends AbstractPage<ListRestoresRequest, ListRestoresResponse, Restore, ListRestoresPage> {
        private ListRestoresPage(PageContext<ListRestoresRequest, ListRestoresResponse, Restore> context, ListRestoresResponse response) {
            super(context, (Object)response);
        }

        private static ListRestoresPage createEmptyPage() {
            return new ListRestoresPage(null, null);
        }

        protected ListRestoresPage createPage(PageContext<ListRestoresRequest, ListRestoresResponse, Restore> context, ListRestoresResponse response) {
            return new ListRestoresPage(context, response);
        }

        public ApiFuture<ListRestoresPage> createPageAsync(PageContext<ListRestoresRequest, ListRestoresResponse, Restore> context, ApiFuture<ListRestoresResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRestoresPagedResponse
    extends AbstractPagedListResponse<ListRestoresRequest, ListRestoresResponse, Restore, ListRestoresPage, ListRestoresFixedSizeCollection> {
        public static ApiFuture<ListRestoresPagedResponse> createAsync(PageContext<ListRestoresRequest, ListRestoresResponse, Restore> context, ApiFuture<ListRestoresResponse> futureResponse) {
            ApiFuture<ListRestoresPage> futurePage = ListRestoresPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRestoresPagedResponse((ListRestoresPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRestoresPagedResponse(ListRestoresPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRestoresFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRestorePlanBindingsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRestorePlanBindingsRequest, ListRestorePlanBindingsResponse, RestorePlanBinding, ListRestorePlanBindingsPage, ListRestorePlanBindingsFixedSizeCollection> {
        private ListRestorePlanBindingsFixedSizeCollection(List<ListRestorePlanBindingsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRestorePlanBindingsFixedSizeCollection createEmptyCollection() {
            return new ListRestorePlanBindingsFixedSizeCollection(null, 0);
        }

        protected ListRestorePlanBindingsFixedSizeCollection createCollection(List<ListRestorePlanBindingsPage> pages, int collectionSize) {
            return new ListRestorePlanBindingsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRestorePlanBindingsPage
    extends AbstractPage<ListRestorePlanBindingsRequest, ListRestorePlanBindingsResponse, RestorePlanBinding, ListRestorePlanBindingsPage> {
        private ListRestorePlanBindingsPage(PageContext<ListRestorePlanBindingsRequest, ListRestorePlanBindingsResponse, RestorePlanBinding> context, ListRestorePlanBindingsResponse response) {
            super(context, (Object)response);
        }

        private static ListRestorePlanBindingsPage createEmptyPage() {
            return new ListRestorePlanBindingsPage(null, null);
        }

        protected ListRestorePlanBindingsPage createPage(PageContext<ListRestorePlanBindingsRequest, ListRestorePlanBindingsResponse, RestorePlanBinding> context, ListRestorePlanBindingsResponse response) {
            return new ListRestorePlanBindingsPage(context, response);
        }

        public ApiFuture<ListRestorePlanBindingsPage> createPageAsync(PageContext<ListRestorePlanBindingsRequest, ListRestorePlanBindingsResponse, RestorePlanBinding> context, ApiFuture<ListRestorePlanBindingsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRestorePlanBindingsPagedResponse
    extends AbstractPagedListResponse<ListRestorePlanBindingsRequest, ListRestorePlanBindingsResponse, RestorePlanBinding, ListRestorePlanBindingsPage, ListRestorePlanBindingsFixedSizeCollection> {
        public static ApiFuture<ListRestorePlanBindingsPagedResponse> createAsync(PageContext<ListRestorePlanBindingsRequest, ListRestorePlanBindingsResponse, RestorePlanBinding> context, ApiFuture<ListRestorePlanBindingsResponse> futureResponse) {
            ApiFuture<ListRestorePlanBindingsPage> futurePage = ListRestorePlanBindingsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRestorePlanBindingsPagedResponse((ListRestorePlanBindingsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRestorePlanBindingsPagedResponse(ListRestorePlanBindingsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRestorePlanBindingsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRestoreChannelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRestoreChannelsRequest, ListRestoreChannelsResponse, RestoreChannel, ListRestoreChannelsPage, ListRestoreChannelsFixedSizeCollection> {
        private ListRestoreChannelsFixedSizeCollection(List<ListRestoreChannelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRestoreChannelsFixedSizeCollection createEmptyCollection() {
            return new ListRestoreChannelsFixedSizeCollection(null, 0);
        }

        protected ListRestoreChannelsFixedSizeCollection createCollection(List<ListRestoreChannelsPage> pages, int collectionSize) {
            return new ListRestoreChannelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRestoreChannelsPage
    extends AbstractPage<ListRestoreChannelsRequest, ListRestoreChannelsResponse, RestoreChannel, ListRestoreChannelsPage> {
        private ListRestoreChannelsPage(PageContext<ListRestoreChannelsRequest, ListRestoreChannelsResponse, RestoreChannel> context, ListRestoreChannelsResponse response) {
            super(context, (Object)response);
        }

        private static ListRestoreChannelsPage createEmptyPage() {
            return new ListRestoreChannelsPage(null, null);
        }

        protected ListRestoreChannelsPage createPage(PageContext<ListRestoreChannelsRequest, ListRestoreChannelsResponse, RestoreChannel> context, ListRestoreChannelsResponse response) {
            return new ListRestoreChannelsPage(context, response);
        }

        public ApiFuture<ListRestoreChannelsPage> createPageAsync(PageContext<ListRestoreChannelsRequest, ListRestoreChannelsResponse, RestoreChannel> context, ApiFuture<ListRestoreChannelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRestoreChannelsPagedResponse
    extends AbstractPagedListResponse<ListRestoreChannelsRequest, ListRestoreChannelsResponse, RestoreChannel, ListRestoreChannelsPage, ListRestoreChannelsFixedSizeCollection> {
        public static ApiFuture<ListRestoreChannelsPagedResponse> createAsync(PageContext<ListRestoreChannelsRequest, ListRestoreChannelsResponse, RestoreChannel> context, ApiFuture<ListRestoreChannelsResponse> futureResponse) {
            ApiFuture<ListRestoreChannelsPage> futurePage = ListRestoreChannelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRestoreChannelsPagedResponse((ListRestoreChannelsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRestoreChannelsPagedResponse(ListRestoreChannelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRestoreChannelsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRestorePlansFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRestorePlansRequest, ListRestorePlansResponse, RestorePlan, ListRestorePlansPage, ListRestorePlansFixedSizeCollection> {
        private ListRestorePlansFixedSizeCollection(List<ListRestorePlansPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRestorePlansFixedSizeCollection createEmptyCollection() {
            return new ListRestorePlansFixedSizeCollection(null, 0);
        }

        protected ListRestorePlansFixedSizeCollection createCollection(List<ListRestorePlansPage> pages, int collectionSize) {
            return new ListRestorePlansFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRestorePlansPage
    extends AbstractPage<ListRestorePlansRequest, ListRestorePlansResponse, RestorePlan, ListRestorePlansPage> {
        private ListRestorePlansPage(PageContext<ListRestorePlansRequest, ListRestorePlansResponse, RestorePlan> context, ListRestorePlansResponse response) {
            super(context, (Object)response);
        }

        private static ListRestorePlansPage createEmptyPage() {
            return new ListRestorePlansPage(null, null);
        }

        protected ListRestorePlansPage createPage(PageContext<ListRestorePlansRequest, ListRestorePlansResponse, RestorePlan> context, ListRestorePlansResponse response) {
            return new ListRestorePlansPage(context, response);
        }

        public ApiFuture<ListRestorePlansPage> createPageAsync(PageContext<ListRestorePlansRequest, ListRestorePlansResponse, RestorePlan> context, ApiFuture<ListRestorePlansResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRestorePlansPagedResponse
    extends AbstractPagedListResponse<ListRestorePlansRequest, ListRestorePlansResponse, RestorePlan, ListRestorePlansPage, ListRestorePlansFixedSizeCollection> {
        public static ApiFuture<ListRestorePlansPagedResponse> createAsync(PageContext<ListRestorePlansRequest, ListRestorePlansResponse, RestorePlan> context, ApiFuture<ListRestorePlansResponse> futureResponse) {
            ApiFuture<ListRestorePlansPage> futurePage = ListRestorePlansPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRestorePlansPagedResponse((ListRestorePlansPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRestorePlansPagedResponse(ListRestorePlansPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRestorePlansFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListVolumeBackupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVolumeBackupsRequest, ListVolumeBackupsResponse, VolumeBackup, ListVolumeBackupsPage, ListVolumeBackupsFixedSizeCollection> {
        private ListVolumeBackupsFixedSizeCollection(List<ListVolumeBackupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVolumeBackupsFixedSizeCollection createEmptyCollection() {
            return new ListVolumeBackupsFixedSizeCollection(null, 0);
        }

        protected ListVolumeBackupsFixedSizeCollection createCollection(List<ListVolumeBackupsPage> pages, int collectionSize) {
            return new ListVolumeBackupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVolumeBackupsPage
    extends AbstractPage<ListVolumeBackupsRequest, ListVolumeBackupsResponse, VolumeBackup, ListVolumeBackupsPage> {
        private ListVolumeBackupsPage(PageContext<ListVolumeBackupsRequest, ListVolumeBackupsResponse, VolumeBackup> context, ListVolumeBackupsResponse response) {
            super(context, (Object)response);
        }

        private static ListVolumeBackupsPage createEmptyPage() {
            return new ListVolumeBackupsPage(null, null);
        }

        protected ListVolumeBackupsPage createPage(PageContext<ListVolumeBackupsRequest, ListVolumeBackupsResponse, VolumeBackup> context, ListVolumeBackupsResponse response) {
            return new ListVolumeBackupsPage(context, response);
        }

        public ApiFuture<ListVolumeBackupsPage> createPageAsync(PageContext<ListVolumeBackupsRequest, ListVolumeBackupsResponse, VolumeBackup> context, ApiFuture<ListVolumeBackupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVolumeBackupsPagedResponse
    extends AbstractPagedListResponse<ListVolumeBackupsRequest, ListVolumeBackupsResponse, VolumeBackup, ListVolumeBackupsPage, ListVolumeBackupsFixedSizeCollection> {
        public static ApiFuture<ListVolumeBackupsPagedResponse> createAsync(PageContext<ListVolumeBackupsRequest, ListVolumeBackupsResponse, VolumeBackup> context, ApiFuture<ListVolumeBackupsResponse> futureResponse) {
            ApiFuture<ListVolumeBackupsPage> futurePage = ListVolumeBackupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListVolumeBackupsPagedResponse((ListVolumeBackupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListVolumeBackupsPagedResponse(ListVolumeBackupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVolumeBackupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBackupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage, ListBackupsFixedSizeCollection> {
        private ListBackupsFixedSizeCollection(List<ListBackupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBackupsFixedSizeCollection createEmptyCollection() {
            return new ListBackupsFixedSizeCollection(null, 0);
        }

        protected ListBackupsFixedSizeCollection createCollection(List<ListBackupsPage> pages, int collectionSize) {
            return new ListBackupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBackupsPage
    extends AbstractPage<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage> {
        private ListBackupsPage(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ListBackupsResponse response) {
            super(context, (Object)response);
        }

        private static ListBackupsPage createEmptyPage() {
            return new ListBackupsPage(null, null);
        }

        protected ListBackupsPage createPage(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ListBackupsResponse response) {
            return new ListBackupsPage(context, response);
        }

        public ApiFuture<ListBackupsPage> createPageAsync(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ApiFuture<ListBackupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBackupsPagedResponse
    extends AbstractPagedListResponse<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage, ListBackupsFixedSizeCollection> {
        public static ApiFuture<ListBackupsPagedResponse> createAsync(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ApiFuture<ListBackupsResponse> futureResponse) {
            ApiFuture<ListBackupsPage> futurePage = ListBackupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBackupsPagedResponse((ListBackupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBackupsPagedResponse(ListBackupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBackupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBackupPlanBindingsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBackupPlanBindingsRequest, ListBackupPlanBindingsResponse, BackupPlanBinding, ListBackupPlanBindingsPage, ListBackupPlanBindingsFixedSizeCollection> {
        private ListBackupPlanBindingsFixedSizeCollection(List<ListBackupPlanBindingsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBackupPlanBindingsFixedSizeCollection createEmptyCollection() {
            return new ListBackupPlanBindingsFixedSizeCollection(null, 0);
        }

        protected ListBackupPlanBindingsFixedSizeCollection createCollection(List<ListBackupPlanBindingsPage> pages, int collectionSize) {
            return new ListBackupPlanBindingsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBackupPlanBindingsPage
    extends AbstractPage<ListBackupPlanBindingsRequest, ListBackupPlanBindingsResponse, BackupPlanBinding, ListBackupPlanBindingsPage> {
        private ListBackupPlanBindingsPage(PageContext<ListBackupPlanBindingsRequest, ListBackupPlanBindingsResponse, BackupPlanBinding> context, ListBackupPlanBindingsResponse response) {
            super(context, (Object)response);
        }

        private static ListBackupPlanBindingsPage createEmptyPage() {
            return new ListBackupPlanBindingsPage(null, null);
        }

        protected ListBackupPlanBindingsPage createPage(PageContext<ListBackupPlanBindingsRequest, ListBackupPlanBindingsResponse, BackupPlanBinding> context, ListBackupPlanBindingsResponse response) {
            return new ListBackupPlanBindingsPage(context, response);
        }

        public ApiFuture<ListBackupPlanBindingsPage> createPageAsync(PageContext<ListBackupPlanBindingsRequest, ListBackupPlanBindingsResponse, BackupPlanBinding> context, ApiFuture<ListBackupPlanBindingsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBackupPlanBindingsPagedResponse
    extends AbstractPagedListResponse<ListBackupPlanBindingsRequest, ListBackupPlanBindingsResponse, BackupPlanBinding, ListBackupPlanBindingsPage, ListBackupPlanBindingsFixedSizeCollection> {
        public static ApiFuture<ListBackupPlanBindingsPagedResponse> createAsync(PageContext<ListBackupPlanBindingsRequest, ListBackupPlanBindingsResponse, BackupPlanBinding> context, ApiFuture<ListBackupPlanBindingsResponse> futureResponse) {
            ApiFuture<ListBackupPlanBindingsPage> futurePage = ListBackupPlanBindingsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBackupPlanBindingsPagedResponse((ListBackupPlanBindingsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBackupPlanBindingsPagedResponse(ListBackupPlanBindingsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBackupPlanBindingsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBackupChannelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBackupChannelsRequest, ListBackupChannelsResponse, BackupChannel, ListBackupChannelsPage, ListBackupChannelsFixedSizeCollection> {
        private ListBackupChannelsFixedSizeCollection(List<ListBackupChannelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBackupChannelsFixedSizeCollection createEmptyCollection() {
            return new ListBackupChannelsFixedSizeCollection(null, 0);
        }

        protected ListBackupChannelsFixedSizeCollection createCollection(List<ListBackupChannelsPage> pages, int collectionSize) {
            return new ListBackupChannelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBackupChannelsPage
    extends AbstractPage<ListBackupChannelsRequest, ListBackupChannelsResponse, BackupChannel, ListBackupChannelsPage> {
        private ListBackupChannelsPage(PageContext<ListBackupChannelsRequest, ListBackupChannelsResponse, BackupChannel> context, ListBackupChannelsResponse response) {
            super(context, (Object)response);
        }

        private static ListBackupChannelsPage createEmptyPage() {
            return new ListBackupChannelsPage(null, null);
        }

        protected ListBackupChannelsPage createPage(PageContext<ListBackupChannelsRequest, ListBackupChannelsResponse, BackupChannel> context, ListBackupChannelsResponse response) {
            return new ListBackupChannelsPage(context, response);
        }

        public ApiFuture<ListBackupChannelsPage> createPageAsync(PageContext<ListBackupChannelsRequest, ListBackupChannelsResponse, BackupChannel> context, ApiFuture<ListBackupChannelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBackupChannelsPagedResponse
    extends AbstractPagedListResponse<ListBackupChannelsRequest, ListBackupChannelsResponse, BackupChannel, ListBackupChannelsPage, ListBackupChannelsFixedSizeCollection> {
        public static ApiFuture<ListBackupChannelsPagedResponse> createAsync(PageContext<ListBackupChannelsRequest, ListBackupChannelsResponse, BackupChannel> context, ApiFuture<ListBackupChannelsResponse> futureResponse) {
            ApiFuture<ListBackupChannelsPage> futurePage = ListBackupChannelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBackupChannelsPagedResponse((ListBackupChannelsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBackupChannelsPagedResponse(ListBackupChannelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBackupChannelsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBackupPlansFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBackupPlansRequest, ListBackupPlansResponse, BackupPlan, ListBackupPlansPage, ListBackupPlansFixedSizeCollection> {
        private ListBackupPlansFixedSizeCollection(List<ListBackupPlansPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBackupPlansFixedSizeCollection createEmptyCollection() {
            return new ListBackupPlansFixedSizeCollection(null, 0);
        }

        protected ListBackupPlansFixedSizeCollection createCollection(List<ListBackupPlansPage> pages, int collectionSize) {
            return new ListBackupPlansFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBackupPlansPage
    extends AbstractPage<ListBackupPlansRequest, ListBackupPlansResponse, BackupPlan, ListBackupPlansPage> {
        private ListBackupPlansPage(PageContext<ListBackupPlansRequest, ListBackupPlansResponse, BackupPlan> context, ListBackupPlansResponse response) {
            super(context, (Object)response);
        }

        private static ListBackupPlansPage createEmptyPage() {
            return new ListBackupPlansPage(null, null);
        }

        protected ListBackupPlansPage createPage(PageContext<ListBackupPlansRequest, ListBackupPlansResponse, BackupPlan> context, ListBackupPlansResponse response) {
            return new ListBackupPlansPage(context, response);
        }

        public ApiFuture<ListBackupPlansPage> createPageAsync(PageContext<ListBackupPlansRequest, ListBackupPlansResponse, BackupPlan> context, ApiFuture<ListBackupPlansResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBackupPlansPagedResponse
    extends AbstractPagedListResponse<ListBackupPlansRequest, ListBackupPlansResponse, BackupPlan, ListBackupPlansPage, ListBackupPlansFixedSizeCollection> {
        public static ApiFuture<ListBackupPlansPagedResponse> createAsync(PageContext<ListBackupPlansRequest, ListBackupPlansResponse, BackupPlan> context, ApiFuture<ListBackupPlansResponse> futureResponse) {
            ApiFuture<ListBackupPlansPage> futurePage = ListBackupPlansPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBackupPlansPagedResponse((ListBackupPlansPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBackupPlansPagedResponse(ListBackupPlansPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBackupPlansFixedSizeCollection.createEmptyCollection());
        }
    }
}

