/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.geminidataanalytics.v1beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.geminidataanalytics.v1beta.CreateDataAgentRequest;
import com.google.cloud.geminidataanalytics.v1beta.DataAgent;
import com.google.cloud.geminidataanalytics.v1beta.DataAgentName;
import com.google.cloud.geminidataanalytics.v1beta.DataAgentServiceSettings;
import com.google.cloud.geminidataanalytics.v1beta.DeleteDataAgentRequest;
import com.google.cloud.geminidataanalytics.v1beta.GetDataAgentRequest;
import com.google.cloud.geminidataanalytics.v1beta.ListAccessibleDataAgentsRequest;
import com.google.cloud.geminidataanalytics.v1beta.ListAccessibleDataAgentsResponse;
import com.google.cloud.geminidataanalytics.v1beta.ListDataAgentsRequest;
import com.google.cloud.geminidataanalytics.v1beta.ListDataAgentsResponse;
import com.google.cloud.geminidataanalytics.v1beta.LocationName;
import com.google.cloud.geminidataanalytics.v1beta.OperationMetadata;
import com.google.cloud.geminidataanalytics.v1beta.UpdateDataAgentRequest;
import com.google.cloud.geminidataanalytics.v1beta.stub.DataAgentServiceStub;
import com.google.cloud.geminidataanalytics.v1beta.stub.DataAgentServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DataAgentServiceClient
implements BackgroundResource {
    private final DataAgentServiceSettings settings;
    private final DataAgentServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final DataAgentServiceClient create() throws IOException {
        return DataAgentServiceClient.create(DataAgentServiceSettings.newBuilder().build());
    }

    public static final DataAgentServiceClient create(DataAgentServiceSettings settings) throws IOException {
        return new DataAgentServiceClient(settings);
    }

    public static final DataAgentServiceClient create(DataAgentServiceStub stub) {
        return new DataAgentServiceClient(stub);
    }

    protected DataAgentServiceClient(DataAgentServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataAgentServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected DataAgentServiceClient(DataAgentServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final DataAgentServiceSettings getSettings() {
        return this.settings;
    }

    public DataAgentServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListDataAgentsPagedResponse listDataAgents(LocationName parent) {
        ListDataAgentsRequest request = ListDataAgentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDataAgents(request);
    }

    public final ListDataAgentsPagedResponse listDataAgents(String parent) {
        ListDataAgentsRequest request = ListDataAgentsRequest.newBuilder().setParent(parent).build();
        return this.listDataAgents(request);
    }

    public final ListDataAgentsPagedResponse listDataAgents(ListDataAgentsRequest request) {
        return (ListDataAgentsPagedResponse)((Object)this.listDataAgentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDataAgentsRequest, ListDataAgentsPagedResponse> listDataAgentsPagedCallable() {
        return this.stub.listDataAgentsPagedCallable();
    }

    public final UnaryCallable<ListDataAgentsRequest, ListDataAgentsResponse> listDataAgentsCallable() {
        return this.stub.listDataAgentsCallable();
    }

    public final ListAccessibleDataAgentsPagedResponse listAccessibleDataAgents(LocationName parent) {
        ListAccessibleDataAgentsRequest request = ListAccessibleDataAgentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAccessibleDataAgents(request);
    }

    public final ListAccessibleDataAgentsPagedResponse listAccessibleDataAgents(String parent) {
        ListAccessibleDataAgentsRequest request = ListAccessibleDataAgentsRequest.newBuilder().setParent(parent).build();
        return this.listAccessibleDataAgents(request);
    }

    public final ListAccessibleDataAgentsPagedResponse listAccessibleDataAgents(ListAccessibleDataAgentsRequest request) {
        return (ListAccessibleDataAgentsPagedResponse)((Object)this.listAccessibleDataAgentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAccessibleDataAgentsRequest, ListAccessibleDataAgentsPagedResponse> listAccessibleDataAgentsPagedCallable() {
        return this.stub.listAccessibleDataAgentsPagedCallable();
    }

    public final UnaryCallable<ListAccessibleDataAgentsRequest, ListAccessibleDataAgentsResponse> listAccessibleDataAgentsCallable() {
        return this.stub.listAccessibleDataAgentsCallable();
    }

    public final DataAgent getDataAgent(DataAgentName name) {
        GetDataAgentRequest request = GetDataAgentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataAgent(request);
    }

    public final DataAgent getDataAgent(String name) {
        GetDataAgentRequest request = GetDataAgentRequest.newBuilder().setName(name).build();
        return this.getDataAgent(request);
    }

    public final DataAgent getDataAgent(GetDataAgentRequest request) {
        return (DataAgent)this.getDataAgentCallable().call((Object)request);
    }

    public final UnaryCallable<GetDataAgentRequest, DataAgent> getDataAgentCallable() {
        return this.stub.getDataAgentCallable();
    }

    public final OperationFuture<DataAgent, OperationMetadata> createDataAgentAsync(LocationName parent, DataAgent dataAgent, String dataAgentId) {
        CreateDataAgentRequest request = CreateDataAgentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDataAgent(dataAgent).setDataAgentId(dataAgentId).build();
        return this.createDataAgentAsync(request);
    }

    public final OperationFuture<DataAgent, OperationMetadata> createDataAgentAsync(String parent, DataAgent dataAgent, String dataAgentId) {
        CreateDataAgentRequest request = CreateDataAgentRequest.newBuilder().setParent(parent).setDataAgent(dataAgent).setDataAgentId(dataAgentId).build();
        return this.createDataAgentAsync(request);
    }

    public final OperationFuture<DataAgent, OperationMetadata> createDataAgentAsync(CreateDataAgentRequest request) {
        return this.createDataAgentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDataAgentRequest, DataAgent, OperationMetadata> createDataAgentOperationCallable() {
        return this.stub.createDataAgentOperationCallable();
    }

    public final UnaryCallable<CreateDataAgentRequest, Operation> createDataAgentCallable() {
        return this.stub.createDataAgentCallable();
    }

    public final OperationFuture<DataAgent, OperationMetadata> updateDataAgentAsync(DataAgent dataAgent, FieldMask updateMask) {
        UpdateDataAgentRequest request = UpdateDataAgentRequest.newBuilder().setDataAgent(dataAgent).setUpdateMask(updateMask).build();
        return this.updateDataAgentAsync(request);
    }

    public final OperationFuture<DataAgent, OperationMetadata> updateDataAgentAsync(UpdateDataAgentRequest request) {
        return this.updateDataAgentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateDataAgentRequest, DataAgent, OperationMetadata> updateDataAgentOperationCallable() {
        return this.stub.updateDataAgentOperationCallable();
    }

    public final UnaryCallable<UpdateDataAgentRequest, Operation> updateDataAgentCallable() {
        return this.stub.updateDataAgentCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDataAgentAsync(DataAgentName name) {
        DeleteDataAgentRequest request = DeleteDataAgentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDataAgentAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDataAgentAsync(String name) {
        DeleteDataAgentRequest request = DeleteDataAgentRequest.newBuilder().setName(name).build();
        return this.deleteDataAgentAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDataAgentAsync(DeleteDataAgentRequest request) {
        return this.deleteDataAgentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDataAgentRequest, Empty, OperationMetadata> deleteDataAgentOperationCallable() {
        return this.stub.deleteDataAgentOperationCallable();
    }

    public final UnaryCallable<DeleteDataAgentRequest, Operation> deleteDataAgentCallable() {
        return this.stub.deleteDataAgentCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(ResourceName resource) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAccessibleDataAgentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAccessibleDataAgentsRequest, ListAccessibleDataAgentsResponse, DataAgent, ListAccessibleDataAgentsPage, ListAccessibleDataAgentsFixedSizeCollection> {
        private ListAccessibleDataAgentsFixedSizeCollection(List<ListAccessibleDataAgentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAccessibleDataAgentsFixedSizeCollection createEmptyCollection() {
            return new ListAccessibleDataAgentsFixedSizeCollection(null, 0);
        }

        protected ListAccessibleDataAgentsFixedSizeCollection createCollection(List<ListAccessibleDataAgentsPage> pages, int collectionSize) {
            return new ListAccessibleDataAgentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAccessibleDataAgentsPage
    extends AbstractPage<ListAccessibleDataAgentsRequest, ListAccessibleDataAgentsResponse, DataAgent, ListAccessibleDataAgentsPage> {
        private ListAccessibleDataAgentsPage(PageContext<ListAccessibleDataAgentsRequest, ListAccessibleDataAgentsResponse, DataAgent> context, ListAccessibleDataAgentsResponse response) {
            super(context, (Object)response);
        }

        private static ListAccessibleDataAgentsPage createEmptyPage() {
            return new ListAccessibleDataAgentsPage(null, null);
        }

        protected ListAccessibleDataAgentsPage createPage(PageContext<ListAccessibleDataAgentsRequest, ListAccessibleDataAgentsResponse, DataAgent> context, ListAccessibleDataAgentsResponse response) {
            return new ListAccessibleDataAgentsPage(context, response);
        }

        public ApiFuture<ListAccessibleDataAgentsPage> createPageAsync(PageContext<ListAccessibleDataAgentsRequest, ListAccessibleDataAgentsResponse, DataAgent> context, ApiFuture<ListAccessibleDataAgentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAccessibleDataAgentsPagedResponse
    extends AbstractPagedListResponse<ListAccessibleDataAgentsRequest, ListAccessibleDataAgentsResponse, DataAgent, ListAccessibleDataAgentsPage, ListAccessibleDataAgentsFixedSizeCollection> {
        public static ApiFuture<ListAccessibleDataAgentsPagedResponse> createAsync(PageContext<ListAccessibleDataAgentsRequest, ListAccessibleDataAgentsResponse, DataAgent> context, ApiFuture<ListAccessibleDataAgentsResponse> futureResponse) {
            ApiFuture<ListAccessibleDataAgentsPage> futurePage = ListAccessibleDataAgentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAccessibleDataAgentsPagedResponse((ListAccessibleDataAgentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAccessibleDataAgentsPagedResponse(ListAccessibleDataAgentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAccessibleDataAgentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDataAgentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDataAgentsRequest, ListDataAgentsResponse, DataAgent, ListDataAgentsPage, ListDataAgentsFixedSizeCollection> {
        private ListDataAgentsFixedSizeCollection(List<ListDataAgentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDataAgentsFixedSizeCollection createEmptyCollection() {
            return new ListDataAgentsFixedSizeCollection(null, 0);
        }

        protected ListDataAgentsFixedSizeCollection createCollection(List<ListDataAgentsPage> pages, int collectionSize) {
            return new ListDataAgentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDataAgentsPage
    extends AbstractPage<ListDataAgentsRequest, ListDataAgentsResponse, DataAgent, ListDataAgentsPage> {
        private ListDataAgentsPage(PageContext<ListDataAgentsRequest, ListDataAgentsResponse, DataAgent> context, ListDataAgentsResponse response) {
            super(context, (Object)response);
        }

        private static ListDataAgentsPage createEmptyPage() {
            return new ListDataAgentsPage(null, null);
        }

        protected ListDataAgentsPage createPage(PageContext<ListDataAgentsRequest, ListDataAgentsResponse, DataAgent> context, ListDataAgentsResponse response) {
            return new ListDataAgentsPage(context, response);
        }

        public ApiFuture<ListDataAgentsPage> createPageAsync(PageContext<ListDataAgentsRequest, ListDataAgentsResponse, DataAgent> context, ApiFuture<ListDataAgentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDataAgentsPagedResponse
    extends AbstractPagedListResponse<ListDataAgentsRequest, ListDataAgentsResponse, DataAgent, ListDataAgentsPage, ListDataAgentsFixedSizeCollection> {
        public static ApiFuture<ListDataAgentsPagedResponse> createAsync(PageContext<ListDataAgentsRequest, ListDataAgentsResponse, DataAgent> context, ApiFuture<ListDataAgentsResponse> futureResponse) {
            ApiFuture<ListDataAgentsPage> futurePage = ListDataAgentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDataAgentsPagedResponse((ListDataAgentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDataAgentsPagedResponse(ListDataAgentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDataAgentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

