/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.geminidataanalytics.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.geminidataanalytics.v1beta.ChatRequest;
import com.google.cloud.geminidataanalytics.v1beta.Conversation;
import com.google.cloud.geminidataanalytics.v1beta.CreateConversationRequest;
import com.google.cloud.geminidataanalytics.v1beta.DataChatServiceClient;
import com.google.cloud.geminidataanalytics.v1beta.GetConversationRequest;
import com.google.cloud.geminidataanalytics.v1beta.ListConversationsRequest;
import com.google.cloud.geminidataanalytics.v1beta.ListConversationsResponse;
import com.google.cloud.geminidataanalytics.v1beta.ListMessagesRequest;
import com.google.cloud.geminidataanalytics.v1beta.ListMessagesResponse;
import com.google.cloud.geminidataanalytics.v1beta.Message;
import com.google.cloud.geminidataanalytics.v1beta.stub.DataChatServiceStub;
import com.google.cloud.geminidataanalytics.v1beta.stub.DataChatServiceStubSettings;
import com.google.cloud.geminidataanalytics.v1beta.stub.GrpcDataChatServiceCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.stub.GrpcOperationsStub;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcDataChatServiceStub
extends DataChatServiceStub {
    private static final MethodDescriptor<ChatRequest, Message> chatMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.cloud.geminidataanalytics.v1beta.DataChatService/Chat").setRequestMarshaller(ProtoUtils.marshaller((com.google.protobuf.Message)ChatRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((com.google.protobuf.Message)Message.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateConversationRequest, Conversation> createConversationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.geminidataanalytics.v1beta.DataChatService/CreateConversation").setRequestMarshaller(ProtoUtils.marshaller((com.google.protobuf.Message)CreateConversationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((com.google.protobuf.Message)Conversation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetConversationRequest, Conversation> getConversationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.geminidataanalytics.v1beta.DataChatService/GetConversation").setRequestMarshaller(ProtoUtils.marshaller((com.google.protobuf.Message)GetConversationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((com.google.protobuf.Message)Conversation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListConversationsRequest, ListConversationsResponse> listConversationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.geminidataanalytics.v1beta.DataChatService/ListConversations").setRequestMarshaller(ProtoUtils.marshaller((com.google.protobuf.Message)ListConversationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((com.google.protobuf.Message)ListConversationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListMessagesRequest, ListMessagesResponse> listMessagesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.geminidataanalytics.v1beta.DataChatService/ListMessages").setRequestMarshaller(ProtoUtils.marshaller((com.google.protobuf.Message)ListMessagesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((com.google.protobuf.Message)ListMessagesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((com.google.protobuf.Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((com.google.protobuf.Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((com.google.protobuf.Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((com.google.protobuf.Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final ServerStreamingCallable<ChatRequest, Message> chatCallable;
    private final UnaryCallable<CreateConversationRequest, Conversation> createConversationCallable;
    private final UnaryCallable<GetConversationRequest, Conversation> getConversationCallable;
    private final UnaryCallable<ListConversationsRequest, ListConversationsResponse> listConversationsCallable;
    private final UnaryCallable<ListConversationsRequest, DataChatServiceClient.ListConversationsPagedResponse> listConversationsPagedCallable;
    private final UnaryCallable<ListMessagesRequest, ListMessagesResponse> listMessagesCallable;
    private final UnaryCallable<ListMessagesRequest, DataChatServiceClient.ListMessagesPagedResponse> listMessagesPagedCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, DataChatServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDataChatServiceStub create(DataChatServiceStubSettings settings) throws IOException {
        return new GrpcDataChatServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDataChatServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcDataChatServiceStub(DataChatServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDataChatServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDataChatServiceStub(DataChatServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDataChatServiceStub(DataChatServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDataChatServiceCallableFactory());
    }

    protected GrpcDataChatServiceStub(DataChatServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings chatTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(chatMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings createConversationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createConversationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getConversationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getConversationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listConversationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listConversationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listMessagesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listMessagesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.chatCallable = callableFactory.createServerStreamingCallable(chatTransportSettings, settings.chatSettings(), clientContext);
        this.createConversationCallable = callableFactory.createUnaryCallable(createConversationTransportSettings, settings.createConversationSettings(), clientContext);
        this.getConversationCallable = callableFactory.createUnaryCallable(getConversationTransportSettings, settings.getConversationSettings(), clientContext);
        this.listConversationsCallable = callableFactory.createUnaryCallable(listConversationsTransportSettings, settings.listConversationsSettings(), clientContext);
        this.listConversationsPagedCallable = callableFactory.createPagedCallable(listConversationsTransportSettings, settings.listConversationsSettings(), clientContext);
        this.listMessagesCallable = callableFactory.createUnaryCallable(listMessagesTransportSettings, settings.listMessagesSettings(), clientContext);
        this.listMessagesPagedCallable = callableFactory.createPagedCallable(listMessagesTransportSettings, settings.listMessagesSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public ServerStreamingCallable<ChatRequest, Message> chatCallable() {
        return this.chatCallable;
    }

    @Override
    public UnaryCallable<CreateConversationRequest, Conversation> createConversationCallable() {
        return this.createConversationCallable;
    }

    @Override
    public UnaryCallable<GetConversationRequest, Conversation> getConversationCallable() {
        return this.getConversationCallable;
    }

    @Override
    public UnaryCallable<ListConversationsRequest, ListConversationsResponse> listConversationsCallable() {
        return this.listConversationsCallable;
    }

    @Override
    public UnaryCallable<ListConversationsRequest, DataChatServiceClient.ListConversationsPagedResponse> listConversationsPagedCallable() {
        return this.listConversationsPagedCallable;
    }

    @Override
    public UnaryCallable<ListMessagesRequest, ListMessagesResponse> listMessagesCallable() {
        return this.listMessagesCallable;
    }

    @Override
    public UnaryCallable<ListMessagesRequest, DataChatServiceClient.ListMessagesPagedResponse> listMessagesPagedCallable() {
        return this.listMessagesPagedCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, DataChatServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

