/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.geminidataanalytics.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.geminidataanalytics.v1beta.ChatRequest;
import com.google.cloud.geminidataanalytics.v1beta.Conversation;
import com.google.cloud.geminidataanalytics.v1beta.CreateConversationRequest;
import com.google.cloud.geminidataanalytics.v1beta.DataChatServiceClient;
import com.google.cloud.geminidataanalytics.v1beta.GetConversationRequest;
import com.google.cloud.geminidataanalytics.v1beta.ListConversationsRequest;
import com.google.cloud.geminidataanalytics.v1beta.ListConversationsResponse;
import com.google.cloud.geminidataanalytics.v1beta.ListMessagesRequest;
import com.google.cloud.geminidataanalytics.v1beta.ListMessagesResponse;
import com.google.cloud.geminidataanalytics.v1beta.Message;
import com.google.cloud.geminidataanalytics.v1beta.StorageMessage;
import com.google.cloud.geminidataanalytics.v1beta.stub.DataChatServiceStub;
import com.google.cloud.geminidataanalytics.v1beta.stub.GrpcDataChatServiceStub;
import com.google.cloud.geminidataanalytics.v1beta.stub.HttpJsonDataChatServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class DataChatServiceStubSettings
extends StubSettings<DataChatServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final ServerStreamingCallSettings<ChatRequest, Message> chatSettings;
    private final UnaryCallSettings<CreateConversationRequest, Conversation> createConversationSettings;
    private final UnaryCallSettings<GetConversationRequest, Conversation> getConversationSettings;
    private final PagedCallSettings<ListConversationsRequest, ListConversationsResponse, DataChatServiceClient.ListConversationsPagedResponse> listConversationsSettings;
    private final PagedCallSettings<ListMessagesRequest, ListMessagesResponse, DataChatServiceClient.ListMessagesPagedResponse> listMessagesSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DataChatServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListConversationsRequest, ListConversationsResponse, Conversation> LIST_CONVERSATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListConversationsRequest, ListConversationsResponse, Conversation>(){

        public String emptyToken() {
            return "";
        }

        public ListConversationsRequest injectToken(ListConversationsRequest payload, String token) {
            return ListConversationsRequest.newBuilder((ListConversationsRequest)payload).setPageToken(token).build();
        }

        public ListConversationsRequest injectPageSize(ListConversationsRequest payload, int pageSize) {
            return ListConversationsRequest.newBuilder((ListConversationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListConversationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListConversationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Conversation> extractResources(ListConversationsResponse payload) {
            return payload.getConversationsList();
        }
    };
    private static final PagedListDescriptor<ListMessagesRequest, ListMessagesResponse, StorageMessage> LIST_MESSAGES_PAGE_STR_DESC = new PagedListDescriptor<ListMessagesRequest, ListMessagesResponse, StorageMessage>(){

        public String emptyToken() {
            return "";
        }

        public ListMessagesRequest injectToken(ListMessagesRequest payload, String token) {
            return ListMessagesRequest.newBuilder((ListMessagesRequest)payload).setPageToken(token).build();
        }

        public ListMessagesRequest injectPageSize(ListMessagesRequest payload, int pageSize) {
            return ListMessagesRequest.newBuilder((ListMessagesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMessagesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMessagesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<StorageMessage> extractResources(ListMessagesResponse payload) {
            return payload.getMessagesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListConversationsRequest, ListConversationsResponse, DataChatServiceClient.ListConversationsPagedResponse> LIST_CONVERSATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListConversationsRequest, ListConversationsResponse, DataChatServiceClient.ListConversationsPagedResponse>(){

        public ApiFuture<DataChatServiceClient.ListConversationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListConversationsRequest, ListConversationsResponse> callable, ListConversationsRequest request, ApiCallContext context, ApiFuture<ListConversationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONVERSATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataChatServiceClient.ListConversationsPagedResponse.createAsync((PageContext<ListConversationsRequest, ListConversationsResponse, Conversation>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListMessagesRequest, ListMessagesResponse, DataChatServiceClient.ListMessagesPagedResponse> LIST_MESSAGES_PAGE_STR_FACT = new PagedListResponseFactory<ListMessagesRequest, ListMessagesResponse, DataChatServiceClient.ListMessagesPagedResponse>(){

        public ApiFuture<DataChatServiceClient.ListMessagesPagedResponse> getFuturePagedResponse(UnaryCallable<ListMessagesRequest, ListMessagesResponse> callable, ListMessagesRequest request, ApiCallContext context, ApiFuture<ListMessagesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MESSAGES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataChatServiceClient.ListMessagesPagedResponse.createAsync((PageContext<ListMessagesRequest, ListMessagesResponse, StorageMessage>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DataChatServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DataChatServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<DataChatServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataChatServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public ServerStreamingCallSettings<ChatRequest, Message> chatSettings() {
        return this.chatSettings;
    }

    public UnaryCallSettings<CreateConversationRequest, Conversation> createConversationSettings() {
        return this.createConversationSettings;
    }

    public UnaryCallSettings<GetConversationRequest, Conversation> getConversationSettings() {
        return this.getConversationSettings;
    }

    public PagedCallSettings<ListConversationsRequest, ListConversationsResponse, DataChatServiceClient.ListConversationsPagedResponse> listConversationsSettings() {
        return this.listConversationsSettings;
    }

    public PagedCallSettings<ListMessagesRequest, ListMessagesResponse, DataChatServiceClient.ListMessagesPagedResponse> listMessagesSettings() {
        return this.listMessagesSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DataChatServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public DataChatServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDataChatServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDataChatServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "geminidataanalytics";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "geminidataanalytics.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "geminidataanalytics.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DataChatServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataChatServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataChatServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DataChatServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DataChatServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.chatSettings = settingsBuilder.chatSettings().build();
        this.createConversationSettings = settingsBuilder.createConversationSettings().build();
        this.getConversationSettings = settingsBuilder.getConversationSettings().build();
        this.listConversationsSettings = settingsBuilder.listConversationsSettings().build();
        this.listMessagesSettings = settingsBuilder.listMessagesSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DataChatServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final ServerStreamingCallSettings.Builder<ChatRequest, Message> chatSettings;
        private final UnaryCallSettings.Builder<CreateConversationRequest, Conversation> createConversationSettings;
        private final UnaryCallSettings.Builder<GetConversationRequest, Conversation> getConversationSettings;
        private final PagedCallSettings.Builder<ListConversationsRequest, ListConversationsResponse, DataChatServiceClient.ListConversationsPagedResponse> listConversationsSettings;
        private final PagedCallSettings.Builder<ListMessagesRequest, ListMessagesResponse, DataChatServiceClient.ListMessagesPagedResponse> listMessagesSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DataChatServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.chatSettings = ServerStreamingCallSettings.newBuilder();
            this.createConversationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getConversationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listConversationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONVERSATIONS_PAGE_STR_FACT);
            this.listMessagesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MESSAGES_PAGE_STR_FACT);
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createConversationSettings, this.getConversationSettings, this.listConversationsSettings, this.listMessagesSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DataChatServiceStubSettings settings) {
            super((StubSettings)settings);
            this.chatSettings = settings.chatSettings.toBuilder();
            this.createConversationSettings = settings.createConversationSettings.toBuilder();
            this.getConversationSettings = settings.getConversationSettings.toBuilder();
            this.listConversationsSettings = settings.listConversationsSettings.toBuilder();
            this.listMessagesSettings = settings.listMessagesSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createConversationSettings, this.getConversationSettings, this.listConversationsSettings, this.listMessagesSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DataChatServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DataChatServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataChatServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DataChatServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DataChatServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DataChatServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataChatServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DataChatServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.chatSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createConversationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getConversationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listConversationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listMessagesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public ServerStreamingCallSettings.Builder<ChatRequest, Message> chatSettings() {
            return this.chatSettings;
        }

        public UnaryCallSettings.Builder<CreateConversationRequest, Conversation> createConversationSettings() {
            return this.createConversationSettings;
        }

        public UnaryCallSettings.Builder<GetConversationRequest, Conversation> getConversationSettings() {
            return this.getConversationSettings;
        }

        public PagedCallSettings.Builder<ListConversationsRequest, ListConversationsResponse, DataChatServiceClient.ListConversationsPagedResponse> listConversationsSettings() {
            return this.listConversationsSettings;
        }

        public PagedCallSettings.Builder<ListMessagesRequest, ListMessagesResponse, DataChatServiceClient.ListMessagesPagedResponse> listMessagesSettings() {
            return this.listMessagesSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DataChatServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public DataChatServiceStubSettings build() throws IOException {
            return new DataChatServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

