/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.geminidataanalytics.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.geminidataanalytics.v1beta.CreateDataAgentRequest;
import com.google.cloud.geminidataanalytics.v1beta.DataAgent;
import com.google.cloud.geminidataanalytics.v1beta.DataAgentServiceClient;
import com.google.cloud.geminidataanalytics.v1beta.DeleteDataAgentRequest;
import com.google.cloud.geminidataanalytics.v1beta.GetDataAgentRequest;
import com.google.cloud.geminidataanalytics.v1beta.ListAccessibleDataAgentsRequest;
import com.google.cloud.geminidataanalytics.v1beta.ListAccessibleDataAgentsResponse;
import com.google.cloud.geminidataanalytics.v1beta.ListDataAgentsRequest;
import com.google.cloud.geminidataanalytics.v1beta.ListDataAgentsResponse;
import com.google.cloud.geminidataanalytics.v1beta.OperationMetadata;
import com.google.cloud.geminidataanalytics.v1beta.UpdateDataAgentRequest;
import com.google.cloud.geminidataanalytics.v1beta.stub.DataAgentServiceStub;
import com.google.cloud.geminidataanalytics.v1beta.stub.GrpcDataAgentServiceStub;
import com.google.cloud.geminidataanalytics.v1beta.stub.HttpJsonDataAgentServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class DataAgentServiceStubSettings
extends StubSettings<DataAgentServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListDataAgentsRequest, ListDataAgentsResponse, DataAgentServiceClient.ListDataAgentsPagedResponse> listDataAgentsSettings;
    private final PagedCallSettings<ListAccessibleDataAgentsRequest, ListAccessibleDataAgentsResponse, DataAgentServiceClient.ListAccessibleDataAgentsPagedResponse> listAccessibleDataAgentsSettings;
    private final UnaryCallSettings<GetDataAgentRequest, DataAgent> getDataAgentSettings;
    private final UnaryCallSettings<CreateDataAgentRequest, Operation> createDataAgentSettings;
    private final OperationCallSettings<CreateDataAgentRequest, DataAgent, OperationMetadata> createDataAgentOperationSettings;
    private final UnaryCallSettings<UpdateDataAgentRequest, Operation> updateDataAgentSettings;
    private final OperationCallSettings<UpdateDataAgentRequest, DataAgent, OperationMetadata> updateDataAgentOperationSettings;
    private final UnaryCallSettings<DeleteDataAgentRequest, Operation> deleteDataAgentSettings;
    private final OperationCallSettings<DeleteDataAgentRequest, Empty, OperationMetadata> deleteDataAgentOperationSettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DataAgentServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListDataAgentsRequest, ListDataAgentsResponse, DataAgent> LIST_DATA_AGENTS_PAGE_STR_DESC = new PagedListDescriptor<ListDataAgentsRequest, ListDataAgentsResponse, DataAgent>(){

        public String emptyToken() {
            return "";
        }

        public ListDataAgentsRequest injectToken(ListDataAgentsRequest payload, String token) {
            return ListDataAgentsRequest.newBuilder((ListDataAgentsRequest)payload).setPageToken(token).build();
        }

        public ListDataAgentsRequest injectPageSize(ListDataAgentsRequest payload, int pageSize) {
            return ListDataAgentsRequest.newBuilder((ListDataAgentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDataAgentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDataAgentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DataAgent> extractResources(ListDataAgentsResponse payload) {
            return payload.getDataAgentsList();
        }
    };
    private static final PagedListDescriptor<ListAccessibleDataAgentsRequest, ListAccessibleDataAgentsResponse, DataAgent> LIST_ACCESSIBLE_DATA_AGENTS_PAGE_STR_DESC = new PagedListDescriptor<ListAccessibleDataAgentsRequest, ListAccessibleDataAgentsResponse, DataAgent>(){

        public String emptyToken() {
            return "";
        }

        public ListAccessibleDataAgentsRequest injectToken(ListAccessibleDataAgentsRequest payload, String token) {
            return ListAccessibleDataAgentsRequest.newBuilder((ListAccessibleDataAgentsRequest)payload).setPageToken(token).build();
        }

        public ListAccessibleDataAgentsRequest injectPageSize(ListAccessibleDataAgentsRequest payload, int pageSize) {
            return ListAccessibleDataAgentsRequest.newBuilder((ListAccessibleDataAgentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAccessibleDataAgentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAccessibleDataAgentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DataAgent> extractResources(ListAccessibleDataAgentsResponse payload) {
            return payload.getDataAgentsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListDataAgentsRequest, ListDataAgentsResponse, DataAgentServiceClient.ListDataAgentsPagedResponse> LIST_DATA_AGENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListDataAgentsRequest, ListDataAgentsResponse, DataAgentServiceClient.ListDataAgentsPagedResponse>(){

        public ApiFuture<DataAgentServiceClient.ListDataAgentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDataAgentsRequest, ListDataAgentsResponse> callable, ListDataAgentsRequest request, ApiCallContext context, ApiFuture<ListDataAgentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATA_AGENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataAgentServiceClient.ListDataAgentsPagedResponse.createAsync((PageContext<ListDataAgentsRequest, ListDataAgentsResponse, DataAgent>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAccessibleDataAgentsRequest, ListAccessibleDataAgentsResponse, DataAgentServiceClient.ListAccessibleDataAgentsPagedResponse> LIST_ACCESSIBLE_DATA_AGENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListAccessibleDataAgentsRequest, ListAccessibleDataAgentsResponse, DataAgentServiceClient.ListAccessibleDataAgentsPagedResponse>(){

        public ApiFuture<DataAgentServiceClient.ListAccessibleDataAgentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAccessibleDataAgentsRequest, ListAccessibleDataAgentsResponse> callable, ListAccessibleDataAgentsRequest request, ApiCallContext context, ApiFuture<ListAccessibleDataAgentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ACCESSIBLE_DATA_AGENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataAgentServiceClient.ListAccessibleDataAgentsPagedResponse.createAsync((PageContext<ListAccessibleDataAgentsRequest, ListAccessibleDataAgentsResponse, DataAgent>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DataAgentServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DataAgentServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<DataAgentServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataAgentServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListDataAgentsRequest, ListDataAgentsResponse, DataAgentServiceClient.ListDataAgentsPagedResponse> listDataAgentsSettings() {
        return this.listDataAgentsSettings;
    }

    public PagedCallSettings<ListAccessibleDataAgentsRequest, ListAccessibleDataAgentsResponse, DataAgentServiceClient.ListAccessibleDataAgentsPagedResponse> listAccessibleDataAgentsSettings() {
        return this.listAccessibleDataAgentsSettings;
    }

    public UnaryCallSettings<GetDataAgentRequest, DataAgent> getDataAgentSettings() {
        return this.getDataAgentSettings;
    }

    public UnaryCallSettings<CreateDataAgentRequest, Operation> createDataAgentSettings() {
        return this.createDataAgentSettings;
    }

    public OperationCallSettings<CreateDataAgentRequest, DataAgent, OperationMetadata> createDataAgentOperationSettings() {
        return this.createDataAgentOperationSettings;
    }

    public UnaryCallSettings<UpdateDataAgentRequest, Operation> updateDataAgentSettings() {
        return this.updateDataAgentSettings;
    }

    public OperationCallSettings<UpdateDataAgentRequest, DataAgent, OperationMetadata> updateDataAgentOperationSettings() {
        return this.updateDataAgentOperationSettings;
    }

    public UnaryCallSettings<DeleteDataAgentRequest, Operation> deleteDataAgentSettings() {
        return this.deleteDataAgentSettings;
    }

    public OperationCallSettings<DeleteDataAgentRequest, Empty, OperationMetadata> deleteDataAgentOperationSettings() {
        return this.deleteDataAgentOperationSettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DataAgentServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public DataAgentServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDataAgentServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDataAgentServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "geminidataanalytics";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "geminidataanalytics.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "geminidataanalytics.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DataAgentServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataAgentServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataAgentServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DataAgentServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DataAgentServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listDataAgentsSettings = settingsBuilder.listDataAgentsSettings().build();
        this.listAccessibleDataAgentsSettings = settingsBuilder.listAccessibleDataAgentsSettings().build();
        this.getDataAgentSettings = settingsBuilder.getDataAgentSettings().build();
        this.createDataAgentSettings = settingsBuilder.createDataAgentSettings().build();
        this.createDataAgentOperationSettings = settingsBuilder.createDataAgentOperationSettings().build();
        this.updateDataAgentSettings = settingsBuilder.updateDataAgentSettings().build();
        this.updateDataAgentOperationSettings = settingsBuilder.updateDataAgentOperationSettings().build();
        this.deleteDataAgentSettings = settingsBuilder.deleteDataAgentSettings().build();
        this.deleteDataAgentOperationSettings = settingsBuilder.deleteDataAgentOperationSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DataAgentServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListDataAgentsRequest, ListDataAgentsResponse, DataAgentServiceClient.ListDataAgentsPagedResponse> listDataAgentsSettings;
        private final PagedCallSettings.Builder<ListAccessibleDataAgentsRequest, ListAccessibleDataAgentsResponse, DataAgentServiceClient.ListAccessibleDataAgentsPagedResponse> listAccessibleDataAgentsSettings;
        private final UnaryCallSettings.Builder<GetDataAgentRequest, DataAgent> getDataAgentSettings;
        private final UnaryCallSettings.Builder<CreateDataAgentRequest, Operation> createDataAgentSettings;
        private final OperationCallSettings.Builder<CreateDataAgentRequest, DataAgent, OperationMetadata> createDataAgentOperationSettings;
        private final UnaryCallSettings.Builder<UpdateDataAgentRequest, Operation> updateDataAgentSettings;
        private final OperationCallSettings.Builder<UpdateDataAgentRequest, DataAgent, OperationMetadata> updateDataAgentOperationSettings;
        private final UnaryCallSettings.Builder<DeleteDataAgentRequest, Operation> deleteDataAgentSettings;
        private final OperationCallSettings.Builder<DeleteDataAgentRequest, Empty, OperationMetadata> deleteDataAgentOperationSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DataAgentServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listDataAgentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATA_AGENTS_PAGE_STR_FACT);
            this.listAccessibleDataAgentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ACCESSIBLE_DATA_AGENTS_PAGE_STR_FACT);
            this.getDataAgentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDataAgentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDataAgentOperationSettings = OperationCallSettings.newBuilder();
            this.updateDataAgentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDataAgentOperationSettings = OperationCallSettings.newBuilder();
            this.deleteDataAgentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDataAgentOperationSettings = OperationCallSettings.newBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDataAgentsSettings, this.listAccessibleDataAgentsSettings, this.getDataAgentSettings, this.createDataAgentSettings, this.updateDataAgentSettings, this.deleteDataAgentSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DataAgentServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listDataAgentsSettings = settings.listDataAgentsSettings.toBuilder();
            this.listAccessibleDataAgentsSettings = settings.listAccessibleDataAgentsSettings.toBuilder();
            this.getDataAgentSettings = settings.getDataAgentSettings.toBuilder();
            this.createDataAgentSettings = settings.createDataAgentSettings.toBuilder();
            this.createDataAgentOperationSettings = settings.createDataAgentOperationSettings.toBuilder();
            this.updateDataAgentSettings = settings.updateDataAgentSettings.toBuilder();
            this.updateDataAgentOperationSettings = settings.updateDataAgentOperationSettings.toBuilder();
            this.deleteDataAgentSettings = settings.deleteDataAgentSettings.toBuilder();
            this.deleteDataAgentOperationSettings = settings.deleteDataAgentOperationSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDataAgentsSettings, this.listAccessibleDataAgentsSettings, this.getDataAgentSettings, this.createDataAgentSettings, this.updateDataAgentSettings, this.deleteDataAgentSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DataAgentServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DataAgentServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataAgentServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DataAgentServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DataAgentServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DataAgentServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataAgentServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DataAgentServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listDataAgentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listAccessibleDataAgentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getDataAgentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createDataAgentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateDataAgentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteDataAgentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createDataAgentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DataAgent.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateDataAgentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DataAgent.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteDataAgentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListDataAgentsRequest, ListDataAgentsResponse, DataAgentServiceClient.ListDataAgentsPagedResponse> listDataAgentsSettings() {
            return this.listDataAgentsSettings;
        }

        public PagedCallSettings.Builder<ListAccessibleDataAgentsRequest, ListAccessibleDataAgentsResponse, DataAgentServiceClient.ListAccessibleDataAgentsPagedResponse> listAccessibleDataAgentsSettings() {
            return this.listAccessibleDataAgentsSettings;
        }

        public UnaryCallSettings.Builder<GetDataAgentRequest, DataAgent> getDataAgentSettings() {
            return this.getDataAgentSettings;
        }

        public UnaryCallSettings.Builder<CreateDataAgentRequest, Operation> createDataAgentSettings() {
            return this.createDataAgentSettings;
        }

        public OperationCallSettings.Builder<CreateDataAgentRequest, DataAgent, OperationMetadata> createDataAgentOperationSettings() {
            return this.createDataAgentOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateDataAgentRequest, Operation> updateDataAgentSettings() {
            return this.updateDataAgentSettings;
        }

        public OperationCallSettings.Builder<UpdateDataAgentRequest, DataAgent, OperationMetadata> updateDataAgentOperationSettings() {
            return this.updateDataAgentOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteDataAgentRequest, Operation> deleteDataAgentSettings() {
            return this.deleteDataAgentSettings;
        }

        public OperationCallSettings.Builder<DeleteDataAgentRequest, Empty, OperationMetadata> deleteDataAgentOperationSettings() {
            return this.deleteDataAgentOperationSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DataAgentServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public DataAgentServiceStubSettings build() throws IOException {
            return new DataAgentServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

