/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1alpha.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gaming.v1alpha.CreateGameServerClusterRequest;
import com.google.cloud.gaming.v1alpha.DeleteGameServerClusterRequest;
import com.google.cloud.gaming.v1alpha.GameServerCluster;
import com.google.cloud.gaming.v1alpha.GameServerClustersServiceClient;
import com.google.cloud.gaming.v1alpha.GetGameServerClusterRequest;
import com.google.cloud.gaming.v1alpha.ListGameServerClustersRequest;
import com.google.cloud.gaming.v1alpha.ListGameServerClustersResponse;
import com.google.cloud.gaming.v1alpha.UpdateGameServerClusterRequest;
import com.google.cloud.gaming.v1alpha.stub.GameServerClustersServiceStub;
import com.google.cloud.gaming.v1alpha.stub.GrpcGameServerClustersServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class GameServerClustersServiceStubSettings
extends StubSettings<GameServerClustersServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerClustersServiceClient.ListGameServerClustersPagedResponse> listGameServerClustersSettings;
    private final UnaryCallSettings<GetGameServerClusterRequest, GameServerCluster> getGameServerClusterSettings;
    private final UnaryCallSettings<CreateGameServerClusterRequest, Operation> createGameServerClusterSettings;
    private final OperationCallSettings<CreateGameServerClusterRequest, GameServerCluster, Empty> createGameServerClusterOperationSettings;
    private final UnaryCallSettings<DeleteGameServerClusterRequest, Operation> deleteGameServerClusterSettings;
    private final OperationCallSettings<DeleteGameServerClusterRequest, Empty, Empty> deleteGameServerClusterOperationSettings;
    private final UnaryCallSettings<UpdateGameServerClusterRequest, Operation> updateGameServerClusterSettings;
    private final OperationCallSettings<UpdateGameServerClusterRequest, GameServerCluster, Empty> updateGameServerClusterOperationSettings;
    private static final PagedListDescriptor<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerCluster> LIST_GAME_SERVER_CLUSTERS_PAGE_STR_DESC = new PagedListDescriptor<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerCluster>(){

        public String emptyToken() {
            return "";
        }

        public ListGameServerClustersRequest injectToken(ListGameServerClustersRequest payload, String token) {
            return ListGameServerClustersRequest.newBuilder((ListGameServerClustersRequest)payload).setPageToken(token).build();
        }

        public ListGameServerClustersRequest injectPageSize(ListGameServerClustersRequest payload, int pageSize) {
            return ListGameServerClustersRequest.newBuilder((ListGameServerClustersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGameServerClustersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGameServerClustersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<GameServerCluster> extractResources(ListGameServerClustersResponse payload) {
            return payload.getGameServerClustersList() != null ? payload.getGameServerClustersList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerClustersServiceClient.ListGameServerClustersPagedResponse> LIST_GAME_SERVER_CLUSTERS_PAGE_STR_FACT = new PagedListResponseFactory<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerClustersServiceClient.ListGameServerClustersPagedResponse>(){

        public ApiFuture<GameServerClustersServiceClient.ListGameServerClustersPagedResponse> getFuturePagedResponse(UnaryCallable<ListGameServerClustersRequest, ListGameServerClustersResponse> callable, ListGameServerClustersRequest request, ApiCallContext context, ApiFuture<ListGameServerClustersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GAME_SERVER_CLUSTERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GameServerClustersServiceClient.ListGameServerClustersPagedResponse.createAsync((PageContext<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerCluster>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerClustersServiceClient.ListGameServerClustersPagedResponse> listGameServerClustersSettings() {
        return this.listGameServerClustersSettings;
    }

    public UnaryCallSettings<GetGameServerClusterRequest, GameServerCluster> getGameServerClusterSettings() {
        return this.getGameServerClusterSettings;
    }

    public UnaryCallSettings<CreateGameServerClusterRequest, Operation> createGameServerClusterSettings() {
        return this.createGameServerClusterSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<CreateGameServerClusterRequest, GameServerCluster, Empty> createGameServerClusterOperationSettings() {
        return this.createGameServerClusterOperationSettings;
    }

    public UnaryCallSettings<DeleteGameServerClusterRequest, Operation> deleteGameServerClusterSettings() {
        return this.deleteGameServerClusterSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<DeleteGameServerClusterRequest, Empty, Empty> deleteGameServerClusterOperationSettings() {
        return this.deleteGameServerClusterOperationSettings;
    }

    public UnaryCallSettings<UpdateGameServerClusterRequest, Operation> updateGameServerClusterSettings() {
        return this.updateGameServerClusterSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<UpdateGameServerClusterRequest, GameServerCluster, Empty> updateGameServerClusterOperationSettings() {
        return this.updateGameServerClusterOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GameServerClustersServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcGameServerClustersServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "gameservices.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return GameServerClustersServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GameServerClustersServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected GameServerClustersServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listGameServerClustersSettings = settingsBuilder.listGameServerClustersSettings().build();
        this.getGameServerClusterSettings = settingsBuilder.getGameServerClusterSettings().build();
        this.createGameServerClusterSettings = settingsBuilder.createGameServerClusterSettings().build();
        this.createGameServerClusterOperationSettings = settingsBuilder.createGameServerClusterOperationSettings().build();
        this.deleteGameServerClusterSettings = settingsBuilder.deleteGameServerClusterSettings().build();
        this.deleteGameServerClusterOperationSettings = settingsBuilder.deleteGameServerClusterOperationSettings().build();
        this.updateGameServerClusterSettings = settingsBuilder.updateGameServerClusterSettings().build();
        this.updateGameServerClusterOperationSettings = settingsBuilder.updateGameServerClusterOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<GameServerClustersServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerClustersServiceClient.ListGameServerClustersPagedResponse> listGameServerClustersSettings;
        private final UnaryCallSettings.Builder<GetGameServerClusterRequest, GameServerCluster> getGameServerClusterSettings;
        private final UnaryCallSettings.Builder<CreateGameServerClusterRequest, Operation> createGameServerClusterSettings;
        private final OperationCallSettings.Builder<CreateGameServerClusterRequest, GameServerCluster, Empty> createGameServerClusterOperationSettings;
        private final UnaryCallSettings.Builder<DeleteGameServerClusterRequest, Operation> deleteGameServerClusterSettings;
        private final OperationCallSettings.Builder<DeleteGameServerClusterRequest, Empty, Empty> deleteGameServerClusterOperationSettings;
        private final UnaryCallSettings.Builder<UpdateGameServerClusterRequest, Operation> updateGameServerClusterSettings;
        private final OperationCallSettings.Builder<UpdateGameServerClusterRequest, GameServerCluster, Empty> updateGameServerClusterOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listGameServerClustersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GAME_SERVER_CLUSTERS_PAGE_STR_FACT);
            this.getGameServerClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGameServerClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGameServerClusterOperationSettings = OperationCallSettings.newBuilder();
            this.deleteGameServerClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGameServerClusterOperationSettings = OperationCallSettings.newBuilder();
            this.updateGameServerClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGameServerClusterOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGameServerClustersSettings, this.getGameServerClusterSettings, this.createGameServerClusterSettings, this.deleteGameServerClusterSettings, this.updateGameServerClusterSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(GameServerClustersServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)GameServerClustersServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GameServerClustersServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(GameServerClustersServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listGameServerClustersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getGameServerClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createGameServerClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteGameServerClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateGameServerClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createGameServerClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(GameServerCluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Empty.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteGameServerClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Empty.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateGameServerClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(GameServerCluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Empty.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        protected Builder(GameServerClustersServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listGameServerClustersSettings = settings.listGameServerClustersSettings.toBuilder();
            this.getGameServerClusterSettings = settings.getGameServerClusterSettings.toBuilder();
            this.createGameServerClusterSettings = settings.createGameServerClusterSettings.toBuilder();
            this.createGameServerClusterOperationSettings = settings.createGameServerClusterOperationSettings.toBuilder();
            this.deleteGameServerClusterSettings = settings.deleteGameServerClusterSettings.toBuilder();
            this.deleteGameServerClusterOperationSettings = settings.deleteGameServerClusterOperationSettings.toBuilder();
            this.updateGameServerClusterSettings = settings.updateGameServerClusterSettings.toBuilder();
            this.updateGameServerClusterOperationSettings = settings.updateGameServerClusterOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGameServerClustersSettings, this.getGameServerClusterSettings, this.createGameServerClusterSettings, this.deleteGameServerClusterSettings, this.updateGameServerClusterSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerClustersServiceClient.ListGameServerClustersPagedResponse> listGameServerClustersSettings() {
            return this.listGameServerClustersSettings;
        }

        public UnaryCallSettings.Builder<GetGameServerClusterRequest, GameServerCluster> getGameServerClusterSettings() {
            return this.getGameServerClusterSettings;
        }

        public UnaryCallSettings.Builder<CreateGameServerClusterRequest, Operation> createGameServerClusterSettings() {
            return this.createGameServerClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateGameServerClusterRequest, GameServerCluster, Empty> createGameServerClusterOperationSettings() {
            return this.createGameServerClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteGameServerClusterRequest, Operation> deleteGameServerClusterSettings() {
            return this.deleteGameServerClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteGameServerClusterRequest, Empty, Empty> deleteGameServerClusterOperationSettings() {
            return this.deleteGameServerClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateGameServerClusterRequest, Operation> updateGameServerClusterSettings() {
            return this.updateGameServerClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateGameServerClusterRequest, GameServerCluster, Empty> updateGameServerClusterOperationSettings() {
            return this.updateGameServerClusterOperationSettings;
        }

        public GameServerClustersServiceStubSettings build() throws IOException {
            return new GameServerClustersServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

