/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1alpha;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.gaming.v1alpha.CreateRealmRequest;
import com.google.cloud.gaming.v1alpha.DeleteRealmRequest;
import com.google.cloud.gaming.v1alpha.GetRealmRequest;
import com.google.cloud.gaming.v1alpha.ListRealmsRequest;
import com.google.cloud.gaming.v1alpha.ListRealmsResponse;
import com.google.cloud.gaming.v1alpha.Realm;
import com.google.cloud.gaming.v1alpha.RealmsServiceSettings;
import com.google.cloud.gaming.v1alpha.UpdateRealmRequest;
import com.google.cloud.gaming.v1alpha.stub.RealmsServiceStub;
import com.google.cloud.gaming.v1alpha.stub.RealmsServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RealmsServiceClient
implements BackgroundResource {
    private final RealmsServiceSettings settings;
    private final RealmsServiceStub stub;
    private final OperationsClient operationsClient;
    private static final PathTemplate LOCATION_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}");
    private static final PathTemplate REALM_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/realms/{realm}");

    @Deprecated
    public static final String formatLocationName(String project, String location) {
        return LOCATION_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location});
    }

    @Deprecated
    public static final String formatRealmName(String project, String location, String realm) {
        return REALM_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location, "realm", realm});
    }

    @Deprecated
    public static final String parseProjectFromLocationName(String locationName) {
        return LOCATION_PATH_TEMPLATE.parse(locationName).get((Object)"project");
    }

    @Deprecated
    public static final String parseLocationFromLocationName(String locationName) {
        return LOCATION_PATH_TEMPLATE.parse(locationName).get((Object)"location");
    }

    @Deprecated
    public static final String parseProjectFromRealmName(String realmName) {
        return REALM_PATH_TEMPLATE.parse(realmName).get((Object)"project");
    }

    @Deprecated
    public static final String parseLocationFromRealmName(String realmName) {
        return REALM_PATH_TEMPLATE.parse(realmName).get((Object)"location");
    }

    @Deprecated
    public static final String parseRealmFromRealmName(String realmName) {
        return REALM_PATH_TEMPLATE.parse(realmName).get((Object)"realm");
    }

    public static final RealmsServiceClient create() throws IOException {
        return RealmsServiceClient.create(RealmsServiceSettings.newBuilder().build());
    }

    public static final RealmsServiceClient create(RealmsServiceSettings settings) throws IOException {
        return new RealmsServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RealmsServiceClient create(RealmsServiceStub stub) {
        return new RealmsServiceClient(stub);
    }

    protected RealmsServiceClient(RealmsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RealmsServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RealmsServiceClient(RealmsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final RealmsServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RealmsServiceStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListRealmsPagedResponse listRealms(String parent) {
        LOCATION_PATH_TEMPLATE.validate(parent, "listRealms");
        ListRealmsRequest request = ListRealmsRequest.newBuilder().setParent(parent).build();
        return this.listRealms(request);
    }

    public final ListRealmsPagedResponse listRealms(ListRealmsRequest request) {
        return (ListRealmsPagedResponse)((Object)this.listRealmsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRealmsRequest, ListRealmsPagedResponse> listRealmsPagedCallable() {
        return this.stub.listRealmsPagedCallable();
    }

    public final UnaryCallable<ListRealmsRequest, ListRealmsResponse> listRealmsCallable() {
        return this.stub.listRealmsCallable();
    }

    public final Realm getRealm(String name) {
        REALM_PATH_TEMPLATE.validate(name, "getRealm");
        GetRealmRequest request = GetRealmRequest.newBuilder().setName(name).build();
        return this.getRealm(request);
    }

    public final Realm getRealm(GetRealmRequest request) {
        return (Realm)this.getRealmCallable().call((Object)request);
    }

    public final UnaryCallable<GetRealmRequest, Realm> getRealmCallable() {
        return this.stub.getRealmCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Realm, Empty> createRealmAsync(String parent, String realmId, Realm realm) {
        LOCATION_PATH_TEMPLATE.validate(parent, "createRealm");
        CreateRealmRequest request = CreateRealmRequest.newBuilder().setParent(parent).setRealmId(realmId).setRealm(realm).build();
        return this.createRealmAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Realm, Empty> createRealmAsync(CreateRealmRequest request) {
        return this.createRealmOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<CreateRealmRequest, Realm, Empty> createRealmOperationCallable() {
        return this.stub.createRealmOperationCallable();
    }

    public final UnaryCallable<CreateRealmRequest, Operation> createRealmCallable() {
        return this.stub.createRealmCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Empty> deleteRealmAsync(String name) {
        REALM_PATH_TEMPLATE.validate(name, "deleteRealm");
        DeleteRealmRequest request = DeleteRealmRequest.newBuilder().setName(name).build();
        return this.deleteRealmAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Empty> deleteRealmAsync(DeleteRealmRequest request) {
        return this.deleteRealmOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<DeleteRealmRequest, Empty, Empty> deleteRealmOperationCallable() {
        return this.stub.deleteRealmOperationCallable();
    }

    public final UnaryCallable<DeleteRealmRequest, Operation> deleteRealmCallable() {
        return this.stub.deleteRealmCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Realm, Empty> updateRealmAsync(Realm realm, FieldMask updateMask) {
        UpdateRealmRequest request = UpdateRealmRequest.newBuilder().setRealm(realm).setUpdateMask(updateMask).build();
        return this.updateRealmAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Realm, Empty> updateRealmAsync(UpdateRealmRequest request) {
        return this.updateRealmOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<UpdateRealmRequest, Realm, Empty> updateRealmOperationCallable() {
        return this.stub.updateRealmOperationCallable();
    }

    public final UnaryCallable<UpdateRealmRequest, Operation> updateRealmCallable() {
        return this.stub.updateRealmCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRealmsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRealmsRequest, ListRealmsResponse, Realm, ListRealmsPage, ListRealmsFixedSizeCollection> {
        private ListRealmsFixedSizeCollection(List<ListRealmsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRealmsFixedSizeCollection createEmptyCollection() {
            return new ListRealmsFixedSizeCollection(null, 0);
        }

        protected ListRealmsFixedSizeCollection createCollection(List<ListRealmsPage> pages, int collectionSize) {
            return new ListRealmsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRealmsPage
    extends AbstractPage<ListRealmsRequest, ListRealmsResponse, Realm, ListRealmsPage> {
        private ListRealmsPage(PageContext<ListRealmsRequest, ListRealmsResponse, Realm> context, ListRealmsResponse response) {
            super(context, (Object)response);
        }

        private static ListRealmsPage createEmptyPage() {
            return new ListRealmsPage(null, null);
        }

        protected ListRealmsPage createPage(PageContext<ListRealmsRequest, ListRealmsResponse, Realm> context, ListRealmsResponse response) {
            return new ListRealmsPage(context, response);
        }

        public ApiFuture<ListRealmsPage> createPageAsync(PageContext<ListRealmsRequest, ListRealmsResponse, Realm> context, ApiFuture<ListRealmsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRealmsPagedResponse
    extends AbstractPagedListResponse<ListRealmsRequest, ListRealmsResponse, Realm, ListRealmsPage, ListRealmsFixedSizeCollection> {
        public static ApiFuture<ListRealmsPagedResponse> createAsync(PageContext<ListRealmsRequest, ListRealmsResponse, Realm> context, ApiFuture<ListRealmsResponse> futureResponse) {
            ApiFuture<ListRealmsPage> futurePage = ListRealmsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRealmsPage, ListRealmsPagedResponse>(){

                public ListRealmsPagedResponse apply(ListRealmsPage input) {
                    return new ListRealmsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListRealmsPagedResponse(ListRealmsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRealmsFixedSizeCollection.createEmptyCollection());
        }
    }
}

