/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1alpha;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.gaming.v1alpha.ClusterPercentageSelector;
import com.google.cloud.gaming.v1alpha.CommitRolloutRequest;
import com.google.cloud.gaming.v1alpha.CreateGameServerDeploymentRequest;
import com.google.cloud.gaming.v1alpha.DeleteGameServerDeploymentRequest;
import com.google.cloud.gaming.v1alpha.DeploymentTarget;
import com.google.cloud.gaming.v1alpha.GameServerDeployment;
import com.google.cloud.gaming.v1alpha.GameServerDeploymentsServiceSettings;
import com.google.cloud.gaming.v1alpha.GameServerTemplate;
import com.google.cloud.gaming.v1alpha.GetDeploymentTargetRequest;
import com.google.cloud.gaming.v1alpha.GetGameServerDeploymentRequest;
import com.google.cloud.gaming.v1alpha.ListGameServerDeploymentsRequest;
import com.google.cloud.gaming.v1alpha.ListGameServerDeploymentsResponse;
import com.google.cloud.gaming.v1alpha.RevertRolloutRequest;
import com.google.cloud.gaming.v1alpha.SetRolloutTargetRequest;
import com.google.cloud.gaming.v1alpha.StartRolloutRequest;
import com.google.cloud.gaming.v1alpha.UpdateGameServerDeploymentRequest;
import com.google.cloud.gaming.v1alpha.stub.GameServerDeploymentsServiceStub;
import com.google.cloud.gaming.v1alpha.stub.GameServerDeploymentsServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GameServerDeploymentsServiceClient
implements BackgroundResource {
    private final GameServerDeploymentsServiceSettings settings;
    private final GameServerDeploymentsServiceStub stub;
    private final OperationsClient operationsClient;
    private static final PathTemplate GAME_SERVER_DEPLOYMENT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/gameServerDeployments/{game_server_deployment}");
    private static final PathTemplate LOCATION_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}");

    @Deprecated
    public static final String formatGameServerDeploymentName(String project, String location, String gameServerDeployment) {
        return GAME_SERVER_DEPLOYMENT_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location, "game_server_deployment", gameServerDeployment});
    }

    @Deprecated
    public static final String formatLocationName(String project, String location) {
        return LOCATION_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location});
    }

    @Deprecated
    public static final String parseProjectFromGameServerDeploymentName(String gameServerDeploymentName) {
        return GAME_SERVER_DEPLOYMENT_PATH_TEMPLATE.parse(gameServerDeploymentName).get((Object)"project");
    }

    @Deprecated
    public static final String parseLocationFromGameServerDeploymentName(String gameServerDeploymentName) {
        return GAME_SERVER_DEPLOYMENT_PATH_TEMPLATE.parse(gameServerDeploymentName).get((Object)"location");
    }

    @Deprecated
    public static final String parseGameServerDeploymentFromGameServerDeploymentName(String gameServerDeploymentName) {
        return GAME_SERVER_DEPLOYMENT_PATH_TEMPLATE.parse(gameServerDeploymentName).get((Object)"game_server_deployment");
    }

    @Deprecated
    public static final String parseProjectFromLocationName(String locationName) {
        return LOCATION_PATH_TEMPLATE.parse(locationName).get((Object)"project");
    }

    @Deprecated
    public static final String parseLocationFromLocationName(String locationName) {
        return LOCATION_PATH_TEMPLATE.parse(locationName).get((Object)"location");
    }

    public static final GameServerDeploymentsServiceClient create() throws IOException {
        return GameServerDeploymentsServiceClient.create(GameServerDeploymentsServiceSettings.newBuilder().build());
    }

    public static final GameServerDeploymentsServiceClient create(GameServerDeploymentsServiceSettings settings) throws IOException {
        return new GameServerDeploymentsServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GameServerDeploymentsServiceClient create(GameServerDeploymentsServiceStub stub) {
        return new GameServerDeploymentsServiceClient(stub);
    }

    protected GameServerDeploymentsServiceClient(GameServerDeploymentsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GameServerDeploymentsServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GameServerDeploymentsServiceClient(GameServerDeploymentsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final GameServerDeploymentsServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GameServerDeploymentsServiceStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListGameServerDeploymentsPagedResponse listGameServerDeployments(String parent) {
        LOCATION_PATH_TEMPLATE.validate(parent, "listGameServerDeployments");
        ListGameServerDeploymentsRequest request = ListGameServerDeploymentsRequest.newBuilder().setParent(parent).build();
        return this.listGameServerDeployments(request);
    }

    public final ListGameServerDeploymentsPagedResponse listGameServerDeployments(ListGameServerDeploymentsRequest request) {
        return (ListGameServerDeploymentsPagedResponse)((Object)this.listGameServerDeploymentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGameServerDeploymentsRequest, ListGameServerDeploymentsPagedResponse> listGameServerDeploymentsPagedCallable() {
        return this.stub.listGameServerDeploymentsPagedCallable();
    }

    public final UnaryCallable<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse> listGameServerDeploymentsCallable() {
        return this.stub.listGameServerDeploymentsCallable();
    }

    public final GameServerDeployment getGameServerDeployment(String name) {
        GAME_SERVER_DEPLOYMENT_PATH_TEMPLATE.validate(name, "getGameServerDeployment");
        GetGameServerDeploymentRequest request = GetGameServerDeploymentRequest.newBuilder().setName(name).build();
        return this.getGameServerDeployment(request);
    }

    public final GameServerDeployment getGameServerDeployment(GetGameServerDeploymentRequest request) {
        return (GameServerDeployment)this.getGameServerDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<GetGameServerDeploymentRequest, GameServerDeployment> getGameServerDeploymentCallable() {
        return this.stub.getGameServerDeploymentCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerDeployment, Empty> createGameServerDeploymentAsync(String parent, String deploymentId, GameServerDeployment gameServerDeployment) {
        LOCATION_PATH_TEMPLATE.validate(parent, "createGameServerDeployment");
        CreateGameServerDeploymentRequest request = CreateGameServerDeploymentRequest.newBuilder().setParent(parent).setDeploymentId(deploymentId).setGameServerDeployment(gameServerDeployment).build();
        return this.createGameServerDeploymentAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerDeployment, Empty> createGameServerDeploymentAsync(CreateGameServerDeploymentRequest request) {
        return this.createGameServerDeploymentOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<CreateGameServerDeploymentRequest, GameServerDeployment, Empty> createGameServerDeploymentOperationCallable() {
        return this.stub.createGameServerDeploymentOperationCallable();
    }

    public final UnaryCallable<CreateGameServerDeploymentRequest, Operation> createGameServerDeploymentCallable() {
        return this.stub.createGameServerDeploymentCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Empty> deleteGameServerDeploymentAsync(String name) {
        GAME_SERVER_DEPLOYMENT_PATH_TEMPLATE.validate(name, "deleteGameServerDeployment");
        DeleteGameServerDeploymentRequest request = DeleteGameServerDeploymentRequest.newBuilder().setName(name).build();
        return this.deleteGameServerDeploymentAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Empty> deleteGameServerDeploymentAsync(DeleteGameServerDeploymentRequest request) {
        return this.deleteGameServerDeploymentOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<DeleteGameServerDeploymentRequest, Empty, Empty> deleteGameServerDeploymentOperationCallable() {
        return this.stub.deleteGameServerDeploymentOperationCallable();
    }

    public final UnaryCallable<DeleteGameServerDeploymentRequest, Operation> deleteGameServerDeploymentCallable() {
        return this.stub.deleteGameServerDeploymentCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerDeployment, Empty> updateGameServerDeploymentAsync(GameServerDeployment gameServerDeployment, FieldMask updateMask) {
        UpdateGameServerDeploymentRequest request = UpdateGameServerDeploymentRequest.newBuilder().setGameServerDeployment(gameServerDeployment).setUpdateMask(updateMask).build();
        return this.updateGameServerDeploymentAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerDeployment, Empty> updateGameServerDeploymentAsync(UpdateGameServerDeploymentRequest request) {
        return this.updateGameServerDeploymentOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<UpdateGameServerDeploymentRequest, GameServerDeployment, Empty> updateGameServerDeploymentOperationCallable() {
        return this.stub.updateGameServerDeploymentOperationCallable();
    }

    public final UnaryCallable<UpdateGameServerDeploymentRequest, Operation> updateGameServerDeploymentCallable() {
        return this.stub.updateGameServerDeploymentCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerDeployment, Empty> startRolloutAsync(String name, GameServerTemplate newGameServerTemplate) {
        GAME_SERVER_DEPLOYMENT_PATH_TEMPLATE.validate(name, "startRollout");
        StartRolloutRequest request = StartRolloutRequest.newBuilder().setName(name).setNewGameServerTemplate(newGameServerTemplate).build();
        return this.startRolloutAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerDeployment, Empty> startRolloutAsync(StartRolloutRequest request) {
        return this.startRolloutOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<StartRolloutRequest, GameServerDeployment, Empty> startRolloutOperationCallable() {
        return this.stub.startRolloutOperationCallable();
    }

    public final UnaryCallable<StartRolloutRequest, Operation> startRolloutCallable() {
        return this.stub.startRolloutCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerDeployment, Empty> setRolloutTargetAsync(String name, List<ClusterPercentageSelector> clusterPercentageSelector) {
        GAME_SERVER_DEPLOYMENT_PATH_TEMPLATE.validate(name, "setRolloutTarget");
        SetRolloutTargetRequest request = SetRolloutTargetRequest.newBuilder().setName(name).addAllClusterPercentageSelector(clusterPercentageSelector).build();
        return this.setRolloutTargetAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerDeployment, Empty> setRolloutTargetAsync(SetRolloutTargetRequest request) {
        return this.setRolloutTargetOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<SetRolloutTargetRequest, GameServerDeployment, Empty> setRolloutTargetOperationCallable() {
        return this.stub.setRolloutTargetOperationCallable();
    }

    public final UnaryCallable<SetRolloutTargetRequest, Operation> setRolloutTargetCallable() {
        return this.stub.setRolloutTargetCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerDeployment, Empty> commitRolloutAsync(String name) {
        GAME_SERVER_DEPLOYMENT_PATH_TEMPLATE.validate(name, "commitRollout");
        CommitRolloutRequest request = CommitRolloutRequest.newBuilder().setName(name).build();
        return this.commitRolloutAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerDeployment, Empty> commitRolloutAsync(CommitRolloutRequest request) {
        return this.commitRolloutOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<CommitRolloutRequest, GameServerDeployment, Empty> commitRolloutOperationCallable() {
        return this.stub.commitRolloutOperationCallable();
    }

    public final UnaryCallable<CommitRolloutRequest, Operation> commitRolloutCallable() {
        return this.stub.commitRolloutCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerDeployment, Empty> revertRolloutAsync(String name) {
        GAME_SERVER_DEPLOYMENT_PATH_TEMPLATE.validate(name, "revertRollout");
        RevertRolloutRequest request = RevertRolloutRequest.newBuilder().setName(name).build();
        return this.revertRolloutAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerDeployment, Empty> revertRolloutAsync(RevertRolloutRequest request) {
        return this.revertRolloutOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<RevertRolloutRequest, GameServerDeployment, Empty> revertRolloutOperationCallable() {
        return this.stub.revertRolloutOperationCallable();
    }

    public final UnaryCallable<RevertRolloutRequest, Operation> revertRolloutCallable() {
        return this.stub.revertRolloutCallable();
    }

    public final DeploymentTarget getDeploymentTarget(String name) {
        GAME_SERVER_DEPLOYMENT_PATH_TEMPLATE.validate(name, "getDeploymentTarget");
        GetDeploymentTargetRequest request = GetDeploymentTargetRequest.newBuilder().setName(name).build();
        return this.getDeploymentTarget(request);
    }

    public final DeploymentTarget getDeploymentTarget(GetDeploymentTargetRequest request) {
        return (DeploymentTarget)this.getDeploymentTargetCallable().call((Object)request);
    }

    public final UnaryCallable<GetDeploymentTargetRequest, DeploymentTarget> getDeploymentTargetCallable() {
        return this.stub.getDeploymentTargetCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListGameServerDeploymentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeployment, ListGameServerDeploymentsPage, ListGameServerDeploymentsFixedSizeCollection> {
        private ListGameServerDeploymentsFixedSizeCollection(List<ListGameServerDeploymentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGameServerDeploymentsFixedSizeCollection createEmptyCollection() {
            return new ListGameServerDeploymentsFixedSizeCollection(null, 0);
        }

        protected ListGameServerDeploymentsFixedSizeCollection createCollection(List<ListGameServerDeploymentsPage> pages, int collectionSize) {
            return new ListGameServerDeploymentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGameServerDeploymentsPage
    extends AbstractPage<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeployment, ListGameServerDeploymentsPage> {
        private ListGameServerDeploymentsPage(PageContext<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeployment> context, ListGameServerDeploymentsResponse response) {
            super(context, (Object)response);
        }

        private static ListGameServerDeploymentsPage createEmptyPage() {
            return new ListGameServerDeploymentsPage(null, null);
        }

        protected ListGameServerDeploymentsPage createPage(PageContext<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeployment> context, ListGameServerDeploymentsResponse response) {
            return new ListGameServerDeploymentsPage(context, response);
        }

        public ApiFuture<ListGameServerDeploymentsPage> createPageAsync(PageContext<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeployment> context, ApiFuture<ListGameServerDeploymentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGameServerDeploymentsPagedResponse
    extends AbstractPagedListResponse<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeployment, ListGameServerDeploymentsPage, ListGameServerDeploymentsFixedSizeCollection> {
        public static ApiFuture<ListGameServerDeploymentsPagedResponse> createAsync(PageContext<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeployment> context, ApiFuture<ListGameServerDeploymentsResponse> futureResponse) {
            ApiFuture<ListGameServerDeploymentsPage> futurePage = ListGameServerDeploymentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListGameServerDeploymentsPage, ListGameServerDeploymentsPagedResponse>(){

                public ListGameServerDeploymentsPagedResponse apply(ListGameServerDeploymentsPage input) {
                    return new ListGameServerDeploymentsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListGameServerDeploymentsPagedResponse(ListGameServerDeploymentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGameServerDeploymentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

