/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1alpha;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.gaming.v1alpha.CreateGameServerClusterRequest;
import com.google.cloud.gaming.v1alpha.DeleteGameServerClusterRequest;
import com.google.cloud.gaming.v1alpha.GameServerCluster;
import com.google.cloud.gaming.v1alpha.GameServerClustersServiceSettings;
import com.google.cloud.gaming.v1alpha.GetGameServerClusterRequest;
import com.google.cloud.gaming.v1alpha.ListGameServerClustersRequest;
import com.google.cloud.gaming.v1alpha.ListGameServerClustersResponse;
import com.google.cloud.gaming.v1alpha.UpdateGameServerClusterRequest;
import com.google.cloud.gaming.v1alpha.stub.GameServerClustersServiceStub;
import com.google.cloud.gaming.v1alpha.stub.GameServerClustersServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GameServerClustersServiceClient
implements BackgroundResource {
    private final GameServerClustersServiceSettings settings;
    private final GameServerClustersServiceStub stub;
    private final OperationsClient operationsClient;
    private static final PathTemplate GAME_SERVER_CLUSTER_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/realms/{realm}/gameServerClusters/{game_server_cluster}");
    private static final PathTemplate REALM_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/realms/{realm}");

    @Deprecated
    public static final String formatGameServerClusterName(String project, String location, String realm, String gameServerCluster) {
        return GAME_SERVER_CLUSTER_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location, "realm", realm, "game_server_cluster", gameServerCluster});
    }

    @Deprecated
    public static final String formatRealmName(String project, String location, String realm) {
        return REALM_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location, "realm", realm});
    }

    @Deprecated
    public static final String parseProjectFromGameServerClusterName(String gameServerClusterName) {
        return GAME_SERVER_CLUSTER_PATH_TEMPLATE.parse(gameServerClusterName).get((Object)"project");
    }

    @Deprecated
    public static final String parseLocationFromGameServerClusterName(String gameServerClusterName) {
        return GAME_SERVER_CLUSTER_PATH_TEMPLATE.parse(gameServerClusterName).get((Object)"location");
    }

    @Deprecated
    public static final String parseRealmFromGameServerClusterName(String gameServerClusterName) {
        return GAME_SERVER_CLUSTER_PATH_TEMPLATE.parse(gameServerClusterName).get((Object)"realm");
    }

    @Deprecated
    public static final String parseGameServerClusterFromGameServerClusterName(String gameServerClusterName) {
        return GAME_SERVER_CLUSTER_PATH_TEMPLATE.parse(gameServerClusterName).get((Object)"game_server_cluster");
    }

    @Deprecated
    public static final String parseProjectFromRealmName(String realmName) {
        return REALM_PATH_TEMPLATE.parse(realmName).get((Object)"project");
    }

    @Deprecated
    public static final String parseLocationFromRealmName(String realmName) {
        return REALM_PATH_TEMPLATE.parse(realmName).get((Object)"location");
    }

    @Deprecated
    public static final String parseRealmFromRealmName(String realmName) {
        return REALM_PATH_TEMPLATE.parse(realmName).get((Object)"realm");
    }

    public static final GameServerClustersServiceClient create() throws IOException {
        return GameServerClustersServiceClient.create(GameServerClustersServiceSettings.newBuilder().build());
    }

    public static final GameServerClustersServiceClient create(GameServerClustersServiceSettings settings) throws IOException {
        return new GameServerClustersServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GameServerClustersServiceClient create(GameServerClustersServiceStub stub) {
        return new GameServerClustersServiceClient(stub);
    }

    protected GameServerClustersServiceClient(GameServerClustersServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GameServerClustersServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GameServerClustersServiceClient(GameServerClustersServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final GameServerClustersServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GameServerClustersServiceStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListGameServerClustersPagedResponse listGameServerClusters(String parent) {
        REALM_PATH_TEMPLATE.validate(parent, "listGameServerClusters");
        ListGameServerClustersRequest request = ListGameServerClustersRequest.newBuilder().setParent(parent).build();
        return this.listGameServerClusters(request);
    }

    public final ListGameServerClustersPagedResponse listGameServerClusters(ListGameServerClustersRequest request) {
        return (ListGameServerClustersPagedResponse)((Object)this.listGameServerClustersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGameServerClustersRequest, ListGameServerClustersPagedResponse> listGameServerClustersPagedCallable() {
        return this.stub.listGameServerClustersPagedCallable();
    }

    public final UnaryCallable<ListGameServerClustersRequest, ListGameServerClustersResponse> listGameServerClustersCallable() {
        return this.stub.listGameServerClustersCallable();
    }

    public final GameServerCluster getGameServerCluster(String name) {
        GAME_SERVER_CLUSTER_PATH_TEMPLATE.validate(name, "getGameServerCluster");
        GetGameServerClusterRequest request = GetGameServerClusterRequest.newBuilder().setName(name).build();
        return this.getGameServerCluster(request);
    }

    public final GameServerCluster getGameServerCluster(GetGameServerClusterRequest request) {
        return (GameServerCluster)this.getGameServerClusterCallable().call((Object)request);
    }

    public final UnaryCallable<GetGameServerClusterRequest, GameServerCluster> getGameServerClusterCallable() {
        return this.stub.getGameServerClusterCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerCluster, Empty> createGameServerClusterAsync(String parent, String gameServerClusterId, GameServerCluster gameServerCluster) {
        REALM_PATH_TEMPLATE.validate(parent, "createGameServerCluster");
        CreateGameServerClusterRequest request = CreateGameServerClusterRequest.newBuilder().setParent(parent).setGameServerClusterId(gameServerClusterId).setGameServerCluster(gameServerCluster).build();
        return this.createGameServerClusterAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerCluster, Empty> createGameServerClusterAsync(CreateGameServerClusterRequest request) {
        return this.createGameServerClusterOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<CreateGameServerClusterRequest, GameServerCluster, Empty> createGameServerClusterOperationCallable() {
        return this.stub.createGameServerClusterOperationCallable();
    }

    public final UnaryCallable<CreateGameServerClusterRequest, Operation> createGameServerClusterCallable() {
        return this.stub.createGameServerClusterCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Empty> deleteGameServerClusterAsync(String name) {
        GAME_SERVER_CLUSTER_PATH_TEMPLATE.validate(name, "deleteGameServerCluster");
        DeleteGameServerClusterRequest request = DeleteGameServerClusterRequest.newBuilder().setName(name).build();
        return this.deleteGameServerClusterAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Empty> deleteGameServerClusterAsync(DeleteGameServerClusterRequest request) {
        return this.deleteGameServerClusterOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<DeleteGameServerClusterRequest, Empty, Empty> deleteGameServerClusterOperationCallable() {
        return this.stub.deleteGameServerClusterOperationCallable();
    }

    public final UnaryCallable<DeleteGameServerClusterRequest, Operation> deleteGameServerClusterCallable() {
        return this.stub.deleteGameServerClusterCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerCluster, Empty> updateGameServerClusterAsync(GameServerCluster gameServerCluster, FieldMask updateMask) {
        UpdateGameServerClusterRequest request = UpdateGameServerClusterRequest.newBuilder().setGameServerCluster(gameServerCluster).setUpdateMask(updateMask).build();
        return this.updateGameServerClusterAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerCluster, Empty> updateGameServerClusterAsync(UpdateGameServerClusterRequest request) {
        return this.updateGameServerClusterOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<UpdateGameServerClusterRequest, GameServerCluster, Empty> updateGameServerClusterOperationCallable() {
        return this.stub.updateGameServerClusterOperationCallable();
    }

    public final UnaryCallable<UpdateGameServerClusterRequest, Operation> updateGameServerClusterCallable() {
        return this.stub.updateGameServerClusterCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListGameServerClustersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerCluster, ListGameServerClustersPage, ListGameServerClustersFixedSizeCollection> {
        private ListGameServerClustersFixedSizeCollection(List<ListGameServerClustersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGameServerClustersFixedSizeCollection createEmptyCollection() {
            return new ListGameServerClustersFixedSizeCollection(null, 0);
        }

        protected ListGameServerClustersFixedSizeCollection createCollection(List<ListGameServerClustersPage> pages, int collectionSize) {
            return new ListGameServerClustersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGameServerClustersPage
    extends AbstractPage<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerCluster, ListGameServerClustersPage> {
        private ListGameServerClustersPage(PageContext<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerCluster> context, ListGameServerClustersResponse response) {
            super(context, (Object)response);
        }

        private static ListGameServerClustersPage createEmptyPage() {
            return new ListGameServerClustersPage(null, null);
        }

        protected ListGameServerClustersPage createPage(PageContext<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerCluster> context, ListGameServerClustersResponse response) {
            return new ListGameServerClustersPage(context, response);
        }

        public ApiFuture<ListGameServerClustersPage> createPageAsync(PageContext<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerCluster> context, ApiFuture<ListGameServerClustersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGameServerClustersPagedResponse
    extends AbstractPagedListResponse<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerCluster, ListGameServerClustersPage, ListGameServerClustersFixedSizeCollection> {
        public static ApiFuture<ListGameServerClustersPagedResponse> createAsync(PageContext<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerCluster> context, ApiFuture<ListGameServerClustersResponse> futureResponse) {
            ApiFuture<ListGameServerClustersPage> futurePage = ListGameServerClustersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListGameServerClustersPage, ListGameServerClustersPagedResponse>(){

                public ListGameServerClustersPagedResponse apply(ListGameServerClustersPage input) {
                    return new ListGameServerClustersPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListGameServerClustersPagedResponse(ListGameServerClustersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGameServerClustersFixedSizeCollection.createEmptyCollection());
        }
    }
}

