/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.functions.v2.CreateFunctionRequest;
import com.google.cloud.functions.v2.DeleteFunctionRequest;
import com.google.cloud.functions.v2.Function;
import com.google.cloud.functions.v2.FunctionServiceClient;
import com.google.cloud.functions.v2.GenerateDownloadUrlRequest;
import com.google.cloud.functions.v2.GenerateDownloadUrlResponse;
import com.google.cloud.functions.v2.GenerateUploadUrlRequest;
import com.google.cloud.functions.v2.GenerateUploadUrlResponse;
import com.google.cloud.functions.v2.GetFunctionRequest;
import com.google.cloud.functions.v2.ListFunctionsRequest;
import com.google.cloud.functions.v2.ListFunctionsResponse;
import com.google.cloud.functions.v2.ListRuntimesRequest;
import com.google.cloud.functions.v2.ListRuntimesResponse;
import com.google.cloud.functions.v2.OperationMetadata;
import com.google.cloud.functions.v2.UpdateFunctionRequest;
import com.google.cloud.functions.v2.stub.FunctionServiceStub;
import com.google.cloud.functions.v2.stub.GrpcFunctionServiceStub;
import com.google.cloud.functions.v2.stub.HttpJsonFunctionServiceStub;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class FunctionServiceStubSettings
extends StubSettings<FunctionServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetFunctionRequest, Function> getFunctionSettings;
    private final PagedCallSettings<ListFunctionsRequest, ListFunctionsResponse, FunctionServiceClient.ListFunctionsPagedResponse> listFunctionsSettings;
    private final UnaryCallSettings<CreateFunctionRequest, Operation> createFunctionSettings;
    private final OperationCallSettings<CreateFunctionRequest, Function, OperationMetadata> createFunctionOperationSettings;
    private final UnaryCallSettings<UpdateFunctionRequest, Operation> updateFunctionSettings;
    private final OperationCallSettings<UpdateFunctionRequest, Function, OperationMetadata> updateFunctionOperationSettings;
    private final UnaryCallSettings<DeleteFunctionRequest, Operation> deleteFunctionSettings;
    private final OperationCallSettings<DeleteFunctionRequest, Empty, OperationMetadata> deleteFunctionOperationSettings;
    private final UnaryCallSettings<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlSettings;
    private final UnaryCallSettings<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlSettings;
    private final UnaryCallSettings<ListRuntimesRequest, ListRuntimesResponse> listRuntimesSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, FunctionServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListFunctionsRequest, ListFunctionsResponse, Function> LIST_FUNCTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListFunctionsRequest, ListFunctionsResponse, Function>(){

        public String emptyToken() {
            return "";
        }

        public ListFunctionsRequest injectToken(ListFunctionsRequest payload, String token) {
            return ListFunctionsRequest.newBuilder((ListFunctionsRequest)payload).setPageToken(token).build();
        }

        public ListFunctionsRequest injectPageSize(ListFunctionsRequest payload, int pageSize) {
            return ListFunctionsRequest.newBuilder((ListFunctionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListFunctionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListFunctionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Function> extractResources(ListFunctionsResponse payload) {
            return payload.getFunctionsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListFunctionsRequest, ListFunctionsResponse, FunctionServiceClient.ListFunctionsPagedResponse> LIST_FUNCTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListFunctionsRequest, ListFunctionsResponse, FunctionServiceClient.ListFunctionsPagedResponse>(){

        public ApiFuture<FunctionServiceClient.ListFunctionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListFunctionsRequest, ListFunctionsResponse> callable, ListFunctionsRequest request, ApiCallContext context, ApiFuture<ListFunctionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FUNCTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return FunctionServiceClient.ListFunctionsPagedResponse.createAsync((PageContext<ListFunctionsRequest, ListFunctionsResponse, Function>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, FunctionServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, FunctionServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<FunctionServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return FunctionServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetFunctionRequest, Function> getFunctionSettings() {
        return this.getFunctionSettings;
    }

    public PagedCallSettings<ListFunctionsRequest, ListFunctionsResponse, FunctionServiceClient.ListFunctionsPagedResponse> listFunctionsSettings() {
        return this.listFunctionsSettings;
    }

    public UnaryCallSettings<CreateFunctionRequest, Operation> createFunctionSettings() {
        return this.createFunctionSettings;
    }

    public OperationCallSettings<CreateFunctionRequest, Function, OperationMetadata> createFunctionOperationSettings() {
        return this.createFunctionOperationSettings;
    }

    public UnaryCallSettings<UpdateFunctionRequest, Operation> updateFunctionSettings() {
        return this.updateFunctionSettings;
    }

    public OperationCallSettings<UpdateFunctionRequest, Function, OperationMetadata> updateFunctionOperationSettings() {
        return this.updateFunctionOperationSettings;
    }

    public UnaryCallSettings<DeleteFunctionRequest, Operation> deleteFunctionSettings() {
        return this.deleteFunctionSettings;
    }

    public OperationCallSettings<DeleteFunctionRequest, Empty, OperationMetadata> deleteFunctionOperationSettings() {
        return this.deleteFunctionOperationSettings;
    }

    public UnaryCallSettings<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlSettings() {
        return this.generateUploadUrlSettings;
    }

    public UnaryCallSettings<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlSettings() {
        return this.generateDownloadUrlSettings;
    }

    public UnaryCallSettings<ListRuntimesRequest, ListRuntimesResponse> listRuntimesSettings() {
        return this.listRuntimesSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, FunctionServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public FunctionServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcFunctionServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonFunctionServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "cloudfunctions";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "cloudfunctions.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudfunctions.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return FunctionServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(FunctionServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(FunctionServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return FunctionServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected FunctionServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getFunctionSettings = settingsBuilder.getFunctionSettings().build();
        this.listFunctionsSettings = settingsBuilder.listFunctionsSettings().build();
        this.createFunctionSettings = settingsBuilder.createFunctionSettings().build();
        this.createFunctionOperationSettings = settingsBuilder.createFunctionOperationSettings().build();
        this.updateFunctionSettings = settingsBuilder.updateFunctionSettings().build();
        this.updateFunctionOperationSettings = settingsBuilder.updateFunctionOperationSettings().build();
        this.deleteFunctionSettings = settingsBuilder.deleteFunctionSettings().build();
        this.deleteFunctionOperationSettings = settingsBuilder.deleteFunctionOperationSettings().build();
        this.generateUploadUrlSettings = settingsBuilder.generateUploadUrlSettings().build();
        this.generateDownloadUrlSettings = settingsBuilder.generateDownloadUrlSettings().build();
        this.listRuntimesSettings = settingsBuilder.listRuntimesSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<FunctionServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetFunctionRequest, Function> getFunctionSettings;
        private final PagedCallSettings.Builder<ListFunctionsRequest, ListFunctionsResponse, FunctionServiceClient.ListFunctionsPagedResponse> listFunctionsSettings;
        private final UnaryCallSettings.Builder<CreateFunctionRequest, Operation> createFunctionSettings;
        private final OperationCallSettings.Builder<CreateFunctionRequest, Function, OperationMetadata> createFunctionOperationSettings;
        private final UnaryCallSettings.Builder<UpdateFunctionRequest, Operation> updateFunctionSettings;
        private final OperationCallSettings.Builder<UpdateFunctionRequest, Function, OperationMetadata> updateFunctionOperationSettings;
        private final UnaryCallSettings.Builder<DeleteFunctionRequest, Operation> deleteFunctionSettings;
        private final OperationCallSettings.Builder<DeleteFunctionRequest, Empty, OperationMetadata> deleteFunctionOperationSettings;
        private final UnaryCallSettings.Builder<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlSettings;
        private final UnaryCallSettings.Builder<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlSettings;
        private final UnaryCallSettings.Builder<ListRuntimesRequest, ListRuntimesResponse> listRuntimesSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, FunctionServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getFunctionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listFunctionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FUNCTIONS_PAGE_STR_FACT);
            this.createFunctionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createFunctionOperationSettings = OperationCallSettings.newBuilder();
            this.updateFunctionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateFunctionOperationSettings = OperationCallSettings.newBuilder();
            this.deleteFunctionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteFunctionOperationSettings = OperationCallSettings.newBuilder();
            this.generateUploadUrlSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.generateDownloadUrlSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRuntimesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getFunctionSettings, this.listFunctionsSettings, this.createFunctionSettings, this.updateFunctionSettings, this.deleteFunctionSettings, this.generateUploadUrlSettings, this.generateDownloadUrlSettings, this.listRuntimesSettings, this.listLocationsSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings, (Object[])new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        protected Builder(FunctionServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getFunctionSettings = settings.getFunctionSettings.toBuilder();
            this.listFunctionsSettings = settings.listFunctionsSettings.toBuilder();
            this.createFunctionSettings = settings.createFunctionSettings.toBuilder();
            this.createFunctionOperationSettings = settings.createFunctionOperationSettings.toBuilder();
            this.updateFunctionSettings = settings.updateFunctionSettings.toBuilder();
            this.updateFunctionOperationSettings = settings.updateFunctionOperationSettings.toBuilder();
            this.deleteFunctionSettings = settings.deleteFunctionSettings.toBuilder();
            this.deleteFunctionOperationSettings = settings.deleteFunctionOperationSettings.toBuilder();
            this.generateUploadUrlSettings = settings.generateUploadUrlSettings.toBuilder();
            this.generateDownloadUrlSettings = settings.generateDownloadUrlSettings.toBuilder();
            this.listRuntimesSettings = settings.listRuntimesSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getFunctionSettings, this.listFunctionsSettings, this.createFunctionSettings, this.updateFunctionSettings, this.deleteFunctionSettings, this.generateUploadUrlSettings, this.generateDownloadUrlSettings, this.listRuntimesSettings, this.listLocationsSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings, (Object[])new UnaryCallSettings.Builder[0]);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(FunctionServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)FunctionServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)FunctionServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(FunctionServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)FunctionServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)FunctionServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)FunctionServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(FunctionServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getFunctionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listFunctionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createFunctionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateFunctionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteFunctionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.generateUploadUrlSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.generateDownloadUrlSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listRuntimesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createFunctionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Function.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateFunctionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Function.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteFunctionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetFunctionRequest, Function> getFunctionSettings() {
            return this.getFunctionSettings;
        }

        public PagedCallSettings.Builder<ListFunctionsRequest, ListFunctionsResponse, FunctionServiceClient.ListFunctionsPagedResponse> listFunctionsSettings() {
            return this.listFunctionsSettings;
        }

        public UnaryCallSettings.Builder<CreateFunctionRequest, Operation> createFunctionSettings() {
            return this.createFunctionSettings;
        }

        public OperationCallSettings.Builder<CreateFunctionRequest, Function, OperationMetadata> createFunctionOperationSettings() {
            return this.createFunctionOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateFunctionRequest, Operation> updateFunctionSettings() {
            return this.updateFunctionSettings;
        }

        public OperationCallSettings.Builder<UpdateFunctionRequest, Function, OperationMetadata> updateFunctionOperationSettings() {
            return this.updateFunctionOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteFunctionRequest, Operation> deleteFunctionSettings() {
            return this.deleteFunctionSettings;
        }

        public OperationCallSettings.Builder<DeleteFunctionRequest, Empty, OperationMetadata> deleteFunctionOperationSettings() {
            return this.deleteFunctionOperationSettings;
        }

        public UnaryCallSettings.Builder<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlSettings() {
            return this.generateUploadUrlSettings;
        }

        public UnaryCallSettings.Builder<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlSettings() {
            return this.generateDownloadUrlSettings;
        }

        public UnaryCallSettings.Builder<ListRuntimesRequest, ListRuntimesResponse> listRuntimesSettings() {
            return this.listRuntimesSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, FunctionServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public FunctionServiceStubSettings build() throws IOException {
            return new FunctionServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

