/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.telemetry;

import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.BaseApiTracer;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.threeten.bp.Duration;

class CompositeApiTracer
extends BaseApiTracer {
    private final List<ApiTracer> children;

    public CompositeApiTracer(List<ApiTracer> children) {
        this.children = ImmutableList.copyOf(children);
    }

    public ApiTracer.Scope inScope() {
        List childScopes = this.children.stream().map(ApiTracer::inScope).collect(Collectors.toCollection(() -> new ArrayList(this.children.size())));
        return () -> childScopes.forEach(ApiTracer.Scope::close);
    }

    public void operationSucceeded() {
        this.children.forEach(ApiTracer::operationSucceeded);
    }

    public void operationCancelled() {
        this.children.forEach(ApiTracer::operationCancelled);
    }

    public void operationFailed(Throwable error) {
        this.children.forEach(child -> child.operationFailed(error));
    }

    public void connectionSelected(String id) {
        this.children.forEach(child -> child.connectionSelected(id));
    }

    public void attemptStarted(int attemptNumber) {
        this.children.forEach(child -> child.attemptStarted(null, attemptNumber));
    }

    public void attemptStarted(Object request, int attemptNumber) {
        this.children.forEach(child -> child.attemptStarted(request, attemptNumber));
    }

    public void attemptSucceeded() {
        this.children.forEach(ApiTracer::attemptSucceeded);
    }

    public void attemptCancelled() {
        this.children.forEach(ApiTracer::attemptCancelled);
    }

    public void attemptFailed(Throwable error, Duration delay) {
        this.children.forEach(child -> child.attemptFailed(error, delay));
    }

    public void attemptFailedDuration(Throwable error, java.time.Duration delay) {
        this.children.forEach(child -> child.attemptFailedDuration(error, delay));
    }

    public void attemptFailedRetriesExhausted(Throwable error) {
        this.children.forEach(child -> child.attemptFailedRetriesExhausted(error));
    }

    public void attemptPermanentFailure(Throwable error) {
        this.children.forEach(child -> child.attemptPermanentFailure(error));
    }

    public void lroStartFailed(Throwable error) {
        this.children.forEach(child -> child.lroStartFailed(error));
    }

    public void lroStartSucceeded() {
        this.children.forEach(ApiTracer::lroStartSucceeded);
    }

    public void responseReceived() {
        this.children.forEach(ApiTracer::responseReceived);
    }

    public void requestSent() {
        this.children.forEach(ApiTracer::requestSent);
    }

    public void batchRequestSent(long elementCount, long requestSize) {
        this.children.forEach(child -> child.batchRequestSent(elementCount, requestSize));
    }
}

