/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.cloud.firestore.v1.stub.FirestoreStub;
import com.google.cloud.firestore.v1.stub.FirestoreStubSettings;
import com.google.cloud.firestore.v1.stub.GrpcFirestoreCallableFactory;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.BatchWriteRequest;
import com.google.firestore.v1.BatchWriteResponse;
import com.google.firestore.v1.BeginTransactionRequest;
import com.google.firestore.v1.BeginTransactionResponse;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.CommitResponse;
import com.google.firestore.v1.CreateDocumentRequest;
import com.google.firestore.v1.DeleteDocumentRequest;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.GetDocumentRequest;
import com.google.firestore.v1.ListCollectionIdsRequest;
import com.google.firestore.v1.ListCollectionIdsResponse;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.ListDocumentsResponse;
import com.google.firestore.v1.ListenRequest;
import com.google.firestore.v1.ListenResponse;
import com.google.firestore.v1.PartitionQueryRequest;
import com.google.firestore.v1.PartitionQueryResponse;
import com.google.firestore.v1.RollbackRequest;
import com.google.firestore.v1.RunAggregationQueryRequest;
import com.google.firestore.v1.RunAggregationQueryResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.UpdateDocumentRequest;
import com.google.firestore.v1.WriteRequest;
import com.google.firestore.v1.WriteResponse;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcFirestoreStub
extends FirestoreStub {
    private static final MethodDescriptor<GetDocumentRequest, Document> getDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/GetDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)GetDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Document.getDefaultInstance())).build();
    private static final MethodDescriptor<ListDocumentsRequest, ListDocumentsResponse> listDocumentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/ListDocuments").setRequestMarshaller(ProtoUtils.marshaller((Message)ListDocumentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListDocumentsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateDocumentRequest, Document> updateDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/UpdateDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Document.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteDocumentRequest, Empty> deleteDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/DeleteDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.firestore.v1.Firestore/BatchGetDocuments").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchGetDocumentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)BatchGetDocumentsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<BeginTransactionRequest, BeginTransactionResponse> beginTransactionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/BeginTransaction").setRequestMarshaller(ProtoUtils.marshaller((Message)BeginTransactionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)BeginTransactionResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CommitRequest, CommitResponse> commitMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/Commit").setRequestMarshaller(ProtoUtils.marshaller((Message)CommitRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CommitResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<RollbackRequest, Empty> rollbackMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/Rollback").setRequestMarshaller(ProtoUtils.marshaller((Message)RollbackRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<RunQueryRequest, RunQueryResponse> runQueryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.firestore.v1.Firestore/RunQuery").setRequestMarshaller(ProtoUtils.marshaller((Message)RunQueryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RunQueryResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQueryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.firestore.v1.Firestore/RunAggregationQuery").setRequestMarshaller(ProtoUtils.marshaller((Message)RunAggregationQueryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RunAggregationQueryResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<PartitionQueryRequest, PartitionQueryResponse> partitionQueryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/PartitionQuery").setRequestMarshaller(ProtoUtils.marshaller((Message)PartitionQueryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PartitionQueryResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<WriteRequest, WriteResponse> writeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName("google.firestore.v1.Firestore/Write").setRequestMarshaller(ProtoUtils.marshaller((Message)WriteRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)WriteResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListenRequest, ListenResponse> listenMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName("google.firestore.v1.Firestore/Listen").setRequestMarshaller(ProtoUtils.marshaller((Message)ListenRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListenResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListCollectionIdsRequest, ListCollectionIdsResponse> listCollectionIdsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/ListCollectionIds").setRequestMarshaller(ProtoUtils.marshaller((Message)ListCollectionIdsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListCollectionIdsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchWriteRequest, BatchWriteResponse> batchWriteMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/BatchWrite").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchWriteRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)BatchWriteResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateDocumentRequest, Document> createDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/CreateDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Document.getDefaultInstance())).build();
    private final UnaryCallable<GetDocumentRequest, Document> getDocumentCallable;
    private final UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> listDocumentsCallable;
    private final UnaryCallable<ListDocumentsRequest, FirestoreClient.ListDocumentsPagedResponse> listDocumentsPagedCallable;
    private final UnaryCallable<UpdateDocumentRequest, Document> updateDocumentCallable;
    private final UnaryCallable<DeleteDocumentRequest, Empty> deleteDocumentCallable;
    private final ServerStreamingCallable<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsCallable;
    private final UnaryCallable<BeginTransactionRequest, BeginTransactionResponse> beginTransactionCallable;
    private final UnaryCallable<CommitRequest, CommitResponse> commitCallable;
    private final UnaryCallable<RollbackRequest, Empty> rollbackCallable;
    private final ServerStreamingCallable<RunQueryRequest, RunQueryResponse> runQueryCallable;
    private final ServerStreamingCallable<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQueryCallable;
    private final UnaryCallable<PartitionQueryRequest, PartitionQueryResponse> partitionQueryCallable;
    private final UnaryCallable<PartitionQueryRequest, FirestoreClient.PartitionQueryPagedResponse> partitionQueryPagedCallable;
    private final BidiStreamingCallable<WriteRequest, WriteResponse> writeCallable;
    private final BidiStreamingCallable<ListenRequest, ListenResponse> listenCallable;
    private final UnaryCallable<ListCollectionIdsRequest, ListCollectionIdsResponse> listCollectionIdsCallable;
    private final UnaryCallable<ListCollectionIdsRequest, FirestoreClient.ListCollectionIdsPagedResponse> listCollectionIdsPagedCallable;
    private final UnaryCallable<BatchWriteRequest, BatchWriteResponse> batchWriteCallable;
    private final UnaryCallable<CreateDocumentRequest, Document> createDocumentCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcFirestoreStub create(FirestoreStubSettings settings) throws IOException {
        return new GrpcFirestoreStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcFirestoreStub create(ClientContext clientContext) throws IOException {
        return new GrpcFirestoreStub(FirestoreStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcFirestoreStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcFirestoreStub(FirestoreStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcFirestoreStub(FirestoreStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcFirestoreCallableFactory());
    }

    protected GrpcFirestoreStub(FirestoreStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDocumentMethodDescriptor).build();
        GrpcCallSettings listDocumentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listDocumentsMethodDescriptor).build();
        GrpcCallSettings updateDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateDocumentMethodDescriptor).build();
        GrpcCallSettings deleteDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteDocumentMethodDescriptor).build();
        GrpcCallSettings batchGetDocumentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchGetDocumentsMethodDescriptor).build();
        GrpcCallSettings beginTransactionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(beginTransactionMethodDescriptor).build();
        GrpcCallSettings commitTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(commitMethodDescriptor).build();
        GrpcCallSettings rollbackTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(rollbackMethodDescriptor).build();
        GrpcCallSettings runQueryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(runQueryMethodDescriptor).build();
        GrpcCallSettings runAggregationQueryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(runAggregationQueryMethodDescriptor).build();
        GrpcCallSettings partitionQueryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(partitionQueryMethodDescriptor).build();
        GrpcCallSettings writeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(writeMethodDescriptor).build();
        GrpcCallSettings listenTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listenMethodDescriptor).build();
        GrpcCallSettings listCollectionIdsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listCollectionIdsMethodDescriptor).build();
        GrpcCallSettings batchWriteTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchWriteMethodDescriptor).build();
        GrpcCallSettings createDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createDocumentMethodDescriptor).build();
        this.getDocumentCallable = callableFactory.createUnaryCallable(getDocumentTransportSettings, settings.getDocumentSettings(), clientContext);
        this.listDocumentsCallable = callableFactory.createUnaryCallable(listDocumentsTransportSettings, settings.listDocumentsSettings(), clientContext);
        this.listDocumentsPagedCallable = callableFactory.createPagedCallable(listDocumentsTransportSettings, settings.listDocumentsSettings(), clientContext);
        this.updateDocumentCallable = callableFactory.createUnaryCallable(updateDocumentTransportSettings, settings.updateDocumentSettings(), clientContext);
        this.deleteDocumentCallable = callableFactory.createUnaryCallable(deleteDocumentTransportSettings, settings.deleteDocumentSettings(), clientContext);
        this.batchGetDocumentsCallable = callableFactory.createServerStreamingCallable(batchGetDocumentsTransportSettings, settings.batchGetDocumentsSettings(), clientContext);
        this.beginTransactionCallable = callableFactory.createUnaryCallable(beginTransactionTransportSettings, settings.beginTransactionSettings(), clientContext);
        this.commitCallable = callableFactory.createUnaryCallable(commitTransportSettings, settings.commitSettings(), clientContext);
        this.rollbackCallable = callableFactory.createUnaryCallable(rollbackTransportSettings, settings.rollbackSettings(), clientContext);
        this.runQueryCallable = callableFactory.createServerStreamingCallable(runQueryTransportSettings, settings.runQuerySettings(), clientContext);
        this.runAggregationQueryCallable = callableFactory.createServerStreamingCallable(runAggregationQueryTransportSettings, settings.runAggregationQuerySettings(), clientContext);
        this.partitionQueryCallable = callableFactory.createUnaryCallable(partitionQueryTransportSettings, settings.partitionQuerySettings(), clientContext);
        this.partitionQueryPagedCallable = callableFactory.createPagedCallable(partitionQueryTransportSettings, settings.partitionQuerySettings(), clientContext);
        this.writeCallable = callableFactory.createBidiStreamingCallable(writeTransportSettings, settings.writeSettings(), clientContext);
        this.listenCallable = callableFactory.createBidiStreamingCallable(listenTransportSettings, settings.listenSettings(), clientContext);
        this.listCollectionIdsCallable = callableFactory.createUnaryCallable(listCollectionIdsTransportSettings, settings.listCollectionIdsSettings(), clientContext);
        this.listCollectionIdsPagedCallable = callableFactory.createPagedCallable(listCollectionIdsTransportSettings, settings.listCollectionIdsSettings(), clientContext);
        this.batchWriteCallable = callableFactory.createUnaryCallable(batchWriteTransportSettings, settings.batchWriteSettings(), clientContext);
        this.createDocumentCallable = callableFactory.createUnaryCallable(createDocumentTransportSettings, settings.createDocumentSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetDocumentRequest, Document> getDocumentCallable() {
        return this.getDocumentCallable;
    }

    @Override
    public UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> listDocumentsCallable() {
        return this.listDocumentsCallable;
    }

    @Override
    public UnaryCallable<ListDocumentsRequest, FirestoreClient.ListDocumentsPagedResponse> listDocumentsPagedCallable() {
        return this.listDocumentsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateDocumentRequest, Document> updateDocumentCallable() {
        return this.updateDocumentCallable;
    }

    @Override
    public UnaryCallable<DeleteDocumentRequest, Empty> deleteDocumentCallable() {
        return this.deleteDocumentCallable;
    }

    @Override
    public ServerStreamingCallable<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsCallable() {
        return this.batchGetDocumentsCallable;
    }

    @Override
    public UnaryCallable<BeginTransactionRequest, BeginTransactionResponse> beginTransactionCallable() {
        return this.beginTransactionCallable;
    }

    @Override
    public UnaryCallable<CommitRequest, CommitResponse> commitCallable() {
        return this.commitCallable;
    }

    @Override
    public UnaryCallable<RollbackRequest, Empty> rollbackCallable() {
        return this.rollbackCallable;
    }

    @Override
    public ServerStreamingCallable<RunQueryRequest, RunQueryResponse> runQueryCallable() {
        return this.runQueryCallable;
    }

    @Override
    public ServerStreamingCallable<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQueryCallable() {
        return this.runAggregationQueryCallable;
    }

    @Override
    public UnaryCallable<PartitionQueryRequest, PartitionQueryResponse> partitionQueryCallable() {
        return this.partitionQueryCallable;
    }

    @Override
    public UnaryCallable<PartitionQueryRequest, FirestoreClient.PartitionQueryPagedResponse> partitionQueryPagedCallable() {
        return this.partitionQueryPagedCallable;
    }

    @Override
    public BidiStreamingCallable<WriteRequest, WriteResponse> writeCallable() {
        return this.writeCallable;
    }

    @Override
    public BidiStreamingCallable<ListenRequest, ListenResponse> listenCallable() {
        return this.listenCallable;
    }

    @Override
    public UnaryCallable<ListCollectionIdsRequest, ListCollectionIdsResponse> listCollectionIdsCallable() {
        return this.listCollectionIdsCallable;
    }

    @Override
    public UnaryCallable<ListCollectionIdsRequest, FirestoreClient.ListCollectionIdsPagedResponse> listCollectionIdsPagedCallable() {
        return this.listCollectionIdsPagedCallable;
    }

    @Override
    public UnaryCallable<BatchWriteRequest, BatchWriteResponse> batchWriteCallable() {
        return this.batchWriteCallable;
    }

    @Override
    public UnaryCallable<CreateDocumentRequest, Document> createDocumentCallable() {
        return this.createDocumentCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

