/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptions;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreRpcContext;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QueryPartition;
import com.google.cloud.firestore.TraceUtil;
import com.google.cloud.firestore.UserDataConverter;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.PartitionQueryRequest;
import io.opencensus.common.Scope;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;

public class CollectionGroup
extends Query {
    CollectionGroup(FirestoreRpcContext<?> rpcContext, String collectionId) {
        super(rpcContext, Query.QueryOptions.builder().setParentPath(rpcContext.getResourcePath()).setCollectionId(collectionId).setAllDescendants(true).build());
    }

    public void getPartitions(long desiredPartitionCount, ApiStreamObserver<QueryPartition> observer) {
        FirestoreClient.PartitionQueryPagedResponse response;
        Query queryWithDefaultOrder = this.orderBy(FieldPath.DOCUMENT_ID);
        PartitionQueryRequest.Builder request = PartitionQueryRequest.newBuilder();
        request.setStructuredQuery(queryWithDefaultOrder.buildQuery());
        request.setParent(this.options.getParentPath().toString());
        request.setPartitionCount(desiredPartitionCount - 1L);
        TraceUtil traceUtil = TraceUtil.getInstance();
        Span span = traceUtil.startSpan("CloudFirestoreOperation.partitionQuery");
        try {
            Scope scope = traceUtil.getTracer().withSpan(span);
            Object object = null;
            try {
                response = (FirestoreClient.PartitionQueryPagedResponse)((Object)ApiExceptions.callAndTranslateApiException(this.rpcContext.sendRequest(request.build(), this.rpcContext.getClient().partitionQueryPagedCallable())));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (scope != null) {
                    if (object != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        scope.close();
                    }
                }
            }
        }
        catch (ApiException exception) {
            span.setStatus(Status.UNKNOWN.withDescription(exception.getMessage()));
            throw FirestoreException.apiException(exception);
        }
        finally {
            span.end(TraceUtil.END_SPAN_OPTIONS);
        }
        Object[] lastCursor = null;
        for (Cursor cursor : response.iterateAll()) {
            Object[] decodedCursorValue = new Object[cursor.getValuesCount()];
            for (int i = 0; i < cursor.getValuesCount(); ++i) {
                decodedCursorValue[i] = UserDataConverter.decodeValue(this.rpcContext, cursor.getValues(i));
            }
            observer.onNext((Object)new QueryPartition(queryWithDefaultOrder, lastCursor, decodedCursorValue));
            lastCursor = decodedCursorValue;
        }
        observer.onNext((Object)new QueryPartition(queryWithDefaultOrder, lastCursor, null));
        observer.onCompleted();
    }
}

