/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptions;
import com.google.cloud.firestore.CustomClassMapper;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.WriteResult;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.common.base.Preconditions;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.DocumentMask;
import com.google.firestore.v1.ListDocumentsRequest;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CollectionReference
extends Query {
    CollectionReference(FirestoreImpl firestore, ResourcePath collectionPath) {
        super(firestore, collectionPath);
    }

    @Nonnull
    public String getId() {
        return this.path.getId();
    }

    @Nullable
    public DocumentReference getParent() {
        ResourcePath parent = (ResourcePath)this.path.getParent();
        return parent.isDocument() ? new DocumentReference(this.firestore, parent) : null;
    }

    @Nonnull
    public String getPath() {
        return this.path.getPath();
    }

    @Nonnull
    public DocumentReference document() {
        return this.document(FirestoreImpl.autoId());
    }

    @Nonnull
    public DocumentReference document(@Nonnull String childPath) {
        ResourcePath documentPath = (ResourcePath)this.path.append(childPath);
        Preconditions.checkArgument((boolean)documentPath.isDocument(), (Object)String.format("Path should point to a Document Reference: %s", this.path));
        return new DocumentReference(this.firestore, documentPath);
    }

    @Nonnull
    public Iterable<DocumentReference> listDocuments() {
        FirestoreClient.ListDocumentsPagedResponse response;
        ListDocumentsRequest.Builder request = ListDocumentsRequest.newBuilder();
        request.setParent(((ResourcePath)this.path.getParent()).toString());
        request.setCollectionId(this.getId());
        request.setMask(DocumentMask.getDefaultInstance());
        request.setShowMissing(true);
        try {
            response = (FirestoreClient.ListDocumentsPagedResponse)((Object)ApiExceptions.callAndTranslateApiException(this.firestore.sendRequest(request.build(), this.firestore.getClient().listDocumentsPagedCallable())));
        }
        catch (ApiException exception) {
            throw FirestoreException.apiException(exception);
        }
        return new Iterable<DocumentReference>(){

            @Override
            @Nonnull
            public Iterator<DocumentReference> iterator() {
                final Iterator iterator = response.iterateAll().iterator();
                return new Iterator<DocumentReference>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public DocumentReference next() {
                        ResourcePath path = ResourcePath.create(((Document)iterator.next()).getName());
                        return CollectionReference.this.document(path.getId());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        };
    }

    @Nonnull
    public ApiFuture<DocumentReference> add(@Nonnull Map<String, Object> fields) {
        final DocumentReference documentReference = this.document();
        ApiFuture<WriteResult> createFuture = documentReference.create(fields);
        return ApiFutures.transform(createFuture, (ApiFunction)new ApiFunction<WriteResult, DocumentReference>(){

            public DocumentReference apply(WriteResult writeResult) {
                return documentReference;
            }
        });
    }

    public ApiFuture<DocumentReference> add(Object pojo) {
        Object converted = CustomClassMapper.convertToPlainJavaTypes(pojo);
        if (!(converted instanceof Map)) {
            FirestoreException.invalidState("Can't set a document's data to an array or primitive", new Object[0]);
        }
        return this.add((Map)converted);
    }
}

