/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.CustomClassMapper;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.EventListener;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.ListenerRegistration;
import com.google.cloud.firestore.Order;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.UserDataConverter;
import com.google.cloud.firestore.Watch;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Value;
import com.google.protobuf.ByteString;
import com.google.protobuf.Int32Value;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Tracing;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Query {
    final ResourcePath path;
    final FirestoreImpl firestore;
    final QueryOptions options;

    Query(FirestoreImpl firestore, ResourcePath path) {
        this(firestore, path, new QueryOptions());
    }

    protected Query(FirestoreImpl firestore, ResourcePath path, QueryOptions queryOptions) {
        Preconditions.checkArgument((boolean)path.isCollection(), (Object)"Invalid path specified. Path should point to a collection");
        this.firestore = firestore;
        this.path = path;
        this.options = queryOptions;
    }

    @Nonnull
    public Firestore getFirestore() {
        return this.firestore;
    }

    private static boolean isUnaryComparison(@Nullable Object value) {
        return value == null || value.equals(Double.NaN) || value.equals(Float.valueOf(Float.NaN));
    }

    private List<FieldOrder> createImplicitOrderBy() {
        ArrayList<FieldOrder> implicitOrders = new ArrayList<FieldOrder>(this.options.fieldOrders);
        boolean hasDocumentId = false;
        if (implicitOrders.isEmpty()) {
            for (FieldFilter fieldFilter : this.options.fieldFilters) {
                if (fieldFilter.isEqualsFilter()) continue;
                implicitOrders.add(new FieldOrder(fieldFilter.fieldPath, Direction.ASCENDING));
                break;
            }
        } else {
            for (FieldOrder fieldOrder : this.options.fieldOrders) {
                if (!fieldOrder.fieldPath.equals(FieldPath.DOCUMENT_ID)) continue;
                hasDocumentId = true;
            }
        }
        if (!hasDocumentId) {
            Direction lastDirection = implicitOrders.isEmpty() ? Direction.ASCENDING : ((FieldOrder)implicitOrders.get((int)(implicitOrders.size() - 1))).direction;
            implicitOrders.add(new FieldOrder(FieldPath.documentId(), lastDirection));
        }
        return implicitOrders;
    }

    private Cursor createCursor(List<FieldOrder> order, DocumentSnapshot documentSnapshot, boolean before) {
        ArrayList<Object> fieldValues = new ArrayList<Object>();
        for (FieldOrder fieldOrder : order) {
            if (fieldOrder.fieldPath.equals(FieldPath.DOCUMENT_ID)) {
                fieldValues.add(documentSnapshot.getReference());
                continue;
            }
            Preconditions.checkArgument((boolean)documentSnapshot.contains(fieldOrder.fieldPath), (Object)"Field '%s' is missing in the provided DocumentSnapshot. Please provide a document that contains values for all specified orderBy() and where() constraints.");
            fieldValues.add(documentSnapshot.get(fieldOrder.fieldPath));
        }
        return this.createCursor(order, fieldValues.toArray(), before);
    }

    private Cursor createCursor(List<FieldOrder> order, Object[] fieldValues, boolean before) {
        Cursor.Builder result = Cursor.newBuilder();
        Preconditions.checkState((fieldValues.length != 0 ? 1 : 0) != 0, (Object)"At least one cursor value must be specified.");
        Preconditions.checkState((fieldValues.length <= order.size() ? 1 : 0) != 0, (Object)"Too many cursor values specified. The specified values must match the orderBy() constraints of the query.");
        Iterator<FieldOrder> fieldOrderIterator = order.iterator();
        for (Object fieldValue : fieldValues) {
            FieldPath fieldPath;
            Object sanitizedValue = (fieldPath = fieldOrderIterator.next().fieldPath).equals(FieldPath.DOCUMENT_ID) ? this.convertReference(fieldValue) : CustomClassMapper.serialize(fieldValue);
            Value encodedValue = UserDataConverter.encodeValue(fieldPath, sanitizedValue, UserDataConverter.ARGUMENT);
            if (encodedValue == null) {
                throw FirestoreException.invalidState("Cannot use FieldValue.delete() or FieldValue.serverTimestamp() in a query boundary", new Object[0]);
            }
            result.addValues(encodedValue);
        }
        result.setBefore(before);
        return result.build();
    }

    private Object convertReference(Object fieldValue) {
        DocumentReference reference;
        if (fieldValue instanceof String) {
            reference = new DocumentReference(this.firestore, (ResourcePath)this.path.append((String)fieldValue));
        } else if (fieldValue instanceof DocumentReference) {
            reference = (DocumentReference)fieldValue;
        } else {
            throw new IllegalArgumentException("The corresponding value for FieldPath.documentId() must be a String or a DocumentReference.");
        }
        if (!this.path.isPrefixOf(reference.getResourcePath())) {
            throw new IllegalArgumentException(String.format("'%s' is not part of the query result set and cannot be used as a query boundary.", reference.getPath()));
        }
        if (!reference.getParent().getResourcePath().equals(this.path)) {
            throw new IllegalArgumentException(String.format("Only a direct child can be used as a query boundary. Found: '%s'", reference.getPath()));
        }
        return reference;
    }

    @Nonnull
    public Query whereEqualTo(@Nonnull String field, @Nullable Object value) {
        return this.whereEqualTo(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public Query whereEqualTo(@Nonnull FieldPath fieldPath, @Nullable Object value) {
        Preconditions.checkState((this.options.startCursor == null && this.options.endCursor == null ? 1 : 0) != 0, (Object)"Cannot call whereEqualTo() after defining a boundary with startAt(), startAfter(), endBefore() or endAt().");
        QueryOptions newOptions = new QueryOptions(this.options);
        if (Query.isUnaryComparison(value)) {
            newOptions.fieldFilters.add(new UnaryFilter(fieldPath, value));
        } else {
            if (fieldPath.equals(FieldPath.DOCUMENT_ID)) {
                value = this.convertReference(value);
            }
            newOptions.fieldFilters.add(new ComparisonFilter(fieldPath, StructuredQuery.FieldFilter.Operator.EQUAL, value));
        }
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query whereLessThan(@Nonnull String field, @Nonnull Object value) {
        return this.whereLessThan(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public Query whereLessThan(@Nonnull FieldPath fieldPath, @Nonnull Object value) {
        Preconditions.checkState((this.options.startCursor == null && this.options.endCursor == null ? 1 : 0) != 0, (Object)"Cannot call whereLessThan() after defining a boundary with startAt(), startAfter(), endBefore() or endAt().");
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.fieldFilters.add(new ComparisonFilter(fieldPath, StructuredQuery.FieldFilter.Operator.LESS_THAN, value));
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query whereLessThanOrEqualTo(@Nonnull String field, @Nonnull Object value) {
        return this.whereLessThanOrEqualTo(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public Query whereLessThanOrEqualTo(@Nonnull FieldPath fieldPath, @Nonnull Object value) {
        Preconditions.checkState((this.options.startCursor == null && this.options.endCursor == null ? 1 : 0) != 0, (Object)"Cannot call whereLessThanOrEqualTo() after defining a boundary with startAt(), startAfter(), endBefore() or endAt().");
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.fieldFilters.add(new ComparisonFilter(fieldPath, StructuredQuery.FieldFilter.Operator.LESS_THAN_OR_EQUAL, value));
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query whereGreaterThan(@Nonnull String field, @Nonnull Object value) {
        return this.whereGreaterThan(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public Query whereGreaterThan(@Nonnull FieldPath fieldPath, @Nonnull Object value) {
        Preconditions.checkState((this.options.startCursor == null && this.options.endCursor == null ? 1 : 0) != 0, (Object)"Cannot call whereGreaterThan() after defining a boundary with startAt(), startAfter(), endBefore() or endAt().");
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.fieldFilters.add(new ComparisonFilter(fieldPath, StructuredQuery.FieldFilter.Operator.GREATER_THAN, value));
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query whereGreaterThanOrEqualTo(@Nonnull String field, @Nonnull Object value) {
        return this.whereGreaterThanOrEqualTo(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public Query whereGreaterThanOrEqualTo(@Nonnull FieldPath fieldPath, @Nonnull Object value) {
        Preconditions.checkState((this.options.startCursor == null && this.options.endCursor == null ? 1 : 0) != 0, (Object)"Cannot call whereGreaterThanOrEqualTo() after defining a boundary with startAt(), startAfter(), endBefore() or endAt().");
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.fieldFilters.add(new ComparisonFilter(fieldPath, StructuredQuery.FieldFilter.Operator.GREATER_THAN_OR_EQUAL, value));
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query whereArrayContains(@Nonnull String field, @Nonnull Object value) {
        return this.whereArrayContains(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public Query whereArrayContains(@Nonnull FieldPath fieldPath, @Nonnull Object value) {
        Preconditions.checkState((this.options.startCursor == null && this.options.endCursor == null ? 1 : 0) != 0, (Object)"Cannot call whereArrayContains() after defining a boundary with startAt(), startAfter(), endBefore() or endAt().");
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.fieldFilters.add(new ComparisonFilter(fieldPath, StructuredQuery.FieldFilter.Operator.ARRAY_CONTAINS, value));
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query orderBy(@Nonnull String field) {
        return this.orderBy(FieldPath.fromDotSeparatedString(field), Direction.ASCENDING);
    }

    @Nonnull
    public Query orderBy(@Nonnull FieldPath fieldPath) {
        return this.orderBy(fieldPath, Direction.ASCENDING);
    }

    @Nonnull
    public Query orderBy(@Nonnull String field, @Nonnull Direction direction) {
        return this.orderBy(FieldPath.fromDotSeparatedString(field), direction);
    }

    @Nonnull
    public Query orderBy(@Nonnull FieldPath fieldPath, @Nonnull Direction direction) {
        Preconditions.checkState((this.options.startCursor == null && this.options.endCursor == null ? 1 : 0) != 0, (Object)"Cannot specify an orderBy() constraint after calling startAt(), startAfter(), endBefore() or endAt().");
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.fieldOrders.add(new FieldOrder(fieldPath, direction));
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query limit(int limit) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.limit = limit;
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query offset(int offset) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.offset = offset;
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query startAt(@Nonnull DocumentSnapshot snapshot) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.fieldOrders = this.createImplicitOrderBy();
        newOptions.startCursor = this.createCursor((List<FieldOrder>)newOptions.fieldOrders, snapshot, true);
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query startAt(Object ... fieldValues) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.startCursor = this.createCursor((List<FieldOrder>)newOptions.fieldOrders, fieldValues, true);
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query select(String ... fields) {
        FieldPath[] fieldPaths = new FieldPath[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldPaths[i] = FieldPath.fromDotSeparatedString(fields[i]);
        }
        return this.select(fieldPaths);
    }

    @Nonnull
    public Query select(FieldPath ... fieldPaths) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.fieldProjections = new ArrayList();
        if (fieldPaths.length == 0) {
            fieldPaths = new FieldPath[]{FieldPath.DOCUMENT_ID};
        }
        for (FieldPath path : fieldPaths) {
            StructuredQuery.FieldReference fieldReference = StructuredQuery.FieldReference.newBuilder().setFieldPath(path.getEncodedPath()).build();
            newOptions.fieldProjections.add(fieldReference);
        }
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query startAfter(@Nonnull DocumentSnapshot snapshot) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.fieldOrders = this.createImplicitOrderBy();
        newOptions.startCursor = this.createCursor((List<FieldOrder>)newOptions.fieldOrders, snapshot, false);
        return new Query(this.firestore, this.path, newOptions);
    }

    public Query startAfter(Object ... fieldValues) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.startCursor = this.createCursor((List<FieldOrder>)newOptions.fieldOrders, fieldValues, false);
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query endBefore(@Nonnull DocumentSnapshot snapshot) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.fieldOrders = this.createImplicitOrderBy();
        newOptions.endCursor = this.createCursor((List<FieldOrder>)newOptions.fieldOrders, snapshot, true);
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query endBefore(Object ... fieldValues) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.endCursor = this.createCursor((List<FieldOrder>)newOptions.fieldOrders, fieldValues, true);
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query endAt(Object ... fieldValues) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.endCursor = this.createCursor((List<FieldOrder>)newOptions.fieldOrders, fieldValues, false);
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query endAt(@Nonnull DocumentSnapshot snapshot) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.fieldOrders = this.createImplicitOrderBy();
        newOptions.endCursor = this.createCursor((List<FieldOrder>)newOptions.fieldOrders, snapshot, false);
        return new Query(this.firestore, this.path, newOptions);
    }

    StructuredQuery.Builder buildQuery() {
        StructuredQuery.Filter filter;
        StructuredQuery.Builder structuredQuery = StructuredQuery.newBuilder();
        structuredQuery.addFrom(StructuredQuery.CollectionSelector.newBuilder().setCollectionId(this.path.getId()));
        if (this.options.fieldFilters.size() == 1) {
            filter = ((FieldFilter)this.options.fieldFilters.get(0)).toProto();
            if (filter.hasFieldFilter()) {
                structuredQuery.getWhereBuilder().setFieldFilter(filter.getFieldFilter());
            } else {
                Preconditions.checkState((boolean)filter.hasUnaryFilter(), (Object)"Expected a UnaryFilter or a FieldFilter.");
                structuredQuery.getWhereBuilder().setUnaryFilter(filter.getUnaryFilter());
            }
        } else if (this.options.fieldFilters.size() > 1) {
            filter = StructuredQuery.Filter.newBuilder();
            StructuredQuery.CompositeFilter.Builder compositeFilter = StructuredQuery.CompositeFilter.newBuilder();
            compositeFilter.setOp(StructuredQuery.CompositeFilter.Operator.AND);
            for (FieldFilter fieldFilter : this.options.fieldFilters) {
                compositeFilter.addFilters(fieldFilter.toProto());
            }
            filter.setCompositeFilter(compositeFilter.build());
            structuredQuery.setWhere(filter.build());
        }
        if (!this.options.fieldOrders.isEmpty()) {
            for (FieldOrder order : this.options.fieldOrders) {
                structuredQuery.addOrderBy(order.toProto());
            }
        }
        if (!this.options.fieldProjections.isEmpty()) {
            structuredQuery.getSelectBuilder().addAllFields((Iterable)this.options.fieldProjections);
        }
        if (this.options.limit != -1) {
            structuredQuery.setLimit(Int32Value.newBuilder().setValue(this.options.limit));
        }
        if (this.options.offset != -1) {
            structuredQuery.setOffset(this.options.offset);
        }
        if (this.options.startCursor != null) {
            structuredQuery.setStartAt(this.options.startCursor);
        }
        if (this.options.endCursor != null) {
            structuredQuery.setEndAt(this.options.endCursor);
        }
        return structuredQuery;
    }

    public void stream(final @Nonnull ApiStreamObserver<DocumentSnapshot> responseObserver) {
        this.stream(new QuerySnapshotObserver(){

            public void onNext(QueryDocumentSnapshot documentSnapshot) {
                responseObserver.onNext((Object)documentSnapshot);
            }

            public void onError(Throwable throwable) {
                responseObserver.onError(throwable);
            }

            public void onCompleted() {
                responseObserver.onCompleted();
            }
        }, null);
    }

    private void stream(final QuerySnapshotObserver documentObserver, @Nullable ByteString transactionId) {
        RunQueryRequest.Builder request = RunQueryRequest.newBuilder();
        request.setStructuredQuery(this.buildQuery()).setParent(((ResourcePath)this.path.getParent()).toString());
        if (transactionId != null) {
            request.setTransaction(transactionId);
        }
        Tracing.getTracer().getCurrentSpan().addAnnotation("Firestore.Query: Start", (Map)ImmutableMap.of((Object)"transactional", (Object)AttributeValue.booleanAttributeValue((transactionId != null ? 1 : 0) != 0)));
        ApiStreamObserver<RunQueryResponse> observer = new ApiStreamObserver<RunQueryResponse>(){
            Timestamp readTime;
            boolean firstResponse;
            int numDocuments;

            public void onNext(RunQueryResponse response) {
                if (!this.firstResponse) {
                    this.firstResponse = true;
                    Tracing.getTracer().getCurrentSpan().addAnnotation("Firestore.Query: First response");
                }
                if (response.hasDocument()) {
                    ++this.numDocuments;
                    if (this.numDocuments % 100 == 0) {
                        Tracing.getTracer().getCurrentSpan().addAnnotation("Firestore.Query: Received 100 documents");
                    }
                    Document document = response.getDocument();
                    QueryDocumentSnapshot documentSnapshot = QueryDocumentSnapshot.fromDocument(Query.this.firestore, Timestamp.fromProto((com.google.protobuf.Timestamp)response.getReadTime()), document);
                    documentObserver.onNext(documentSnapshot);
                }
                if (this.readTime == null) {
                    this.readTime = Timestamp.fromProto((com.google.protobuf.Timestamp)response.getReadTime());
                }
            }

            public void onError(Throwable throwable) {
                Tracing.getTracer().getCurrentSpan().addAnnotation("Firestore.Query: Error");
                documentObserver.onError(throwable);
            }

            public void onCompleted() {
                Tracing.getTracer().getCurrentSpan().addAnnotation("Firestore.Query: Completed", (Map)ImmutableMap.of((Object)"numDocuments", (Object)AttributeValue.longAttributeValue((long)this.numDocuments)));
                documentObserver.onCompleted(this.readTime);
            }
        };
        this.firestore.streamRequest(request.build(), observer, this.firestore.getClient().runQueryCallable());
    }

    @Nonnull
    public ApiFuture<QuerySnapshot> get() {
        return this.get(null);
    }

    @Nonnull
    public ListenerRegistration addSnapshotListener(@Nonnull EventListener<QuerySnapshot> listener) {
        return this.addSnapshotListener(this.firestore.getClient().getExecutor(), listener);
    }

    @Nonnull
    public ListenerRegistration addSnapshotListener(@Nonnull Executor executor, @Nonnull EventListener<QuerySnapshot> listener) {
        return Watch.forQuery(this).runWatch(executor, listener);
    }

    ApiFuture<QuerySnapshot> get(@Nullable ByteString transactionId) {
        final SettableApiFuture result = SettableApiFuture.create();
        this.stream(new QuerySnapshotObserver(){
            List<QueryDocumentSnapshot> documentSnapshots = new ArrayList<QueryDocumentSnapshot>();

            public void onNext(QueryDocumentSnapshot documentSnapshot) {
                this.documentSnapshots.add(documentSnapshot);
            }

            public void onError(Throwable throwable) {
                result.setException(throwable);
            }

            public void onCompleted() {
                QuerySnapshot querySnapshot = QuerySnapshot.withDocuments(Query.this, this.getReadTime(), this.documentSnapshots);
                result.set((Object)querySnapshot);
            }
        }, transactionId);
        return result;
    }

    Comparator<QueryDocumentSnapshot> comparator() {
        return new Comparator<QueryDocumentSnapshot>(){

            @Override
            public int compare(QueryDocumentSnapshot doc1, QueryDocumentSnapshot doc2) {
                Direction lastDirection = Query.this.options.fieldOrders.isEmpty() ? Direction.ASCENDING : ((FieldOrder)((QueryOptions)Query.this.options).fieldOrders.get((int)(((QueryOptions)Query.this.options).fieldOrders.size() - 1))).direction;
                ArrayList<FieldOrder> orderBys = new ArrayList<FieldOrder>();
                orderBys.addAll(Query.this.options.fieldOrders);
                orderBys.add(new FieldOrder(FieldPath.DOCUMENT_ID, lastDirection));
                for (FieldOrder orderBy : orderBys) {
                    int comp;
                    if (orderBy.fieldPath.equals(FieldPath.documentId())) {
                        comp = doc1.getReference().getResourcePath().compareTo(doc2.getReference().getResourcePath());
                    } else {
                        Preconditions.checkState((doc1.contains(orderBy.fieldPath) && doc2.contains(orderBy.fieldPath) ? 1 : 0) != 0, (Object)"Can only compare fields that exist in the DocumentSnapshot. Please include the fields you are ordering on in your select() call.");
                        Value v1 = doc1.extractField(orderBy.fieldPath);
                        Value v2 = doc2.extractField(orderBy.fieldPath);
                        comp = Order.INSTANCE.compare(v1, v2);
                    }
                    if (comp == 0) continue;
                    int direction = orderBy.direction.equals((Object)Direction.ASCENDING) ? 1 : -1;
                    return direction * comp;
                }
                return 0;
            }
        };
    }

    ResourcePath getResourcePath() {
        return this.path;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Query)) {
            return false;
        }
        Query query = (Query)obj;
        return Objects.equals(this.path, query.path) && Objects.equals(this.firestore, query.firestore) && Objects.equals(this.options, query.options);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.firestore, this.options);
    }

    private static abstract class QuerySnapshotObserver
    implements ApiStreamObserver<QueryDocumentSnapshot> {
        private Timestamp readTime;

        private QuerySnapshotObserver() {
        }

        void onCompleted(Timestamp readTime) {
            this.readTime = readTime;
            this.onCompleted();
        }

        Timestamp getReadTime() {
            return this.readTime;
        }
    }

    private static class QueryOptions {
        private int limit;
        private int offset;
        private Cursor startCursor;
        private Cursor endCursor;
        private List<FieldFilter> fieldFilters;
        private List<FieldOrder> fieldOrders;
        private List<StructuredQuery.FieldReference> fieldProjections;

        QueryOptions() {
            this.limit = -1;
            this.offset = -1;
            this.fieldFilters = new ArrayList<FieldFilter>();
            this.fieldOrders = new ArrayList<FieldOrder>();
            this.fieldProjections = new ArrayList<StructuredQuery.FieldReference>();
        }

        QueryOptions(QueryOptions options) {
            this.limit = options.limit;
            this.offset = options.offset;
            this.startCursor = options.startCursor;
            this.endCursor = options.endCursor;
            this.fieldFilters = new ArrayList<FieldFilter>(options.fieldFilters);
            this.fieldOrders = new ArrayList<FieldOrder>(options.fieldOrders);
            this.fieldProjections = options.fieldProjections;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryOptions that = (QueryOptions)o;
            if (this.limit != that.limit) {
                return false;
            }
            if (this.offset != that.offset) {
                return false;
            }
            if (this.startCursor != null ? !this.startCursor.equals((Object)that.startCursor) : that.startCursor != null) {
                return false;
            }
            if (this.endCursor != null ? !this.endCursor.equals((Object)that.endCursor) : that.endCursor != null) {
                return false;
            }
            if (!this.fieldFilters.equals(that.fieldFilters)) {
                return false;
            }
            if (!this.fieldOrders.equals(that.fieldOrders)) {
                return false;
            }
            return this.fieldProjections.equals(that.fieldProjections);
        }

        public int hashCode() {
            int result = this.limit;
            result = 31 * result + this.offset;
            result = 31 * result + (this.startCursor != null ? this.startCursor.hashCode() : 0);
            result = 31 * result + (this.endCursor != null ? this.endCursor.hashCode() : 0);
            result = 31 * result + this.fieldFilters.hashCode();
            result = 31 * result + this.fieldOrders.hashCode();
            result = 31 * result + this.fieldProjections.hashCode();
            return result;
        }
    }

    private static class FieldOrder {
        final FieldPath fieldPath;
        final Direction direction;

        FieldOrder(FieldPath fieldPath, Direction direction) {
            this.fieldPath = fieldPath;
            this.direction = direction;
        }

        StructuredQuery.Order toProto() {
            StructuredQuery.Order.Builder result = StructuredQuery.Order.newBuilder();
            result.setField(StructuredQuery.FieldReference.newBuilder().setFieldPath(this.fieldPath.getEncodedPath()));
            result.setDirection(this.direction.getDirection());
            return result.build();
        }
    }

    private static class ComparisonFilter
    extends FieldFilter {
        final StructuredQuery.FieldFilter.Operator operator;

        ComparisonFilter(FieldPath fieldPath, StructuredQuery.FieldFilter.Operator operator, Object value) {
            super(fieldPath, value);
            Preconditions.checkArgument((!Query.isUnaryComparison(value) ? 1 : 0) != 0, (String)"Cannot use '%s' in field comparison", (Object)value);
            this.operator = operator;
        }

        @Override
        boolean isEqualsFilter() {
            return this.operator.equals((Object)StructuredQuery.FieldFilter.Operator.EQUAL);
        }

        @Override
        StructuredQuery.Filter toProto() {
            StructuredQuery.Filter.Builder result = StructuredQuery.Filter.newBuilder();
            Value encodedValue = this.encodeValue();
            result.getFieldFilterBuilder().setField(StructuredQuery.FieldReference.newBuilder().setFieldPath(this.fieldPath.getEncodedPath())).setValue(encodedValue).setOp(this.operator);
            return result.build();
        }
    }

    private static class UnaryFilter
    extends FieldFilter {
        UnaryFilter(FieldPath fieldPath, Object value) {
            super(fieldPath, value);
            Preconditions.checkArgument((boolean)Query.isUnaryComparison(value), (String)"Cannot use '%s' in unary comparison", (Object)value);
        }

        @Override
        boolean isEqualsFilter() {
            return true;
        }

        @Override
        StructuredQuery.Filter toProto() {
            StructuredQuery.Filter.Builder result = StructuredQuery.Filter.newBuilder();
            result.getUnaryFilterBuilder().setField(StructuredQuery.FieldReference.newBuilder().setFieldPath(this.fieldPath.getEncodedPath())).setOp(this.value == null ? StructuredQuery.UnaryFilter.Operator.IS_NULL : StructuredQuery.UnaryFilter.Operator.IS_NAN);
            return result.build();
        }
    }

    private static abstract class FieldFilter {
        final FieldPath fieldPath;
        final Object value;

        FieldFilter(FieldPath fieldPath, Object value) {
            this.value = value;
            this.fieldPath = fieldPath;
        }

        Value encodeValue() {
            Object sanitizedObject = CustomClassMapper.serialize(this.value);
            Value encodedValue = UserDataConverter.encodeValue(this.fieldPath, sanitizedObject, UserDataConverter.ARGUMENT);
            if (encodedValue == null) {
                throw FirestoreException.invalidState("Cannot use Firestore Sentinels in FieldFilter", new Object[0]);
            }
            return encodedValue;
        }

        abstract boolean isEqualsFilter();

        abstract StructuredQuery.Filter toProto();
    }

    public static enum Direction {
        ASCENDING(StructuredQuery.Direction.ASCENDING),
        DESCENDING(StructuredQuery.Direction.DESCENDING);

        private final StructuredQuery.Direction direction;

        private Direction(StructuredQuery.Direction direction) {
            this.direction = direction;
        }

        StructuredQuery.Direction getDirection() {
            return this.direction;
        }
    }
}

