/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FieldValue;
import com.google.firestore.v1beta1.DocumentMask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;

public final class FieldMask {
    static final FieldMask EMPTY_MASK = new FieldMask((SortedSet<FieldPath>)new TreeSet<FieldPath>());
    private final SortedSet<FieldPath> fieldPaths;

    FieldMask(Collection<FieldPath> fieldPaths) {
        this((SortedSet<FieldPath>)new TreeSet<FieldPath>(fieldPaths));
    }

    private FieldMask(SortedSet<FieldPath> fieldPaths) {
        this.fieldPaths = fieldPaths;
    }

    @Nonnull
    public static FieldMask of(String ... fieldPaths) {
        ArrayList<FieldPath> paths = new ArrayList<FieldPath>();
        for (String fieldPath : fieldPaths) {
            paths.add(FieldPath.fromDotSeparatedString(fieldPath));
        }
        return new FieldMask(paths);
    }

    @Nonnull
    public static FieldMask of(FieldPath ... fieldPaths) {
        return new FieldMask(Arrays.asList(fieldPaths));
    }

    static FieldMask fromObject(Map<String, Object> values) {
        List<FieldPath> fieldPaths = FieldMask.extractFromMap(values, FieldPath.empty());
        return new FieldMask(fieldPaths);
    }

    private static List<FieldPath> extractFromMap(Map<String, Object> values, FieldPath path) {
        ArrayList<FieldPath> fieldPaths = new ArrayList<FieldPath>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            Object value = entry.getValue();
            FieldPath childPath = path.append(FieldPath.of(entry.getKey()));
            if (entry.getValue() instanceof FieldValue) {
                if (!((FieldValue)entry.getValue()).includeInDocumentMask()) continue;
                fieldPaths.add(childPath);
                continue;
            }
            if (value instanceof Map) {
                fieldPaths.addAll(FieldMask.extractFromMap((Map)value, childPath));
                continue;
            }
            fieldPaths.add(childPath);
        }
        return fieldPaths;
    }

    DocumentMask toPb() {
        DocumentMask.Builder updateMask = DocumentMask.newBuilder();
        for (FieldPath fieldPath : this.fieldPaths) {
            updateMask.addFieldPaths(fieldPath.getEncodedPath());
        }
        return updateMask.build();
    }

    boolean isEmpty() {
        return this.fieldPaths.isEmpty();
    }
}

