/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldMask;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.cloud.firestore.UpdateBuilder;
import com.google.cloud.firestore.WriteResult;
import com.google.common.base.Preconditions;
import com.google.firestore.v1beta1.BeginTransactionRequest;
import com.google.firestore.v1beta1.BeginTransactionResponse;
import com.google.firestore.v1beta1.RollbackRequest;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Transaction
extends UpdateBuilder<Transaction> {
    private static final String READ_BEFORE_WRITE_ERROR_MSG = "Firestore transactions require all reads to be executed before all writes";
    private final ByteString previousTransactionId;
    private ByteString transactionId;
    private boolean pending;

    Transaction(FirestoreImpl firestore, @Nullable ByteString previousTransactionId) {
        super(firestore);
        this.previousTransactionId = previousTransactionId;
    }

    @Nullable
    ByteString getTransactionId() {
        return this.transactionId;
    }

    boolean isPending() {
        return this.pending;
    }

    ApiFuture<Void> begin() {
        BeginTransactionRequest.Builder beginTransaction = BeginTransactionRequest.newBuilder();
        beginTransaction.setDatabase(this.firestore.getDatabaseName());
        if (this.previousTransactionId != null) {
            beginTransaction.getOptionsBuilder().getReadWriteBuilder().setRetryTransaction(this.previousTransactionId);
        }
        ApiFuture<BeginTransactionResponse> transactionBeginFuture = this.firestore.sendRequest(beginTransaction.build(), this.firestore.getClient().beginTransactionCallable());
        return ApiFutures.transform(transactionBeginFuture, (ApiFunction)new ApiFunction<BeginTransactionResponse, Void>(){

            public Void apply(BeginTransactionResponse beginTransactionResponse) {
                Transaction.this.transactionId = beginTransactionResponse.getTransaction();
                Transaction.this.pending = true;
                return null;
            }
        });
    }

    ApiFuture<List<WriteResult>> commit() {
        this.pending = false;
        return super.commit(this.transactionId);
    }

    ApiFuture<Void> rollback() {
        this.pending = false;
        RollbackRequest.Builder reqBuilder = RollbackRequest.newBuilder();
        reqBuilder.setTransaction(this.transactionId);
        reqBuilder.setDatabase(this.firestore.getDatabaseName());
        ApiFuture<Empty> rollbackFuture = this.firestore.sendRequest(reqBuilder.build(), this.firestore.getClient().rollbackCallable());
        return ApiFutures.transform(rollbackFuture, (ApiFunction)new ApiFunction<Empty, Void>(){

            public Void apply(Empty beginTransactionResponse) {
                return null;
            }
        });
    }

    @Nonnull
    public ApiFuture<DocumentSnapshot> get(@Nonnull DocumentReference documentRef) {
        Preconditions.checkState((boolean)this.isEmpty(), (Object)READ_BEFORE_WRITE_ERROR_MSG);
        return ApiFutures.transform(this.firestore.getAll(new DocumentReference[]{documentRef}, null, this.transactionId), (ApiFunction)new ApiFunction<List<DocumentSnapshot>, DocumentSnapshot>(){

            public DocumentSnapshot apply(List<DocumentSnapshot> snapshots) {
                return snapshots.isEmpty() ? null : snapshots.get(0);
            }
        });
    }

    @Nonnull
    public ApiFuture<List<DocumentSnapshot>> getAll(DocumentReference ... documentReferences) {
        Preconditions.checkState((boolean)this.isEmpty(), (Object)READ_BEFORE_WRITE_ERROR_MSG);
        return this.firestore.getAll(documentReferences, null, this.transactionId);
    }

    @Nonnull
    public ApiFuture<List<DocumentSnapshot>> getAll(@Nonnull DocumentReference[] documentReferences, @Nullable FieldMask fieldMask) {
        Preconditions.checkState((boolean)this.isEmpty(), (Object)READ_BEFORE_WRITE_ERROR_MSG);
        return this.firestore.getAll(documentReferences, fieldMask, this.transactionId);
    }

    @Nonnull
    public ApiFuture<QuerySnapshot> get(@Nonnull Query query) {
        Preconditions.checkState((boolean)this.isEmpty(), (Object)READ_BEFORE_WRITE_ERROR_MSG);
        return query.get(this.transactionId);
    }

    public static interface Function<T> {
        public T updateCallback(Transaction var1) throws Exception;
    }
}

