/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.ResourcePath;
import com.google.firestore.v1beta1.Value;
import com.google.protobuf.ByteString;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;

class Order
implements Comparator<Value> {
    static final Order INSTANCE = new Order();

    private Order() {
    }

    @Override
    public int compare(@Nonnull Value left, @Nonnull Value right) {
        TypeOrder rightType;
        TypeOrder leftType = TypeOrder.fromValue(left);
        int typeComparison = leftType.compareTo(rightType = TypeOrder.fromValue(right));
        if (typeComparison != 0) {
            return typeComparison;
        }
        switch (leftType) {
            case NULL: {
                return 0;
            }
            case BOOLEAN: {
                return Boolean.compare(left.getBooleanValue(), right.getBooleanValue());
            }
            case NUMBER: {
                return this.compareNumbers(left, right);
            }
            case TIMESTAMP: {
                return Order.compareTimestamps(left, right);
            }
            case STRING: {
                return this.compareStrings(left, right);
            }
            case BLOB: {
                return this.compareBlobs(left, right);
            }
            case REF: {
                return this.compareResourcePaths(left, right);
            }
            case GEO_POINT: {
                return Order.compareGeoPoints(left, right);
            }
            case ARRAY: {
                return this.compareArrays(left, right);
            }
            case OBJECT: {
                return this.compareObjects(left, right);
            }
        }
        throw new IllegalArgumentException("Cannot compare " + leftType);
    }

    private int compareStrings(Value left, Value right) {
        return left.getStringValue().compareTo(right.getStringValue());
    }

    private int compareBlobs(Value left, Value right) {
        ByteString leftBytes = left.getBytesValue();
        ByteString rightBytes = right.getBytesValue();
        int size = Math.min(leftBytes.size(), rightBytes.size());
        for (int i = 0; i < size; ++i) {
            int otherByte;
            int thisByte = leftBytes.byteAt(i) & 0xFF;
            if (thisByte < (otherByte = rightBytes.byteAt(i) & 0xFF)) {
                return -1;
            }
            if (thisByte <= otherByte) continue;
            return 1;
        }
        return Integer.compare(leftBytes.size(), rightBytes.size());
    }

    private static int compareTimestamps(Value left, Value right) {
        int cmp = Long.compare(left.getTimestampValue().getSeconds(), right.getTimestampValue().getSeconds());
        if (cmp != 0) {
            return cmp;
        }
        return Integer.compare(left.getTimestampValue().getNanos(), right.getTimestampValue().getNanos());
    }

    private static int compareGeoPoints(Value left, Value right) {
        int cmp = Double.compare(left.getGeoPointValue().getLatitude(), right.getGeoPointValue().getLatitude());
        if (cmp != 0) {
            return cmp;
        }
        return Double.compare(left.getGeoPointValue().getLongitude(), right.getGeoPointValue().getLongitude());
    }

    private int compareResourcePaths(Value left, Value right) {
        ResourcePath leftPath = ResourcePath.create(left.getReferenceValue());
        ResourcePath rightPath = ResourcePath.create(right.getReferenceValue());
        return leftPath.compareTo(rightPath);
    }

    private int compareArrays(Value left, Value right) {
        List leftValue = left.getArrayValue().getValuesList();
        List rightValue = right.getArrayValue().getValuesList();
        int minLength = Math.min(leftValue.size(), rightValue.size());
        for (int i = 0; i < minLength; ++i) {
            int cmp = this.compare((Value)leftValue.get(i), (Value)rightValue.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(leftValue.size(), rightValue.size());
    }

    private int compareObjects(Value left, Value right) {
        TreeMap leftMap = new TreeMap();
        leftMap.putAll(left.getMapValue().getFieldsMap());
        TreeMap rightMap = new TreeMap();
        rightMap.putAll(right.getMapValue().getFieldsMap());
        Iterator leftIterator = leftMap.entrySet().iterator();
        Iterator rightIterator = rightMap.entrySet().iterator();
        while (leftIterator.hasNext() && rightIterator.hasNext()) {
            Map.Entry leftEntry = leftIterator.next();
            Map.Entry rightEntry = rightIterator.next();
            int keyCompare = ((String)leftEntry.getKey()).compareTo((String)rightEntry.getKey());
            if (keyCompare != 0) {
                return keyCompare;
            }
            int valueCompare = this.compare((Value)leftEntry.getValue(), (Value)rightEntry.getValue());
            if (valueCompare == 0) continue;
            return valueCompare;
        }
        return Boolean.compare(leftIterator.hasNext(), rightIterator.hasNext());
    }

    private int compareNumbers(Value left, Value right) {
        if (left.getValueTypeCase() == Value.ValueTypeCase.DOUBLE_VALUE) {
            if (right.getValueTypeCase() == Value.ValueTypeCase.DOUBLE_VALUE) {
                return this.compareDoubles(left.getDoubleValue(), right.getDoubleValue());
            }
            return this.compareDoubles(left.getDoubleValue(), right.getIntegerValue());
        }
        if (right.getValueTypeCase() == Value.ValueTypeCase.INTEGER_VALUE) {
            return Long.compare(left.getIntegerValue(), right.getIntegerValue());
        }
        return this.compareDoubles(left.getIntegerValue(), right.getDoubleValue());
    }

    private int compareDoubles(double left, double right) {
        if (Double.isNaN(left)) {
            return Double.isNaN(right) ? 0 : -1;
        }
        if (Double.isNaN(right)) {
            return 1;
        }
        return Double.compare(left == -0.0 ? 0.0 : left, right == -0.0 ? 0.0 : right);
    }

    static enum TypeOrder implements Comparable<TypeOrder>
    {
        NULL,
        BOOLEAN,
        NUMBER,
        TIMESTAMP,
        STRING,
        BLOB,
        REF,
        GEO_POINT,
        ARRAY,
        OBJECT;


        static TypeOrder fromValue(Value value) {
            switch (value.getValueTypeCase()) {
                case NULL_VALUE: {
                    return NULL;
                }
                case BOOLEAN_VALUE: {
                    return BOOLEAN;
                }
                case INTEGER_VALUE: {
                    return NUMBER;
                }
                case DOUBLE_VALUE: {
                    return NUMBER;
                }
                case TIMESTAMP_VALUE: {
                    return TIMESTAMP;
                }
                case STRING_VALUE: {
                    return STRING;
                }
                case BYTES_VALUE: {
                    return BLOB;
                }
                case REFERENCE_VALUE: {
                    return REF;
                }
                case GEO_POINT_VALUE: {
                    return GEO_POINT;
                }
                case ARRAY_VALUE: {
                    return ARRAY;
                }
                case MAP_VALUE: {
                    return OBJECT;
                }
            }
            throw new IllegalArgumentException("Could not detect value type for " + value);
        }
    }
}

