/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.Timestamp;
import com.google.cloud.firestore.CustomClassMapper;
import com.google.cloud.firestore.DocumentChange;
import com.google.cloud.firestore.DocumentSet;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class QuerySnapshot
implements Iterable<QueryDocumentSnapshot> {
    private final Query query;
    private final Timestamp readTime;

    private QuerySnapshot(Query query, Timestamp readTime) {
        this.query = query;
        this.readTime = readTime;
    }

    public static QuerySnapshot withDocuments(final Query query, Timestamp readTime, final List<QueryDocumentSnapshot> documents) {
        return new QuerySnapshot(query, readTime){
            volatile List<DocumentChange> documentChanges;

            @Override
            @Nonnull
            public List<QueryDocumentSnapshot> getDocuments() {
                return Collections.unmodifiableList(documents);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nonnull
            public List<DocumentChange> getDocumentChanges() {
                if (this.documentChanges == null) {
                    List list = documents;
                    synchronized (list) {
                        if (this.documentChanges == null) {
                            this.documentChanges = new ArrayList<DocumentChange>();
                            for (int i = 0; i < documents.size(); ++i) {
                                this.documentChanges.add(new DocumentChange((QueryDocumentSnapshot)documents.get(i), DocumentChange.Type.ADDED, -1, i));
                            }
                        }
                    }
                }
                return Collections.unmodifiableList(this.documentChanges);
            }

            @Override
            public int size() {
                return documents.size();
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                QuerySnapshot that = (QuerySnapshot)o;
                return Objects.equals(query, that.query) && Objects.equals(this.size(), that.size()) && Objects.equals(this.getDocuments(), that.getDocuments());
            }

            @Override
            public int hashCode() {
                return Objects.hash(query, this.getDocuments());
            }
        };
    }

    public static QuerySnapshot withChanges(final Query query, Timestamp readTime, final DocumentSet documentSet, final List<DocumentChange> documentChanges) {
        return new QuerySnapshot(query, readTime){
            volatile List<QueryDocumentSnapshot> documents;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nonnull
            public List<QueryDocumentSnapshot> getDocuments() {
                if (this.documents == null) {
                    DocumentSet documentSet2 = documentSet;
                    synchronized (documentSet2) {
                        if (this.documents == null) {
                            this.documents = documentSet.toList();
                        }
                    }
                }
                return Collections.unmodifiableList(this.documents);
            }

            @Override
            @Nonnull
            public List<DocumentChange> getDocumentChanges() {
                return Collections.unmodifiableList(documentChanges);
            }

            @Override
            public int size() {
                return documentSet.size();
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                QuerySnapshot that = (QuerySnapshot)o;
                return Objects.equals(query, that.query) && Objects.equals(this.size(), that.size()) && Objects.equals(this.getDocumentChanges(), that.getDocumentChanges()) && Objects.equals(this.getDocuments(), that.getDocuments());
            }

            @Override
            public int hashCode() {
                return Objects.hash(query, this.getDocumentChanges(), this.getDocuments());
            }
        };
    }

    @Nonnull
    public Query getQuery() {
        return this.query;
    }

    @Nonnull
    public Timestamp getReadTime() {
        return this.readTime;
    }

    @Nonnull
    public abstract List<QueryDocumentSnapshot> getDocuments();

    @Nonnull
    public abstract List<DocumentChange> getDocumentChanges();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract int size();

    @Override
    @Nonnull
    public Iterator<QueryDocumentSnapshot> iterator() {
        return this.getDocuments().iterator();
    }

    @Nonnull
    public <T> List<T> toObjects(@Nonnull Class<T> clazz) {
        ArrayList<T> results = new ArrayList<T>();
        for (DocumentSnapshot documentSnapshot : this.getDocuments()) {
            results.add(CustomClassMapper.convertToCustomClass(documentSnapshot.getData(), clazz));
        }
        return results;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

