/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.firestore.v1beta1.Precondition;
import com.google.protobuf.Timestamp;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.threeten.bp.Instant;

public final class Precondition {
    public static final Precondition NONE = new Precondition(null, null);
    private Boolean exists;
    private Instant updateTime;

    private Precondition(Boolean exists, Instant updateTime) {
        this.exists = exists;
        this.updateTime = updateTime;
    }

    @Nonnull
    static Precondition exists(Boolean exists) {
        return new Precondition(exists, null);
    }

    @Nonnull
    public static Precondition updatedAt(Instant updateTime) {
        return new Precondition(null, updateTime);
    }

    boolean isEmpty() {
        return this.exists == null && this.updateTime == null;
    }

    boolean hasExists() {
        return this.exists != null;
    }

    com.google.firestore.v1beta1.Precondition toPb() {
        Precondition.Builder precondition = com.google.firestore.v1beta1.Precondition.newBuilder();
        if (this.exists != null) {
            precondition.setExists(this.exists.booleanValue());
        }
        if (this.updateTime != null) {
            Timestamp.Builder timestamp = Timestamp.newBuilder();
            timestamp.setSeconds(this.updateTime.getEpochSecond());
            timestamp.setNanos(this.updateTime.getNano());
            precondition.setUpdateTime(timestamp.build());
        }
        return precondition.build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Precondition that = (Precondition)obj;
        return Objects.equals(this.exists, that.exists) && Objects.equals(this.updateTime, that.updateTime);
    }

    public int hashCode() {
        return Objects.hash(this.exists, this.updateTime);
    }
}

