/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.CustomClassMapper;
import com.google.cloud.firestore.DocumentChange;
import com.google.cloud.firestore.DocumentSet;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.Instant;

public final class QuerySnapshot
implements Iterable<QueryDocumentSnapshot> {
    private final Query query;
    private final DocumentSet documentSet;
    @Nullable
    private volatile List<QueryDocumentSnapshot> documentSnapshots;
    private final Instant readTime;
    private final List<DocumentChange> documentChanges;

    QuerySnapshot(Query query, Instant readTime, List<QueryDocumentSnapshot> results, List<DocumentChange> documentChanges) {
        this.query = query;
        this.documentSet = null;
        this.documentSnapshots = results;
        this.readTime = readTime;
        this.documentChanges = documentChanges;
    }

    QuerySnapshot(Query query, Instant readTime, DocumentSet results, List<DocumentChange> documentChanges) {
        this.query = query;
        this.documentSet = results;
        this.readTime = readTime;
        this.documentChanges = documentChanges;
    }

    @Nonnull
    public Query getQuery() {
        return this.query;
    }

    @Nonnull
    public Instant getReadTime() {
        return this.readTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public List<QueryDocumentSnapshot> getDocuments() {
        if (this.documentSnapshots == null) {
            Preconditions.checkState((this.documentSet != null ? 1 : 0) != 0);
            DocumentSet documentSet = this.documentSet;
            synchronized (documentSet) {
                if (this.documentSnapshots == null) {
                    this.documentSnapshots = this.documentSet.toList();
                }
            }
        }
        return Collections.unmodifiableList(this.documentSnapshots);
    }

    @Nonnull
    public List<DocumentChange> getDocumentChanges() {
        return Collections.unmodifiableList(this.documentChanges);
    }

    public boolean isEmpty() {
        return this.documentSnapshots != null ? this.documentSnapshots.isEmpty() : this.documentSet.isEmpty();
    }

    public int size() {
        return this.documentSnapshots != null ? this.documentSnapshots.size() : this.documentSet.size();
    }

    @Override
    @Nonnull
    public Iterator<QueryDocumentSnapshot> iterator() {
        return this.getDocuments().iterator();
    }

    @Nonnull
    public <T> List<T> toObjects(@Nonnull Class<T> clazz) {
        ArrayList<T> results = new ArrayList<T>();
        for (DocumentSnapshot documentSnapshot : this.getDocuments()) {
            results.add(CustomClassMapper.convertToCustomClass(documentSnapshot.getData(), clazz));
        }
        return results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuerySnapshot that = (QuerySnapshot)o;
        return Objects.equals(this.query, that.query) && Objects.equals(this.readTime, that.readTime);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.readTime);
    }
}

