/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.AutoValue_ResourcePath;
import com.google.cloud.firestore.BasePath;
import com.google.common.collect.ImmutableList;
import com.google.firestore.v1beta1.DatabaseRootName;
import java.util.Arrays;
import javax.annotation.Nullable;

abstract class ResourcePath
extends BasePath<ResourcePath> {
    ResourcePath() {
    }

    static ResourcePath create(DatabaseRootName databaseName, ImmutableList<String> segments) {
        return new AutoValue_ResourcePath(segments, databaseName);
    }

    static ResourcePath create(DatabaseRootName databaseName) {
        return new AutoValue_ResourcePath((ImmutableList<String>)ImmutableList.of(), databaseName);
    }

    static ResourcePath create(String resourceName) {
        String[] parts = resourceName.split("/");
        if (parts.length >= 6 && parts[0].equals("projects") && parts[2].equals("databases")) {
            Object[] path = Arrays.copyOfRange(parts, 5, parts.length);
            return ResourcePath.create(DatabaseRootName.create((String)parts[1], (String)parts[3]), (ImmutableList<String>)ImmutableList.builder().add(path).build());
        }
        return ResourcePath.create(DatabaseRootName.parse((String)resourceName));
    }

    abstract DatabaseRootName getDatabaseName();

    boolean isDocument() {
        int size = this.getSegments().size();
        return size > 0 && size % 2 == 0;
    }

    boolean isCollection() {
        return this.getSegments().size() % 2 == 1;
    }

    @Nullable
    String getId() {
        ImmutableList<String> parts = this.getSegments();
        if (!parts.isEmpty()) {
            return (String)parts.get(parts.size() - 1);
        }
        return null;
    }

    String getPath() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String part : this.getSegments()) {
            if (first) {
                result.append(part);
                first = false;
                continue;
            }
            result.append("/").append(part);
        }
        return result.toString();
    }

    String getName() {
        String path = this.getPath();
        if (path.isEmpty()) {
            return this.getDatabaseName().toString();
        }
        return this.getDatabaseName() + "/documents/" + this.getPath();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    String[] splitChildPath(String name) {
        return name.split("/");
    }

    @Override
    ResourcePath createPathWithSegments(ImmutableList<String> segments) {
        return ResourcePath.create(this.getDatabaseName(), segments);
    }
}

