/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.InternalApi;
import com.google.cloud.ServiceDefaults;
import com.google.cloud.ServiceOptions;
import com.google.cloud.TransportOptions;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreFactory;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreRpcFactory;
import com.google.cloud.firestore.spi.v1beta1.FirestoreRpc;
import com.google.cloud.firestore.spi.v1beta1.GrpcFirestoreRpc;
import com.google.cloud.firestore.v1beta1.FirestoreSettings;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nonnull;

public final class FirestoreOptions
extends ServiceOptions<Firestore, FirestoreOptions> {
    private static final String API_SHORT_NAME = "Firestore";
    private static final Set<String> SCOPES = ImmutableSet.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/datastore").build();
    private static final String DEFAULT_HOST = FirestoreSettings.getDefaultEndpoint();
    private static final String DEFAULT_DATABASE_ID = "(default)";
    private static final long serialVersionUID = -5853552236134770088L;
    private final String databaseId;

    public static FirestoreOptions getDefaultInstance() {
        return FirestoreOptions.newBuilder().build();
    }

    protected boolean projectIdRequired() {
        return false;
    }

    protected String getDefaultHost() {
        return DEFAULT_HOST;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    @InternalApi(value="This class should only be extended within google-cloud-java")
    protected FirestoreOptions(Builder builder) {
        super(FirestoreFactory.class, FirestoreRpcFactory.class, (ServiceOptions.Builder)builder, (ServiceDefaults)new FirestoreDefaults());
        this.databaseId = builder.databaseId;
    }

    @Nonnull
    public static GrpcTransportOptions getDefaultGrpcTransportOptions() {
        return GrpcTransportOptions.newBuilder().build();
    }

    protected Set<String> getScopes() {
        return SCOPES;
    }

    FirestoreRpc getFirestoreRpc() {
        return (FirestoreRpc)this.getRpc();
    }

    public boolean equals(Object obj) {
        return obj instanceof FirestoreOptions && this.baseEquals((FirestoreOptions)((Object)obj));
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    private static class FirestoreDefaults
    implements ServiceDefaults<Firestore, FirestoreOptions> {
        private FirestoreDefaults() {
        }

        @Nonnull
        public FirestoreFactory getDefaultServiceFactory() {
            return DefaultFirestoreFactory.INSTANCE;
        }

        @Nonnull
        public FirestoreRpcFactory getDefaultRpcFactory() {
            return DefaultFirestoreRpcFactory.INSTANCE;
        }

        @Nonnull
        public TransportOptions getDefaultTransportOptions() {
            return FirestoreOptions.getDefaultGrpcTransportOptions();
        }
    }

    public static class Builder
    extends ServiceOptions.Builder<Firestore, FirestoreOptions, Builder> {
        private String databaseId = "(default)";

        private Builder() {
        }

        private Builder(FirestoreOptions options) {
            super((ServiceOptions)options);
        }

        @Nonnull
        public Builder setTransportOptions(@Nonnull TransportOptions transportOptions) {
            if (!(transportOptions instanceof GrpcTransportOptions)) {
                throw new IllegalArgumentException("Only grpc transport is allowed for Firestore.");
            }
            return (Builder)super.setTransportOptions(transportOptions);
        }

        @Nonnull
        public FirestoreOptions build() {
            return new FirestoreOptions(this);
        }

        public Builder setDatabaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }
    }

    public static class DefaultFirestoreRpcFactory
    implements FirestoreRpcFactory {
        private static final FirestoreRpcFactory INSTANCE = new DefaultFirestoreRpcFactory();

        @Nonnull
        public FirestoreRpc create(@Nonnull FirestoreOptions options) {
            try {
                return new GrpcFirestoreRpc(options);
            }
            catch (IOException e) {
                throw FirestoreException.networkException(e, false);
            }
        }
    }

    public static class DefaultFirestoreFactory
    implements FirestoreFactory {
        private static final FirestoreFactory INSTANCE = new DefaultFirestoreFactory();

        @Nonnull
        public Firestore create(@Nonnull FirestoreOptions options) {
            return new FirestoreImpl(options);
        }
    }
}

