/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.v1beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.grpc.GrpcTransport;
import com.google.api.gax.grpc.GrpcTransportProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.SimpleCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamingCallSettings;
import com.google.api.gax.rpc.TransportProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.v1beta1.PagedResponseWrappers;
import com.google.cloud.firestore.v1beta1.stub.FirestoreStub;
import com.google.cloud.firestore.v1beta1.stub.GrpcFirestoreStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.firestore.v1beta1.BatchGetDocumentsRequest;
import com.google.firestore.v1beta1.BatchGetDocumentsResponse;
import com.google.firestore.v1beta1.BeginTransactionRequest;
import com.google.firestore.v1beta1.BeginTransactionResponse;
import com.google.firestore.v1beta1.CommitRequest;
import com.google.firestore.v1beta1.CommitResponse;
import com.google.firestore.v1beta1.CreateDocumentRequest;
import com.google.firestore.v1beta1.DeleteDocumentRequest;
import com.google.firestore.v1beta1.Document;
import com.google.firestore.v1beta1.GetDocumentRequest;
import com.google.firestore.v1beta1.ListCollectionIdsRequest;
import com.google.firestore.v1beta1.ListCollectionIdsResponse;
import com.google.firestore.v1beta1.ListDocumentsRequest;
import com.google.firestore.v1beta1.ListDocumentsResponse;
import com.google.firestore.v1beta1.ListenRequest;
import com.google.firestore.v1beta1.ListenResponse;
import com.google.firestore.v1beta1.RollbackRequest;
import com.google.firestore.v1beta1.RunQueryRequest;
import com.google.firestore.v1beta1.RunQueryResponse;
import com.google.firestore.v1beta1.UpdateDocumentRequest;
import com.google.firestore.v1beta1.WriteRequest;
import com.google.firestore.v1beta1.WriteResponse;
import com.google.protobuf.Empty;
import io.grpc.Status;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class FirestoreSettings
extends ClientSettings {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/datastore").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/com/google/cloud/firestore/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private final SimpleCallSettings<GetDocumentRequest, Document> getDocumentSettings;
    private final PagedCallSettings<ListDocumentsRequest, ListDocumentsResponse, PagedResponseWrappers.ListDocumentsPagedResponse> listDocumentsSettings;
    private final SimpleCallSettings<CreateDocumentRequest, Document> createDocumentSettings;
    private final SimpleCallSettings<UpdateDocumentRequest, Document> updateDocumentSettings;
    private final SimpleCallSettings<DeleteDocumentRequest, Empty> deleteDocumentSettings;
    private final StreamingCallSettings<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsSettings;
    private final SimpleCallSettings<BeginTransactionRequest, BeginTransactionResponse> beginTransactionSettings;
    private final SimpleCallSettings<CommitRequest, CommitResponse> commitSettings;
    private final SimpleCallSettings<RollbackRequest, Empty> rollbackSettings;
    private final StreamingCallSettings<RunQueryRequest, RunQueryResponse> runQuerySettings;
    private final StreamingCallSettings<WriteRequest, WriteResponse> writeSettings;
    private final StreamingCallSettings<ListenRequest, ListenResponse> listenSettings;
    private final PagedCallSettings<ListCollectionIdsRequest, ListCollectionIdsResponse, PagedResponseWrappers.ListCollectionIdsPagedResponse> listCollectionIdsSettings;
    private static final PagedListDescriptor<ListDocumentsRequest, ListDocumentsResponse, Document> LIST_DOCUMENTS_PAGE_STR_DESC;
    private static final PagedListDescriptor<ListCollectionIdsRequest, ListCollectionIdsResponse, String> LIST_COLLECTION_IDS_PAGE_STR_DESC;
    private static final PagedListResponseFactory<ListDocumentsRequest, ListDocumentsResponse, PagedResponseWrappers.ListDocumentsPagedResponse> LIST_DOCUMENTS_PAGE_STR_FACT;
    private static final PagedListResponseFactory<ListCollectionIdsRequest, ListCollectionIdsResponse, PagedResponseWrappers.ListCollectionIdsPagedResponse> LIST_COLLECTION_IDS_PAGE_STR_FACT;

    public SimpleCallSettings<GetDocumentRequest, Document> getDocumentSettings() {
        return this.getDocumentSettings;
    }

    public PagedCallSettings<ListDocumentsRequest, ListDocumentsResponse, PagedResponseWrappers.ListDocumentsPagedResponse> listDocumentsSettings() {
        return this.listDocumentsSettings;
    }

    public SimpleCallSettings<CreateDocumentRequest, Document> createDocumentSettings() {
        return this.createDocumentSettings;
    }

    public SimpleCallSettings<UpdateDocumentRequest, Document> updateDocumentSettings() {
        return this.updateDocumentSettings;
    }

    public SimpleCallSettings<DeleteDocumentRequest, Empty> deleteDocumentSettings() {
        return this.deleteDocumentSettings;
    }

    public StreamingCallSettings<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsSettings() {
        return this.batchGetDocumentsSettings;
    }

    public SimpleCallSettings<BeginTransactionRequest, BeginTransactionResponse> beginTransactionSettings() {
        return this.beginTransactionSettings;
    }

    public SimpleCallSettings<CommitRequest, CommitResponse> commitSettings() {
        return this.commitSettings;
    }

    public SimpleCallSettings<RollbackRequest, Empty> rollbackSettings() {
        return this.rollbackSettings;
    }

    public StreamingCallSettings<RunQueryRequest, RunQueryResponse> runQuerySettings() {
        return this.runQuerySettings;
    }

    public StreamingCallSettings<WriteRequest, WriteResponse> writeSettings() {
        return this.writeSettings;
    }

    public StreamingCallSettings<ListenRequest, ListenResponse> listenSettings() {
        return this.listenSettings;
    }

    public PagedCallSettings<ListCollectionIdsRequest, ListCollectionIdsResponse, PagedResponseWrappers.ListCollectionIdsPagedResponse> listCollectionIdsSettings() {
        return this.listCollectionIdsSettings;
    }

    public FirestoreStub createStub() throws IOException {
        if (this.getTransportProvider().getTransportName().equals(GrpcTransport.getGrpcTransportName())) {
            return GrpcFirestoreStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "firestore.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultGrpcChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setEndpoint(FirestoreSettings.getDefaultEndpoint()).setGeneratorHeader(DEFAULT_GAPIC_NAME, FirestoreSettings.getGapicVersion());
    }

    public static GrpcTransportProvider.Builder defaultGrpcTransportProviderBuilder() {
        return GrpcTransportProvider.newBuilder().setChannelProvider((ChannelProvider)FirestoreSettings.defaultGrpcChannelProviderBuilder().build());
    }

    public static TransportProvider defaultTransportProvider() {
        return FirestoreSettings.defaultGrpcTransportProviderBuilder().build();
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(FirestoreSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    @Deprecated
    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    @Deprecated
    public static Builder defaultBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private FirestoreSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getTransportProvider(), settingsBuilder.getCredentialsProvider(), settingsBuilder.getClock());
        this.getDocumentSettings = settingsBuilder.getDocumentSettings().build();
        this.listDocumentsSettings = settingsBuilder.listDocumentsSettings().build();
        this.createDocumentSettings = settingsBuilder.createDocumentSettings().build();
        this.updateDocumentSettings = settingsBuilder.updateDocumentSettings().build();
        this.deleteDocumentSettings = settingsBuilder.deleteDocumentSettings().build();
        this.batchGetDocumentsSettings = settingsBuilder.batchGetDocumentsSettings().build();
        this.beginTransactionSettings = settingsBuilder.beginTransactionSettings().build();
        this.commitSettings = settingsBuilder.commitSettings().build();
        this.rollbackSettings = settingsBuilder.rollbackSettings().build();
        this.runQuerySettings = settingsBuilder.runQuerySettings().build();
        this.writeSettings = settingsBuilder.writeSettings().build();
        this.listenSettings = settingsBuilder.listenSettings().build();
        this.listCollectionIdsSettings = settingsBuilder.listCollectionIdsSettings().build();
    }

    static {
        LIST_DOCUMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListDocumentsRequest, ListDocumentsResponse, Document>(){

            public String emptyToken() {
                return FirestoreSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListDocumentsRequest injectToken(ListDocumentsRequest payload, String token) {
                return ListDocumentsRequest.newBuilder((ListDocumentsRequest)payload).setPageToken(token).build();
            }

            public ListDocumentsRequest injectPageSize(ListDocumentsRequest payload, int pageSize) {
                return ListDocumentsRequest.newBuilder((ListDocumentsRequest)payload).setPageSize(pageSize).build();
            }

            public Integer extractPageSize(ListDocumentsRequest payload) {
                return payload.getPageSize();
            }

            public String extractNextToken(ListDocumentsResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<Document> extractResources(ListDocumentsResponse payload) {
                return payload.getDocumentsList();
            }
        };
        LIST_COLLECTION_IDS_PAGE_STR_DESC = new PagedListDescriptor<ListCollectionIdsRequest, ListCollectionIdsResponse, String>(){

            public String emptyToken() {
                return FirestoreSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListCollectionIdsRequest injectToken(ListCollectionIdsRequest payload, String token) {
                return ListCollectionIdsRequest.newBuilder((ListCollectionIdsRequest)payload).setPageToken(token).build();
            }

            public ListCollectionIdsRequest injectPageSize(ListCollectionIdsRequest payload, int pageSize) {
                return ListCollectionIdsRequest.newBuilder((ListCollectionIdsRequest)payload).setPageSize(pageSize).build();
            }

            public Integer extractPageSize(ListCollectionIdsRequest payload) {
                return payload.getPageSize();
            }

            public String extractNextToken(ListCollectionIdsResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<String> extractResources(ListCollectionIdsResponse payload) {
                return payload.getCollectionIdsList();
            }
        };
        LIST_DOCUMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListDocumentsRequest, ListDocumentsResponse, PagedResponseWrappers.ListDocumentsPagedResponse>(){

            public ApiFuture<PagedResponseWrappers.ListDocumentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> callable, ListDocumentsRequest request, ApiCallContext context, ApiFuture<ListDocumentsResponse> futureResponse) {
                PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DOCUMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
                return PagedResponseWrappers.ListDocumentsPagedResponse.createAsync((PageContext<ListDocumentsRequest, ListDocumentsResponse, Document>)pageContext, futureResponse);
            }
        };
        LIST_COLLECTION_IDS_PAGE_STR_FACT = new PagedListResponseFactory<ListCollectionIdsRequest, ListCollectionIdsResponse, PagedResponseWrappers.ListCollectionIdsPagedResponse>(){

            public ApiFuture<PagedResponseWrappers.ListCollectionIdsPagedResponse> getFuturePagedResponse(UnaryCallable<ListCollectionIdsRequest, ListCollectionIdsResponse> callable, ListCollectionIdsRequest request, ApiCallContext context, ApiFuture<ListCollectionIdsResponse> futureResponse) {
                PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_COLLECTION_IDS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
                return PagedResponseWrappers.ListCollectionIdsPagedResponse.createAsync((PageContext<ListCollectionIdsRequest, ListCollectionIdsResponse, String>)pageContext, futureResponse);
            }
        };
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final SimpleCallSettings.Builder<GetDocumentRequest, Document> getDocumentSettings;
        private final PagedCallSettings.Builder<ListDocumentsRequest, ListDocumentsResponse, PagedResponseWrappers.ListDocumentsPagedResponse> listDocumentsSettings;
        private final SimpleCallSettings.Builder<CreateDocumentRequest, Document> createDocumentSettings;
        private final SimpleCallSettings.Builder<UpdateDocumentRequest, Document> updateDocumentSettings;
        private final SimpleCallSettings.Builder<DeleteDocumentRequest, Empty> deleteDocumentSettings;
        private final StreamingCallSettings.Builder<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsSettings;
        private final SimpleCallSettings.Builder<BeginTransactionRequest, BeginTransactionResponse> beginTransactionSettings;
        private final SimpleCallSettings.Builder<CommitRequest, CommitResponse> commitSettings;
        private final SimpleCallSettings.Builder<RollbackRequest, Empty> rollbackSettings;
        private final StreamingCallSettings.Builder<RunQueryRequest, RunQueryResponse> runQuerySettings;
        private final StreamingCallSettings.Builder<WriteRequest, WriteResponse> writeSettings;
        private final StreamingCallSettings.Builder<ListenRequest, ListenResponse> listenSettings;
        private final PagedCallSettings.Builder<ListCollectionIdsRequest, ListCollectionIdsResponse, PagedResponseWrappers.ListCollectionIdsPagedResponse> listCollectionIdsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            this((ClientContext)null);
        }

        private Builder(ClientContext clientContext) {
            super(clientContext);
            this.getDocumentSettings = SimpleCallSettings.newBuilder();
            this.listDocumentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DOCUMENTS_PAGE_STR_FACT);
            this.createDocumentSettings = SimpleCallSettings.newBuilder();
            this.updateDocumentSettings = SimpleCallSettings.newBuilder();
            this.deleteDocumentSettings = SimpleCallSettings.newBuilder();
            this.batchGetDocumentsSettings = StreamingCallSettings.newBuilder();
            this.beginTransactionSettings = SimpleCallSettings.newBuilder();
            this.commitSettings = SimpleCallSettings.newBuilder();
            this.rollbackSettings = SimpleCallSettings.newBuilder();
            this.runQuerySettings = StreamingCallSettings.newBuilder();
            this.writeSettings = StreamingCallSettings.newBuilder();
            this.listenSettings = StreamingCallSettings.newBuilder();
            this.listCollectionIdsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_COLLECTION_IDS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getDocumentSettings, this.listDocumentsSettings, this.createDocumentSettings, this.updateDocumentSettings, this.deleteDocumentSettings, this.beginTransactionSettings, this.commitSettings, this.rollbackSettings, this.listCollectionIdsSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportProvider(FirestoreSettings.defaultTransportProvider());
            builder.setCredentialsProvider((CredentialsProvider)FirestoreSettings.defaultCredentialsProviderBuilder().build());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listDocumentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.beginTransactionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.commitSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.rollbackSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listCollectionIdsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(FirestoreSettings settings) {
            super((ClientSettings)settings);
            this.getDocumentSettings = settings.getDocumentSettings.toBuilder();
            this.listDocumentsSettings = settings.listDocumentsSettings.toBuilder();
            this.createDocumentSettings = settings.createDocumentSettings.toBuilder();
            this.updateDocumentSettings = settings.updateDocumentSettings.toBuilder();
            this.deleteDocumentSettings = settings.deleteDocumentSettings.toBuilder();
            this.batchGetDocumentsSettings = settings.batchGetDocumentsSettings.toBuilder();
            this.beginTransactionSettings = settings.beginTransactionSettings.toBuilder();
            this.commitSettings = settings.commitSettings.toBuilder();
            this.rollbackSettings = settings.rollbackSettings.toBuilder();
            this.runQuerySettings = settings.runQuerySettings.toBuilder();
            this.writeSettings = settings.writeSettings.toBuilder();
            this.listenSettings = settings.listenSettings.toBuilder();
            this.listCollectionIdsSettings = settings.listCollectionIdsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getDocumentSettings, this.listDocumentsSettings, this.createDocumentSettings, this.updateDocumentSettings, this.deleteDocumentSettings, this.beginTransactionSettings, this.commitSettings, this.rollbackSettings, this.listCollectionIdsSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setTransportProvider(TransportProvider transportProvider) {
            super.setTransportProvider(transportProvider);
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            super.setCredentialsProvider(credentialsProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder, Void> settingsUpdater) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public SimpleCallSettings.Builder<GetDocumentRequest, Document> getDocumentSettings() {
            return this.getDocumentSettings;
        }

        public PagedCallSettings.Builder<ListDocumentsRequest, ListDocumentsResponse, PagedResponseWrappers.ListDocumentsPagedResponse> listDocumentsSettings() {
            return this.listDocumentsSettings;
        }

        public SimpleCallSettings.Builder<CreateDocumentRequest, Document> createDocumentSettings() {
            return this.createDocumentSettings;
        }

        public SimpleCallSettings.Builder<UpdateDocumentRequest, Document> updateDocumentSettings() {
            return this.updateDocumentSettings;
        }

        public SimpleCallSettings.Builder<DeleteDocumentRequest, Empty> deleteDocumentSettings() {
            return this.deleteDocumentSettings;
        }

        public StreamingCallSettings.Builder<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsSettings() {
            return this.batchGetDocumentsSettings;
        }

        public SimpleCallSettings.Builder<BeginTransactionRequest, BeginTransactionResponse> beginTransactionSettings() {
            return this.beginTransactionSettings;
        }

        public SimpleCallSettings.Builder<CommitRequest, CommitResponse> commitSettings() {
            return this.commitSettings;
        }

        public SimpleCallSettings.Builder<RollbackRequest, Empty> rollbackSettings() {
            return this.rollbackSettings;
        }

        public StreamingCallSettings.Builder<RunQueryRequest, RunQueryResponse> runQuerySettings() {
            return this.runQuerySettings;
        }

        public StreamingCallSettings.Builder<WriteRequest, WriteResponse> writeSettings() {
            return this.writeSettings;
        }

        public StreamingCallSettings.Builder<ListenRequest, ListenResponse> listenSettings() {
            return this.listenSettings;
        }

        public PagedCallSettings.Builder<ListCollectionIdsRequest, ListCollectionIdsResponse, PagedResponseWrappers.ListCollectionIdsPagedResponse> listCollectionIdsSettings() {
            return this.listCollectionIdsSettings;
        }

        public FirestoreSettings build() throws IOException {
            return new FirestoreSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode[]{GrpcStatusCode.of((Status.Code)Status.Code.DEADLINE_EXCEEDED), GrpcStatusCode.of((Status.Code)Status.Code.UNAVAILABLE)})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)300000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)300000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"streaming", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

