/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.BaseServiceException;
import com.google.cloud.http.BaseHttpServiceException;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;

public final class FirestoreException
extends BaseHttpServiceException {
    private static final Set<BaseServiceException.Error> RETRYABLE_ERRORS = ImmutableSet.of((Object)new BaseServiceException.Error(Integer.valueOf(10), "ABORTED", false), (Object)new BaseServiceException.Error(Integer.valueOf(4), "DEADLINE_EXCEEDED", false), (Object)new BaseServiceException.Error(Integer.valueOf(14), "UNAVAILABLE", true));
    private static final long serialVersionUID = 9100921023984662143L;

    private FirestoreException(int code, String message, String reason) {
        this(code, message, reason, true, null);
    }

    private FirestoreException(int code, String message, String reason, boolean idempotent, Throwable cause) {
        super(code, message, reason, idempotent, RETRYABLE_ERRORS, cause);
    }

    private FirestoreException(IOException exception) {
        super(exception, true, RETRYABLE_ERRORS);
    }

    static FirestoreException invalidState(String message, Object ... params) {
        return new FirestoreException(0, String.format(message, params), "FAILED_PRECONDITION");
    }

    static FirestoreException serverRejected(String message, Object ... params) {
        return new FirestoreException(0, String.format(message, params), "CANCELLED");
    }

    static FirestoreException networkException(IOException exception) {
        return new FirestoreException(exception);
    }
}

