/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.v1.FirestoreAdminSettings;
import com.google.cloud.firestore.v1.stub.FirestoreAdminStub;
import com.google.cloud.firestore.v1.stub.FirestoreAdminStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firestore.admin.v1.Backup;
import com.google.firestore.admin.v1.BackupName;
import com.google.firestore.admin.v1.BackupSchedule;
import com.google.firestore.admin.v1.BackupScheduleName;
import com.google.firestore.admin.v1.BulkDeleteDocumentsMetadata;
import com.google.firestore.admin.v1.BulkDeleteDocumentsRequest;
import com.google.firestore.admin.v1.BulkDeleteDocumentsResponse;
import com.google.firestore.admin.v1.CloneDatabaseMetadata;
import com.google.firestore.admin.v1.CloneDatabaseRequest;
import com.google.firestore.admin.v1.CollectionGroupName;
import com.google.firestore.admin.v1.CreateBackupScheduleRequest;
import com.google.firestore.admin.v1.CreateDatabaseMetadata;
import com.google.firestore.admin.v1.CreateDatabaseRequest;
import com.google.firestore.admin.v1.CreateIndexRequest;
import com.google.firestore.admin.v1.CreateUserCredsRequest;
import com.google.firestore.admin.v1.Database;
import com.google.firestore.admin.v1.DatabaseName;
import com.google.firestore.admin.v1.DeleteBackupRequest;
import com.google.firestore.admin.v1.DeleteBackupScheduleRequest;
import com.google.firestore.admin.v1.DeleteDatabaseMetadata;
import com.google.firestore.admin.v1.DeleteDatabaseRequest;
import com.google.firestore.admin.v1.DeleteIndexRequest;
import com.google.firestore.admin.v1.DeleteUserCredsRequest;
import com.google.firestore.admin.v1.DisableUserCredsRequest;
import com.google.firestore.admin.v1.EnableUserCredsRequest;
import com.google.firestore.admin.v1.ExportDocumentsMetadata;
import com.google.firestore.admin.v1.ExportDocumentsRequest;
import com.google.firestore.admin.v1.ExportDocumentsResponse;
import com.google.firestore.admin.v1.Field;
import com.google.firestore.admin.v1.FieldName;
import com.google.firestore.admin.v1.FieldOperationMetadata;
import com.google.firestore.admin.v1.GetBackupRequest;
import com.google.firestore.admin.v1.GetBackupScheduleRequest;
import com.google.firestore.admin.v1.GetDatabaseRequest;
import com.google.firestore.admin.v1.GetFieldRequest;
import com.google.firestore.admin.v1.GetIndexRequest;
import com.google.firestore.admin.v1.GetUserCredsRequest;
import com.google.firestore.admin.v1.ImportDocumentsMetadata;
import com.google.firestore.admin.v1.ImportDocumentsRequest;
import com.google.firestore.admin.v1.Index;
import com.google.firestore.admin.v1.IndexName;
import com.google.firestore.admin.v1.IndexOperationMetadata;
import com.google.firestore.admin.v1.ListBackupSchedulesRequest;
import com.google.firestore.admin.v1.ListBackupSchedulesResponse;
import com.google.firestore.admin.v1.ListBackupsRequest;
import com.google.firestore.admin.v1.ListBackupsResponse;
import com.google.firestore.admin.v1.ListDatabasesRequest;
import com.google.firestore.admin.v1.ListDatabasesResponse;
import com.google.firestore.admin.v1.ListFieldsRequest;
import com.google.firestore.admin.v1.ListFieldsResponse;
import com.google.firestore.admin.v1.ListIndexesRequest;
import com.google.firestore.admin.v1.ListIndexesResponse;
import com.google.firestore.admin.v1.ListUserCredsRequest;
import com.google.firestore.admin.v1.ListUserCredsResponse;
import com.google.firestore.admin.v1.LocationName;
import com.google.firestore.admin.v1.ProjectName;
import com.google.firestore.admin.v1.ResetUserPasswordRequest;
import com.google.firestore.admin.v1.RestoreDatabaseMetadata;
import com.google.firestore.admin.v1.RestoreDatabaseRequest;
import com.google.firestore.admin.v1.UpdateBackupScheduleRequest;
import com.google.firestore.admin.v1.UpdateDatabaseMetadata;
import com.google.firestore.admin.v1.UpdateDatabaseRequest;
import com.google.firestore.admin.v1.UpdateFieldRequest;
import com.google.firestore.admin.v1.UserCreds;
import com.google.firestore.admin.v1.UserCredsName;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FirestoreAdminClient
implements BackgroundResource {
    private final FirestoreAdminSettings settings;
    private final FirestoreAdminStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final FirestoreAdminClient create() throws IOException {
        return FirestoreAdminClient.create(FirestoreAdminSettings.newBuilder().build());
    }

    public static final FirestoreAdminClient create(FirestoreAdminSettings settings) throws IOException {
        return new FirestoreAdminClient(settings);
    }

    public static final FirestoreAdminClient create(FirestoreAdminStub stub) {
        return new FirestoreAdminClient(stub);
    }

    protected FirestoreAdminClient(FirestoreAdminSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FirestoreAdminStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected FirestoreAdminClient(FirestoreAdminStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final FirestoreAdminSettings getSettings() {
        return this.settings;
    }

    public FirestoreAdminStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<Index, IndexOperationMetadata> createIndexAsync(CollectionGroupName parent, Index index) {
        CreateIndexRequest request = CreateIndexRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setIndex(index).build();
        return this.createIndexAsync(request);
    }

    public final OperationFuture<Index, IndexOperationMetadata> createIndexAsync(String parent, Index index) {
        CreateIndexRequest request = CreateIndexRequest.newBuilder().setParent(parent).setIndex(index).build();
        return this.createIndexAsync(request);
    }

    public final OperationFuture<Index, IndexOperationMetadata> createIndexAsync(CreateIndexRequest request) {
        return this.createIndexOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateIndexRequest, Index, IndexOperationMetadata> createIndexOperationCallable() {
        return this.stub.createIndexOperationCallable();
    }

    public final UnaryCallable<CreateIndexRequest, Operation> createIndexCallable() {
        return this.stub.createIndexCallable();
    }

    public final ListIndexesPagedResponse listIndexes(CollectionGroupName parent) {
        ListIndexesRequest request = ListIndexesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listIndexes(request);
    }

    public final ListIndexesPagedResponse listIndexes(String parent) {
        ListIndexesRequest request = ListIndexesRequest.newBuilder().setParent(parent).build();
        return this.listIndexes(request);
    }

    public final ListIndexesPagedResponse listIndexes(ListIndexesRequest request) {
        return (ListIndexesPagedResponse)((Object)this.listIndexesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListIndexesRequest, ListIndexesPagedResponse> listIndexesPagedCallable() {
        return this.stub.listIndexesPagedCallable();
    }

    public final UnaryCallable<ListIndexesRequest, ListIndexesResponse> listIndexesCallable() {
        return this.stub.listIndexesCallable();
    }

    public final Index getIndex(IndexName name) {
        GetIndexRequest request = GetIndexRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getIndex(request);
    }

    public final Index getIndex(String name) {
        GetIndexRequest request = GetIndexRequest.newBuilder().setName(name).build();
        return this.getIndex(request);
    }

    public final Index getIndex(GetIndexRequest request) {
        return (Index)this.getIndexCallable().call((Object)request);
    }

    public final UnaryCallable<GetIndexRequest, Index> getIndexCallable() {
        return this.stub.getIndexCallable();
    }

    public final void deleteIndex(IndexName name) {
        DeleteIndexRequest request = DeleteIndexRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteIndex(request);
    }

    public final void deleteIndex(String name) {
        DeleteIndexRequest request = DeleteIndexRequest.newBuilder().setName(name).build();
        this.deleteIndex(request);
    }

    public final void deleteIndex(DeleteIndexRequest request) {
        this.deleteIndexCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteIndexRequest, Empty> deleteIndexCallable() {
        return this.stub.deleteIndexCallable();
    }

    public final Field getField(FieldName name) {
        GetFieldRequest request = GetFieldRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getField(request);
    }

    public final Field getField(String name) {
        GetFieldRequest request = GetFieldRequest.newBuilder().setName(name).build();
        return this.getField(request);
    }

    public final Field getField(GetFieldRequest request) {
        return (Field)this.getFieldCallable().call((Object)request);
    }

    public final UnaryCallable<GetFieldRequest, Field> getFieldCallable() {
        return this.stub.getFieldCallable();
    }

    public final OperationFuture<Field, FieldOperationMetadata> updateFieldAsync(Field field) {
        UpdateFieldRequest request = UpdateFieldRequest.newBuilder().setField(field).build();
        return this.updateFieldAsync(request);
    }

    public final OperationFuture<Field, FieldOperationMetadata> updateFieldAsync(UpdateFieldRequest request) {
        return this.updateFieldOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateFieldRequest, Field, FieldOperationMetadata> updateFieldOperationCallable() {
        return this.stub.updateFieldOperationCallable();
    }

    public final UnaryCallable<UpdateFieldRequest, Operation> updateFieldCallable() {
        return this.stub.updateFieldCallable();
    }

    public final ListFieldsPagedResponse listFields(CollectionGroupName parent) {
        ListFieldsRequest request = ListFieldsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFields(request);
    }

    public final ListFieldsPagedResponse listFields(String parent) {
        ListFieldsRequest request = ListFieldsRequest.newBuilder().setParent(parent).build();
        return this.listFields(request);
    }

    public final ListFieldsPagedResponse listFields(ListFieldsRequest request) {
        return (ListFieldsPagedResponse)((Object)this.listFieldsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFieldsRequest, ListFieldsPagedResponse> listFieldsPagedCallable() {
        return this.stub.listFieldsPagedCallable();
    }

    public final UnaryCallable<ListFieldsRequest, ListFieldsResponse> listFieldsCallable() {
        return this.stub.listFieldsCallable();
    }

    public final OperationFuture<ExportDocumentsResponse, ExportDocumentsMetadata> exportDocumentsAsync(DatabaseName name) {
        ExportDocumentsRequest request = ExportDocumentsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.exportDocumentsAsync(request);
    }

    public final OperationFuture<ExportDocumentsResponse, ExportDocumentsMetadata> exportDocumentsAsync(String name) {
        ExportDocumentsRequest request = ExportDocumentsRequest.newBuilder().setName(name).build();
        return this.exportDocumentsAsync(request);
    }

    public final OperationFuture<ExportDocumentsResponse, ExportDocumentsMetadata> exportDocumentsAsync(ExportDocumentsRequest request) {
        return this.exportDocumentsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportDocumentsRequest, ExportDocumentsResponse, ExportDocumentsMetadata> exportDocumentsOperationCallable() {
        return this.stub.exportDocumentsOperationCallable();
    }

    public final UnaryCallable<ExportDocumentsRequest, Operation> exportDocumentsCallable() {
        return this.stub.exportDocumentsCallable();
    }

    public final OperationFuture<Empty, ImportDocumentsMetadata> importDocumentsAsync(DatabaseName name) {
        ImportDocumentsRequest request = ImportDocumentsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.importDocumentsAsync(request);
    }

    public final OperationFuture<Empty, ImportDocumentsMetadata> importDocumentsAsync(String name) {
        ImportDocumentsRequest request = ImportDocumentsRequest.newBuilder().setName(name).build();
        return this.importDocumentsAsync(request);
    }

    public final OperationFuture<Empty, ImportDocumentsMetadata> importDocumentsAsync(ImportDocumentsRequest request) {
        return this.importDocumentsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportDocumentsRequest, Empty, ImportDocumentsMetadata> importDocumentsOperationCallable() {
        return this.stub.importDocumentsOperationCallable();
    }

    public final UnaryCallable<ImportDocumentsRequest, Operation> importDocumentsCallable() {
        return this.stub.importDocumentsCallable();
    }

    public final OperationFuture<BulkDeleteDocumentsResponse, BulkDeleteDocumentsMetadata> bulkDeleteDocumentsAsync(DatabaseName name) {
        BulkDeleteDocumentsRequest request = BulkDeleteDocumentsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.bulkDeleteDocumentsAsync(request);
    }

    public final OperationFuture<BulkDeleteDocumentsResponse, BulkDeleteDocumentsMetadata> bulkDeleteDocumentsAsync(String name) {
        BulkDeleteDocumentsRequest request = BulkDeleteDocumentsRequest.newBuilder().setName(name).build();
        return this.bulkDeleteDocumentsAsync(request);
    }

    public final OperationFuture<BulkDeleteDocumentsResponse, BulkDeleteDocumentsMetadata> bulkDeleteDocumentsAsync(BulkDeleteDocumentsRequest request) {
        return this.bulkDeleteDocumentsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BulkDeleteDocumentsRequest, BulkDeleteDocumentsResponse, BulkDeleteDocumentsMetadata> bulkDeleteDocumentsOperationCallable() {
        return this.stub.bulkDeleteDocumentsOperationCallable();
    }

    public final UnaryCallable<BulkDeleteDocumentsRequest, Operation> bulkDeleteDocumentsCallable() {
        return this.stub.bulkDeleteDocumentsCallable();
    }

    public final OperationFuture<Database, CreateDatabaseMetadata> createDatabaseAsync(ProjectName parent, Database database, String databaseId) {
        CreateDatabaseRequest request = CreateDatabaseRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDatabase(database).setDatabaseId(databaseId).build();
        return this.createDatabaseAsync(request);
    }

    public final OperationFuture<Database, CreateDatabaseMetadata> createDatabaseAsync(String parent, Database database, String databaseId) {
        CreateDatabaseRequest request = CreateDatabaseRequest.newBuilder().setParent(parent).setDatabase(database).setDatabaseId(databaseId).build();
        return this.createDatabaseAsync(request);
    }

    public final OperationFuture<Database, CreateDatabaseMetadata> createDatabaseAsync(CreateDatabaseRequest request) {
        return this.createDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDatabaseRequest, Database, CreateDatabaseMetadata> createDatabaseOperationCallable() {
        return this.stub.createDatabaseOperationCallable();
    }

    public final UnaryCallable<CreateDatabaseRequest, Operation> createDatabaseCallable() {
        return this.stub.createDatabaseCallable();
    }

    public final Database getDatabase(DatabaseName name) {
        GetDatabaseRequest request = GetDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDatabase(request);
    }

    public final Database getDatabase(String name) {
        GetDatabaseRequest request = GetDatabaseRequest.newBuilder().setName(name).build();
        return this.getDatabase(request);
    }

    public final Database getDatabase(GetDatabaseRequest request) {
        return (Database)this.getDatabaseCallable().call((Object)request);
    }

    public final UnaryCallable<GetDatabaseRequest, Database> getDatabaseCallable() {
        return this.stub.getDatabaseCallable();
    }

    public final ListDatabasesResponse listDatabases(ProjectName parent) {
        ListDatabasesRequest request = ListDatabasesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDatabases(request);
    }

    public final ListDatabasesResponse listDatabases(String parent) {
        ListDatabasesRequest request = ListDatabasesRequest.newBuilder().setParent(parent).build();
        return this.listDatabases(request);
    }

    public final ListDatabasesResponse listDatabases(ListDatabasesRequest request) {
        return (ListDatabasesResponse)this.listDatabasesCallable().call((Object)request);
    }

    public final UnaryCallable<ListDatabasesRequest, ListDatabasesResponse> listDatabasesCallable() {
        return this.stub.listDatabasesCallable();
    }

    public final OperationFuture<Database, UpdateDatabaseMetadata> updateDatabaseAsync(Database database, FieldMask updateMask) {
        UpdateDatabaseRequest request = UpdateDatabaseRequest.newBuilder().setDatabase(database).setUpdateMask(updateMask).build();
        return this.updateDatabaseAsync(request);
    }

    public final OperationFuture<Database, UpdateDatabaseMetadata> updateDatabaseAsync(UpdateDatabaseRequest request) {
        return this.updateDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateDatabaseRequest, Database, UpdateDatabaseMetadata> updateDatabaseOperationCallable() {
        return this.stub.updateDatabaseOperationCallable();
    }

    public final UnaryCallable<UpdateDatabaseRequest, Operation> updateDatabaseCallable() {
        return this.stub.updateDatabaseCallable();
    }

    public final OperationFuture<Database, DeleteDatabaseMetadata> deleteDatabaseAsync(DatabaseName name) {
        DeleteDatabaseRequest request = DeleteDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDatabaseAsync(request);
    }

    public final OperationFuture<Database, DeleteDatabaseMetadata> deleteDatabaseAsync(String name) {
        DeleteDatabaseRequest request = DeleteDatabaseRequest.newBuilder().setName(name).build();
        return this.deleteDatabaseAsync(request);
    }

    public final OperationFuture<Database, DeleteDatabaseMetadata> deleteDatabaseAsync(DeleteDatabaseRequest request) {
        return this.deleteDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDatabaseRequest, Database, DeleteDatabaseMetadata> deleteDatabaseOperationCallable() {
        return this.stub.deleteDatabaseOperationCallable();
    }

    public final UnaryCallable<DeleteDatabaseRequest, Operation> deleteDatabaseCallable() {
        return this.stub.deleteDatabaseCallable();
    }

    public final UserCreds createUserCreds(DatabaseName parent, UserCreds userCreds, String userCredsId) {
        CreateUserCredsRequest request = CreateUserCredsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setUserCreds(userCreds).setUserCredsId(userCredsId).build();
        return this.createUserCreds(request);
    }

    public final UserCreds createUserCreds(String parent, UserCreds userCreds, String userCredsId) {
        CreateUserCredsRequest request = CreateUserCredsRequest.newBuilder().setParent(parent).setUserCreds(userCreds).setUserCredsId(userCredsId).build();
        return this.createUserCreds(request);
    }

    public final UserCreds createUserCreds(CreateUserCredsRequest request) {
        return (UserCreds)this.createUserCredsCallable().call((Object)request);
    }

    public final UnaryCallable<CreateUserCredsRequest, UserCreds> createUserCredsCallable() {
        return this.stub.createUserCredsCallable();
    }

    public final UserCreds getUserCreds(UserCredsName name) {
        GetUserCredsRequest request = GetUserCredsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getUserCreds(request);
    }

    public final UserCreds getUserCreds(String name) {
        GetUserCredsRequest request = GetUserCredsRequest.newBuilder().setName(name).build();
        return this.getUserCreds(request);
    }

    public final UserCreds getUserCreds(GetUserCredsRequest request) {
        return (UserCreds)this.getUserCredsCallable().call((Object)request);
    }

    public final UnaryCallable<GetUserCredsRequest, UserCreds> getUserCredsCallable() {
        return this.stub.getUserCredsCallable();
    }

    public final ListUserCredsResponse listUserCreds(DatabaseName parent) {
        ListUserCredsRequest request = ListUserCredsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listUserCreds(request);
    }

    public final ListUserCredsResponse listUserCreds(String parent) {
        ListUserCredsRequest request = ListUserCredsRequest.newBuilder().setParent(parent).build();
        return this.listUserCreds(request);
    }

    public final ListUserCredsResponse listUserCreds(ListUserCredsRequest request) {
        return (ListUserCredsResponse)this.listUserCredsCallable().call((Object)request);
    }

    public final UnaryCallable<ListUserCredsRequest, ListUserCredsResponse> listUserCredsCallable() {
        return this.stub.listUserCredsCallable();
    }

    public final UserCreds enableUserCreds(UserCredsName name) {
        EnableUserCredsRequest request = EnableUserCredsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.enableUserCreds(request);
    }

    public final UserCreds enableUserCreds(String name) {
        EnableUserCredsRequest request = EnableUserCredsRequest.newBuilder().setName(name).build();
        return this.enableUserCreds(request);
    }

    public final UserCreds enableUserCreds(EnableUserCredsRequest request) {
        return (UserCreds)this.enableUserCredsCallable().call((Object)request);
    }

    public final UnaryCallable<EnableUserCredsRequest, UserCreds> enableUserCredsCallable() {
        return this.stub.enableUserCredsCallable();
    }

    public final UserCreds disableUserCreds(UserCredsName name) {
        DisableUserCredsRequest request = DisableUserCredsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.disableUserCreds(request);
    }

    public final UserCreds disableUserCreds(String name) {
        DisableUserCredsRequest request = DisableUserCredsRequest.newBuilder().setName(name).build();
        return this.disableUserCreds(request);
    }

    public final UserCreds disableUserCreds(DisableUserCredsRequest request) {
        return (UserCreds)this.disableUserCredsCallable().call((Object)request);
    }

    public final UnaryCallable<DisableUserCredsRequest, UserCreds> disableUserCredsCallable() {
        return this.stub.disableUserCredsCallable();
    }

    public final UserCreds resetUserPassword(UserCredsName name) {
        ResetUserPasswordRequest request = ResetUserPasswordRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.resetUserPassword(request);
    }

    public final UserCreds resetUserPassword(String name) {
        ResetUserPasswordRequest request = ResetUserPasswordRequest.newBuilder().setName(name).build();
        return this.resetUserPassword(request);
    }

    public final UserCreds resetUserPassword(ResetUserPasswordRequest request) {
        return (UserCreds)this.resetUserPasswordCallable().call((Object)request);
    }

    public final UnaryCallable<ResetUserPasswordRequest, UserCreds> resetUserPasswordCallable() {
        return this.stub.resetUserPasswordCallable();
    }

    public final void deleteUserCreds(UserCredsName name) {
        DeleteUserCredsRequest request = DeleteUserCredsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteUserCreds(request);
    }

    public final void deleteUserCreds(String name) {
        DeleteUserCredsRequest request = DeleteUserCredsRequest.newBuilder().setName(name).build();
        this.deleteUserCreds(request);
    }

    public final void deleteUserCreds(DeleteUserCredsRequest request) {
        this.deleteUserCredsCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteUserCredsRequest, Empty> deleteUserCredsCallable() {
        return this.stub.deleteUserCredsCallable();
    }

    public final Backup getBackup(BackupName name) {
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBackup(request);
    }

    public final Backup getBackup(String name) {
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(name).build();
        return this.getBackup(request);
    }

    public final Backup getBackup(GetBackupRequest request) {
        return (Backup)this.getBackupCallable().call((Object)request);
    }

    public final UnaryCallable<GetBackupRequest, Backup> getBackupCallable() {
        return this.stub.getBackupCallable();
    }

    public final ListBackupsResponse listBackups(LocationName parent) {
        ListBackupsRequest request = ListBackupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBackups(request);
    }

    public final ListBackupsResponse listBackups(String parent) {
        ListBackupsRequest request = ListBackupsRequest.newBuilder().setParent(parent).build();
        return this.listBackups(request);
    }

    public final ListBackupsResponse listBackups(ListBackupsRequest request) {
        return (ListBackupsResponse)this.listBackupsCallable().call((Object)request);
    }

    public final UnaryCallable<ListBackupsRequest, ListBackupsResponse> listBackupsCallable() {
        return this.stub.listBackupsCallable();
    }

    public final void deleteBackup(BackupName name) {
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteBackup(request);
    }

    public final void deleteBackup(String name) {
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(name).build();
        this.deleteBackup(request);
    }

    public final void deleteBackup(DeleteBackupRequest request) {
        this.deleteBackupCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteBackupRequest, Empty> deleteBackupCallable() {
        return this.stub.deleteBackupCallable();
    }

    public final OperationFuture<Database, RestoreDatabaseMetadata> restoreDatabaseAsync(RestoreDatabaseRequest request) {
        return this.restoreDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RestoreDatabaseRequest, Database, RestoreDatabaseMetadata> restoreDatabaseOperationCallable() {
        return this.stub.restoreDatabaseOperationCallable();
    }

    public final UnaryCallable<RestoreDatabaseRequest, Operation> restoreDatabaseCallable() {
        return this.stub.restoreDatabaseCallable();
    }

    public final BackupSchedule createBackupSchedule(DatabaseName parent, BackupSchedule backupSchedule) {
        CreateBackupScheduleRequest request = CreateBackupScheduleRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBackupSchedule(backupSchedule).build();
        return this.createBackupSchedule(request);
    }

    public final BackupSchedule createBackupSchedule(String parent, BackupSchedule backupSchedule) {
        CreateBackupScheduleRequest request = CreateBackupScheduleRequest.newBuilder().setParent(parent).setBackupSchedule(backupSchedule).build();
        return this.createBackupSchedule(request);
    }

    public final BackupSchedule createBackupSchedule(CreateBackupScheduleRequest request) {
        return (BackupSchedule)this.createBackupScheduleCallable().call((Object)request);
    }

    public final UnaryCallable<CreateBackupScheduleRequest, BackupSchedule> createBackupScheduleCallable() {
        return this.stub.createBackupScheduleCallable();
    }

    public final BackupSchedule getBackupSchedule(BackupScheduleName name) {
        GetBackupScheduleRequest request = GetBackupScheduleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBackupSchedule(request);
    }

    public final BackupSchedule getBackupSchedule(String name) {
        GetBackupScheduleRequest request = GetBackupScheduleRequest.newBuilder().setName(name).build();
        return this.getBackupSchedule(request);
    }

    public final BackupSchedule getBackupSchedule(GetBackupScheduleRequest request) {
        return (BackupSchedule)this.getBackupScheduleCallable().call((Object)request);
    }

    public final UnaryCallable<GetBackupScheduleRequest, BackupSchedule> getBackupScheduleCallable() {
        return this.stub.getBackupScheduleCallable();
    }

    public final ListBackupSchedulesResponse listBackupSchedules(DatabaseName parent) {
        ListBackupSchedulesRequest request = ListBackupSchedulesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBackupSchedules(request);
    }

    public final ListBackupSchedulesResponse listBackupSchedules(String parent) {
        ListBackupSchedulesRequest request = ListBackupSchedulesRequest.newBuilder().setParent(parent).build();
        return this.listBackupSchedules(request);
    }

    public final ListBackupSchedulesResponse listBackupSchedules(ListBackupSchedulesRequest request) {
        return (ListBackupSchedulesResponse)this.listBackupSchedulesCallable().call((Object)request);
    }

    public final UnaryCallable<ListBackupSchedulesRequest, ListBackupSchedulesResponse> listBackupSchedulesCallable() {
        return this.stub.listBackupSchedulesCallable();
    }

    public final BackupSchedule updateBackupSchedule(BackupSchedule backupSchedule, FieldMask updateMask) {
        UpdateBackupScheduleRequest request = UpdateBackupScheduleRequest.newBuilder().setBackupSchedule(backupSchedule).setUpdateMask(updateMask).build();
        return this.updateBackupSchedule(request);
    }

    public final BackupSchedule updateBackupSchedule(UpdateBackupScheduleRequest request) {
        return (BackupSchedule)this.updateBackupScheduleCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateBackupScheduleRequest, BackupSchedule> updateBackupScheduleCallable() {
        return this.stub.updateBackupScheduleCallable();
    }

    public final void deleteBackupSchedule(BackupScheduleName name) {
        DeleteBackupScheduleRequest request = DeleteBackupScheduleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteBackupSchedule(request);
    }

    public final void deleteBackupSchedule(String name) {
        DeleteBackupScheduleRequest request = DeleteBackupScheduleRequest.newBuilder().setName(name).build();
        this.deleteBackupSchedule(request);
    }

    public final void deleteBackupSchedule(DeleteBackupScheduleRequest request) {
        this.deleteBackupScheduleCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteBackupScheduleRequest, Empty> deleteBackupScheduleCallable() {
        return this.stub.deleteBackupScheduleCallable();
    }

    public final OperationFuture<Database, CloneDatabaseMetadata> cloneDatabaseAsync(CloneDatabaseRequest request) {
        return this.cloneDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CloneDatabaseRequest, Database, CloneDatabaseMetadata> cloneDatabaseOperationCallable() {
        return this.stub.cloneDatabaseOperationCallable();
    }

    public final UnaryCallable<CloneDatabaseRequest, Operation> cloneDatabaseCallable() {
        return this.stub.cloneDatabaseCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListIndexesPagedResponse
    extends AbstractPagedListResponse<ListIndexesRequest, ListIndexesResponse, Index, ListIndexesPage, ListIndexesFixedSizeCollection> {
        public static ApiFuture<ListIndexesPagedResponse> createAsync(PageContext<ListIndexesRequest, ListIndexesResponse, Index> context, ApiFuture<ListIndexesResponse> futureResponse) {
            ApiFuture<ListIndexesPage> futurePage = ListIndexesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListIndexesPagedResponse((ListIndexesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListIndexesPagedResponse(ListIndexesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListIndexesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFieldsPagedResponse
    extends AbstractPagedListResponse<ListFieldsRequest, ListFieldsResponse, Field, ListFieldsPage, ListFieldsFixedSizeCollection> {
        public static ApiFuture<ListFieldsPagedResponse> createAsync(PageContext<ListFieldsRequest, ListFieldsResponse, Field> context, ApiFuture<ListFieldsResponse> futureResponse) {
            ApiFuture<ListFieldsPage> futurePage = ListFieldsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListFieldsPagedResponse((ListFieldsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListFieldsPagedResponse(ListFieldsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFieldsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFieldsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFieldsRequest, ListFieldsResponse, Field, ListFieldsPage, ListFieldsFixedSizeCollection> {
        private ListFieldsFixedSizeCollection(List<ListFieldsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFieldsFixedSizeCollection createEmptyCollection() {
            return new ListFieldsFixedSizeCollection(null, 0);
        }

        protected ListFieldsFixedSizeCollection createCollection(List<ListFieldsPage> pages, int collectionSize) {
            return new ListFieldsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFieldsPage
    extends AbstractPage<ListFieldsRequest, ListFieldsResponse, Field, ListFieldsPage> {
        private ListFieldsPage(PageContext<ListFieldsRequest, ListFieldsResponse, Field> context, ListFieldsResponse response) {
            super(context, (Object)response);
        }

        private static ListFieldsPage createEmptyPage() {
            return new ListFieldsPage(null, null);
        }

        protected ListFieldsPage createPage(PageContext<ListFieldsRequest, ListFieldsResponse, Field> context, ListFieldsResponse response) {
            return new ListFieldsPage(context, response);
        }

        public ApiFuture<ListFieldsPage> createPageAsync(PageContext<ListFieldsRequest, ListFieldsResponse, Field> context, ApiFuture<ListFieldsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListIndexesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListIndexesRequest, ListIndexesResponse, Index, ListIndexesPage, ListIndexesFixedSizeCollection> {
        private ListIndexesFixedSizeCollection(List<ListIndexesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListIndexesFixedSizeCollection createEmptyCollection() {
            return new ListIndexesFixedSizeCollection(null, 0);
        }

        protected ListIndexesFixedSizeCollection createCollection(List<ListIndexesPage> pages, int collectionSize) {
            return new ListIndexesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListIndexesPage
    extends AbstractPage<ListIndexesRequest, ListIndexesResponse, Index, ListIndexesPage> {
        private ListIndexesPage(PageContext<ListIndexesRequest, ListIndexesResponse, Index> context, ListIndexesResponse response) {
            super(context, (Object)response);
        }

        private static ListIndexesPage createEmptyPage() {
            return new ListIndexesPage(null, null);
        }

        protected ListIndexesPage createPage(PageContext<ListIndexesRequest, ListIndexesResponse, Index> context, ListIndexesResponse response) {
            return new ListIndexesPage(context, response);
        }

        public ApiFuture<ListIndexesPage> createPageAsync(PageContext<ListIndexesRequest, ListIndexesResponse, Index> context, ApiFuture<ListIndexesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }
}

